/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

import ibis.ipl.impl.stacking.lrmc.util.Message;

public class MessageQueue {
    private final int limit;
    private Message head;
    private Message tail;
    private int size = 0;
    private boolean finish = false;

    public MessageQueue() {
        this(Integer.MAX_VALUE);
    }

    public MessageQueue(int limit) {
        this.limit = limit;
    }

    public synchronized void terminate() {
        this.finish = true;
        this.notifyAll();
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void enqueue(Message m) {
        while (!this.finish && this.size >= this.limit) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        if (this.finish) {
            return;
        }
        if (this.head == null) {
            this.head = this.tail = m;
            m.next = null;
            this.notifyAll();
        } else {
            this.tail.next = m;
            this.tail = m;
        }
        ++this.size;
    }

    public synchronized Message dequeue() {
        while (this.size == 0 && !this.finish) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        if (this.finish) {
            return null;
        }
        Message tmp = this.head;
        this.head = this.head.next;
        tmp.next = null;
        --this.size;
        if (this.size == this.limit - 1) {
            this.notifyAll();
        }
        return tmp;
    }
}

