/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.io.SerializationInput;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.stacking.lrmc.LrmcSendPortIdentifier;
import ibis.ipl.impl.stacking.lrmc.Multicaster;
import ibis.ipl.impl.stacking.lrmc.io.LrmcInputStream;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class LrmcReadMessage
implements ReadMessage {
    SerializationInput in;
    boolean isFinished = false;
    Multicaster om;
    long count = 0L;
    LrmcInputStream stream;
    private boolean inUpcall = false;

    public LrmcReadMessage(Multicaster om, LrmcInputStream stream) {
        this.in = om.sin;
        this.om = om;
        this.stream = stream;
    }

    void setInUpcall(boolean val) {
        this.inUpcall = val;
    }

    protected final void checkNotFinished() throws IOException {
        if (this.isFinished) {
            throw new IOException("Operating on a message that was already finished");
        }
    }

    public SendPortIdentifier origin() {
        int source = this.om.bin.getInputStream().getSource();
        IbisIdentifier id = this.om.lrmc.ibis.getId(source);
        return new LrmcSendPortIdentifier(id, this.om.name);
    }

    protected int available() throws IOException {
        this.checkNotFinished();
        return this.in.available();
    }

    public boolean readBoolean() throws IOException {
        this.checkNotFinished();
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        this.checkNotFinished();
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        this.checkNotFinished();
        return this.in.readChar();
    }

    public short readShort() throws IOException {
        this.checkNotFinished();
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        this.checkNotFinished();
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.checkNotFinished();
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        this.checkNotFinished();
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        this.checkNotFinished();
        return this.in.readDouble();
    }

    public String readString() throws IOException {
        this.checkNotFinished();
        return this.in.readString();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        this.checkNotFinished();
        return this.in.readObject();
    }

    public void readArray(boolean[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(byte[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(char[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(short[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(int[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(long[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(float[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(double[] destination) throws IOException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(Object[] destination) throws IOException, ClassNotFoundException {
        this.readArray(destination, 0, destination.length);
    }

    public void readArray(boolean[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(byte[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(char[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(short[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(int[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(long[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(float[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(double[] destination, int offset, int size) throws IOException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public void readArray(Object[] destination, int offset, int size) throws IOException, ClassNotFoundException {
        this.checkNotFinished();
        this.in.readArray(destination, offset, size);
    }

    public long bytesRead() throws IOException {
        long cnt = this.om.bin.bytesRead();
        long retval = cnt - this.count;
        this.count = cnt;
        return retval;
    }

    public int remaining() throws IOException {
        if (this.isFinished) {
            return 0;
        }
        return this.om.bin.available();
    }

    public int size() throws IOException {
        return this.om.bin.bufferSize();
    }

    public long finish() throws IOException {
        if (!this.isFinished) {
            long retval = this.om.finalizeRead(this.stream);
            this.om.receivePort.doFinish();
            if (this.inUpcall) {
                ThreadPool.createNew((Runnable)this.om.receivePort, (String)"ReceivePort");
            }
            this.isFinished = true;
            return retval;
        }
        throw new IOException("ReadMessage already finished");
    }

    public void finish(IOException exception) {
        if (!this.isFinished) {
            this.isFinished = true;
            this.om.finalizeRead(this.stream);
            this.om.receivePort.doFinish();
            if (this.inUpcall) {
                ThreadPool.createNew((Runnable)this.om.receivePort, (String)"ReceivePort");
            }
        }
    }

    public ReceivePort localPort() {
        return this.om.receivePort;
    }

    public long sequenceNumber() {
        return 0L;
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        this.checkNotFinished();
        this.in.readByteBuffer(value);
    }
}

