/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class Password
extends MessageAttribute {
    String password;

    public Password() {
        super(MessageAttributeInterface.MessageAttributeType.Password);
    }

    public Password(String password) {
        super(MessageAttributeInterface.MessageAttributeType.Password);
        this.setPassword(password);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public byte[] getBytes() throws UtilityException {
        int length = this.password.length();
        if (length % 4 != 0) {
            length += 4 - length % 4;
        }
        byte[] result = new byte[length += 4];
        System.arraycopy(Utility.IntegerToTwoBytes(Password.typeToInteger(this.type)), 0, result, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(length - 4), 0, result, 2, 2);
        byte[] temp = this.password.getBytes();
        System.arraycopy(temp, 0, result, 4, temp.length);
        return result;
    }

    public static Password parse(byte[] data) {
        Password result = new Password();
        String password = new String(data);
        result.setPassword(password);
        return result;
    }
}

