/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NextProtoNegoClientConnection
extends AbstractConnection
implements NextProtoNego.ClientProvider {
    private final Logger LOG = Log.getLogger(this.getClass());
    private final SocketChannel channel;
    private final Object attachment;
    private final SPDYClient client;
    private final SSLEngine engine;
    private volatile boolean completed;

    public NextProtoNegoClientConnection(SocketChannel channel, SslConnection.DecryptedEndPoint endPoint, Object attachment, Executor executor, SPDYClient client) {
        super(endPoint, executor);
        this.channel = channel;
        this.attachment = attachment;
        this.client = client;
        this.engine = endPoint.getSslConnection().getSSLEngine();
        NextProtoNego.put((SSLEngine)this.engine, (NextProtoNego.Provider)this);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        try {
            this.getEndPoint().flush(BufferUtil.EMPTY_BUFFER);
            if (this.completed) {
                this.replaceConnection();
            } else {
                this.fillInterested();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void onFillable() {
        int filled;
        do {
            if ((filled = this.fill()) != 0 || this.completed) continue;
            this.fillInterested();
        } while (filled > 0 && !this.completed);
        if (this.completed) {
            this.replaceConnection();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            this.LOG.debug(x);
            NextProtoNego.remove((SSLEngine)this.engine);
            this.getEndPoint().close();
            return -1;
        }
    }

    public boolean supports() {
        return true;
    }

    public void unsupported() {
        NextProtoNego.remove((SSLEngine)this.engine);
        this.completed = true;
    }

    public String selectProtocol(List<String> protocols) {
        NextProtoNego.remove((SSLEngine)this.engine);
        this.completed = true;
        String protocol = this.client.selectProtocol(protocols);
        return protocol == null ? null : protocol;
    }

    private void replaceConnection() {
        EndPoint endPoint = this.getEndPoint();
        Connection connection = this.client.getConnectionFactory().newConnection(this.channel, endPoint, this.attachment);
        endPoint.getConnection().onClose();
        endPoint.setConnection(connection);
        connection.onOpen();
    }
}

