/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import java.io.File;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class CheckNativeMethods {
    private static boolean first = true;

    private static void checkNativeMethods(JavaClass clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isNative()) continue;
            if (first) {
                first = false;
            } else {
                System.out.print(",");
            }
            System.out.print(clazz.getClassName());
            return;
        }
    }

    private static JavaClass[] increase_one(JavaClass[] old) {
        JavaClass[] s;
        if (old == null) {
            s = new JavaClass[1];
        } else {
            s = new JavaClass[old.length + 1];
            for (int i = 0; i < old.length; ++i) {
                s[i] = old[i];
            }
        }
        return s;
    }

    public static void main(String[] args) {
        int i;
        JavaClass[] clazz = null;
        boolean verbose = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-f")) {
                String filename = args[++i];
                try {
                    ClassParser p = new ClassParser(filename.replace('.', File.separatorChar));
                    clazz = CheckNativeMethods.increase_one(clazz);
                    clazz[clazz.length - 1] = p.parse();
                }
                catch (Exception e) {
                    System.err.println("Error for arg " + args[i] + ": " + e);
                    e.printStackTrace(System.err);
                    System.exit(1);
                }
                continue;
            }
            clazz = CheckNativeMethods.increase_one(clazz);
            int index = args[i].lastIndexOf(46);
            try {
                if (args[i].substring(index + 1).equals("class")) {
                    clazz[clazz.length - 1] = Repository.lookupClass((String)args[i].substring(0, index));
                    continue;
                }
                clazz[clazz.length - 1] = Repository.lookupClass((String)args[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: class " + args[i] + " not found");
                System.exit(1);
            }
        }
        if (clazz != null) {
            for (i = 0; i < clazz.length; ++i) {
                if (clazz[i] == null) continue;
                if (verbose) {
                    System.err.println("Check class " + clazz[i].getClassName());
                }
                CheckNativeMethods.checkNativeMethods(clazz[i]);
            }
            System.out.println("");
        }
    }
}

