/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.compile.ASMRepository;
import ibis.io.rewriter.ASMCodeGenerator;
import ibis.io.rewriter.ASMRewriterConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

class ASMSerializationInfo
implements ASMRewriterConstants,
Opcodes {
    static FieldComparator fieldComparator = new FieldComparator();
    static HashMap<String, Long> serialversionids = new HashMap();
    static HashMap<Type, ASMSerializationInfo> primitiveSerialization = new HashMap();
    static ASMSerializationInfo referenceSerialization = new ASMSerializationInfo("writeObject", "readObject", "readFieldObject", "Ljava/lang/Object;", false);
    String write_name;
    String read_name;
    String final_read_name;
    String signature;
    boolean primitive;

    ASMSerializationInfo(String wn, String rn, String frn, String signature, boolean primitive) {
        this.write_name = wn;
        this.read_name = rn;
        this.final_read_name = frn;
        this.signature = signature;
        this.primitive = primitive;
    }

    static ASMSerializationInfo getSerializationInfo(Type tp) {
        ASMSerializationInfo temp = primitiveSerialization.get(tp);
        return temp == null ? referenceSerialization : temp;
    }

    public static boolean directImplementationOf(ClassNode clazz, String name) {
        List names = clazz.interfaces;
        String supername = clazz.superName;
        if (supername != null && supername.equals(name)) {
            return true;
        }
        if (names == null) {
            return false;
        }
        for (String n : names) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean predecessor(String c1, ClassNode c2) {
        String n = c2.superName;
        if (n.equals(c1)) {
            return true;
        }
        if (n.equals("java/lang/Object")) {
            return false;
        }
        return ASMSerializationInfo.predecessor(c1, ASMCodeGenerator.lookupClass(n));
    }

    static boolean isFinal(Type t) {
        if (t.getSort() == 9) {
            return ASMSerializationInfo.isFinal(t.getElementType());
        }
        if (t.getSort() == 10) {
            ClassNode cl = ASMCodeGenerator.lookupClass(t.getInternalName());
            return (cl.access & 0x10) == 16;
        }
        return true;
    }

    static boolean isIbisSerializable(ClassNode clazz) {
        return ASMSerializationInfo.directImplementationOf(clazz, "ibis/io/Serializable");
    }

    static boolean isExternalizable(ClassNode clazz) {
        try {
            return ASMRepository.implementationOf((ClassNode)clazz, (String)"java/io/Externalizable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean isSerializable(ClassNode clazz) {
        try {
            return ASMRepository.implementationOf((ClassNode)clazz, (String)"java/io/Serializable");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static boolean hasSerialPersistentFields(List<FieldNode> fields) {
        for (FieldNode f : fields) {
            if (!f.name.equals("serialPersistentFields") || (f.access & 0x1A) != 26 || !f.desc.equals("[Ljava/io/ObjectStreamField;")) continue;
            return true;
        }
        return false;
    }

    static boolean hasFinalFields(List<FieldNode> fields) {
        for (FieldNode f : fields) {
            if ((f.access & 0x10) != 16) continue;
            return true;
        }
        return false;
    }

    static boolean hasIbisConstructor(ClassNode cl) {
        List methods = cl.methods;
        MethodNode[] clMethods = methods.toArray(new MethodNode[methods.size()]);
        for (int i = 0; i < clMethods.length; ++i) {
            if (!clMethods[i].name.equals("<init>") || !clMethods[i].desc.equals("(Libis/io/IbisSerializationInputStream;)V")) continue;
            return true;
        }
        return false;
    }

    static long computeSUID(ClassNode clazz) {
        if (!ASMSerializationInfo.isSerializable(clazz)) {
            return 0L;
        }
        try {
            int mods;
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(clazz.name);
            int classModifiers = clazz.access & 0x611;
            List methods = clazz.methods;
            MethodNode[] cMethods = methods.toArray(new MethodNode[methods.size()]);
            if ((classModifiers & 0x200) != 0) {
                classModifiers = cMethods.length > 0 ? (classModifiers |= 0x400) : (classModifiers &= 0xFFFFFBFF);
            }
            dout.writeInt(classModifiers);
            List l = clazz.interfaces;
            Object[] interfaceNames = l.toArray(new String[l.size()]);
            Arrays.sort(interfaceNames);
            for (int i2 = 0; i2 < interfaceNames.length; ++i2) {
                dout.writeUTF((String)interfaceNames[i2]);
            }
            List fields = clazz.fields;
            FieldNode[] cFields = fields.toArray(new FieldNode[fields.size()]);
            Arrays.sort(cFields, fieldComparator);
            for (i = 0; i < cFields.length; ++i) {
                mods = cFields[i].access;
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(cFields[i].name);
                dout.writeInt(mods);
                dout.writeUTF(cFields[i].desc);
            }
            for (i = 0; i < cMethods.length; ++i) {
                if (!cMethods[i].name.equals("<clinit>")) continue;
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
                break;
            }
            Arrays.sort(cMethods, new Comparator<MethodNode>(){

                @Override
                public int compare(MethodNode o1, MethodNode o2) {
                    String name1 = o1.name;
                    String name2 = o2.name;
                    if (name1.equals(name2)) {
                        String sig1 = o1.desc;
                        String sig2 = o2.desc;
                        return sig1.compareTo(sig2);
                    }
                    return name1.compareTo(name2);
                }
            });
            for (i = 0; i < cMethods.length; ++i) {
                if (!cMethods[i].name.equals("<init>") || ((mods = cMethods[i].access) & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(cMethods[i].desc.replace('/', '.'));
            }
            for (i = 0; i < cMethods.length; ++i) {
                if (cMethods[i].name.equals("<init>") || cMethods[i].name.equals("<clinit>") || ((mods = cMethods[i].access) & 2) != 0) continue;
                dout.writeUTF(cMethods[i].name);
                dout.writeInt(mods);
                dout.writeUTF(cMethods[i].desc.replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i3 = Math.min(hashBytes.length, 8) - 1; i3 >= 0; --i3) {
                hash = hash << 8 | (long)(hashBytes[i3] & 0xFF);
            }
            return hash;
        }
        catch (Exception ex) {
            System.err.println("Warning: could not get serialVersionUID for class " + clazz.name);
            ex.printStackTrace(System.err);
            return 0L;
        }
    }

    static long getSerialVersionUID(String classname, ClassNode clazz) {
        long uid;
        Long ui = serialversionids.get(classname);
        if (ui == null) {
            uid = ASMSerializationInfo.computeSUID(clazz);
            serialversionids.put(classname, new Long(uid));
        } else {
            uid = ui;
        }
        return uid;
    }

    static MethodNode findMethod(List<MethodNode> methods, String name, String signature) {
        for (MethodNode m : methods) {
            if (!m.name.equals(name) || !m.desc.equals(signature)) continue;
            return m;
        }
        return null;
    }

    static boolean hasWriteObject(List<MethodNode> methods) {
        return ASMSerializationInfo.findMethod(methods, "writeObject", "(Ljava/io/ObjectOutputStream;)V") != null;
    }

    static boolean hasReadObject(List<MethodNode> methods) {
        return ASMSerializationInfo.findMethod(methods, "readObject", "(Ljava/io/ObjectInputStream;)V") != null;
    }

    static {
        primitiveSerialization.put(Type.BOOLEAN_TYPE, new ASMSerializationInfo("writeBoolean", "readBoolean", "readFieldBoolean", "Z", true));
        primitiveSerialization.put(Type.BYTE_TYPE, new ASMSerializationInfo("writeByte", "readByte", "readFieldByte", "B", true));
        primitiveSerialization.put(Type.SHORT_TYPE, new ASMSerializationInfo("writeShort", "readShort", "readFieldShort", "S", true));
        primitiveSerialization.put(Type.CHAR_TYPE, new ASMSerializationInfo("writeChar", "readChar", "readFieldChar", "C", true));
        primitiveSerialization.put(Type.INT_TYPE, new ASMSerializationInfo("writeInt", "readInt", "readFieldInt", "I", true));
        primitiveSerialization.put(Type.LONG_TYPE, new ASMSerializationInfo("writeLong", "readLong", "readFieldLong", "J", true));
        primitiveSerialization.put(Type.FLOAT_TYPE, new ASMSerializationInfo("writeFloat", "readFloat", "readFieldFloat", "F", true));
        primitiveSerialization.put(Type.DOUBLE_TYPE, new ASMSerializationInfo("writeDouble", "readDouble", "readFieldDouble", "D", true));
        primitiveSerialization.put(TYPE_STRING, new ASMSerializationInfo("writeString", "readString", "readFieldString", TYPE_STRING.getDescriptor(), true));
        primitiveSerialization.put(TYPE_CLASS, new ASMSerializationInfo("writeClass", "readClass", "readFieldClass", TYPE_CLASS.getDescriptor(), true));
    }

    private static class FieldComparator
    implements Comparator<FieldNode> {
        private FieldComparator() {
        }

        @Override
        public int compare(FieldNode f1, FieldNode f2) {
            return f1.name.compareTo(f2.name);
        }
    }
}

