/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.nio;

import ibis.io.IOProperties;
import ibis.io.SimpleBigConversion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class NioChunkBigConversion
extends SimpleBigConversion {
    public static final int BUFFER_SIZE = IOProperties.CONVERSION_BUFFER_SIZE;
    private ByteOrder order = ByteOrder.BIG_ENDIAN;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE).order(this.order);
    private CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
    private ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
    private IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
    private LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
    private FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
    private DoubleBuffer doubleBuffer = this.byteBuffer.asDoubleBuffer();

    @Override
    public void char2byte(char[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 2, len);
            this.charBuffer.clear();
            this.charBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 2);
            this.byteBuffer.get(dst, off2, chunkSize * 2);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 2;
        }
    }

    @Override
    public void byte2char(byte[] src, int index_src, char[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 2, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 2);
            this.charBuffer.position(0).limit(chunkSize);
            this.charBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 2;
            index_dst += chunkSize;
        }
    }

    @Override
    public void short2byte(short[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 2, len);
            this.shortBuffer.clear();
            this.shortBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 2);
            this.byteBuffer.get(dst, off2, chunkSize * 2);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 2;
        }
    }

    @Override
    public void byte2short(byte[] src, int index_src, short[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 2, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 2);
            this.shortBuffer.position(0).limit(chunkSize);
            this.shortBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 2;
            index_dst += chunkSize;
        }
    }

    @Override
    public void int2byte(int[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 4, len);
            this.intBuffer.clear();
            this.intBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 4);
            this.byteBuffer.get(dst, off2, chunkSize * 4);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 4;
        }
    }

    @Override
    public void byte2int(byte[] src, int index_src, int[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 4, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 4);
            this.intBuffer.position(0).limit(chunkSize);
            this.intBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 4;
            index_dst += chunkSize;
        }
    }

    @Override
    public void long2byte(long[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 8, len);
            this.longBuffer.clear();
            this.longBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 8);
            this.byteBuffer.get(dst, off2, chunkSize * 8);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 8;
        }
    }

    @Override
    public void byte2long(byte[] src, int index_src, long[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 8, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 8);
            this.longBuffer.position(0).limit(chunkSize);
            this.longBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 8;
            index_dst += chunkSize;
        }
    }

    @Override
    public void float2byte(float[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 4, len);
            this.floatBuffer.clear();
            this.floatBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 4);
            this.byteBuffer.get(dst, off2, chunkSize * 4);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 4;
        }
    }

    @Override
    public void byte2float(byte[] src, int index_src, float[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 4, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 4);
            this.floatBuffer.position(0).limit(chunkSize);
            this.floatBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 4;
            index_dst += chunkSize;
        }
    }

    @Override
    public void double2byte(double[] src, int off, int len, byte[] dst, int off2) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 8, len);
            this.doubleBuffer.clear();
            this.doubleBuffer.put(src, off, chunkSize);
            this.byteBuffer.position(0).limit(chunkSize * 8);
            this.byteBuffer.get(dst, off2, chunkSize * 8);
            len -= chunkSize;
            off += chunkSize;
            off2 += chunkSize * 8;
        }
    }

    @Override
    public void byte2double(byte[] src, int index_src, double[] dst, int index_dst, int len) {
        while (len > 0) {
            int chunkSize = Math.min(BUFFER_SIZE / 8, len);
            this.byteBuffer.clear();
            this.byteBuffer.put(src, index_src, chunkSize * 8);
            this.doubleBuffer.position(0).limit(chunkSize);
            this.doubleBuffer.get(dst, index_dst, chunkSize);
            len -= chunkSize;
            index_src += chunkSize * 8;
            index_dst += chunkSize;
        }
    }
}

