/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.ByteSerializationOutputStream;
import ibis.io.DataOutputStream;
import ibis.io.DataSerializationInputStream;
import ibis.io.IOProperties;
import ibis.io.SerializationTimer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSerializationOutputStream
extends ByteSerializationOutputStream {
    private static final boolean DEBUG = IOProperties.DEBUG;
    private static final int SMALL_ARRAY_BOUND = IOProperties.SMALL_ARRAY_BOUND;
    private static final int ARRAY_BUFFER_SIZE = IOProperties.ARRAY_BUFFER_SIZE;
    private static final boolean NO_ARRAY_BUFFERS = IOProperties.properties.getBooleanProperty("ibis.io.noarraybuffers");
    private static Logger logger = LoggerFactory.getLogger(DataSerializationOutputStream.class);
    private static final boolean TIME_DATA_SERIALIZATION = IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.data") || IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.ibis");
    static final int TYPE_ARRAY = 1;
    private byte[] byte_buffer;
    private char[] char_buffer;
    private short[] short_buffer;
    private int[] int_buffer;
    private long[] long_buffer;
    private float[] float_buffer;
    private double[] double_buffer;
    private int byte_index;
    private int char_index;
    private int short_index;
    private int int_index;
    private int long_index;
    private int float_index;
    private int double_index;
    private final int BYTE_BUFFER_SIZE;
    private final int CHAR_BUFFER_SIZE;
    private final int SHORT_BUFFER_SIZE;
    private final int INT_BUFFER_SIZE;
    private final int LONG_BUFFER_SIZE;
    private final int FLOAT_BUFFER_SIZE;
    private final int DOUBLE_BUFFER_SIZE;
    private ArrayDescriptor[] array;
    private int array_index;
    private short[] indices_short;
    private boolean[] touched = new boolean[9];
    final SerializationTimer timer;

    public DataSerializationOutputStream(DataOutputStream out) throws IOException {
        super(out);
        int bufferSize = out.bufferSize();
        if (bufferSize <= 0) {
            bufferSize = IOProperties.TYPED_BUFFER_SIZE;
        }
        this.BYTE_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 1);
        this.CHAR_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 2);
        this.SHORT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 2);
        this.INT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 4);
        this.LONG_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 8);
        this.FLOAT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 4);
        this.DOUBLE_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 8);
        if (!NO_ARRAY_BUFFERS) {
            this.initArrays();
        }
        this.timer = TIME_DATA_SERIALIZATION ? new SerializationTimer(this.toString()) : null;
    }

    protected DataSerializationOutputStream() throws IOException {
        this.BYTE_BUFFER_SIZE = 0;
        this.CHAR_BUFFER_SIZE = 0;
        this.SHORT_BUFFER_SIZE = 0;
        this.INT_BUFFER_SIZE = 0;
        this.LONG_BUFFER_SIZE = 0;
        this.FLOAT_BUFFER_SIZE = 0;
        this.DOUBLE_BUFFER_SIZE = 0;
        this.timer = TIME_DATA_SERIALIZATION ? new SerializationTimer(this.toString()) : null;
    }

    @Override
    public String serializationImplName() {
        return "data";
    }

    @Override
    public void statistics() {
    }

    public void writeArrayBoolean(boolean[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < IOProperties.SMALL_ARRAY_BOUND / 1) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeBoolean(ref[i]);
            }
        } else {
            if (this.array_index == IOProperties.ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayBoolean: " + ref + " offset: " + offset + " len: " + len + " type: " + 1);
            }
            this.array[this.array_index].type = 1;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 1, len);
        }
    }

    public void writeArrayByte(byte[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 1) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeByte(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayByte: " + ref + " offset: " + offset + " len: " + len + " type: " + 2);
            }
            this.array[this.array_index].type = 2;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 2, len);
        }
    }

    public void internalWriteByteBuffer(ByteBuffer value) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeByteBuffer(value);
        } else {
            int len = value.limit() - value.position();
            if (len < SMALL_ARRAY_BOUND / 1) {
                for (int i = 0; i < len; ++i) {
                    this.writeByte(value.get());
                }
            } else {
                if (this.array_index == ARRAY_BUFFER_SIZE) {
                    this.internalFlush();
                }
                this.array[this.array_index].type = 2;
                this.array[this.array_index].offset = 0;
                this.array[this.array_index].len = len;
                this.array[this.array_index].array = value;
                ++this.array_index;
                this.addStatSendArray(value, 2, len);
            }
        }
    }

    public void writeArrayChar(char[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 2) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeChar(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayChar: " + new String(ref) + " offset: " + offset + " len: " + len + " type: " + 3);
            }
            this.array[this.array_index].type = 3;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 3, len);
        }
    }

    public void writeArrayShort(short[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 2) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeShort(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayShort: " + ref + " offset: " + offset + " len: " + len + " type: " + 4);
            }
            this.array[this.array_index].type = 4;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 4, len);
        }
    }

    public void writeArrayInt(int[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 4) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeInt(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayInt: " + ref + " offset: " + offset + " len: " + len + " type: " + 5);
            }
            this.array[this.array_index].type = 5;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 5, len);
        }
    }

    public void writeArrayLong(long[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < IOProperties.SMALL_ARRAY_BOUND / 8) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeLong(ref[i]);
            }
        } else {
            if (this.array_index == IOProperties.ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayLong: " + ref + " offset: " + offset + " len: " + len + " type: " + 6);
            }
            this.array[this.array_index].type = 6;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 6, len);
        }
    }

    public void writeArrayFloat(float[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 4) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeFloat(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayFloat: " + ref + " offset: " + offset + " len: " + len + " type: " + 7);
            }
            this.array[this.array_index].type = 7;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 7, len);
        }
    }

    public void writeArrayDouble(double[] ref, int offset, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.out.writeArray(ref, offset, len);
        } else if (len < SMALL_ARRAY_BOUND / 8) {
            for (int i = offset; i < offset + len; ++i) {
                this.writeDouble(ref[i]);
            }
        } else {
            if (this.array_index == ARRAY_BUFFER_SIZE) {
                this.internalFlush();
            }
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("writeArrayDouble: " + ref + " offset: " + offset + " len: " + len + " type: " + 8);
            }
            this.array[this.array_index].type = 8;
            this.array[this.array_index].offset = offset;
            this.array[this.array_index].len = len;
            this.array[this.array_index].array = ref;
            ++this.array_index;
            this.addStatSendArray(ref, 8, len);
        }
    }

    void addStatSendArray(Object ref, int type, int len) {
    }

    @Override
    public void flush() throws IOException {
        this.internalFlush();
        this.out.finish();
    }

    private void internalFlush() throws IOException {
        int i;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("doing a flush()");
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.suspend();
        }
        if (!NO_ARRAY_BUFFERS) {
            this.flushBuffers();
            for (i = 0; i < this.array_index; ++i) {
                ArrayDescriptor a = this.array[i];
                switch (a.type) {
                    case 1: {
                        this.out.writeArray((boolean[])a.array, a.offset, a.len);
                        break;
                    }
                    case 2: {
                        if (a.array instanceof ByteBuffer) {
                            this.out.writeByteBuffer((ByteBuffer)a.array);
                            break;
                        }
                        this.out.writeArray((byte[])a.array, a.offset, a.len);
                        break;
                    }
                    case 3: {
                        this.out.writeArray((char[])a.array, a.offset, a.len);
                        break;
                    }
                    case 4: {
                        this.out.writeArray((short[])a.array, a.offset, a.len);
                        break;
                    }
                    case 5: {
                        this.out.writeArray((int[])a.array, a.offset, a.len);
                        break;
                    }
                    case 6: {
                        this.out.writeArray((long[])a.array, a.offset, a.len);
                        break;
                    }
                    case 7: {
                        this.out.writeArray((float[])a.array, a.offset, a.len);
                        break;
                    }
                    case 8: {
                        this.out.writeArray((double[])a.array, a.offset, a.len);
                    }
                }
                a.array = null;
            }
            this.array_index = 0;
        }
        this.out.flush();
        if (TIME_DATA_SERIALIZATION) {
            this.timer.resume();
        }
        if (!NO_ARRAY_BUFFERS && !this.out.finished()) {
            this.indices_short = new short[9];
            if (this.touched[2]) {
                this.byte_buffer = new byte[this.BYTE_BUFFER_SIZE];
            }
            if (this.touched[3]) {
                this.char_buffer = new char[this.CHAR_BUFFER_SIZE];
            }
            if (this.touched[4]) {
                this.short_buffer = new short[this.SHORT_BUFFER_SIZE];
            }
            if (this.touched[5]) {
                this.int_buffer = new int[this.INT_BUFFER_SIZE];
            }
            if (this.touched[6]) {
                this.long_buffer = new long[this.LONG_BUFFER_SIZE];
            }
            if (this.touched[7]) {
                this.float_buffer = new float[this.FLOAT_BUFFER_SIZE];
            }
            if (this.touched[8]) {
                this.double_buffer = new double[this.DOUBLE_BUFFER_SIZE];
            }
        }
        for (i = 0; i < 9; ++i) {
            this.touched[i] = false;
        }
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeBoolean(value);
        } else {
            if (this.byte_index == this.byte_buffer.length) {
                this.internalFlush();
            }
            this.byte_buffer[this.byte_index++] = (byte)(value ? 1 : 0);
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote boolean " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeByte(byte value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeByte(value);
        } else {
            if (this.byte_index == this.byte_buffer.length) {
                this.internalFlush();
            }
            this.byte_buffer[this.byte_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote byte " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeChar(char value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeChar(value);
        } else {
            if (this.char_index == this.char_buffer.length) {
                this.internalFlush();
            }
            this.char_buffer[this.char_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote char " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeShort(short value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeShort(value);
        } else {
            if (this.short_index == this.short_buffer.length) {
                this.internalFlush();
            }
            this.short_buffer[this.short_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote short " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeInt(value);
        } else {
            if (this.int_index == this.int_buffer.length) {
                this.internalFlush();
            }
            this.int_buffer[this.int_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote int[HEX] " + value + "[0x" + Integer.toHexString(value) + "]");
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeLong(value);
        } else {
            if (this.long_index == this.long_buffer.length) {
                this.internalFlush();
            }
            this.long_buffer[this.long_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote long " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeFloat(float value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeFloat(value);
        } else {
            if (this.float_index == this.float_buffer.length) {
                this.internalFlush();
            }
            this.float_buffer[this.float_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote float " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeDouble(double value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            this.out.writeDouble(value);
        } else {
            if (this.double_index == this.double_buffer.length) {
                this.internalFlush();
            }
            this.double_buffer[this.double_index++] = value;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("wrote double " + value);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    private void initArrays() {
        this.array = new ArrayDescriptor[ARRAY_BUFFER_SIZE];
        for (int i = 0; i < ARRAY_BUFFER_SIZE; ++i) {
            this.array[i] = new ArrayDescriptor();
        }
        this.indices_short = new short[9];
        this.byte_buffer = new byte[this.BYTE_BUFFER_SIZE];
        this.char_buffer = new char[this.CHAR_BUFFER_SIZE];
        this.short_buffer = new short[this.SHORT_BUFFER_SIZE];
        this.int_buffer = new int[this.INT_BUFFER_SIZE];
        this.long_buffer = new long[this.LONG_BUFFER_SIZE];
        this.float_buffer = new float[this.FLOAT_BUFFER_SIZE];
        this.double_buffer = new double[this.DOUBLE_BUFFER_SIZE];
    }

    @Override
    public void writeString(String str) throws IOException {
        this.writeUTF(str);
    }

    public void writeUTF(String str) throws IOException {
        int i;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (str == null) {
            this.writeInt(-1);
            if (TIME_DATA_SERIALIZATION) {
                this.timer.stop();
            }
            return;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("write UTF " + str);
        }
        int len = str.length();
        int bn = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = str.charAt(i2);
            if (c > '\u0000' && c <= '\u007f') {
                ++bn;
                continue;
            }
            if (c <= '\u07ff') {
                bn += 2;
                continue;
            }
            bn += 3;
        }
        byte[] b = new byte[bn];
        bn = 0;
        for (i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                b[bn++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                b[bn++] = (byte)(0xC0 | 0x1F & c >> 6);
                b[bn++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            b[bn++] = (byte)(0xE0 | 0xF & c >> 12);
            b[bn++] = (byte)(0x80 | 0x3F & c >> 6);
            b[bn++] = (byte)(0x80 | 0x3F & c);
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeUTF: len = " + bn);
            for (i = 0; i < bn; ++i) {
                logger.debug("writeUTF: b[" + i + "] = " + (b[i] & 0xFF));
            }
        }
        this.writeInt(bn);
        this.writeArrayByte(b, 0, bn);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    private void reset_indices() {
        this.byte_index = 0;
        this.char_index = 0;
        this.short_index = 0;
        this.int_index = 0;
        this.long_index = 0;
        this.float_index = 0;
        this.double_index = 0;
    }

    private void flushBuffers() throws IOException {
        this.indices_short[1] = (short)this.array_index;
        this.indices_short[2] = (short)this.byte_index;
        this.indices_short[3] = (short)this.char_index;
        this.indices_short[4] = (short)this.short_index;
        this.indices_short[5] = (short)this.int_index;
        this.indices_short[6] = (short)this.long_index;
        this.indices_short[7] = (short)this.float_index;
        this.indices_short[8] = (short)this.double_index;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writing arrays " + this.array_index);
            logger.debug("writing bytes " + this.byte_index);
            logger.debug("writing chars " + this.char_index);
            logger.debug("writing shorts " + this.short_index);
            logger.debug("writing ints " + this.int_index);
            logger.debug("writing longs " + this.long_index);
            logger.debug("writing floats " + this.float_index);
            logger.debug("writing doubles " + this.double_index);
        }
        this.out.writeArray(this.indices_short, 1, 8);
        if (this.byte_index > 0) {
            this.out.writeArray(this.byte_buffer, 0, this.byte_index);
            this.touched[2] = true;
        }
        if (this.char_index > 0) {
            this.out.writeArray(this.char_buffer, 0, this.char_index);
            this.touched[3] = true;
        }
        if (this.short_index > 0) {
            this.out.writeArray(this.short_buffer, 0, this.short_index);
            this.touched[4] = true;
        }
        if (this.int_index > 0) {
            this.out.writeArray(this.int_buffer, 0, this.int_index);
            this.touched[5] = true;
        }
        if (this.long_index > 0) {
            this.out.writeArray(this.long_buffer, 0, this.long_index);
            this.touched[6] = true;
        }
        if (this.float_index > 0) {
            this.out.writeArray(this.float_buffer, 0, this.float_index);
            this.touched[7] = true;
        }
        if (this.double_index > 0) {
            this.out.writeArray(this.double_buffer, 0, this.double_index);
            this.touched[8] = true;
        }
        this.reset_indices();
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayBoolean(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayByte(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.internalWriteByteBuffer(value);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayShort(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayChar(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayInt(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayLong(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayFloat(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.writeArrayDouble(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.byte_buffer = null;
        this.char_buffer = null;
        this.short_buffer = null;
        this.int_buffer = null;
        this.long_buffer = null;
        this.float_buffer = null;
        this.double_buffer = null;
        this.array = null;
    }

    private static final class ArrayDescriptor {
        int type;
        Object array;
        int offset;
        int len;

        private ArrayDescriptor() {
        }
    }
}

