/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.GESUtils;
import com.touchgraph.graphlayout.graphelements.Locality;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalityUtils {
    TGPanel tgPanel;
    Locality locality;
    public static final int INFINITE_LOCALITY_RADIUS = Integer.MAX_VALUE;
    ShiftLocaleThread shiftLocaleThread;
    boolean fastFinishShift = false;

    public LocalityUtils(Locality loc, TGPanel tgp) {
        this.locality = loc;
        this.tgPanel = tgp;
    }

    public void fastFinishAnimation() {
        this.fastFinishShift = true;
    }

    private synchronized boolean markDistantNodes(Hashtable<Node, Integer> subgraph) {
        boolean[] someNodeWasMarked = new boolean[]{false};
        for (Node n : this.locality.getNodeIterable()) {
            if (subgraph.containsKey(n)) continue;
            n.markedForRemoval = true;
            someNodeWasMarked[0] = true;
        }
        return someNodeWasMarked[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMarkedNodes() {
        Vector<Node> nodesToRemove = new Vector<Node>();
        Locality locality = this.locality;
        synchronized (locality) {
            for (Node n : this.locality.getNodeIterable()) {
                if (!n.markedForRemoval) continue;
                nodesToRemove.addElement(n);
                n.markedForRemoval = false;
                n.massfade = 1.0;
            }
            this.locality.removeNodes(nodesToRemove);
        }
    }

    private synchronized void addNearNodes(Hashtable<Node, Integer> distHash, int radius) throws TGException {
        for (int r = 0; r < radius + 1; ++r) {
            Enumeration<Node> localNodes = distHash.keys();
            while (localNodes.hasMoreElements()) {
                Node n = localNodes.nextElement();
                if (this.locality.contains(n) || distHash.get(n) > r) continue;
                n.massfade = 1.0;
                n.justMadeLocal = true;
                this.locality.addNodeWithEdges(n);
                if (this.fastFinishShift) continue;
                try {
                    if (radius == 1) {
                        Thread.sleep(50L);
                        continue;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {}
            }
        }
    }

    private synchronized void unmarkNewAdditions() {
        for (Node n : this.locality.getNodeIterable()) {
            n.justMadeLocal = false;
        }
    }

    public void setLocale(Node n, int radius, int maxAddEdgeCount, int maxExpandEdgeCount, boolean unidirectional) throws TGException {
        if (n == null || radius < 0) {
            return;
        }
        if (this.shiftLocaleThread != null && this.shiftLocaleThread.isAlive()) {
            this.fastFinishShift = true;
            while (this.shiftLocaleThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (radius == Integer.MAX_VALUE || n == null) {
            this.addAllGraphElts();
            this.tgPanel.resetDamper();
            return;
        }
        this.fastFinishShift = false;
        this.shiftLocaleThread = new ShiftLocaleThread(n, radius, maxAddEdgeCount, maxExpandEdgeCount, unidirectional);
    }

    public void setLocale(Node n, int radius) throws TGException {
        this.setLocale(n, radius, 1000, 1000, false);
    }

    public synchronized void addAllGraphElts() throws TGException {
        this.locality.addAll();
    }

    public void expandNode(final Node n) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(n)) {
                        return;
                    }
                    LocalityUtils.this.tgPanel.stopDamper();
                    for (Edge e : n.getEdgeIterable()) {
                        Node newNode = e.getOtherEndpt(n);
                        if (!LocalityUtils.this.locality.contains(newNode)) {
                            newNode.justMadeLocal = true;
                            try {
                                LocalityUtils.this.locality.addNodeWithEdges(newNode);
                                Thread.sleep(50L);
                            }
                            catch (TGException tge) {
                                System.err.println("TGException: " + tge.getMessage());
                            }
                            catch (InterruptedException ex) {}
                            continue;
                        }
                        if (LocalityUtils.this.locality.contains(e)) continue;
                        LocalityUtils.this.locality.addEdge(e);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.unmarkNewAdditions();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    public void hideNode(final Node hideNode) {
        if (hideNode == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(hideNode)) {
                        return;
                    }
                    LocalityUtils.this.locality.removeNode(hideNode);
                    if (hideNode == LocalityUtils.this.tgPanel.getSelect()) {
                        LocalityUtils.this.tgPanel.clearSelect();
                    }
                    Hashtable<Node, Integer> subgraph = GESUtils.getLargestConnectedSubgraph(LocalityUtils.this.locality);
                    LocalityUtils.this.markDistantNodes(subgraph);
                    LocalityUtils.this.tgPanel.repaint();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    public void collapseNode(final Node collapseNode) {
        if (collapseNode == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(collapseNode)) {
                        return;
                    }
                    LocalityUtils.this.locality.removeNode(collapseNode);
                    Hashtable<Node, Integer> subgraph = GESUtils.getLargestConnectedSubgraph(LocalityUtils.this.locality);
                    LocalityUtils.this.markDistantNodes(subgraph);
                    try {
                        LocalityUtils.this.locality.addNodeWithEdges(collapseNode);
                    }
                    catch (TGException tge) {
                        tge.printStackTrace();
                    }
                    LocalityUtils.this.tgPanel.repaint();
                    LocalityUtils.this.tgPanel.resetDamper();
                    try {
                        Thread.sleep(600L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    class ShiftLocaleThread
    extends Thread {
        Hashtable<Node, Integer> distHash;
        Node focusNode;
        int radius;
        int maxAddEdgeCount;
        int maxExpandEdgeCount;
        boolean unidirectional;

        ShiftLocaleThread(Node n, int r, int maec, int meec, boolean unid) {
            this.focusNode = n;
            this.radius = r;
            this.maxAddEdgeCount = maec;
            this.maxExpandEdgeCount = meec;
            this.unidirectional = unid;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LocalityUtils localityUtils = LocalityUtils.this;
            synchronized (localityUtils) {
                if (!LocalityUtils.this.locality.getCompleteEltSet().contains(this.focusNode)) {
                    return;
                }
                LocalityUtils.this.tgPanel.stopDamper();
                this.distHash = GESUtils.calculateDistances(LocalityUtils.this.locality.getCompleteEltSet(), this.focusNode, this.radius, this.maxAddEdgeCount, this.maxExpandEdgeCount, this.unidirectional);
                try {
                    int i;
                    if (this.radius == 1) {
                        LocalityUtils.this.addNearNodes(this.distHash, this.radius);
                        for (i = 0; i < 4 && !LocalityUtils.this.fastFinishShift; ++i) {
                            Thread.sleep(100L);
                        }
                        LocalityUtils.this.unmarkNewAdditions();
                        for (i = 0; i < 4 && !LocalityUtils.this.fastFinishShift; ++i) {
                            Thread.sleep(100L);
                        }
                    }
                    if (LocalityUtils.this.markDistantNodes(this.distHash)) {
                        for (i = 0; i < 8 && !LocalityUtils.this.fastFinishShift; ++i) {
                            Thread.sleep(100L);
                        }
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    for (i = 0; i < 1 && !LocalityUtils.this.fastFinishShift; ++i) {
                        if (this.radius <= 1) continue;
                        Thread.sleep(100L);
                    }
                    if (this.radius != 1) {
                        LocalityUtils.this.addNearNodes(this.distHash, this.radius);
                        for (i = 0; i < 4 && !LocalityUtils.this.fastFinishShift; ++i) {
                            Thread.sleep(100L);
                        }
                        LocalityUtils.this.unmarkNewAdditions();
                    }
                }
                catch (TGException tge) {
                    System.err.println("TGException: " + tge.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LocalityUtils.this.tgPanel.resetDamper();
            }
        }
    }
}

