/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.simple;

import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class ConnectTest {
    private static final int SERVERPORT = 42611;
    private static final int REPEAT = 10;
    private static final int COUNT = 1000;
    private static final int TIMEOUT = 1000;
    private static final boolean PINGPONG = false;
    private static VirtualSocketFactory sf;
    private static HashMap<String, Object> connectProperties;
    private static boolean pingpong;
    private static int count;
    private static int timeout;
    private static boolean fillTimeout;
    private static boolean sleep;
    private static Random rand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect(VirtualSocketAddress target) {
        long[] detailedDirect = new long[1 + 2 * target.machine().numberOfAddresses()];
        long[] detailedVirtual = new long[5];
        connectProperties.put("direct.detailed.timing", detailedDirect);
        connectProperties.put("virtual.detailed.timing", detailedVirtual);
        int failed = 0;
        long time = System.currentTimeMillis();
        for (int c = 0; c < count; ++c) {
            VirtualSocket s;
            OutputStream out;
            InputStream in;
            block8: {
                in = null;
                out = null;
                s = null;
                try {
                    s = sf.createClientSocket(target, timeout, fillTimeout, connectProperties);
                    if (!pingpong) break block8;
                    s.setTcpNoDelay(true);
                    out = s.getOutputStream();
                    out.write(42);
                    out.flush();
                    in = s.getInputStream();
                    int tmp = in.read();
                    if (tmp == 42) break block8;
                    System.err.println("EEP: got " + tmp + " instead of 42");
                }
                catch (Exception e) {
                    try {
                        time = System.currentTimeMillis() - time;
                        System.out.println("Failed to create connection to " + target);
                        e.printStackTrace();
                        ++failed;
                    }
                    catch (Throwable throwable) {
                        VirtualSocketFactory.close(s, out, in);
                        throw throwable;
                    }
                    VirtualSocketFactory.close(s, out, in);
                    continue;
                }
            }
            VirtualSocketFactory.close(s, out, in);
            continue;
        }
        time = System.currentTimeMillis() - time;
        System.out.println(count + " connections in " + time + " ms. -> " + (double)time / (double)count + "ms/conn, Failed: " + failed);
        System.out.println("Details direct : " + Arrays.toString(detailedDirect));
        Arrays.fill(detailedDirect, 0L);
        System.out.println("Details virtual: " + Arrays.toString(detailedVirtual));
        Arrays.fill(detailedVirtual, 0L);
        if (sleep) {
            try {
                Thread.sleep(1000 + rand.nextInt(5000));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void accept(String id) throws IOException {
        System.out.println("Creating server socket");
        VirtualServerSocket ss = sf.createServerSocket(42611, 0, connectProperties);
        System.out.println("Created server on " + ss.getLocalSocketAddress());
        if (id != null) {
            sf.getServiceLink().registerProperty(id, ss.getLocalSocketAddress().toString());
        }
        System.out.println("Server waiting for connections");
        while (true) {
            InputStream in = null;
            OutputStream out = null;
            try {
                VirtualSocket s = ss.accept();
                if (pingpong) {
                    s.setTcpNoDelay(true);
                    in = s.getInputStream();
                    int tmp = in.read();
                    if (tmp != 42) {
                        System.err.println("EEP: got " + tmp + " instead of 42");
                    }
                    out = s.getOutputStream();
                    out.write(42);
                    out.flush();
                }
                VirtualSocketFactory.close(s, out, in);
                continue;
            }
            catch (Exception e) {
                System.out.println("Server got exception " + e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        ClientInfo[] info;
        try {
            sf = VirtualSocketFactory.createSocketFactory();
        }
        catch (InitializationException e1) {
            System.out.println("Failed to create socketfactory!");
            e1.printStackTrace();
            System.exit(1);
        }
        connectProperties = new HashMap();
        String id = null;
        int targets = args.length;
        int repeat = 10;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-repeat")) {
                repeat = Integer.parseInt(args[i + 1]);
                args[i + 1] = null;
                args[i] = null;
                targets -= 2;
                ++i;
                continue;
            }
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[i + 1]);
                args[i + 1] = null;
                args[i] = null;
                targets -= 2;
                ++i;
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Integer.parseInt(args[i + 1]);
                args[i + 1] = null;
                args[i] = null;
                targets -= 2;
                ++i;
                continue;
            }
            if (args[i].equals("-fill")) {
                fillTimeout = true;
                args[i] = null;
                --targets;
                continue;
            }
            if (args[i].equals("-sleep")) {
                sleep = true;
                args[i] = null;
                --targets;
                continue;
            }
            if (args[i].equals("-ssh")) {
                connectProperties.put("allowSSH", "true");
                args[i] = null;
                --targets;
                continue;
            }
            if (args[i].equals("-pingpong")) {
                pingpong = true;
                args[i] = null;
                --targets;
                continue;
            }
            if (args[i].equals("-cache")) {
                connectProperties.put("cache.winner", null);
                args[i] = null;
                --targets;
                continue;
            }
            if (!args[i].equals("-id")) continue;
            id = args[i + 1];
            args[i + 1] = null;
            args[i] = null;
            targets -= 2;
            ++i;
        }
        VirtualSocketAddress[] targetAds = new VirtualSocketAddress[targets];
        int index = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            targetAds[index++] = new VirtualSocketAddress(args[i]);
        }
        if (targets == 0 && id != null && (info = sf.getServiceLink().clients(id)) != null && info.length > 0) {
            index = 0;
            targetAds = new VirtualSocketAddress[info.length];
            ClientInfo[] clientInfoArray = info;
            int n = clientInfoArray.length;
            for (int i = 0; i < n; ++i) {
                ClientInfo c = clientInfoArray[i];
                String address = c.getProperty(id);
                if (address == null) continue;
                targetAds[index++] = new VirtualSocketAddress(address);
            }
        }
        if (targetAds.length > 0) {
            for (VirtualSocketAddress a : targetAds) {
                if (a == null) continue;
                if (sleep) {
                    try {
                        Thread.sleep(1000 + rand.nextInt(5000));
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
                System.out.println("Creating connection to " + a);
                for (int r = 0; r < repeat; ++r) {
                    ConnectTest.connect(a);
                }
            }
        } else {
            ConnectTest.accept(id);
        }
        sf.printStatistics("");
    }

    static {
        pingpong = false;
        count = 1000;
        timeout = 1000;
        fillTimeout = false;
        sleep = false;
        rand = new Random();
    }
}

