/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.AdaptorServerSocketFactory;
import mx4j.tools.adaptor.PlainAdaptorServerSocketFactory;
import mx4j.tools.adaptor.http.DefaultProcessor;
import mx4j.tools.adaptor.http.HttpAdaptorMBean;
import mx4j.tools.adaptor.http.HttpCommandProcessor;
import mx4j.tools.adaptor.http.HttpException;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpOutputStream;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.util.Base64Codec;
import org.w3c.dom.Document;

public class HttpAdaptor
implements HttpAdaptorMBean,
MBeanRegistration {
    private static final String VERSION = "2.1.1";
    private int port = 8080;
    private String host = "localhost";
    private MBeanServer server;
    private ServerSocket serverSocket;
    private boolean alive;
    private Map commands = new HashMap();
    private ProcessorMBean processor = null;
    private ObjectName processorName = null;
    private ProcessorMBean defaultProcessor = new DefaultProcessor();
    private String authenticationMethod = "none";
    private String realm = "MX4J";
    private Map authorizations = new HashMap();
    private AdaptorServerSocketFactory socketFactory = null;
    private ObjectName factoryName;
    private String processorClass;
    private Date startDate;
    private long requestsCount;
    private String[][] defaultCommandProcessors = new String[][]{{"server", "mx4j.tools.adaptor.http.ServerCommandProcessor"}, {"serverbydomain", "mx4j.tools.adaptor.http.ServerByDomainCommandProcessor"}, {"mbean", "mx4j.tools.adaptor.http.MBeanCommandProcessor"}, {"setattributes", "mx4j.tools.adaptor.http.SetAttributesCommandProcessor"}, {"setattribute", "mx4j.tools.adaptor.http.SetAttributeCommandProcessor"}, {"getattribute", "mx4j.tools.adaptor.http.GetAttributeCommandProcessor"}, {"delete", "mx4j.tools.adaptor.http.DeleteMBeanCommandProcessor"}, {"invoke", "mx4j.tools.adaptor.http.InvokeOperationCommandProcessor"}, {"create", "mx4j.tools.adaptor.http.CreateMBeanCommandProcessor"}, {"constructors", "mx4j.tools.adaptor.http.ConstructorsCommandProcessor"}, {"relation", "mx4j.tools.adaptor.http.RelationCommandProcessor"}, {"empty", "mx4j.tools.adaptor.http.EmptyCommandProcessor"}};
    private DocumentBuilder builder;

    public HttpAdaptor() {
    }

    public HttpAdaptor(int port) {
        this.port = port;
    }

    public HttpAdaptor(String host) {
        this.host = host;
    }

    public HttpAdaptor(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public void setPort(int port) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setAuthenticationMethod(String method) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change authentication method with the server running");
        }
        if (method == null || !method.equals("none") && !method.equals("basic") && !method.equals("digest")) {
            throw new IllegalArgumentException("Only accept methods none/basic/digest");
        }
        this.authenticationMethod = method;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setProcessor(ProcessorMBean processor) {
        this.processor = processor;
        this.processorName = null;
    }

    public void setProcessorClass(String processorClass) {
        this.processorClass = processorClass;
    }

    public void setProcessorNameString(String processorName) throws MalformedObjectNameException {
        this.processorName = new ObjectName(processorName);
    }

    public void setProcessorName(ObjectName processorName) {
        this.processor = null;
        this.processorName = processorName;
    }

    public ProcessorMBean getProcessor() {
        return this.processor;
    }

    public ObjectName getProcessorName() {
        return this.processorName;
    }

    public void setSocketFactory(AdaptorServerSocketFactory factory) {
        this.factoryName = null;
        this.socketFactory = factory;
    }

    public void setSocketFactoryName(ObjectName factoryName) {
        this.socketFactory = null;
        this.factoryName = factoryName;
    }

    public void setSocketFactoryNameString(String factoryName) throws MalformedObjectNameException {
        this.socketFactory = null;
        this.factoryName = new ObjectName(factoryName);
    }

    public boolean isActive() {
        return this.alive;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getRequestsCount() {
        return this.requestsCount;
    }

    public String getVersion() {
        return VERSION;
    }

    public void addCommandProcessor(String path, HttpCommandProcessor processor) {
        this.commands.put(path, processor);
        if (this.alive) {
            processor.setMBeanServer(this.server);
            processor.setDocumentBuilder(this.builder);
        }
    }

    public void addCommandProcessor(String path, String processorClass) {
        try {
            HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(processorClass).newInstance();
            this.addCommandProcessor(path, processor);
        }
        catch (Exception e) {
            Logger log = this.getLogger();
            log.error("Exception creating Command Processor of class " + processorClass, e);
        }
    }

    public void removeCommandProcessor(String path) {
        if (this.commands.containsKey(path)) {
            this.commands.remove(path);
        }
    }

    public void start() throws IOException {
        final Logger logger = this.getLogger();
        if (this.server != null) {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket == null) {
                logger.error("Server socket is null");
                return;
            }
            if (this.processorClass != null && this.processorName != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Building processor class of type " + this.processorClass + " and name " + this.processorName);
                }
                try {
                    this.server.createMBean(this.processorClass, this.processorName, null);
                }
                catch (JMException e) {
                    logger.error("Exception creating processor class", e);
                }
            }
            Iterator i = this.commands.values().iterator();
            while (i.hasNext()) {
                HttpCommandProcessor processor = (HttpCommandProcessor)i.next();
                processor.setMBeanServer(this.server);
                processor.setDocumentBuilder(this.builder);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("HttpAdaptor server listening on port " + this.port);
            }
            this.alive = true;
            Thread serverThread = new Thread(new Runnable(){

                public void run() {
                    if (logger.isEnabledFor(20)) {
                        logger.info("HttpAdaptor version 2.1.1 started on port " + HttpAdaptor.this.port);
                    }
                    HttpAdaptor.this.startDate = new Date();
                    HttpAdaptor.this.requestsCount = 0L;
                    while (HttpAdaptor.this.alive) {
                        try {
                            Socket client = null;
                            client = HttpAdaptor.this.serverSocket.accept();
                            if (!HttpAdaptor.this.alive) {
                                client.close();
                                break;
                            }
                            HttpAdaptor.this.requestsCount++;
                            new HttpClient(client).start();
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (Exception e) {
                            logger.warn("Exception during request processing", e);
                        }
                        catch (Error e) {
                            logger.error("Error during request processing", e);
                        }
                    }
                    try {
                        HttpAdaptor.this.serverSocket.close();
                    }
                    catch (IOException e) {
                        logger.warn("Exception closing the server", e);
                    }
                    HttpAdaptor.this.serverSocket = null;
                    HttpAdaptor.this.alive = false;
                    if (logger.isEnabledFor(20)) {
                        logger.info("HttpAdaptor version 2.1.1 stopped on port " + HttpAdaptor.this.port);
                    }
                }
            });
            serverThread.start();
        } else if (logger.isEnabledFor(20)) {
            logger.info("Start failed, no server target server has been set");
        }
    }

    public void restart() throws IOException {
        this.stop();
        this.start();
    }

    public void stop() {
        try {
            if (this.alive) {
                this.alive = false;
                new Socket(this.host, this.port);
            }
        }
        catch (IOException e) {
            this.getLogger().warn(e.getMessage());
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn(e.getMessage());
        }
    }

    public void addAuthorization(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username and passwords cannot be null");
        }
        this.authorizations.put(username, password);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.buildCommands();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.socketFactory == null) {
            if (this.factoryName == null) {
                this.socketFactory = new PlainAdaptorServerSocketFactory();
                return this.socketFactory.createServerSocket(this.port, 50, this.host);
            }
            try {
                return (ServerSocket)this.server.invoke(this.factoryName, "createServerSocket", new Object[]{new Integer(this.port), new Integer(50), this.host}, new String[]{"int", "int", "java.lang.String"});
            }
            catch (Exception x) {
                Logger log = this.getLogger();
                log.error("Exception invoking AdaptorServerSocketFactory via MBeanServer", x);
            }
        } else {
            return this.socketFactory.createServerSocket(this.port, 50, this.host);
        }
        return null;
    }

    private boolean isUsernameValid(String username, String password) {
        if (this.authorizations.containsKey(username)) {
            return password.equals(this.authorizations.get(username));
        }
        return false;
    }

    protected HttpCommandProcessor getProcessor(String path) {
        return (HttpCommandProcessor)this.commands.get(path);
    }

    protected void buildCommands() {
        Logger log = this.getLogger();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
            for (int i = 0; i < this.defaultCommandProcessors.length; ++i) {
                try {
                    HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(this.defaultCommandProcessors[i][1]).newInstance();
                    this.commands.put(this.defaultCommandProcessors[i][0], processor);
                    continue;
                }
                catch (Exception e) {
                    log.warn("Exception building command procesor", e);
                }
            }
        }
        catch (ParserConfigurationException e) {
            log.error("Exception building the Document Factories", e);
        }
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Document document) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeResponse", new Object[]{out, in, document}, new String[]{"mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream", "org.w3c.dom.Document"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeResponse(out, in, document);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeResponse(out, in, document);
        }
    }

    protected void findUnknownElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "notFoundElement", new Object[]{path, out, in}, new String[]{"java.lang.String", "mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.notFoundElement(path, out, in);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.notFoundElement(path, out, in);
        }
    }

    protected String preProcess(String path) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            Logger log = this.getLogger();
            if (log.isEnabledFor(0)) {
                log.trace("Preprocess using " + this.processorName);
            }
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                if (log.isEnabledFor(0)) {
                    log.trace("Preprocessing");
                }
                path = (String)this.server.invoke(this.processorName, "preProcess", new Object[]{path}, new String[]{"java.lang.String"});
                processed = true;
            } else if (log.isEnabledFor(0)) {
                log.trace(this.processorName + " not found");
            }
        }
        if (!processed && this.processor != null) {
            path = this.processor.preProcess(path);
            processed = true;
        }
        if (!processed) {
            path = this.defaultProcessor.preProcess(path);
        }
        return path;
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeError", new Object[]{out, in, e}, new String[]{"mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream", "java.lang.Exception"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeError(out, in, e);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeError(out, in, e);
        }
    }

    static /* synthetic */ Logger access$800(HttpAdaptor x0) {
        return x0.getLogger();
    }

    private class HttpClient
    extends Thread {
        private Socket client;

        HttpClient(Socket client) {
            this.client = client;
        }

        public boolean isValid(String authorizationString) {
            String decodeString;
            if (HttpAdaptor.this.authenticationMethod.startsWith("basic") && (decodeString = new String(Base64Codec.decodeBase64((authorizationString = authorizationString.substring(5, authorizationString.length())).getBytes()))).indexOf(":") > 0) {
                try {
                    StringTokenizer tokens = new StringTokenizer(decodeString, ":");
                    String username = tokens.nextToken();
                    String password = tokens.nextToken();
                    return HttpAdaptor.this.isUsernameValid(username, password);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }

        private boolean handleAuthentication(HttpInputStream in, HttpOutputStream out) throws IOException {
            if (HttpAdaptor.this.authenticationMethod.equals("basic")) {
                String result = in.getHeader("authorization");
                if (result != null) {
                    if (this.isValid(result)) {
                        return true;
                    }
                    throw new HttpException(403, "Authentication failed");
                }
                out.setCode(401);
                out.setHeader("WWW-Authenticate", "Basic realm=\"" + HttpAdaptor.this.realm + "\"");
                out.sendHeaders();
                out.flush();
                return false;
            }
            if (HttpAdaptor.this.authenticationMethod.equals("digest")) {
                // empty if block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            log = HttpAdaptor.access$800(HttpAdaptor.this);
            httpIn = null;
            httpOut = null;
            try {
                try {
                    block58: {
                        in = this.client.getInputStream();
                        httpIn = new HttpInputStream(in);
                        httpIn.readRequest();
                        path = httpIn.getPath();
                        queryString = httpIn.getQueryString();
                        if (log.isEnabledFor(10)) {
                            log.debug("Request " + path + (queryString == null ? "" : "?" + queryString));
                        }
                        if (!(postPath = HttpAdaptor.this.preProcess(path)).equals(path)) {
                            if (log.isEnabledFor(10)) {
                                log.debug("Processor replaced path " + path + " with the path " + postPath);
                            }
                            path = postPath;
                        }
                        if (this.handleAuthentication(httpIn, (HttpOutputStream)(httpOut = new HttpOutputStream(out = this.client.getOutputStream(), httpIn)))) break block58;
                        var12_16 = null;
                        ** GOTO lbl-1000
                    }
                    processor = HttpAdaptor.this.getProcessor(path.substring(1, path.length()));
                    if (processor == null) {
                        if (log.isEnabledFor(10)) {
                            log.debug("No suitable command processor found, requesting from processor path " + path);
                        }
                        HttpAdaptor.this.findUnknownElement(path, (HttpOutputStream)httpOut, httpIn);
                    } else {
                        document = processor.executeRequest(httpIn);
                        HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, document);
                    }
                    ** GOTO lbl184
                }
                catch (Exception ex) {
                    log.warn("Exception during http request", ex);
                    if (httpOut != null) {
                        try {
                            HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, ex);
                        }
                        catch (IOException e) {
                            log.warn("IOException during http request", e);
                        }
                        catch (JMException e) {
                            log.warn("JMException during http request", e);
                        }
                        catch (RuntimeException rte) {
                            log.error("RuntimeException during http request", rte);
                        }
                        catch (Error er) {
                            log.error("Error during http request ", er);
                        }
                        catch (Throwable t) {
                            log.fatal("Throwable during http request ", t);
                        }
                    }
                    var12_18 = null;
                    try {
                        if (httpOut != null) {
                            httpOut.flush();
                        }
                    }
                    catch (IOException e) {
                        log.warn("Exception during request processing", e);
                        var15_28 = null;
                        try {
                            this.client.close();
                            return;
                        }
                        catch (IOException e) {
                            log.info("Exception during socket close", e);
                            return;
                        }
                    }
                    var15_27 = null;
                    ** GOTO lbl-1000
                    {
                        catch (Throwable var14_58) {
                            var15_29 = null;
                            ** try [egrp 5[TRYBLOCK] [18 : 475->485)] { 
lbl76:
                            // 1 sources

                            this.client.close();
                            throw var14_58;
lbl78:
                            // 1 sources

                            catch (IOException e) {
                                log.info("Exception during socket close", e);
                            }
                            throw var14_58;
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException e) {}
                        log.info("Exception during socket close", e);
                        return;
                        this.client.close();
                        return;
                    }
                }
                catch (Error ex) {
                    log.error("Error during http request ", ex);
                    var12_19 = null;
                    ** try [egrp 3[TRYBLOCK] [15 : 435->465)] { 
lbl-1000:
                    // 1 sources

                    {
                        catch (Throwable var14_59) {
                            var15_32 = null;
                            ** try [egrp 5[TRYBLOCK] [18 : 475->485)] { 
lbl96:
                            // 1 sources

                            this.client.close();
                            throw var14_59;
lbl98:
                            // 1 sources

                            catch (IOException e) {
                                log.info("Exception during socket close", e);
                            }
                            throw var14_59;
                        }
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        log.warn("Exception during request processing", e);
                        var15_31 = null;
                        try {}
                        catch (IOException e) {
                            log.info("Exception during socket close", e);
                            return;
                        }
                        this.client.close();
                        return;
                    }
                    if (httpOut != null) {
                        httpOut.flush();
                    }
                    var15_30 = null;
                    {
                        try {}
                        catch (IOException e) {}
                        log.info("Exception during socket close", e);
                        return;
                        this.client.close();
                        return;
                    }
                }
            }
            catch (Throwable var11_63) {
                var12_20 = null;
                ** try [egrp 3[TRYBLOCK] [15 : 435->465)] { 
lbl-1000:
                // 1 sources

                {
                    catch (Throwable var14_60) {
                        var15_35 = null;
                        ** try [egrp 5[TRYBLOCK] [18 : 475->485)] { 
lbl131:
                        // 1 sources

                        this.client.close();
                        throw var14_60;
lbl133:
                        // 1 sources

                        catch (IOException e) {
                            log.info("Exception during socket close", e);
                        }
                        throw var14_60;
                    }
                }
lbl-1000:
                // 1 sources

                try {}
                catch (IOException e) {
                    log.warn("Exception during request processing", e);
                    var15_34 = null;
                    try {}
                    catch (IOException e) {
                        log.info("Exception during socket close", e);
                        throw var11_63;
                    }
                    this.client.close();
                    throw var11_63;
                }
                if (httpOut != null) {
                    httpOut.flush();
                }
                var15_33 = null;
                ** GOTO lbl-1000
lbl-1000:
                // 1 sources

                {
                    ** try [egrp 3[TRYBLOCK] [15 : 435->465)] { 
lbl-1000:
                    // 1 sources

                    {
                        catch (Throwable var14_56) {
                            var15_23 = null;
                            ** try [egrp 5[TRYBLOCK] [18 : 475->485)] { 
lbl157:
                            // 1 sources

                            this.client.close();
                            throw var14_56;
lbl159:
                            // 1 sources

                            catch (IOException e) {
                                log.info("Exception during socket close", e);
                            }
                            throw var14_56;
                        }
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        log.warn("Exception during request processing", e);
                        var15_22 = null;
                        try {}
                        catch (IOException e) {
                            log.info("Exception during socket close", e);
                            return;
                        }
                        this.client.close();
                        return;
                    }
                    if (httpOut != null) {
                        httpOut.flush();
                    }
                    var15_21 = null;
                    {
                        try {}
                        catch (IOException e) {}
                        log.info("Exception during socket close", e);
                        return;
                        this.client.close();
                        return;
                    }
lbl184:
                    // 2 sources

                    var12_17 = null;
                    ** try [egrp 3[TRYBLOCK] [15 : 435->465)] { 
lbl-1000:
                    // 1 sources

                    {
                        catch (Throwable var14_57) {
                            var15_26 = null;
                            ** try [egrp 5[TRYBLOCK] [18 : 475->485)] { 
lbl190:
                            // 1 sources

                            this.client.close();
                            throw var14_57;
lbl192:
                            // 1 sources

                            catch (IOException e) {
                                log.info("Exception during socket close", e);
                            }
                            throw var14_57;
                        }
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        log.warn("Exception during request processing", e);
                        var15_25 = null;
                        try {}
                        catch (IOException e) {
                            log.info("Exception during socket close", e);
                            return;
                        }
                        this.client.close();
                        return;
                    }
                    if (httpOut != null) {
                        httpOut.flush();
                    }
                    var15_24 = null;
                    {
                        try {}
                        catch (IOException e) {}
                        log.info("Exception during socket close", e);
                        return;
                        this.client.close();
                        return;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {}
                    log.info("Exception during socket close", e);
                    throw var11_63;
                    this.client.close();
                    throw var11_63;
                }
            }
        }
    }
}

