/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.viz;

import com.touchgraph.graphlayout.Edge;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.viz.ClientNode;
import ibis.smartsockets.viz.HubNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class RouterClientNode
extends ClientNode {
    private ArrayList<String> mouseOverText = new ArrayList();
    private HashMap<String, ConnectionInfo> cons = new HashMap();
    private HashMap<String, ConnectionInfo> oldCons = new HashMap();

    public RouterClientNode(ClientInfo info, HubNode hub) {
        super(info.getClientAddress().toString(), hub, false);
        this.setRank(0);
        this.setType(4);
        this.setBackColor(Color.decode("#FF7F24"));
        this.setNodeBorderInactiveColor(Color.decode("#CD661D"));
        this.setLabel("R");
        this.update(info);
    }

    private String convert(long tp) {
        if (tp < 1024L) {
            return tp + " bit/s";
        }
        if ((tp /= 1024L) < 1024L) {
            return tp + " Kbit/s";
        }
        return (tp /= 1024L) + " Mbit/s";
    }

    private void addConnection(String from, String to, String id, String tp) {
        String tmp = from + id;
        ConnectionInfo c = this.oldCons.remove(tmp);
        if (c == null) {
            try {
                c = new ConnectionInfo(DirectSocketAddress.getByAddress(from), DirectSocketAddress.getByAddress(to), id, Long.parseLong(tp));
            }
            catch (Exception e) {
                System.out.println("Failed to create ConnectionInfo " + e);
            }
        }
        if (c != null) {
            this.cons.put(tmp, c);
        }
    }

    private void parseConnections(StringTokenizer t) {
        int connections = Integer.parseInt(t.nextToken());
        this.mouseOverText.add("Connections: " + connections);
        if (connections == 0) {
            this.mouseOverText.add("Throughput : 0 Mbit/s");
            this.setMouseOverText(this.mouseOverText.toArray(new String[0]));
            return;
        }
        HashMap<String, ConnectionInfo> tmp = this.cons;
        this.cons = this.oldCons;
        this.oldCons = tmp;
        try {
            for (int i = 0; i < connections; ++i) {
                String from = t.nextToken();
                String to = t.nextToken();
                String id = t.nextToken();
                String tp = t.nextToken();
                this.addConnection(from, to, id, tp);
            }
            long totalTP = Long.parseLong(t.nextToken());
            this.mouseOverText.add("Throughput : " + this.convert(totalTP));
        }
        catch (Exception e) {
            System.out.println("Oops: " + e);
        }
        this.cleanupOldConnections();
    }

    private void cleanupOldConnections() {
        if (this.oldCons.size() > 0) {
            for (ConnectionInfo i : this.oldCons.values()) {
                if (i.edge1 != null) {
                    this.hub.deleteEdge(i.edge1);
                }
                if (i.edge2 == null) continue;
                this.hub.deleteEdge(i.edge2);
            }
            this.oldCons.clear();
        }
    }

    public void update(ClientInfo info) {
        String adr = info.getClientAddress().toString();
        this.mouseOverText.add("Router     : " + adr);
        String stats = info.getProperty("statistics");
        if (stats == null || stats.length() == 0) {
            this.mouseOverText.add("Connections: 0");
            this.mouseOverText.add("Throughput : 0 Mbit/s");
            this.setMouseOverText(this.mouseOverText.toArray(new String[0]));
        } else {
            StringTokenizer t = new StringTokenizer(stats, ", ");
            if (t.countTokens() == 0) {
                this.mouseOverText.add("Connections: 0");
                this.mouseOverText.add("Throughput : 0 Mbit/s");
                this.setMouseOverText(this.mouseOverText.toArray(new String[0]));
            } else {
                this.parseConnections(t);
            }
        }
        this.setMouseOverText(this.mouseOverText.toArray(new String[0]));
        this.mouseOverText.clear();
    }

    public void showConnections(HashMap<Object, ClientNode> clients) {
        for (ConnectionInfo c : this.cons.values()) {
            if (c.edge1 == null) {
                ClientNode from = clients.get(c.from);
                if (from != null) {
                    c.edge1 = new Edge(from, this);
                    c.edge1.setColor(Color.LIGHT_GRAY);
                } else {
                    System.out.println("Could not add edge: " + c.from + " to router");
                }
            }
            if (c.edge2 == null) {
                ClientNode to = clients.get(c.to);
                if (to != null) {
                    c.edge2 = new Edge(this, to);
                    c.edge2.setColor(Color.LIGHT_GRAY);
                } else {
                    System.out.println("Could not add edge: router to " + c.to);
                    System.out.println("Clients:");
                    System.out.println(clients.toString());
                    System.out.println("\n\n\n");
                }
            }
            if (c.edge1 != null && !c.edge1.isVisible()) {
                this.hub.showEdge(c.edge1);
            }
            if (c.edge2 == null || c.edge2.isVisible()) continue;
            this.hub.showEdge(c.edge2);
        }
    }

    private static class ConnectionInfo {
        String id;
        DirectSocketAddress from;
        DirectSocketAddress to;
        long tp;
        Edge edge1;
        Edge edge2;

        ConnectionInfo(DirectSocketAddress from, DirectSocketAddress to, String id, long tp) {
            this.from = from;
            this.to = to;
            this.id = id;
            this.tp = tp;
        }

        String getID() {
            return this.id;
        }

        long getTP() {
            return this.tp;
        }
    }
}

