/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.connections;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.MessageForwardingConnection;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.ClientDescription;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import ibis.smartsockets.hub.state.StateCounter;
import ibis.smartsockets.hub.state.StateSelector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubConnection
extends MessageForwardingConnection {
    private static final Logger conlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.hub");
    private static final Logger goslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.gossip");
    private final HubDescription peer;
    private final HubDescription local;
    private final StateCounter state;
    private long lastSendState;
    private final String uniquePrefix;

    public HubConnection(DirectSocket s, DataInputStream in, DataOutputStream out, HubDescription peer, Connections connections, HubList hubs, StateCounter state, VirtualConnections vcs, boolean master, StatisticsCallback callback, long statisticsInterval) {
        super(s, in, out, connections, hubs, vcs, master, "Hub(" + peer.hubAddressAsString + ")", callback, statisticsInterval);
        this.peer = peer;
        this.state = state;
        this.uniquePrefix = peer.hubAddressAsString + "__";
        this.local = hubs.getLocalDescription();
    }

    @Override
    protected String getUniqueID(long index) {
        return this.uniquePrefix + index;
    }

    public synchronized void setLastSendState() {
        this.lastSendState = this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gossip() {
        long newSendState = this.state.get();
        if (goslogger.isInfoEnabled()) {
            goslogger.info("Gossiping with: " + this.peer.hubAddress);
        }
        StateSelector ss = new StateSelector(this.lastSendState);
        this.knownHubs.select(ss);
        try {
            int writes = 0;
            for (HubDescription tmp : ss.getResult()) {
                if (goslogger.isInfoEnabled()) {
                    goslogger.info("    Writing hub: " + tmp.hubAddressAsString);
                }
                if (goslogger.isDebugEnabled()) {
                    goslogger.debug("      since lastLocalUpdate=" + tmp.getLastLocalUpdate() + " > lastSendState= " + this.lastSendState);
                }
                this.writeHub(tmp);
                ++writes;
            }
            if (writes == 0) {
                this.writePing();
            }
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.flush();
            }
            this.lastSendState = newSendState;
            this.peer.setContactTimeStamp(false);
        }
        catch (Exception e) {
            goslogger.info("Unhandled exception in HubConnection!!", (Throwable)e);
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing() throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHub(HubDescription d) throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(20);
            this.out.writeUTF(d.hubAddress.toString());
            this.out.writeUTF(d.getName());
            this.out.writeUTF(d.getVizInfo());
            this.out.writeInt(d.getHops());
            if (d.isLocal()) {
                this.out.writeLong(d.getLastLocalUpdate());
            } else {
                this.out.writeLong(d.getHomeState());
            }
            ArrayList<ClientDescription> clients = d.getClients(null);
            this.out.writeInt(clients.size());
            for (ClientDescription c : clients) {
                c.write(this.out);
            }
            String[] connectedTo = d.connectedTo();
            if (connectedTo == null || connectedTo.length == 0) {
                this.out.writeInt(0);
                return;
            }
            this.out.writeInt(connectedTo.length);
            for (String c : connectedTo) {
                this.out.writeUTF(c);
            }
        }
    }

    private void readHub() throws IOException {
        DirectSocketAddress address = DirectSocketAddress.getByAddress(this.in.readUTF());
        String name = this.in.readUTF();
        String color = this.in.readUTF();
        HubDescription tmp = this.knownHubs.add(address);
        int hops = this.in.readInt();
        long state = this.in.readLong();
        int clients = this.in.readInt();
        ClientDescription[] c = new ClientDescription[clients];
        for (int i = 0; i < clients; ++i) {
            c[i] = ClientDescription.read(this.in);
        }
        int conns = this.in.readInt();
        String[] a = new String[conns];
        for (int i = 0; i < conns; ++i) {
            a[i] = this.in.readUTF();
        }
        if (this.local.hubAddress.equals(address)) {
            if (hops == 0) {
                this.peer.setCanReachMe();
            } else {
                this.peer.setCanNotReachMe();
            }
        } else if (tmp == this.peer) {
            if (state > tmp.getHomeState()) {
                tmp.update(c, a, name, state, color);
            } else if (state < tmp.getHomeState()) {
                goslogger.warn("EEK: got information directly from " + this.peer.hubAddressAsString + (name.length() > 0 ? " (" + name + ")" : "") + " which seems to be out of date! " + state + " " + tmp.getHomeState());
            }
        } else {
            if (hops + 1 < tmp.getHops() && tmp.addIndirection(this.peer, hops + 1) && vclogger.isDebugEnabled()) {
                vclogger.debug("Found shortcut to hub: " + tmp.hubAddressAsString + " via " + this.peer.hubAddressAsString + " in " + (hops + 1) + " hops");
            }
            if (state > tmp.getHomeState()) {
                tmp.update(c, a, name, state, color);
            } else if (state < tmp.getHomeState()) {
                String pn = this.peer.getName();
                if (goslogger.isDebugEnabled()) {
                    goslogger.debug("Ignoring outdated information about " + tmp.hubAddressAsString + (name.length() > 0 ? " (" + name + ")" : "") + " from " + this.peer.hubAddressAsString + (pn.length() > 0 ? " (" + pn + ") " : " ") + state + " " + tmp.getHomeState());
                }
            }
        }
        this.peer.setContactTimeStamp(false);
    }

    private void handlePing() {
        if (goslogger.isInfoEnabled()) {
            goslogger.debug("Got ping from " + this.peer.hubAddress);
        }
        this.peer.setContactTimeStamp(false);
    }

    @Override
    protected String getName() {
        return "HubConnection(" + this.peer.hubAddress + ")";
    }

    private void disconnect() {
        this.connections.removeHub(this.peer.hubAddress);
        this.local.removeConnectedTo(this.peer.hubAddressAsString);
        this.peer.removeConnection();
        DirectSocketFactory.close(this.s, (OutputStream)this.out, (InputStream)this.in);
        this.closeAllVirtualConnections(this.uniquePrefix);
    }

    @Override
    protected boolean handleOpcode(int opcode) {
        try {
            switch (opcode) {
                case 20: {
                    if (goslogger.isInfoEnabled()) {
                        goslogger.info("HubConnection got gossip!");
                    }
                    this.readHub();
                    return true;
                }
                case 7: {
                    if (goslogger.isInfoEnabled()) {
                        goslogger.info("HubConnection got ping!");
                    }
                    this.handlePing();
                    return true;
                }
            }
            conlogger.warn("HubConnection got junk!");
            this.disconnect();
            return false;
        }
        catch (Exception e) {
            conlogger.warn("HubConnection got exception!", (Throwable)e);
            this.disconnect();
            return false;
        }
    }

    @Override
    protected void handleDisconnect(Exception e) {
        this.disconnect();
        if (vclogger.isInfoEnabled()) {
            vclogger.info("Hub lost connection to " + this.peer.hubAddressAsString + " (disconnect not implemented!)", (Throwable)e);
        }
    }
}

