/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.discovery.Discovery;
import ibis.smartsockets.hub.Acceptor;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.Connector;
import ibis.smartsockets.hub.Statistics;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.connections.MessageForwardingConnectionStatistics;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.ConnectionsSelector;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import ibis.smartsockets.hub.state.StateCounter;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.TypedProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hub
extends Thread
implements StatisticsCallback {
    private static int GOSSIP_SLEEP = 3000;
    private static final int DEFAULT_DISCOVERY_PORT = 24545;
    private static final int DEFAULT_ACCEPT_PORT = 17878;
    private static final Logger misclogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.misc");
    private static final Logger goslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.gossip");
    private final boolean printStatistics;
    private final long STAT_FREQ;
    private final HubList hubs;
    private final Connections connections;
    private final Acceptor acceptor;
    private final Connector connector;
    private final StateCounter state;
    private final Discovery discovery;
    private final VirtualConnections virtualConnections;
    private final String addressFile;
    private long nextStats;
    private MessageForwardingConnectionStatistics mfcStats;
    private boolean done;

    public Hub(TypedProperties p) throws IOException {
        String name;
        DirectSocketAddress local;
        Object[] clusters;
        boolean allowDiscovery;
        block23: {
            boolean allowSSHForHub;
            super("Hub");
            this.state = new StateCounter();
            this.mfcStats = new MessageForwardingConnectionStatistics("Connection(*)");
            this.done = false;
            allowDiscovery = p.booleanProperty("smartsockets.discovery.allowed", false);
            clusters = p.getStringList("smartsockets.hub.clusters", ",", null);
            if (clusters == null || clusters.length == 0) {
                clusters = new String[]{"*"};
            }
            if (allowSSHForHub = p.booleanProperty("smartsockets.hub.ssh", true)) {
                if (misclogger.isInfoEnabled()) {
                    misclogger.info("Hub allowd to use SSH");
                }
                p.setProperty("smartsockets.modules.direct.ssh.in", "true");
                p.setProperty("smartsockets.modules.direct.ssh.out", "true");
            }
            if (misclogger.isInfoEnabled()) {
                misclogger.info("Creating Hub for clusters: " + Arrays.deepToString(clusters));
            }
            DirectSocketFactory factory = DirectSocketFactory.getSocketFactory(p);
            this.hubs = new HubList(this.state);
            this.connections = new Connections();
            this.virtualConnections = new VirtualConnections();
            int port = p.getIntProperty("smartsockets.hub.port", 17878);
            boolean delegate = p.booleanProperty("smartsockets.hub.delegate");
            DirectSocketAddress delegationAddress = null;
            if (delegate) {
                String tmp = p.getProperty("smartsockets.hub.delegate.address");
                if (misclogger.isDebugEnabled()) {
                    misclogger.debug("**** HUB USING DELEGATION TO: " + tmp);
                }
                try {
                    delegationAddress = DirectSocketAddress.getByAddress(tmp);
                }
                catch (Exception e) {
                    throw new IOException("Failed to parse delegation address: \"" + tmp + "\"");
                }
            }
            this.acceptor = new Acceptor(p, port, this.state, this.connections, this.hubs, this.virtualConnections, factory, delegationAddress, this, 5000L);
            this.connector = new Connector(p, this.state, this.connections, this.hubs, this.virtualConnections, factory, this, 5000L);
            local = this.acceptor.getLocal();
            this.connector.setLocal(local);
            if (goslogger.isInfoEnabled()) {
                goslogger.info("GossipAcceptor listning at " + local);
            }
            if ((name = p.getProperty("smartsockets.hub.name")) == null || name.length() == 0) {
                try {
                    name = NetworkUtils.getHostname();
                }
                catch (Exception e) {
                    if (!misclogger.isInfoEnabled()) break block23;
                    misclogger.info("Failed to find simple name for hub!");
                }
            }
        }
        if (misclogger.isInfoEnabled()) {
            misclogger.info("Hub got name: " + name);
        }
        String color = p.getProperty("smartsockets.hub.viz.info");
        HubDescription localDesc = new HubDescription(name, local, this.state, true, color);
        localDesc.setReachable();
        localDesc.setCanReachMe();
        this.hubs.addLocalDescription(localDesc);
        this.addHubs(p.getStringList("smartsockets.hub.addresses"));
        if (goslogger.isInfoEnabled()) {
            goslogger.info("Starting Gossip connector/acceptor");
        }
        this.acceptor.activate();
        this.connector.activate();
        if (misclogger.isInfoEnabled()) {
            misclogger.info("Listning for broadcast on LAN");
        }
        if (allowDiscovery) {
            Object[] suffixes = new String[clusters.length];
            for (int i = 0; i < clusters.length; ++i) {
                if (((String)clusters[i]).equals("*") && clusters.length > 0) {
                    suffixes = new String[]{"*"};
                    break;
                }
                suffixes[i] = ((String)clusters[i]).equals("+") ? "+" : " " + (String)clusters[i];
            }
            int dp = p.getIntProperty("smartsockets.discovery.port", 24545);
            this.discovery = new Discovery(dp, 0, 0);
            this.discovery.answeringMachine("Any Proxies?", (String[])suffixes, local.toString());
            if (misclogger.isInfoEnabled()) {
                misclogger.info("Hub will reply to discovery requests from: " + Arrays.deepToString(suffixes));
            }
        } else {
            this.discovery = null;
            if (misclogger.isInfoEnabled()) {
                misclogger.info("Hub will not reply to discovery requests!");
            }
        }
        if (goslogger.isInfoEnabled()) {
            goslogger.info("Start Gossiping!");
        }
        this.printStatistics = p.booleanProperty("smartsockets.hub.statistics", false);
        this.STAT_FREQ = p.getIntProperty("smartsockets.hub.statistics.interval", 60000);
        this.nextStats = System.currentTimeMillis() + this.STAT_FREQ;
        this.addressFile = p.getProperty("smartsockets.hub.addressfile");
        if (this.addressFile != null && this.addressFile.length() > 0) {
            this.writeAddressFile();
        }
        this.setDaemon(true);
        this.start();
    }

    private void writeAddressFile() {
        try {
            File f = new File(this.addressFile);
            PrintStream out = new PrintStream(new FileOutputStream(f));
            out.println(this.getHubAddress().toString());
            out.close();
            f.deleteOnExit();
        }
        catch (Exception e) {
            misclogger.warn("Failed to save address to file!", (Throwable)e);
        }
    }

    public void addHubs(DirectSocketAddress ... hubAddresses) {
        DirectSocketAddress local = this.hubs.getLocalDescription().hubAddress;
        if (hubAddresses != null) {
            for (DirectSocketAddress s : hubAddresses) {
                if (s == null || local.sameProcess(s)) continue;
                if (misclogger.isInfoEnabled()) {
                    misclogger.info("Adding hub address: " + s);
                }
                this.hubs.add(s);
            }
        }
    }

    public void addHubs(String ... hubAddresses) {
        DirectSocketAddress local = this.hubs.getLocalDescription().hubAddress;
        if (hubAddresses != null) {
            for (String s : hubAddresses) {
                if (s == null) continue;
                try {
                    DirectSocketAddress tmp = DirectSocketAddress.getByAddress(s);
                    if (local.sameProcess(tmp)) continue;
                    if (misclogger.isInfoEnabled()) {
                        misclogger.info("Adding hub address: " + s);
                    }
                    this.hubs.add(tmp);
                }
                catch (Exception e) {
                    misclogger.warn("Failed to parse hub address: " + s);
                }
            }
        }
    }

    private void gossip() {
        if (goslogger.isDebugEnabled()) {
            goslogger.debug("Starting gossip round (local state = " + this.state.get() + ")");
            goslogger.debug("I know the following hubs:\n" + this.hubs.toString());
        }
        ConnectionsSelector selector = new ConnectionsSelector();
        this.hubs.select(selector);
        for (HubConnection c : selector.getResult()) {
            if (c == null) continue;
            c.gossip();
        }
    }

    public void delegateAccept(DirectSocket s) {
        this.acceptor.addIncoming(s);
    }

    public DirectSocketAddress getHubAddress() {
        return this.acceptor.getLocal();
    }

    public DirectSocketAddress[] knownHubs() {
        return this.hubs.knownHubs();
    }

    private synchronized boolean getDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Hub hub = this;
        synchronized (hub) {
            this.done = true;
        }
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.acceptor.end();
        this.connector.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Statistics s) {
        if (!this.printStatistics) {
            return;
        }
        if (this.mfcStats == null) {
            return;
        }
        MessageForwardingConnectionStatistics messageForwardingConnectionStatistics = this.mfcStats;
        synchronized (messageForwardingConnectionStatistics) {
            this.mfcStats.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void statistics() {
        if (!this.printStatistics) {
            return;
        }
        if (this.mfcStats == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextStats) {
            return;
        }
        System.err.println("--- HUB Statistics ---");
        System.err.println(" Connections : " + this.connections.numberOfConnections());
        System.err.println("  - hubs     : " + this.connections.numberOfHubs());
        System.err.println("  - clients  : " + this.connections.numberOfClients());
        System.err.println("--- Connection Statistics ---");
        MessageForwardingConnectionStatistics messageForwardingConnectionStatistics = this.mfcStats;
        synchronized (messageForwardingConnectionStatistics) {
            this.mfcStats.print(System.err, " ");
        }
        this.nextStats = now + this.STAT_FREQ;
    }

    @Override
    public void run() {
        while (!this.getDone()) {
            try {
                if (goslogger.isDebugEnabled()) {
                    goslogger.debug("Sleeping for " + GOSSIP_SLEEP + " ms.");
                }
                Thread.sleep(GOSSIP_SLEEP);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gossip();
            this.statistics();
        }
    }
}

