/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub;

import ibis.smartsockets.direct.DirectSSHSocket;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.CommunicationThread;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.BaseConnection;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import ibis.smartsockets.hub.state.StateCounter;
import ibis.smartsockets.util.TypedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connector
extends CommunicationThread {
    private static final Logger hconlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.hub");
    private int sendBuffer = -1;
    private int receiveBuffer = -1;
    private final int usercode;
    private final StatisticsCallback callback;
    private final long statisticsInterval;

    Connector(TypedProperties p, StateCounter state, Connections connections, HubList knownHubs, VirtualConnections vcs, DirectSocketFactory factory, StatisticsCallback callback, long statisticsInterval) {
        super("HubConnector", state, connections, knownHubs, vcs, factory);
        this.callback = callback;
        this.statisticsInterval = statisticsInterval;
        this.sendBuffer = p.getIntProperty("smartsockets.hub.sendbuffer", -1);
        this.receiveBuffer = p.getIntProperty("smartsockets.hub.receivebuffer", -1);
        this.usercode = p.getIntProperty("smartsockets.hub.virtualPort", 42);
    }

    private boolean sendConnect(DataOutputStream out, DataInputStream in) throws IOException {
        if (hconlogger.isDebugEnabled()) {
            hconlogger.debug("Sending connection request");
        }
        out.write(1);
        out.writeUTF(this.localAsString);
        out.flush();
        int opcode = in.read();
        switch (opcode) {
            case 3: {
                if (hconlogger.isDebugEnabled()) {
                    hconlogger.debug("Connection request accepted");
                }
                return true;
            }
            case 4: {
                if (hconlogger.isDebugEnabled()) {
                    hconlogger.debug("Connection request refused (duplicate)");
                }
                return false;
            }
        }
        if (hconlogger.isDebugEnabled()) {
            hconlogger.warn("Got unknown reply from proxy! (" + opcode + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(HubDescription d) {
        DirectSocket s = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        if (hconlogger.isDebugEnabled()) {
            hconlogger.debug("Creating test connection to " + d.hubAddress);
        }
        try {
            s = this.factory.createSocket(d.hubAddress, 10000, 0, this.sendBuffer, this.receiveBuffer, null, false, this.usercode);
            s.setTcpNoDelay(true);
            s.setSoTimeout(10000);
            out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            out.write(7);
            out.writeUTF(this.localAsString);
            out.flush();
            if (hconlogger.isDebugEnabled()) {
                hconlogger.debug("Succesfully created connection!");
            }
            d.setReachable();
            this.knownHubs.getLocalDescription().addConnectedTo(d.hubAddressAsString);
        }
        catch (IOException e) {
            try {
                if (hconlogger.isDebugEnabled()) {
                    hconlogger.debug("Failed to set up connection!");
                }
                d.setUnreachable();
                this.knownHubs.getLocalDescription().removeConnectedTo(d.hubAddressAsString);
            }
            catch (Throwable throwable) {
                DirectSocketFactory.close(s, out, in);
                throw throwable;
            }
            DirectSocketFactory.close(s, out, in);
        }
        DirectSocketFactory.close(s, (OutputStream)out, (InputStream)in);
    }

    private void createConnection(HubDescription d) {
        String name;
        boolean master;
        DirectSocket s = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        boolean result = false;
        BaseConnection c = null;
        boolean bl = master = this.localAsString.compareTo(d.hubAddress.toString()) < 0;
        if (hconlogger.isInfoEnabled()) {
            hconlogger.info("Creating connection to " + d.hubAddress);
        }
        try {
            s = this.factory.createSocket(d.hubAddress, 10000, 0, this.sendBuffer, this.receiveBuffer, null, false, this.usercode);
            s.setTcpNoDelay(true);
            s.setSoTimeout(10000);
            if (hconlogger.isInfoEnabled()) {
                hconlogger.info("Send buffer = " + s.getSendBufferSize());
                hconlogger.info("Recv buffer = " + s.getReceiveBufferSize());
            }
            out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            if (master) {
                if (hconlogger.isDebugEnabled()) {
                    hconlogger.debug("I am master during connection setup");
                }
                if (!(result = d.createConnection((HubConnection)(c = new HubConnection(s, in, out, d, this.connections, this.knownHubs, this.state, this.virtualConnections, true, this.callback, this.statisticsInterval))))) {
                    if (hconlogger.isDebugEnabled()) {
                        hconlogger.debug("Connection was already created!");
                    }
                    out.write(7);
                    out.writeUTF(this.localAsString);
                    out.flush();
                } else {
                    result = this.sendConnect(out, in);
                }
            } else {
                if (hconlogger.isDebugEnabled()) {
                    hconlogger.debug("I am slave during connection setup");
                }
                if ((result = this.sendConnect(out, in)) && !(result = d.createConnection((HubConnection)(c = new HubConnection(s, in, out, d, this.connections, this.knownHubs, this.state, this.virtualConnections, false, this.callback, this.statisticsInterval))))) {
                    hconlogger.warn("Race condition triggered during connection setup!!");
                }
            }
            s.setSoTimeout(0);
            d.setReachable();
            name = d.hubAddressAsString;
            if (s instanceof DirectSSHSocket) {
                name = name + " (SSH)";
            }
            this.knownHubs.getLocalDescription().addConnectedTo(name);
        }
        catch (IOException e) {
            if (hconlogger.isDebugEnabled()) {
                hconlogger.debug("Got exception!", (Throwable)e);
            }
            d.setUnreachable();
            DirectSocketFactory.close(s, out, in);
        }
        if (result) {
            if (hconlogger.isDebugEnabled()) {
                hconlogger.debug("Succesfully created connection to " + d.hubAddressAsString);
            }
            this.connections.put(d.hubAddress, (HubConnection)c);
            c.activate();
            name = d.hubAddressAsString;
            if (s instanceof DirectSSHSocket) {
                name = name + " (SSH)";
            }
            this.knownHubs.getLocalDescription().addConnectedTo(name);
        } else {
            if (hconlogger.isInfoEnabled()) {
                hconlogger.info("Failed to set up connection!");
            }
            DirectSocketFactory.close(s, out, in);
        }
    }

    private void handleNewHub() {
        HubDescription d = this.knownHubs.nextHubToCheck();
        if (d == null) {
            return;
        }
        if (d.haveConnection()) {
            this.testConnection(d);
        } else {
            this.createConnection(d);
        }
        this.knownHubs.putBack(d);
    }

    @Override
    public void run() {
        while (!this.getDone()) {
            this.handleNewHub();
        }
    }
}

