/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputWriter
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputWriter.class);
    private final String content;
    private final OutputStream destination;
    private boolean finished = false;

    public InputWriter(String content, OutputStream destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Destination may not be null");
        }
        this.content = content;
        this.destination = destination;
        this.setDaemon(true);
        this.setName("Input Writer");
        this.start();
    }

    private synchronized void setFinished() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitUntilFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.content != null) {
                this.destination.write(this.content.getBytes(Charset.defaultCharset()));
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot write content to stream", (Throwable)e);
        }
        finally {
            try {
                this.destination.close();
            }
            catch (IOException e) {
                LOGGER.error("Cannot close input stream", (Throwable)e);
            }
            this.setFinished();
        }
    }
}

