/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.ftp;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final FTPClient ftpClient;
    private boolean completedPendingFtpCommand = false;

    public FtpOutputStream(OutputStream outputStream, FTPClient ftpClient) {
        this.outputStream = outputStream;
        this.ftpClient = ftpClient;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        if (!this.completedPendingFtpCommand) {
            this.ftpClient.completePendingCommand();
            this.completedPendingFtpCommand = true;
            this.ftpClient.disconnect();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public String toString() {
        return this.outputStream.toString();
    }
}

