/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.PropertyTypeException;
import nl.esciencecenter.xenon.UnknownPropertyException;
import nl.esciencecenter.xenon.XenonPropertyDescription;

public class XenonProperties {
    private static final String NAME = "XenonProperties";
    private static final int KILO = 1024;
    private static final int MEGA = 0x100000;
    private static final int GIGA = 0x40000000;
    private final Map<String, XenonPropertyDescription> propertyDescriptions;
    private final Map<String, String> properties;

    public static <K, V> Map<K, V> emptyMap(int capacity) {
        return new HashMap((capacity + 1) * 4 / 3);
    }

    private XenonProperties(Map<String, XenonPropertyDescription> propertyDescriptions, Map<String, String> properties) {
        this.propertyDescriptions = propertyDescriptions;
        this.properties = properties;
    }

    public XenonProperties() {
        this.propertyDescriptions = XenonProperties.emptyMap(0);
        this.properties = XenonProperties.emptyMap(0);
    }

    public XenonProperties(XenonPropertyDescription[] propertyDescriptions, Map<String, String> properties) throws UnknownPropertyException, InvalidPropertyException {
        this.propertyDescriptions = new HashMap<String, XenonPropertyDescription>(propertyDescriptions.length);
        this.properties = new HashMap<String, String>(propertyDescriptions.length);
        for (XenonPropertyDescription d : propertyDescriptions) {
            this.propertyDescriptions.put(d.getName(), d);
        }
        this.addProperties(properties);
    }

    private void addProperties(Map<String, String> properties) throws UnknownPropertyException, InvalidPropertyException {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String key = e.getKey();
            XenonPropertyDescription d = this.propertyDescriptions.get(key);
            if (d == null) {
                throw new UnknownPropertyException(NAME, "Unknown property " + key);
            }
            String value = e.getValue();
            this.checkType(d, key, value);
            this.properties.put(key, value);
        }
    }

    private void checkType(XenonPropertyDescription description, String key, String value) throws InvalidPropertyException {
        XenonPropertyDescription.Type t = description.getType();
        try {
            switch (t) {
                case BOOLEAN: {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        throw new IllegalArgumentException("Not a boolean value: " + value);
                    }
                    break;
                }
                case INTEGER: {
                    Integer.parseInt(value);
                    break;
                }
                case DOUBLE: {
                    Double.parseDouble(value);
                    break;
                }
                case LONG: {
                    Long.parseLong(value);
                    break;
                }
                case SIZE: {
                    this.parseSizeValue(value);
                    break;
                }
                case STRING: {
                    break;
                }
                default: {
                    throw new InvalidPropertyException(NAME, "Unknown property \"" + key + "=" + value + " provided");
                }
            }
        }
        catch (IllegalArgumentException | InvalidPropertyException e) {
            throw new InvalidPropertyException(NAME, "Property \"" + key + "\" has invalid value: " + value + " (expected " + (Object)((Object)t) + ")", e);
        }
    }

    public boolean supportsProperty(String name) {
        return this.propertyDescriptions.containsKey(name);
    }

    public boolean propertySet(String name) throws UnknownPropertyException {
        if (!this.propertyDescriptions.containsKey(name)) {
            throw new UnknownPropertyException(NAME, "No such property: " + name);
        }
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) throws UnknownPropertyException {
        XenonPropertyDescription d = this.propertyDescriptions.get(name);
        if (d == null) {
            throw new UnknownPropertyException(NAME, "No such property: " + name);
        }
        String value = d.getDefaultValue();
        if (this.properties.containsKey(name)) {
            value = this.properties.get(name);
        }
        return value;
    }

    private String getProperty(String name, XenonPropertyDescription.Type type) throws UnknownPropertyException, PropertyTypeException {
        XenonPropertyDescription d = this.propertyDescriptions.get(name);
        if (d == null) {
            throw new UnknownPropertyException(NAME, "No such property: " + name);
        }
        if (d.getType() != type) {
            throw new PropertyTypeException(NAME, "Property " + name + " is of type " + (Object)((Object)d.getType()) + " not " + (Object)((Object)type));
        }
        String value = d.getDefaultValue();
        if (this.properties.containsKey(name)) {
            value = this.properties.get(name);
        }
        return value;
    }

    public boolean getBooleanProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.BOOLEAN);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected BOOLEAN)");
    }

    public int getIntegerProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.INTEGER);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected INTEGER)", e);
        }
    }

    public int getIntegerProperty(String name, int defaultValue) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.INTEGER);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected INTEGER)", e);
        }
    }

    public long getLongProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.LONG);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected LONG)", e);
        }
    }

    public long getNaturalProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.NATURAL);
        try {
            long result = Long.parseLong(value);
            if (result < 0L) {
                throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected NATURAL NUMBER)");
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected NATURAL NUMBER)", e);
        }
    }

    public double getDoubleProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        String value = this.getProperty(name, XenonPropertyDescription.Type.DOUBLE);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Property " + name + " has invalid value: " + value + " (expected DOUBLE)", e);
        }
    }

    public String getStringProperty(String name) throws UnknownPropertyException, PropertyTypeException {
        return this.getProperty(name, XenonPropertyDescription.Type.STRING);
    }

    private long parseSizeValue(String value) throws InvalidPropertyException {
        try {
            if (value.endsWith("G") || value.endsWith("g")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 0x40000000L;
            }
            if (value.endsWith("M") || value.endsWith("m")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 0x100000L;
            }
            if (value.endsWith("K") || value.endsWith("k")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(NAME, "Invalid SIZE value: " + value, e);
        }
    }

    public long getSizeProperty(String name) throws UnknownPropertyException, PropertyTypeException, InvalidPropertyException {
        return this.parseSizeValue(this.getProperty(name, XenonPropertyDescription.Type.SIZE));
    }

    public XenonProperties filter(String prefix) {
        return this.filterUsingPredicate(propertyKey -> propertyKey.startsWith(prefix));
    }

    public XenonProperties exclude(String prefix) {
        return this.filterUsingPredicate(propertyKey -> !propertyKey.startsWith(prefix));
    }

    private XenonProperties filterUsingPredicate(Predicate<String> predicate) {
        Map<String, XenonPropertyDescription> remainingDescriptions = this.filterOnKey(this.propertyDescriptions, predicate);
        Map<String, String> remainingProperties = this.filterOnKey(this.properties, key -> remainingDescriptions.containsKey(key));
        return new XenonProperties(remainingDescriptions, remainingProperties);
    }

    private <K, V> Map<K, V> filterOnKey(Map<K, V> map, Predicate<K> predicate) {
        Map<K, V> remaining = XenonProperties.emptyMap(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (!predicate.test(key)) continue;
            remaining.put(key, value);
        }
        return remaining;
    }

    public XenonProperties clear(String prefix) {
        Map<String, XenonPropertyDescription> toInclude = this.filterOnKey(this.propertyDescriptions, propertyKey -> !propertyKey.startsWith(prefix));
        Map<String, String> propertiesRemaining = this.filterOnKey(this.properties, key -> toInclude.containsKey(key));
        return new XenonProperties(this.propertyDescriptions, propertiesRemaining);
    }

    public XenonPropertyDescription[] getSupportedProperties() {
        Collection<XenonPropertyDescription> tmp = this.propertyDescriptions.values();
        return tmp.toArray(new XenonPropertyDescription[tmp.size()]);
    }

    public String[] getPropertyNames() {
        ArrayList<String> list = new ArrayList<String>(this.propertyDescriptions.keySet());
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.properties);
    }

    public void printProperties(PrintStream out, String prefix) {
        String tmp = prefix == null ? "" : prefix.toLowerCase();
        for (XenonPropertyDescription d : this.propertyDescriptions.values()) {
            String key = d.getName();
            if (!key.toLowerCase().startsWith(tmp)) continue;
            String value = d.getDefaultValue();
            if (this.properties.containsKey(key)) {
                value = this.properties.get(key);
            }
            out.println(key + " = " + value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.propertyDescriptions.size() * 60);
        sb.append('{');
        String comma = "";
        for (XenonPropertyDescription d : this.propertyDescriptions.values()) {
            sb.append(comma);
            String key = d.getName();
            if (this.properties.containsKey(key)) {
                sb.append(key);
                sb.append('=');
                sb.append(this.properties.get(key));
            } else {
                sb.append("<<");
                sb.append(key);
                sb.append('=');
                sb.append(d.getDefaultValue());
                sb.append(">>");
            }
            comma = ", ";
        }
        sb.append('}');
        return sb.toString();
    }
}

