# ipybbycell

[![Build Status](https://github.com/boyuai/ipybbycell/workflows/Build/badge.svg)](https://github.com/boyuai/ipybbycell/actions)
[![codecov](https://codecov.io/gh/boyuai/ipybbycell/branch/master/graph/badge.svg)](https://codecov.io/gh/boyuai/ipybbycell)

BBY Cell Extension

## Installation

You can install using `pip` :

```bash
git clone git@github.com:boyuai/ipybbycell.git
cd ipybbycell
pip install ".[test, examples]"
```

If you are using Jupyter Notebook 5.2 or earlier, you may also need to enable
the nbextension:

```bash
jupyter nbextension enable --py [--sys-prefix|--user|--system] ipybbycell
```

## Development Installation

Create a dev environment:

```bash
git clone git@github.com:boyuai/ipybbycell.git
cd ipybbycell
python3 -m venv venv
source venv/bin/activate
```

Install the python. This will also build the TS package.

```bash
pip install -e ".[test, examples]"
```

When developing your extensions, you need to manually enable your extensions with the
notebook / lab frontend.

For classic notebook, you need to run:

```
jupyter nbextension install --sys-prefix --symlink --overwrite --py ipybbycell
jupyter nbextension enable --sys-prefix --py ipybbycell
```

Note that the `--symlink` flag doesn't work on Windows, so you will here have to run
the `install` command every time that you rebuild your extension. For certain installations
you might also need another flag instead of `--sys-prefix` , but we won't cover the meaning
of those flags here.

### How to see your changes

#### Typescript:

```bash
# Watch the source directory in one terminal, automatically rebuilding when needed
yarn run watch
# Run Jupyter Notebook in another terminal
jupyter notebook
```

After a change wait for the build to finish and then refresh your browser and the changes should take effect.

#### Python:

If you make a change to the python code then you will need to restart the notebook kernel to have it take effect.

## Releasing your initial packages:

* Add tests
* Ensure tests pass locally and on CI. Check that the coverage is reasonable.
* Make a release commit, where you remove the `, 'dev'` entry in `_version.py`.
<!-- * Update the version in `package.json`
* Relase the npm packages:
  

```bash
  npm login
  npm publish
  ``` -->

* Bundle the python package: `python setup.py sdist bdist_wheel`
* Publish the package to PyPI:
  

```bash
  pip install twine
  twine upload dist/ipybbycell*
  ```

* Tag the release commit (`git tag <python package version identifier>`)
* Update the version in `_version.py`, and put it back to dev (e.g. 0.1.0 -> 0.2.0.dev).
  Update the versions of the npm packages (without publishing).
* Commit the changes.
* `git push` and `git push --tags`.
