# Stubs for zope.schema._field (Python 3.6)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any, Optional
from zope.schema._bootstrapfields import Field as Field, Bool as Bool, TextLine as TextLine, Complex as Complex, Int as Int, Real as Real, Object as Object
from zope.schema._bootstrapfields import Iterable as Iterable, MinMaxLen as MinMaxLen, Number as Number, Orderable as Orderable, Text as Text
from zope.schema.interfaces import ValidationError

__docformat__: str

class SourceText(Text):
    __doc__: Any = ...

class Bytes(MinMaxLen, Field):
    __doc__: Any = ...
    def fromUnicode(self, value: Any): ...
    def fromBytes(self, value: Any): ...

class NativeString(Text):
    def fromBytes(self, value: Any): ...

class ASCII(NativeString):
    __doc__: Any = ...

class BytesLine(Bytes):
    def constraint(self, value: Any): ...

class NativeStringLine(TextLine):
    def fromBytes(self, value: Any): ...

class ASCIILine(ASCII):
    __doc__: Any = ...
    def constraint(self, value: Any): ...

class InvalidFloatLiteral(ValueError, ValidationError): ...
class Float(Real): ...
class InvalidDecimalLiteral(ValueError, ValidationError): ...
class Decimal(Number): ...

class Datetime(Orderable, Field):
    __doc__: Any = ...
    def __init__(self, *args: Any, **kw: Any) -> None: ...

class Date(Orderable, Field):
    __doc__: Any = ...

class Timedelta(Orderable, Field):
    __doc__: Any = ...

class Time(Orderable, Field):
    __doc__: Any = ...

class MissingVocabularyError(ValidationError, ValueError, LookupError): ...

class InvalidVocabularyError(ValidationError, ValueError, TypeError):
    def __init__(self, vocabulary: Any) -> None: ...

class Choice(Field):
    vocabulary: Any = ...
    vocabularyName: Any = ...
    def __init__(self, values: Optional[Any] = ..., vocabulary: Optional[Any] = ..., source: Optional[Any] = ..., **kw: Any) -> None: ...
    source: Any = ...
    def bind(self, context: Any): ...
    def fromUnicode(self, value: Any): ...

class _StrippedNativeStringLine(NativeStringLine):
    def fromUnicode(self, value: Any): ...
    def fromBytes(self, value: Any): ...

class URI(_StrippedNativeStringLine): ...
class PythonIdentifier(_StrippedNativeStringLine): ...

class DottedName(_StrippedNativeStringLine):
    min_dots: Any = ...
    max_dots: Any = ...
    def __init__(self, *args: Any, **kw: Any) -> None: ...

class Id(_StrippedNativeStringLine): ...

class InterfaceField(Field):
    __doc__: Any = ...

class Collection(MinMaxLen, Iterable):
    value_type: Any = ...
    unique: bool = ...
    def __init__(self, value_type: Any = ..., unique: Any = ..., **kw: Any) -> None: ...
    def bind(self, context: Any): ...
AbstractCollection = Collection

class Sequence(Collection): ...
class Tuple(Sequence): ...
class MutableSequence(Sequence): ...
class List(MutableSequence): ...

class _AbstractSet(Collection):
    unique: bool = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...

class Set(_AbstractSet): ...
class FrozenSet(_AbstractSet): ...

class Mapping(MinMaxLen, Iterable):
    key_type: Any = ...
    value_type: Any = ...
    def __init__(self, key_type: Optional[Any] = ..., value_type: Optional[Any] = ..., **kw: Any) -> None: ...
    def bind(self, object: Any): ...

class MutableMapping(Mapping): ...
class Dict(MutableMapping): ...
