/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = dateTimeFieldType;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return true;
    }

    public abstract int get(long var1);

    public String getAsText(long l2, Locale locale) {
        return this.getAsText(this.get(l2), locale);
    }

    public final String getAsText(long l2) {
        return this.getAsText(l2, null);
    }

    public String getAsText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.getAsText(n2, locale);
    }

    public final String getAsText(ReadablePartial readablePartial, Locale locale) {
        return this.getAsText(readablePartial, readablePartial.get(this.getType()), locale);
    }

    public String getAsText(int n2, Locale locale) {
        return Integer.toString(n2);
    }

    public String getAsShortText(long l2, Locale locale) {
        return this.getAsShortText(this.get(l2), locale);
    }

    public final String getAsShortText(long l2) {
        return this.getAsShortText(l2, null);
    }

    public String getAsShortText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.getAsShortText(n2, locale);
    }

    public final String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        return this.getAsShortText(readablePartial, readablePartial.get(this.getType()), locale);
    }

    public String getAsShortText(int n2, Locale locale) {
        return this.getAsText(n2, locale);
    }

    public long add(long l2, int n2) {
        return this.getDurationField().add(l2, n2);
    }

    public long add(long l2, long l3) {
        return this.getDurationField().add(l2, l3);
    }

    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        int n4;
        long l2;
        if (n3 == 0) {
            return nArray;
        }
        DateTimeField dateTimeField = null;
        while (n3 > 0) {
            l2 = nArray[n2] + n3;
            n4 = this.getMaximumValue(readablePartial, nArray);
            if (l2 <= (long)n4) {
                nArray[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n3 -= n4 + 1 - nArray[n2];
            nArray = dateTimeField.add(readablePartial, n2 - 1, nArray, 1);
            nArray[n2] = this.getMinimumValue(readablePartial, nArray);
        }
        while (n3 < 0) {
            l2 = nArray[n2] + n3;
            n4 = this.getMinimumValue(readablePartial, nArray);
            if (l2 >= (long)n4) {
                nArray[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n3 -= n4 - 1 - nArray[n2];
            nArray = dateTimeField.add(readablePartial, n2 - 1, nArray, -1);
            nArray[n2] = this.getMaximumValue(readablePartial, nArray);
        }
        return this.set(readablePartial, n2, nArray, nArray[n2]);
    }

    public int[] addWrapPartial(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        int n4;
        long l2;
        if (n3 == 0) {
            return nArray;
        }
        DateTimeField dateTimeField = null;
        while (n3 > 0) {
            l2 = nArray[n2] + n3;
            n4 = this.getMaximumValue(readablePartial, nArray);
            if (l2 <= (long)n4) {
                nArray[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    n3 -= n4 + 1 - nArray[n2];
                    nArray[n2] = this.getMinimumValue(readablePartial, nArray);
                    continue;
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n3 -= n4 + 1 - nArray[n2];
            nArray = dateTimeField.addWrapPartial(readablePartial, n2 - 1, nArray, 1);
            nArray[n2] = this.getMinimumValue(readablePartial, nArray);
        }
        while (n3 < 0) {
            l2 = nArray[n2] + n3;
            n4 = this.getMinimumValue(readablePartial, nArray);
            if (l2 >= (long)n4) {
                nArray[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    n3 -= n4 - 1 - nArray[n2];
                    nArray[n2] = this.getMaximumValue(readablePartial, nArray);
                    continue;
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n3 -= n4 - 1 - nArray[n2];
            nArray = dateTimeField.addWrapPartial(readablePartial, n2 - 1, nArray, -1);
            nArray[n2] = this.getMaximumValue(readablePartial, nArray);
        }
        return this.set(readablePartial, n2, nArray, nArray[n2]);
    }

    public long addWrapField(long l2, int n2) {
        int n3 = this.get(l2);
        int n4 = FieldUtils.getWrappedValue(n3, n2, this.getMinimumValue(l2), this.getMaximumValue(l2));
        return this.set(l2, n4);
    }

    public int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        int n4 = nArray[n2];
        int n5 = FieldUtils.getWrappedValue(n4, n3, this.getMinimumValue(readablePartial), this.getMaximumValue(readablePartial));
        return this.set(readablePartial, n2, nArray, n5);
    }

    public int getDifference(long l2, long l3) {
        return this.getDurationField().getDifference(l2, l3);
    }

    public long getDifferenceAsLong(long l2, long l3) {
        return this.getDurationField().getDifferenceAsLong(l2, l3);
    }

    public abstract long set(long var1, int var3);

    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        FieldUtils.verifyValueBounds(this, n3, this.getMinimumValue(readablePartial, nArray), this.getMaximumValue(readablePartial, nArray));
        nArray[n2] = n3;
        for (int i2 = n2 + 1; i2 < readablePartial.size(); ++i2) {
            DateTimeField dateTimeField = readablePartial.getField(i2);
            if (nArray[i2] > dateTimeField.getMaximumValue(readablePartial, nArray)) {
                nArray[i2] = dateTimeField.getMaximumValue(readablePartial, nArray);
            }
            if (nArray[i2] >= dateTimeField.getMinimumValue(readablePartial, nArray)) continue;
            nArray[i2] = dateTimeField.getMinimumValue(readablePartial, nArray);
        }
        return nArray;
    }

    public long set(long l2, String string, Locale locale) {
        int n2 = this.convertText(string, locale);
        return this.set(l2, n2);
    }

    public final long set(long l2, String string) {
        return this.set(l2, string, null);
    }

    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, String string, Locale locale) {
        int n3 = this.convertText(string, locale);
        return this.set(readablePartial, n2, nArray, n3);
    }

    protected int convertText(String string, Locale locale) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalFieldValueException(this.getType(), string);
        }
    }

    public abstract DurationField getDurationField();

    public abstract DurationField getRangeDurationField();

    public boolean isLeap(long l2) {
        return false;
    }

    public int getLeapAmount(long l2) {
        return 0;
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public abstract int getMinimumValue();

    public int getMinimumValue(long l2) {
        return this.getMinimumValue();
    }

    public int getMinimumValue(ReadablePartial readablePartial) {
        return this.getMinimumValue();
    }

    public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.getMinimumValue(readablePartial);
    }

    public abstract int getMaximumValue();

    public int getMaximumValue(long l2) {
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial readablePartial) {
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.getMaximumValue(readablePartial);
    }

    public int getMaximumTextLength(Locale locale) {
        int n2 = this.getMaximumValue();
        if (n2 >= 0) {
            if (n2 < 10) {
                return 1;
            }
            if (n2 < 100) {
                return 2;
            }
            if (n2 < 1000) {
                return 3;
            }
        }
        return Integer.toString(n2).length();
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getMaximumTextLength(locale);
    }

    public abstract long roundFloor(long var1);

    public long roundCeiling(long l2) {
        long l3 = this.roundFloor(l2);
        if (l3 != l2) {
            l2 = this.add(l3, 1);
        }
        return l2;
    }

    public long roundHalfFloor(long l2) {
        long l3;
        long l4;
        long l5 = this.roundFloor(l2);
        long l6 = l2 - l5;
        if (l6 <= (l4 = (l3 = this.roundCeiling(l2)) - l2)) {
            return l5;
        }
        return l3;
    }

    public long roundHalfCeiling(long l2) {
        long l3;
        long l4 = this.roundFloor(l2);
        long l5 = this.roundCeiling(l2);
        long l6 = l5 - l2;
        if (l6 <= (l3 = l2 - l4)) {
            return l5;
        }
        return l4;
    }

    public long roundHalfEven(long l2) {
        long l3;
        long l4;
        long l5 = this.roundFloor(l2);
        long l6 = l2 - l5;
        if (l6 < (l4 = (l3 = this.roundCeiling(l2)) - l2)) {
            return l5;
        }
        if (l4 < l6) {
            return l3;
        }
        if ((this.get(l3) & 1) == 0) {
            return l3;
        }
        return l5;
    }

    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

