/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldPrimitiveTypes<T>
extends AbstractBeanField<T> {
    private final String locale;

    public BeanFieldPrimitiveTypes(Field field, boolean required, String locale, Locale errorLocale) {
        super(field, required, errorLocale);
        this.locale = locale;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        Object o2 = null;
        if (StringUtils.isNotBlank(value) || value != null && this.field.getType().equals(String.class)) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean converter = new ConvertUtilsBean();
                    converter.register(true, false, 0);
                    o2 = converter.convert(value, this.field.getType());
                } else {
                    LocaleConvertUtilsBean lcub = new LocaleConvertUtilsBean();
                    lcub.setDefaultLocale(new Locale(this.locale));
                    o2 = lcub.convert(value, this.field.getType());
                }
            }
            catch (ConversionException e2) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.field.getType(), String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("conversion.impossible"), value, this.field.getType().getCanonicalName()));
                csve.initCause(e2);
                throw csve;
            }
        }
        return o2;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result = null;
        if (value != null) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean converter = new ConvertUtilsBean();
                    result = converter.convert(value);
                } else {
                    LocaleConvertUtilsBean converter = new LocaleConvertUtilsBean();
                    converter.setDefaultLocale(new Locale(this.locale));
                    result = converter.convert(value);
                }
            }
            catch (ConversionException e2) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("field.not.primitive"));
                csve.initCause(e2);
                throw csve;
            }
        }
        return result;
    }
}

