/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private String pending;
    private boolean inField = false;
    private final boolean ignoreLeadingWhiteSpace;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;
    public static final char NULL_CHARACTER = '\u0000';

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s2 = this.pending;
                this.pending = null;
                return new String[]{s2};
            }
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(128);
        boolean inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = true;
        }
        for (int i2 = 0; i2 < nextLine.length(); ++i2) {
            char c2 = nextLine.charAt(i2);
            if (c2 == this.escape) {
                if (!this.isNextCharacterEscapable(nextLine, inQuotes || this.inField, i2)) continue;
                sb.append(nextLine.charAt(i2 + 1));
                ++i2;
                continue;
            }
            if (c2 == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes || this.inField, i2)) {
                    sb.append(nextLine.charAt(i2 + 1));
                    ++i2;
                } else {
                    if (!this.strictQuotes && i2 > 2 && nextLine.charAt(i2 - 1) != this.separator && nextLine.length() > i2 + 1 && nextLine.charAt(i2 + 1) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && this.isAllWhiteSpace(sb)) {
                            sb.setLength(0);
                        } else {
                            sb.append(c2);
                        }
                    }
                    inQuotes = !inQuotes;
                }
                this.inField = !this.inField;
                continue;
            }
            if (c2 == this.separator && !inQuotes) {
                tokensOnThisLine.add(sb.toString());
                sb.setLength(0);
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && !inQuotes) continue;
            sb.append(c2);
            this.inField = true;
        }
        if (inQuotes) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i2) {
        return inQuotes && nextLine.length() > i2 + 1 && nextLine.charAt(i2 + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i2) {
        return inQuotes && nextLine.length() > i2 + 1 && (nextLine.charAt(i2 + 1) == this.quotechar || nextLine.charAt(i2 + 1) == this.escape);
    }

    protected boolean isAllWhiteSpace(CharSequence sb) {
        boolean result = true;
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            char c2 = sb.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return false;
        }
        return result;
    }
}

