/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

function getPlotData() {
  const data = {
    arm_data: {
      metrics: ['metric_a'],
      in_sample: {
        '0_0': {
          name: '0_0',
          parameters: {
            x1: 2.5,
            x2: 7.5,
          },
          y: {
            metric_a: 24.129964413622268,
          },
          y_hat: {
            metric_a: 24.01006574699846,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5464922590893369,
          },
          context_stratum: null,
        },
        '0_1': {
          name: '0_1',
          parameters: {
            x1: 6.25,
            x2: 3.75,
          },
          y: {
            metric_a: 26.624171220014905,
          },
          y_hat: {
            metric_a: 26.41377793548419,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5765135106961565,
          },
          context_stratum: null,
        },
        '0_10': {
          name: '0_10',
          parameters: {
            x1: 1.5625,
            x2: 8.4375,
          },
          y: {
            metric_a: 31.321658517480987,
          },
          y_hat: {
            metric_a: 31.33356125186804,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.6576285112113143,
          },
          context_stratum: null,
        },
        '0_11': {
          name: '0_11',
          parameters: {
            x1: -0.3125,
            x2: 2.8125,
          },
          y: {
            metric_a: 32.8083830521407,
          },
          y_hat: {
            metric_a: 32.76625916368758,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5796489910967844,
          },
          context_stratum: null,
        },
        '0_12': {
          name: '0_12',
          parameters: {
            x1: 7.1875,
            x2: 10.3125,
          },
          y: {
            metric_a: 98.34760790686913,
          },
          y_hat: {
            metric_a: 98.47004975763232,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.6717521877339758,
          },
          context_stratum: null,
        },
        '0_13': {
          name: '0_13',
          parameters: {
            x1: 3.4375,
            x2: 6.5625,
          },
          y: {
            metric_a: 21.127854002025494,
          },
          y_hat: {
            metric_a: 21.15183877494833,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7035890336050619,
          },
          context_stratum: null,
        },
        '0_14': {
          name: '0_14',
          parameters: {
            x1: -4.0625,
            x2: 14.0625,
          },
          y: {
            metric_a: 4.47623958200588,
          },
          y_hat: {
            metric_a: 4.634259551127094,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9700711080123123,
          },
          context_stratum: null,
        },
        '0_15': {
          name: '0_15',
          parameters: {
            x1: -3.59375,
            x2: 7.03125,
          },
          y: {
            metric_a: 41.77178986158392,
          },
          y_hat: {
            metric_a: 43.02946430348122,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.6648254135737688,
          },
          context_stratum: null,
        },
        '0_16': {
          name: '0_16',
          parameters: {
            x1: 3.90625,
            x2: 14.53125,
          },
          y: {
            metric_a: 166.3236985012143,
          },
          y_hat: {
            metric_a: 165.98753418392286,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9362111671874083,
          },
          context_stratum: null,
        },
        '0_17': {
          name: '0_17',
          parameters: {
            x1: 7.65625,
            x2: 3.28125,
          },
          y: {
            metric_a: 15.473497571024838,
          },
          y_hat: {
            metric_a: 15.91397040802947,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.771370749892483,
          },
          context_stratum: null,
        },
        '0_18': {
          name: '0_18',
          parameters: {
            x1: 0.15625,
            x2: 10.78125,
          },
          y: {
            metric_a: 44.753611366285824,
          },
          y_hat: {
            metric_a: 44.910843040074106,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.721276772145496,
          },
          context_stratum: null,
        },
        '0_19': {
          name: '0_19',
          parameters: {
            x1: 2.03125,
            x2: 1.40625,
          },
          y: {
            metric_a: 9.320218587634006,
          },
          y_hat: {
            metric_a: 9.414481706968537,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5066571111811835,
          },
          context_stratum: null,
        },
        '0_2': {
          name: '0_2',
          parameters: {
            x1: -1.25,
            x2: 11.25,
          },
          y: {
            metric_a: 22.383482484999874,
          },
          y_hat: {
            metric_a: 22.384755967639723,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.562706143383974,
          },
          context_stratum: null,
        },
        '0_20': {
          name: '0_20',
          parameters: {
            x1: 9.53125,
            x2: 8.90625,
          },
          y: {
            metric_a: 40.64753379393727,
          },
          y_hat: {
            metric_a: 40.477956775406135,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.89121149224021,
          },
          context_stratum: null,
        },
        '0_21': {
          name: '0_21',
          parameters: {
            x1: 5.78125,
            x2: 5.15625,
          },
          y: {
            metric_a: 34.736739987996074,
          },
          y_hat: {
            metric_a: 34.5171971981692,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.4141876641443574,
          },
          context_stratum: null,
        },
        '0_22': {
          name: '0_22',
          parameters: {
            x1: -1.71875,
            x2: 12.65625,
          },
          y: {
            metric_a: 21.110094161886266,
          },
          y_hat: {
            metric_a: 20.94190882624772,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.4500065659802797,
          },
          context_stratum: null,
        },
        '0_23': {
          name: '0_23',
          parameters: {
            x1: -2.65625,
            x2: 2.34375,
          },
          y: {
            metric_a: 78.863835999175,
          },
          y_hat: {
            metric_a: 79.73701417580827,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.765272722951101,
          },
          context_stratum: null,
        },
        '0_24': {
          name: '0_24',
          parameters: {
            x1: 4.84375,
            x2: 9.84375,
          },
          y: {
            metric_a: 83.88052752898044,
          },
          y_hat: {
            metric_a: 83.87665268473569,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7104971653428702,
          },
          context_stratum: null,
        },
        '0_25': {
          name: '0_25',
          parameters: {
            x1: 8.59375,
            x2: 6.09375,
          },
          y: {
            metric_a: 21.424386764652148,
          },
          y_hat: {
            metric_a: 21.216944431443586,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.8160503619041526,
          },
          context_stratum: null,
        },
        '0_26': {
          name: '0_26',
          parameters: {
            x1: 1.09375,
            x2: 13.59375,
          },
          y: {
            metric_a: 98.68064045456067,
          },
          y_hat: {
            metric_a: 98.3596463462363,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9345011690222322,
          },
          context_stratum: null,
        },
        '0_27': {
          name: '0_27',
          parameters: {
            x1: -0.78125,
            x2: 4.21875,
          },
          y: {
            metric_a: 26.449512503021804,
          },
          y_hat: {
            metric_a: 26.44221320937291,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.508712019484906,
          },
          context_stratum: null,
        },
        '0_28': {
          name: '0_28',
          parameters: {
            x1: 6.71875,
            x2: 11.71875,
          },
          y: {
            metric_a: 130.64996148022834,
          },
          y_hat: {
            metric_a: 130.4456855183059,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.606480356738296,
          },
          context_stratum: null,
        },
        '0_29': {
          name: '0_29',
          parameters: {
            x1: 2.96875,
            x2: 0.46875,
          },
          y: {
            metric_a: 4.323605035294334,
          },
          y_hat: {
            metric_a: 4.467263905698587,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.804878825134134,
          },
          context_stratum: null,
        },
        '0_3': {
          name: '0_3',
          parameters: {
            x1: 0.625,
            x2: 5.625,
          },
          y: {
            metric_a: 18.111011269006838,
          },
          y_hat: {
            metric_a: 18.147805256576735,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7015284173117837,
          },
          context_stratum: null,
        },
        '0_30': {
          name: '0_30',
          parameters: {
            x1: -4.53125,
            x2: 7.96875,
          },
          y: {
            metric_a: 70.60758289753784,
          },
          y_hat: {
            metric_a: 70.3721619649341,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9032188307618576,
          },
          context_stratum: null,
        },
        '0_31': {
          name: '0_31',
          parameters: {
            x1: -4.296875,
            x2: 3.984375,
          },
          y: {
            metric_a: 132.44958166552067,
          },
          y_hat: {
            metric_a: 131.3546123209113,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9314379219004627,
          },
          context_stratum: null,
        },
        '0_32': {
          name: '0_32',
          parameters: {
            x1: 3.203125,
            x2: 11.484375,
          },
          y: {
            metric_a: 86.10574699756219,
          },
          y_hat: {
            metric_a: 86.93577940409625,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.8451511513790226,
          },
          context_stratum: null,
        },
        '0_33': {
          name: '0_33',
          parameters: {
            x1: 6.953125,
            x2: 0.234375,
          },
          y: {
            metric_a: 18.419596839926022,
          },
          y_hat: {
            metric_a: 18.18022617398734,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.9430126139503274,
          },
          context_stratum: null,
        },
        '0_34': {
          name: '0_34',
          parameters: {
            x1: -0.546875,
            x2: 7.734375,
          },
          y: {
            metric_a: 18.882901179508327,
          },
          y_hat: {
            metric_a: 18.52425808948953,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.6975547138159415,
          },
          context_stratum: null,
        },
        '0_35': {
          name: '0_35',
          parameters: {
            x1: 1.328125,
            x2: 2.109375,
          },
          y: {
            metric_a: 16.326252826011096,
          },
          y_hat: {
            metric_a: 16.196984684749587,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5909520848501446,
          },
          context_stratum: null,
        },
        '0_36': {
          name: '0_36',
          parameters: {
            x1: 8.828125,
            x2: 9.609375,
          },
          y: {
            metric_a: 59.69046760890842,
          },
          y_hat: {
            metric_a: 60.29766495694,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.6815026338829062,
          },
          context_stratum: null,
        },
        '0_37': {
          name: '0_37',
          parameters: {
            x1: 5.078125,
            x2: 5.859375,
          },
          y: {
            metric_a: 34.68741610290739,
          },
          y_hat: {
            metric_a: 34.65569605074377,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.5641598921819233,
          },
          context_stratum: null,
        },
        '0_38': {
          name: '0_38',
          parameters: {
            x1: -2.421875,
            x2: 13.359375,
          },
          y: {
            metric_a: 10.325915083003967,
          },
          y_hat: {
            metric_a: 10.439166459988684,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7105780910173312,
          },
          context_stratum: null,
        },
        '0_39': {
          name: '0_39',
          parameters: {
            x1: -1.484375,
            x2: 1.171875,
          },
          y: {
            metric_a: 66.7077438958342,
          },
          y_hat: {
            metric_a: 66.21639302466514,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.844393098993206,
          },
          context_stratum: null,
        },
        '0_4': {
          name: '0_4',
          parameters: {
            x1: 8.125,
            x2: 13.125,
          },
          y: {
            metric_a: 140.32747319783857,
          },
          y_hat: {
            metric_a: 140.10170525598437,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.947976808682641,
          },
          context_stratum: null,
        },
        '0_5': {
          name: '0_5',
          parameters: {
            x1: 4.375,
            x2: 1.875,
          },
          y: {
            metric_a: 6.954951737223514,
          },
          y_hat: {
            metric_a: 7.118877468942436,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.8579829229270666,
          },
          context_stratum: null,
        },
        '0_6': {
          name: '0_6',
          parameters: {
            x1: -3.125,
            x2: 9.375,
          },
          y: {
            metric_a: 8.57972117932429,
          },
          y_hat: {
            metric_a: 8.275844974635653,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.789351183050694,
          },
          context_stratum: null,
        },
        '0_7': {
          name: '0_7',
          parameters: {
            x1: -2.1875,
            x2: 4.6875,
          },
          y: {
            metric_a: 33.738344621143135,
          },
          y_hat: {
            metric_a: 33.84859687026936,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7181581039001557,
          },
          context_stratum: null,
        },
        '0_8': {
          name: '0_8',
          parameters: {
            x1: 5.3125,
            x2: 12.1875,
          },
          y: {
            metric_a: 136.34953133391176,
          },
          y_hat: {
            metric_a: 136.30938105362594,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.7130217290069856,
          },
          context_stratum: null,
        },
        '0_9': {
          name: '0_9',
          parameters: {
            x1: 9.0625,
            x2: 0.9375,
          },
          y: {
            metric_a: 2.5808075578294103,
          },
          y_hat: {
            metric_a: 2.5955611550721045,
          },
          se: {
            metric_a: 2.0,
          },
          se_hat: {
            metric_a: 1.979633604197754,
          },
          context_stratum: null,
        },
      },
      out_of_sample: {},
      status_quo_name: null,
    },
    blue_scale: [
      [255, 247, 251],
      [236, 231, 242],
      [208, 209, 230],
      [166, 189, 219],
      [116, 169, 207],
      [54, 144, 192],
      [5, 112, 176],
      [3, 78, 123],
    ],
    density: 50,
    f: [
      242.13344103902335,
      225.03814659569719,
      207.59405375250014,
      190.13087037957746,
      173.01534702846635,
      156.62263619604937,
      141.29714643167944,
      127.3091326608612,
      114.81569681582354,
      103.83747583153126,
      94.2621971508761,
      85.876719332472,
      78.41704258397893,
      71.61963017504233,
      65.25525652988543,
      59.14296664017979,
      53.155535219481,
      47.22133649341757,
      41.32309957461557,
      35.49389816285761,
      29.811030329500305,
      24.388117156473275,
      19.364744551579644,
      14.892312607424955,
      11.116478638280498,
      8.159649176742143,
      6.106474660683453,
      4.991799224147542,
      4.792917465935702,
      5.430727545314511,
      6.775357864202533,
      8.653127590989719,
      10.856109801568579,
      13.156542727062629,
      15.325914684198203,
      17.15541948541596,
      18.47453286691794,
      19.165585228995905,
      19.172883168267866,
      18.505805957539238,
      17.236582003714396,
      15.490028800280832,
      13.419822732037638,
      11.183993273345948,
      8.9287705614299,
      6.780781228385017,
      4.844793415010315,
      3.2040910824544966,
      1.9219823415023498,
      1.0439788996770858,
      237.60986310950608,
      220.35824477168563,
      202.76077754386387,
      185.15546000287026,
      167.9211961896864,
      151.4479286859094,
      136.09508615197893,
      122.1452616414355,
      109.7620766714414,
      98.96419451626166,
      89.62881413300825,
      81.52666578977838,
      74.37591983045786,
      67.89747136421651,
      61.850070794488246,
      56.043332966118314,
      50.343017117302985,
      44.67295381957478,
      39.013621496846426,
      33.39776086163981,
      27.903880633348166,
      22.648165423720656,
      17.774076469517247,
      13.437839708933936,
      9.789945406052183,
      6.956778884056888,
      5.025950264081899,
      4.034124055924437,
      3.958890696770773,
      4.720110572294651,
      6.18563386823903,
      8.178150026128804,
      10.484603527801262,
      12.871042692960451,
      15.102856234784682,
      16.966390224444186,
      18.288448158062813,
      18.951542891802763,
      18.903301958742645,
      18.159245576643062,
      16.79963370736221,
      14.957893131483651,
      12.79518247903529,
      10.474725041422474,
      8.145530427831396,
      5.935259387158119,
      3.9487712375328314,
      2.2689999385943764,
      0.9586671829113911,
      0.0625782150426204,
      232.94116285100313,
      215.54563921789497,
      197.80858678251502,
      180.07586242662103,
      162.73821516887827,
      146.2001239962921,
      130.83570615288608,
      116.9395439650736,
      104.68155526441203,
      94.07819445892972,
      84.99592448913691,
      77.18951887277484,
      70.35966300113779,
      64.21190562216657,
      58.49294118033184,
      53.002751220521404,
      47.599956553250195,
      42.20384719180361,
      36.79273950509306,
      31.399145467254968,
      26.10283401119986,
      21.022502587755113,
      16.30537511026695,
      12.112378411712903,
      8.598676135168667,
      5.8944132309498585,
      4.089929730289384,
      3.223549388374785,
      3.2733019122051132,
      4.158195517340481,
      5.743934479257341,
      7.849707169140721,
      10.257420888817784,
      12.726983640182702,
      15.017771847837992,
      16.911401321342574,
      18.23214677059606,
      18.86291784550509,
      18.75501132938155,
      17.93060148166795,
      16.47847284777729,
      14.54057773074188,
      12.285263894834124,
      9.880570645542427,
      7.477870851174693,
      5.205536154077599,
      3.16834671351004,
      1.4488485046632462,
      0.10921767667927185,
      -0.8063788288174223,
      228.12860180369358,
      210.60251181247617,
      192.74092167918354,
      174.89708641932322,
      157.47324143678657,
      140.88803873709807,
      125.52972590521364,
      111.70421429779834,
      99.58725659525683,
      89.19276667399723,
      80.37631567302132,
      72.87715591356965,
      66.37922415587612,
      60.57307448228856,
      55.19319982128427,
      50.02972123322712,
      44.934024052759554,
      39.820893932904724,
      34.66660482577562,
      29.503573571503868,
      24.412909451413647,
      19.51578681921299,
      14.963062138260376,
      10.920184825210768,
      7.546778769422012,
      4.976527020648895,
      3.302290724109625,
      2.563899372051445,
      2.739967584645676,
      3.7488241454640416,
      5.454128588596987,
      7.67167277215156,
      10.178430259537606,
      12.728265574740902,
      15.074691920043286,
      16.994750820848388,
      18.310341428402587,
      18.90496797845257,
      18.733905468251272,
      17.826415163255565,
      16.28014420018686,
      14.24549875937133,
      11.897714133099399,
      9.409245719885028,
      6.933410807031137,
      4.599001713929198,
      2.5105967342920863,
      0.7503564941995293,
      -0.6200104964965476,
      -1.556888452037569,
      223.1738383022897,
      205.53136720199268,
      187.56149914459166,
      169.62441101216785,
      152.1334290779551,
      135.5209152361792,
      120.18845351294176,
      106.45226489350773,
      94.49317341357201,
      84.32211294974238,
      75.7836932713128,
      68.6023442478449,
      62.44638637640933,
      56.991848721240665,
      51.9607621418722,
      47.13318407302396,
      42.35320596960465,
      37.53117736148651,
      32.64147328816419,
      27.716569888804514,
      22.83902594545257,
      18.13248058705239,
      13.751281090693617,
      9.865158719277908,
      6.637912483157741,
      4.206556048240003,
      2.666305395610955,
      2.0584066031053467,
      2.3621532431578274,
      3.495335727930218,
      5.319636947071892,
      7.647517905389584,
      10.251132632428117,
      12.878465583773448,
      15.277386357295626,
      17.220558257090836,
      18.527671174008056,
      19.083006384094265,
      18.846077091752377,
      17.85353979201453,
      16.212055537462653,
      14.080417016850433,
      11.640470162046562,
      9.068678117477575,
      6.5198947893597605,
      4.12309314703711,
      1.982586661772551,
      0.18019664262424584,
      -1.2227264613771425,
      -2.183018912495193,
      218.07901430572787,
      200.3350987759615,
      182.27435145028034,
      164.26339067031665,
      146.7262130814346,
      130.10833758467703,
      114.8236569477722,
      101.19729493485626,
      89.41400546468377,
      79.48118628180771,
      71.23257657693098,
      64.37875521376982,
      58.57380699059887,
      53.479812058882786,
      48.80608921404948,
      44.322483434424726,
      39.86577429207729,
      35.341969732423905,
      30.723703035059167,
      26.043673029693032,
      21.386019008328255,
      16.87686592129405,
      12.673905341482914,
      8.950845665359473,
      5.8752975679351565,
      3.58742902657567,
      2.1846994041817,
      1.7097415388642503,
      2.142576196779281,
      3.400549470921284,
      5.343402692340796,
      7.780276190352353,
      10.478624249657521,
      13.180803253278327,
      15.629327941471807,
      17.592717658180227,
      18.888635700178675,
      19.40230753133863,
      19.0976819473046,
      18.018972173032832,
      16.281831315983077,
      14.053323582808638,
      11.52165851114507,
      8.866912092008228,
      6.245100733255342,
      3.785209543870124,
      1.5912948068886692,
      -0.2550664229865305,
      -1.692753152788832,
      -2.678949836058763,
      212.84686482860536,
      195.01707961657786,
      176.88389058815795,
      158.81988543601653,
      141.25929359379865,
      124.66015158730798,
      109.44740761380953,
      95.95330341411105,
      84.3649245565896,
      74.68544486897355,
      66.73809468643177,
      60.22084204293158,
      54.77493035535709,
      50.04916559219072,
      45.74010408917179,
      41.607298693007515,
      37.48023870622717,
      33.260704658971356,
      28.919747912613328,
      24.490450058104397,
      20.058670278586522,
      15.753078877932303,
      11.734566682214407,
      8.180450233609385,
      5.261750929252209,
      3.1216287247242107,
      1.8597251603734506,
      1.5200702054358075,
      2.083433617415217,
      3.4667639493931404,
      5.527866931743311,
      8.072511041066605,
      10.863567442750536,
      13.638118046596816,
      16.133666123896155,
      18.114856727004987,
      19.397529726010916,
      19.868007338155323,
      19.494800009997036,
      18.329695493293976,
      16.497155376516396,
      14.172302763461971,
      11.549472791033722,
      8.81199334262265,
      6.1167346914102865,
      3.592621857571359,
      1.3435400870040368,
      -0.5490353918818798,
      -2.024074621535597,
      -3.039009841848099,
      207.4808521901744,
      189.58128278728162,
      171.39500459572696,
      153.30012531511392,
      135.7406537538787,
      119.18640634779257,
      104.07191073402836,
      90.73442087752164,
      79.36125890540697,
      69.95052528220526,
      62.315686249542054,
      56.14351661478756,
      51.063704546855654,
      46.71254438702819,
      42.77406148010443,
      38.99755012850617,
      35.20528105462104,
      31.29493792843467,
      27.23614364671153,
      23.062510684050842,
      18.86175012401681,
      14.765166578214732,
      10.936713134410944,
      7.556890699706813,
      4.799751041316618,
      2.8112689985684653,
      1.69324003955073,
      1.491125857470685,
      2.186453104360176,
      3.6957793738986595,
      5.874954532883983,
      8.526287329752414,
      11.408180041884414,
      14.252865640828873,
      16.793216863629084,
      18.790308683958813,
      20.058386530976897,
      20.485011386935838,
      20.04331035654205,
      18.792534520049067,
      16.86561471488236,
      14.445381787054103,
      11.732033098081288,
      8.911837084560162,
      6.1423149044992655,
      3.5523795194410184,
      1.2459108742563316,
      -0.6955362278395896,
      -2.2108801101951485,
      -3.2577112918101037,
      201.98532609453895,
      184.03243488931628,
      165.8131917669735,
      147.71081806333953,
      130.1786255230503,
      113.69734019275896,
      98.70935574482354,
      85.55458899788427,
      74.41809537591571,
      65.2918746406316,
      57.98075478509704,
      52.16177006026817,
      47.45423399449568,
      43.48277533035788,
      39.91938075810188,
      36.50328104871793,
      33.049674291275736,
      29.452296224541758,
      25.67948349090802,
      21.765513315056385,
      17.800064224787466,
      13.917161976936626,
      10.283686568236021,
      7.08289500099243,
      4.491525804978792,
      2.658180864957231,
      1.686789803836632,
      1.624289850815373,
      2.4529633101167363,
      4.088950401134092,
      6.386097612334552,
      9.14317823512095,
      12.114258285173648,
      15.027139433155675,
      17.610473247086116,
      19.622102906012213,
      20.874939341999184,
      21.25792265044684,
      20.74878808542222,
      19.414025421783705,
      17.3945463872378,
      14.880372132573434,
      12.077230406017172,
      9.17408207700474,
      6.329049316119971,
      3.6712162651999947,
      1.3046949773644485,
      -0.6886700978068134,
      -2.2476036057583215,
      -3.3297811204917878,
      196.3657083549407,
      178.3762059263147,
      160.14473780169715,
      142.0593082943691,
      124.58201577044669,
      108.20343289089735,
      93.37183907344901,
      80.42726849035779,
      69.54985910979343,
      60.72442453767063,
      53.748349852511325,
      48.29033918130617,
      43.96046274127257,
      40.3726185386758,
      37.187458467591206,
      34.13452484830418,
      31.02218960485899,
      27.740413783584767,
      24.256380659696976,
      20.60515410953193,
      16.878475797147768,
      13.213137644301142,
      9.778792222268486,
      6.761089436935777,
      4.339145584806175,
      2.6640019809408244,
      1.841695918745863,
      1.9206799675596855,
      2.88398193381569,
      4.647272390897932,
      7.062327377891776,
      9.924355304563313,
      12.983242018649698,
      15.962719932912748,
      18.587639562019948,
      20.612979214395512,
      21.85060795246846,
      22.190997337695034,
      21.616429820829698,
      20.200304331165494,
      18.0908876231977,
      15.484703303348653,
      12.592557484343438,
      9.605935370603639,
      6.683713053643473,
      3.9554601743343127,
      1.5258149670214678,
      -0.5228594171780756,
      -2.1289575809501358,
      -3.2501868312021074,
      190.6286972016439,
      172.6194368414554,
      154.39693962283712,
      136.35379348023193,
      118.96029869167744,
      102.71553538936062,
      88.0714059177084,
      75.36537237201641,
      64.7701538670991,
      56.26239869354052,
      49.63292442829512,
      44.54343912833622,
      40.595905806097434,
      37.394522151567294,
      34.58947575416758,
      31.901166057348515,
      29.131495101077203,
      26.16685731035108,
      22.973416771968814,
      19.587135162877647,
      16.101884351859603,
      12.657202393451492,
      9.425341776315278,
      6.594067897012678,
      4.344607722883964,
      2.83026396696318,
      2.1591442420714486,
      2.3812439640640264,
      3.4803166778715777,
      5.371493518938415,
      7.9044090342438125,
      10.87072484815117,
      14.016314527916428,
      17.061149593039456,
      19.72668854682873,
      21.76542846563413,
      22.988516238544562,
      23.28813550908363,
      22.65101441395045,
      21.15702146316573,
      18.96103202074945,
      16.265247130993856,
      13.284926969337782,
      10.214017130898029,
      7.212535628618781,
      4.410954828024458,
      1.9147735255283607,
      -0.19288540447075775,
      -1.849959570132981,
      -3.014156891789348,
      184.78247960784523,
      166.77040253816614,
      148.5783779723823,
      130.6035991289092,
      113.32386958414897,
      97.24506774082735,
      82.82021013095587,
      70.38146910352543,
      60.09195103074049,
      51.91927731637436,
      45.64818311958795,
      40.93456218065355,
      37.37342900923926,
      34.560404236727926,
      32.136210855569914,
      29.812797309886047,
      27.3860448120634,
      24.739040040268158,
      21.837078145722778,
      18.717116103805377,
      15.475182586251847,
      12.253477417209993,
      9.226672607227535,
      6.584442249162379,
      4.509907602375442,
      3.1584732920978738,
      2.640272027335385,
      3.0068550922228283,
      4.242672974866821,
      6.262238567613473,
      8.912981052000767,
      11.983064805701709,
      15.21451966306217,
      18.32382628540066,
      21.029438281314185,
      23.081758797867952,
      24.2915442718993,
      24.55291153584421,
      23.85690456683478,
      22.28928993114738,
      20.010704429195354,
      17.228130040547924,
      14.160481662638674,
      11.0042237568588,
      7.921110475308048,
      5.042999061372754,
      2.47661329362942,
      0.3060854573870557,
      -1.4059503056734073,
      -2.6171949680001134,
      178.8369301666388,
      160.83909934187997,
      142.6992391994589,
      124.8195108301243,
      107.68433774810396,
      91.80425216392564,
      77.6307355040952,
      65.4880535701142,
      55.52782104296358,
      47.70785438109237,
      41.80700466174135,
      37.476333618863265,
      34.30507351769414,
      31.881466137570538,
      29.837863109909478,
      27.87856560579143,
      25.79395558986753,
      23.46412762851075,
      20.853684052271024,
      18.000657568744288,
      15.0032128146634,
      12.006074789148343,
      9.186154061278096,
      6.734877465557112,
      4.837096087478535,
      3.650183222123758,
      3.2862502554884543,
      3.798405762645608,
      5.171761737208783,
      7.320131620279362,
      10.08868518242177,
      13.262152658480574,
      16.57888168813524,
      19.752106743601715,
      22.497642343719278,
      24.564182092655283,
      25.76241566991206,
      25.98864771723341,
      25.238090558464286,
      23.601677651208597,
      21.244883796059366,
      18.378554979995478,
      15.224434396858548,
      11.981637608126867,
      8.814339987305388,
      5.856311947844702,
      3.2158949067803704,
      0.9784881508347993,
      -0.7926024600946207,
      -2.0550877328309625,
      172.80376284867782,
      154.83752330686085,
      136.77168465913502,
      119.01414880721377,
      102.05481119577256,
      86.40633056824802,
      72.51600372203904,
      60.69775382439182,
      51.09008856255949,
      43.64030807611952,
      38.121406669332664,
      34.18041047137908,
      31.40191937508344,
      29.368037859747762,
      27.70389520521632,
      26.107022304831926,
      24.362881388056625,
      22.34894121055711,
      20.02931219888042,
      17.44316384729796,
      14.690727891627652,
      11.91907890539472,
      9.307188321672513,
      7.048115708003493,
      5.328324829289045,
      4.3070557321315945,
      4.098358746540505,
      4.75689556221991,
      6.2684011535762,
      8.545909487404188,
      11.4322833578657,
      14.708881498827822,
      18.11051904915014,
      21.347411595826745,
      24.133085202847507,
      26.21490934227374,
      27.403811534934974,
      27.598530590121346,
      26.79826615138474,
      25.098244101202226,
      22.66780844297208,
      19.720765175982365,
      16.481035482505334,
      13.150510680831687,
      9.896425550902755,
      6.85502737146016,
      4.136695586771729,
      1.8283603069097794,
      -0.0059195907842379825,
      -1.3239064013621018,
      166.69659305334937,
      148.779861515697,
      130.81024130846595,
      113.20231399278205,
      96.45009749811882,
      81.06571098424791,
      67.48971160926607,
      56.02344327426843,
      46.79090385793774,
      39.72823714533623,
      34.60252121828633,
      31.057408243246986,
      28.673981839582027,
      27.029454900260713,
      25.742900281268287,
      24.50599316345204,
      23.09989806228493,
      21.399864379133554,
      19.369726662185446,
      17.049829144547797,
      14.542356733476261,
      11.996529990902467,
      9.593209071304116,
      7.526992751580643,
      5.985881226124519,
      5.130913094179043,
      5.07805207586123,
      5.8835103564654005,
      7.533607962005647,
      9.940521253028983,
      12.944759084749009,
      16.32436151109794,
      19.81074650065738,
      23.111324828388252,
      25.93767501882039,
      28.036240039487794,
      29.2184775316069,
      29.385735698721636,
      28.54091207909665,
      26.7826125188035,
      24.28306730017242,
      21.258206152032603,
      17.933700354865984,
      14.514327892060024,
      11.170904408136721,
      8.042719205667872,
      5.2426289564335065,
      2.859358041657984,
      0.9577743769611615,
      -0.420002652238189,
      160.53087159295674,
      142.6824820306345,
      124.83195716243674,
      107.40109163357474,
      90.88673639143492,
      75.79799721981209,
      62.566265769462845,
      51.47825492669751,
      42.642233109447815,
      35.982644627523456,
      31.26055963698002,
      28.116844407093552,
      26.13013529487566,
      24.87396514502777,
      23.96249764199694,
      23.082472368833535,
      22.011405202955643,
      20.62276001785204,
      18.880312596577124,
      16.825589796447904,
      14.562574119817938,
      12.242409225490363,
      10.047678992473934,
      8.174448909267696,
      6.8122145637573155,
      6.123779215582722,
      6.2270148803710015,
      7.179689947987683,
      8.968675021211943,
      11.50521122952184,
      14.627401196168144,
      18.11000404371224,
      21.68116113340481,
      25.045681542757233,
      27.913528053955222,
      30.03063485915336,
      31.20928283272366,
      31.353474747799492,
      30.469361204807818,
      28.65805911120558,
      26.09373891032804,
      22.993729891312434,
      19.585199347834838,
      16.07592822067511,
      12.640726674293397,
      9.422454597113237,
      6.536884952980678,
      4.074785439646973,
      2.1018539149104782,
      0.6599998203856927,
      154.3236752961929,
      136.56365900123777,
      118.85598560497678,
      101.62953463780053,
      85.38281870611641,
      70.61987786535279,
      57.76070299711395,
      47.07550196323388,
      38.65577635933097,
      32.41386534377747,
      28.104759090714072,
      25.367093804862055,
      23.778061341788092,
      22.908663596254442,
      22.36925618120813,
      21.842541484244233,
      21.103047928764248,
      20.022901130775608,
      18.566020765448833,
      16.77508354607774,
      14.75567454216646,
      12.66062531074676,
      10.674086389945963,
      8.99353564153612,
      7.809954428565959,
      7.2879109219016485,
      7.547205622055429,
      8.647182516271144,
      10.575233089730112,
      13.241583520540303,
      16.481867988689743,
      20.067585487557828,
      23.72370807664528,
      27.1526380024973,
      30.063041022595304,
      32.20077208123105,
      33.37924255888257,
      33.504993032787375,
      32.58683852530588,
      30.72759963826219,
      28.10253287964012,
      24.92977138940536,
      21.43783951667715,
      17.83765225372659,
      14.308360383232504,
      10.996870116888502,
      8.022287096605794,
      5.477635382120205,
      3.429416722610654,
      1.9192162727346656,
      148.0933718130191,
      130.44309183848463,
      112.90291273540937,
      95.90808139392648,
      79.95761497782959,
      65.54887629357145,
      53.088498847363,
      42.828513631528494,
      34.84283032960673,
      29.031454270146032,
      25.143322733361845,
      22.815357090158123,
      21.624219664077266,
      21.139453529557336,
      20.96864405410653,
      20.791314023315763,
      20.37966063816361,
      19.604918309091406,
      18.431323646667806,
      16.902616186305043,
      15.125749965088126,
      13.255002443017261,
      11.475940974204164,
      9.987418404145899,
      8.981922084601926,
      8.625819398161006,
      9.040888265052992,
      10.288084709367368,
      12.355295481022893,
      15.15164687147115,
      18.510229973858525,
      22.199288381864,
      25.940721818810218,
      29.43471714819503,
      32.388946095954616,
      34.54959685635384,
      35.73153807359834,
      35.84356963097298,
      34.8964824326746,
      32.99405874133556,
      30.31190681027702,
      27.068490666659358,
      23.493621569276456,
      19.801492279038282,
      16.175911539856095,
      12.768264174358656,
      9.701363028113938,
      7.070638023600537,
      4.943311438163207,
      3.3605119726002073,
      141.85920059878634,
      124.3413331321714,
      106.99408876528162,
      90.25791236830034,
      74.6310781008279,
      60.60298241657203,
      48.56527550443524,
      38.75039800214403,
      31.214115413810724,
      25.844088381024555,
      22.383374572524758,
      20.4676453672887,
      19.673841538553145,
      19.571034578797608,
      19.76500701039138,
      19.93290682361503,
      19.845234512983858,
      19.3727657898141,
      18.480183715391302,
      17.212135269453558,
      15.676671581580806,
      14.02926969612406,
      12.456768692539185,
      11.159375906840417,
      10.331135211290487,
      10.140282014528957,
      10.710651632896372,
      12.104866747298814,
      14.311284760335425,
      17.23783881413344,
      20.7149897799845,
      24.507717556361087,
      28.33493971793632,
      31.894822134986317,
      34.8943346431951,
      37.08036624162601,
      38.269531468048775,
      38.372509881545774,
      37.4013488760931,
      35.46011335794789,
      32.7241479899607,
      29.41187846793031,
      25.754367731941088,
      21.96923150876115,
      18.24524850484694,
      14.738699071882394,
      11.576422925738726,
      8.856311678823168,
      6.646164093371283,
      4.986510479038081,
      135.6408183674555,
      118.27920787474912,
      101.15098968030944,
      84.70030869821369,
      69.42327850469856,
      55.80019423063791,
      44.20642433552359,
      34.853744145452495,
      27.779576664737448,
      22.859476255574467,
      19.83092942775493,
      18.328781856855993,
      17.930946058242732,
      18.206918212792637,
      18.761575993525483,
      19.270439272854173,
      19.502910468239566,
      19.329708307083997,
      18.716033831822838,
      17.707210734989424,
      16.412076076876183,
      14.987051667335855,
      13.62010527006526,
      12.51279570202545,
      11.860806217438729,
      11.834344822176952,
      12.559416479598333,
      14.100382220166182,
      16.44604095620224,
      19.50302842493737,
      23.09907818969761,
      26.9958896447259,
      30.909485470255337,
      34.53621227050614,
      37.5826281559687,
      39.79663036651985,
      40.99673156036423,
      41.09511113816035,
      40.10439343865066,
      38.12830577943258,
      35.34141685193322,
      31.9618240770699,
      28.221816924789984,
      24.34256443414611,
      20.518123421107614,
      16.910106870605556,
      13.649638405962435,
      10.837009208918076,
      8.540398432871825,
      6.799596020272446,
      129.4578505967125,
      112.27726590551237,
      95.3946140481489,
      79.25602165838595,
      64.35380574570199,
      51.157994384269024,
      40.02665976682512,
      31.150278344796344,
      24.548163294642833,
      20.08425030601666,
      17.490865612893334,
      16.402418786435696,
      16.398378692686208,
      17.049470346980154,
      17.960503468158265,
      18.806060821573293,
      19.354998858396005,
      19.478331483488084,
      19.141773141795593,
      18.391025730704634,
      17.335357096126675,
      16.13185973671733,
      14.96948772247029,
      14.05116580007244,
      13.574334252288388,
      13.71131613687185,
      14.590430590725205,
      16.27786241487972,
      18.762810917476465,
      21.950497411809597,
      25.665825949451726,
      29.66719497625584,
      33.66782120289595,
      37.36244095823425,
      40.45748737700473,
      42.70209612616215,
      43.916686549624785,
      44.014592118786894,
      43.008426442545456,
      41.001024713213596,
      38.165752230633025,
      34.72014376343289,
      30.897682244813684,
      26.92318941353244,
      22.996285962500252,
      19.284393168807124,
      15.923110751283211,
      13.014951519634955,
      10.628244903782267,
      8.801906912016598,
      123.32948040097267,
      106.35529127233974,
      89.74492663592261,
      73.94465790532165,
      59.441150848633235,
      46.69277948878927,
      36.0395224961083,
      27.650494752328857,
      21.52759863627914,
      17.52385227900368,
      15.366899136709442,
      14.691067781385485,
      15.077871299601796,
      16.09998055512277,
      17.362927894782143,
      18.541006624221993,
      19.403026323866385,
      19.820577124711203,
      19.75978853395195,
      19.266383710536562,
      18.449661354784286,
      17.467082328181977,
      16.508442472856416,
      15.778061739494909,
      15.47529098545239,
      15.774751820057581,
      16.80725261137378,
      18.64089498325115,
      21.26521848373525,
      24.583899857019432,
      28.418911860664068,
      32.525331914178466,
      36.61366660259836,
      40.37725629322919,
      43.52267459187677,
      45.80045513733792,
      47.03283518118268,
      47.13398945446543,
      46.11604023638985,
      44.0804549789995,
      41.19903984275565,
      37.68856888702045,
      33.783664866141166,
      29.71285867139595,
      25.68157836311127,
      21.86352293448318,
      18.39891224332798,
      15.392239342022123,
      12.911733490120113,
      10.995317396547698,
      117.27409741007426,
      100.53188786539857,
      84.22037019550649,
      68.7840966063914,
      54.702073800782244,
      42.41925213804199,
      32.256857354950675,
      24.363290963791826,
      18.724162303203702,
      15.182428898827204,
      13.461566472133264,
      13.196143528902269,
      13.970122112236574,
      15.358757085896968,
      16.969065773805987,
      18.475680702094618,
      19.647808711950958,
      20.357800283781135,
      20.571995291367763,
      20.335726553591076,
      19.757885950274282,
      18.99597129119278,
      18.240467831457188,
      17.697128122164965,
      17.56740018324793,
      18.028433046528047,
      19.21372576642706,
      21.19338685675745,
      23.957215296524296,
      27.407201902945573,
      31.36228864719224,
      35.574215424417865,
      39.75088596628707,
      43.58446118023058,
      46.781891051990726,
      49.09521423769932,
      50.3483495075123,
      50.45603236706746,
      49.42951189123745,
      47.368498462791536,
      44.44294654362408,
      40.868693940783686,
      36.88141981344657,
      32.71336752829942,
      28.57595818339302,
      24.64954036919023,
      21.079083327758553,
      17.970836093641655,
      15.392666755063559,
      13.381406110858606,
      111.30902266591877,
      94.82416011844165,
      78.837476775779,
      63.789979193452,
      50.15096278387059,
      38.34978156358571,
      28.688313859641504,
      21.295650842111478,
      16.142511399307132,
      13.062754152026365,
      11.776224003316493,
      11.918021119715057,
      13.074893020901477,
      14.825246014594804,
      16.778330673076038,
      18.609765711375847,
      20.089547171500527,
      21.090840398217473,
      21.579880357663736,
      21.6011506958499,
      21.262671014955462,
      20.721620366682387,
      20.169007519981495,
      19.812052819773697,
      19.85451103183026,
      20.476337373920156,
      21.813942648647636,
      23.939513285989012,
      26.843014540629586,
      30.424603698722695,
      34.500088887313325,
      38.81786358005932,
      43.0833511601127,
      46.987752092103555,
      50.238605914642996,
      52.58953007076444,
      53.86597954473392,
      53.983005916023004,
      52.950686859692375,
      50.86667055755362,
      47.89882410925021,
      44.26188678583635,
      40.19247328507405,
      35.926475592192844,
      31.681403720234577,
      27.644489247743063,
      23.965577972668694,
      20.752518519669845,
      18.07257134991718,
      15.961410549053895,
      105.45031944477532,
      89.24750551357839,
      73.61061493339395,
      58.97534663300913,
      45.799250123351165,
      34.49377832991059,
      25.340959611143514,
      18.45242399897997,
      13.785567004324413,
      11.1661923333604,
      10.31107050335681,
      10.856106577091822,
      12.391119163401086,
      14.49817032374348,
      16.789478567295873,
      18.942358225120334,
      20.727941762140084,
      22.020096381886816,
      22.784539354553246,
      23.064413097117193,
      22.966381550991603,
      22.64693110121993,
      22.297410792439244,
      22.12653035734492,
      22.340564958222142,
      23.122603602852138,
      24.61220034847272,
      26.883657213013098,
      29.927014318277553,
      33.64044587300174,
      37.836513561649284,
      42.2602667556232,
      46.61479079800079,
      50.590553254037744,
      53.89588666115811,
      56.286048676063025,
      57.587902004269836,
      57.71660996535181,
      56.68084979822521,
      54.575977436815236,
      51.567587535302536,
      47.869165622953545,
      43.71809662993042,
      39.35377191888311,
      34.99976032149682,
      30.850276020918265,
      27.060164767743622,
      23.73879659754536,
      20.952628469701185,
      18.7361682443128,
      99.7126924978026,
      83.81552975924886,
      68.55190243124831,
      54.350510764899454,
      41.65514561910297,
      30.857379179062153,
      22.219122396022968,
      15.83624438063346,
      11.654485703539692,
      9.492711579307255,
      9.065196129845269,
      10.008918257339126,
      11.917022614823004,
      14.37567875125707,
      17.000777986182047,
      19.472128054400443,
      21.56231123001124,
      23.14559380770218,
      24.186700445662943,
      24.72692209382179,
      24.871073490179032,
      24.77456176333681,
      24.62887392347457,
      24.644207838846178,
      25.029554166043013,
      25.971489038685064,
      27.612940444077733,
      30.03033529824888,
      33.213708969528554,
      37.059101073415235,
      41.375705446709304,
      45.90524400562792,
      50.34863258135189,
      54.3958517213383,
      57.75623581786616,
      60.18675173733128,
      61.515574492559956,
      61.65781859061873,
      60.6205885189154,
      58.49678017773862,
      55.44957396867822,
      51.69104926920087,
      47.4591459545328,
      42.99650368117426,
      38.53256960449491,
      34.26851463428879,
      30.364298540708216,
      26.93080775578597,
      24.03358582277941,
      21.70604680273603,
      94.10946794193669,
      78.54008525817251,
      63.67129285084003,
      49.92319114439508,
      37.72389887370949,
      27.443741182809674,
      19.324516778254402,
      13.447605562516834,
      9.748724653505931,
      8.040951679456946,
      8.036658132405321,
      9.374175012024466,
      11.650219129415753,
      14.455484015186578,
      17.410194548615376,
      20.197493585769394,
      22.591697016662764,
      24.46703086838147,
      25.78672845229848,
      26.589709442605827,
      26.978440685844284,
      27.106855818080653,
      27.166358111059573,
      27.36860344241123,
      27.925457964591267,
      29.027305227496946,
      30.82066333372876,
      33.38410111838078,
      36.70758036024132,
      40.68484953557343,
      45.121609005640224,
      49.75629015010579,
      54.28784287576833,
      58.406036462928675,
      61.8214362325069,
      64.29281141753613,
      65.64959704536345,
      65.80674360435629,
      64.76965659751923,
      62.628652090514855,
      59.5443892672722,
      55.72738870736568,
      51.415877480175105,
      46.85538232523116,
      42.280886118156246,
      37.90036100013806,
      33.87897427035304,
      30.329191786148204,
      27.31565537910916,
      24.87086620850844,
      88.65263330353216,
      73.43141337719383,
      58.97680957479818,
      45.698851407818594,
      34.00833865592277,
      24.253610798093295,
      16.656592899298484,
      11.285077546941558,
      8.066195509574229,
      6.80834340527182,
      7.22258028118965,
      8.948886076964193,
      11.587806675673676,
      14.73496164439593,
      18.015531075534824,
      21.116754334073956,
      23.814919799018664,
      25.983790892266445,
      27.584604168583393,
      28.65338133663836,
      29.28974140781266,
      29.645748221783847,
      29.91248080795975,
      30.302988984606188,
      31.032122134440414,
      32.29429709954471,
      34.23980721777802,
      36.94942110341259,
      40.4129668292596,
      44.52173777605494,
      49.07781800070206,
      53.81641615776232,
      58.43476629075401,
      62.62274369221328,
      66.09240653101033,
      68.60445588462042,
      69.98958339148498,
      70.16250565876922,
      69.12683981392654,
      66.97023572911179,
      63.85074976928736,
      59.977188661813585,
      55.58774824602054,
      50.93037442516041,
      46.245080323104304,
      41.74633627525243,
      37.604569118914895,
      33.93395254912047,
      30.798402568030895,
      28.229817751510822,
      83.35290849648521,
      68.49832259798842,
      54.47483821204758,
      41.68111757300888,
      30.509425557571806,
      21.28588724338415,
      14.212992885067294,
      9.345626532125877,
      6.603491148150276,
      5.791270501004121,
      6.619270399697605,
      8.729437979560885,
      11.726428487118724,
      15.21118874801828,
      18.81443006350009,
      22.22807354029346,
      25.23056555104588,
      27.694914822057168,
      29.57987674536211,
      30.91804815426237,
      31.805705066199106,
      32.39265004671282,
      32.869381047897654,
      33.45023721070677,
      34.353081385264694,
      35.77646507339186,
      37.87459100825748,
      40.730523465060564,
      44.333910454518026,
      48.57342051933307,
      53.24741193806885,
      58.08798486843918,
      62.79096750375258,
      67.04671042088027,
      70.56906852031703,
      73.12084788150894,
      74.53404479137893,
      74.72311649946559,
      73.6898313711336,
      71.51910601181758,
      68.36632715340173,
      64.43842838617995,
      59.97321127838454,
      55.220481705564744,
      50.424626180572815,
      45.80613594145782,
      41.54067344514535,
      37.74431209238173,
      34.48063407207137,
      31.781384009581235,
      78.21982418150941,
      63.748328278341006,
      50.1703770640082,
      37.872185353970636,
      27.226749437671046,
      18.538140560603367,
      11.990031898350956,
      7.624993888605431,
      5.356161654286375,
      4.985260696601664,
      6.222348621183755,
      8.711675100534492,
      12.062310312393073,
      15.8809279793767,
      19.804274498436573,
      23.529353769442196,
      26.83690830161801,
      29.59903588874191,
      31.771590678964568,
      33.38323488831385,
      34.526422208455315,
      35.34831527127184,
      36.03856400088716,
      36.81264383142176,
      37.891359849545054,
      39.47736440498325,
      41.728829316083214,
      44.73122309755649,
      48.47398425275265,
      52.84298678179366,
      57.632782595078865,
      62.57254396434471,
      67.35707748232016,
      71.67763830096833,
      75.25022864593147,
      77.83997900276569,
      79.28028968315513,
      79.48537616150413,
      78.45512067088458,
      76.27164567711921,
      73.08760430258896,
      69.1078911589062,
      64.56951494413498,
      59.72351575706155,
      54.81787195560031,
      50.07842008274479,
      45.68590690632065,
      41.75856327563632,
      38.36029293304025,
      35.52326264273099,
      73.26180071868215,
      59.18777525327724,
      46.06725742370735,
      34.27317701248544,
      24.15896052043392,
      16.0070815554458,
      9.983165982143923,
      6.118097588546547,
      4.319012047151816,
      4.385189145877028,
      6.026878234459019,
      8.890972221938192,
      12.59127783504605,
      16.740581536230223,
      20.98207758248108,
      25.01810512183106,
      28.63179885593572,
      31.69428635246924,
      34.15819229722101,
      36.04777619066598,
      37.45122266376689,
      38.51269812352166,
      39.420734341469235,
      40.391736104173354,
      41.64926394911976,
      43.399895269566244,
      45.80572883474318,
      48.95472658383801,
      52.83610137060093,
      57.332771450067106,
      62.23545218443179,
      67.27065832399242,
      72.13264647557016,
      76.5140700924589,
      80.13347595302287,
      82.75858262815638,
      84.22434269781179,
      84.44478914770374,
      83.41790027824578,
      81.22293892032162,
      78.00974982763525,
      73.98101219404509,
      69.37251796644001,
      64.43587733382913,
      59.42179523345179,
      54.56057918900906,
      50.0377103370619,
      45.973925502913474,
      42.43436668376203,
      39.452292978948634,
      68.48623108220076,
      54.82197324371202,
      42.168358453826215,
      30.884441878489387,
      21.30412983155067,
      13.68897603318861,
      8.187434524634796,
      4.81942461265934,
      3.486392037892088,
      3.9854769407809343,
      6.027491284674923,
      9.26229879996805,
      13.308762971060766,
      17.78613911341957,
      22.34438880584432,
      26.691330201197825,
      30.6125461891217,
      33.97818925566158,
      36.73742279715471,
      38.90970147999707,
      40.578547514604665,
      41.88480774829996,
      43.01562634817461,
      44.1880765346379,
      45.62817026961114,
      47.54608505791108,
      50.1076718206952,
      53.403421078566076,
      57.42230829907789,
      62.044153881385164,
      67.0558851822993,
      72.18174441647466,
      77.11600658529869,
      81.55328142684382,
      85.21509923226736,
      87.87206864119591,
      89.36088685266208,
      89.59550391073941,
      88.57199562640712,
      86.36668847750187,
      83.12651829952614,
      79.05175458637832,
      74.37653383117753,
      69.35235749160684,
      64.23175148401467,
      59.24847034537924,
      54.59210386997744,
      50.386387199222526,
      46.69879028829435,
      43.564381873319405,
      63.899569338571624,
      50.65533865798814,
      38.47580704599696,
      27.705802591795333,
      18.660034263486843,
      11.579979583983224,
      6.597860590951846,
      3.72337048086996,
      2.852448460057232,
      3.780269219735281,
      6.218502407401331,
      9.820275559938281,
      14.209807023675822,
      19.013133588386637,
      23.887218967748233,
      28.545427042345885,
      32.77580600255766,
      36.44754689598844,
      39.506205602720506,
      41.96611663430093,
      43.9058210498213,
      45.46256403459252,
      46.82183561553378,
      48.2010676298297,
      49.82831034616441,
      51.91686308448549,
      54.635989006353164,
      58.07864964251796,
      62.23356373979776,
      66.97734525289195,
      72.09329659373039,
      77.30391016717942,
      82.30414731484336,
      86.79119082106985,
      90.49002608193392,
      93.17448304314077,
      94.68323282938474,
      94.93028027763086,
      93.9098221772506,
      91.69516067690925,
      88.43018220538565,
      84.31252229352074,
      79.57421980529627,
      74.46598603569184,
      69.24124773377807,
      64.13612263984244,
      59.34342689763029,
      54.99052089643228,
      51.148321784478455,
      47.85443065822865,
      59.507421493492245,
      46.691530614441405,
      34.991151594494234,
      24.73674847185896,
      16.224363520735082,
      9.676361088192863,
      5.2096962229494395,
      2.824468073297993,
      2.4113183609112596,
      3.7635820033820337,
      6.594006526168776,
      10.559224449065134,
      15.289066397379152,
      20.416610516216064,
      25.605984509160475,
      30.57611003135342,
      35.11748231506361,
      39.09833455689018,
      42.460535485083014,
      45.21308970613306,
      47.429329864670535,
      49.242661572875406,
      50.83665923984175,
      52.428763481573796,
      54.24855547639149,
      56.511828197897955,
      59.390722422037314,
      62.980474279923,
      67.2695041857544,
      72.13116691236993,
      77.34546064290738,
      82.63380467883027,
      87.69260812896304,
      92.22229095762259,
      95.95178643698557,
      98.65849527577363,
      100.18331906990848,
      100.44048972448853,
      99.4223754782261,
      97.19916236650805,
      93.91150013884027,
      89.75411822649588,
      84.9565251121249,
      79.7679559087087,
      74.4418075178194,
      69.21547758941713,
      64.28414588857461,
      59.77934016777501,
      55.77643544040525,
      52.31627605578409,
      55.31463337009778,
      42.93357246011383,
      31.71550392687574,
      21.976578143708473,
      13.994853385845659,
      7.974613948660725,
      4.018483765892128,
      2.117495342219648,
      2.1572567409912935,
      3.929413384123521,
      7.1479586634219245,
      11.473213254187002,
      16.54082440841955,
      21.99111399626341,
      27.495472211393157,
      32.778350040199605,
      37.63264419648633,
      41.92560490110947,
      45.59537642737836,
      48.645549191430476,
      51.14411748628912,
      53.220450540009,
      55.0559531397176,
      56.86769552349003,
      58.88620689251283,
      61.329010786950526,
      64.37037770480403,
      68.10742682908462,
      72.52819685312224,
      77.50282333780916,
      82.8085257938279,
      88.16648332325894,
      93.27539202843298,
      97.83960394147911,
      101.59250272162434,
      104.31541541103857,
      105.85174579639182,
      106.11615335723698,
      105.09926097545406,
      102.86805479668594,
      99.55972383526222,
      95.3657555820925,
      90.51270908369276,
      85.24764351385485,
      79.82299319010926,
      74.47642176599686,
      69.40485103498438,
      64.74426535990631,
      60.57528060522409,
      56.94266212244037,
      51.32537050541627,
      39.38395368226821,
      28.649647898683895,
      19.424495983308166,
      11.969358047447265,
      6.4714925601531945,
      3.020066628236954,
      1.5975119650802725,
      2.084709278523192,
      4.271821086638909,
      7.874236669639231,
      12.556096453030449,
      17.959011296747054,
      23.730690254350122,
      29.549826226473463,
      35.146337265077285,
      40.31545947523915,
      44.92340608590037,
      48.90457622946551,
      52.257204775423084,
      55.04390361133246,
      57.38984354505561,
      59.474015877868865,
      61.51272195420337,
      63.736800005184506,
      66.36463310861126,
      69.57166508610057,
      73.45624703110592,
      78.00588084273855,
      83.08767628140987,
      88.47684476904547,
      93.89529524261701,
      99.04490375590123,
      103.63466314971035,
      107.40290823134245,
      110.1352422904807,
      111.67784475360551,
      111.94602159676096,
      110.92877155096042,
      108.68981730416635,
      105.36264995726341,
      101.13513282146886,
      96.23043346765026,
      90.89272559844696,
      85.37257938967568,
      79.90706367921803,
      74.69443564812482,
      69.87520251956357,
      65.53571415886034,
      61.72525382379122,
      47.543186399244206,
      36.044709947438044,
      25.79411605399127,
      17.079669081435437,
      10.145877693117022,
      5.164010610563778,
      2.210583962572656,
      1.259865985432448,
      2.188347169734975,
      4.784972713271415,
      8.766689654930346,
      13.801554125021497,
      19.537233755190766,
      25.628909785840328,
      31.762559822371475,
      37.673473077779846,
      43.159152832740716,
      48.084715809230914,
      52.38081082757374,
      56.04050161825019,
      59.121036843878336,
      61.7432570423813,
      64.08350855484207,
      66.35691230016899,
      68.79393596662254,
      71.61287731299814,
      74.98922857508028,
      79.02160649121903,
      83.69669977486643,
      88.87903225035922,
      94.34283161761896,
      99.8118019998382,
      104.99191899817554,
      109.59752480140867,
      113.37239464135779,
      116.10674218984111,
      117.64978426031796,
      117.91769738132304,
      116.89801890615509,
      114.65118327987598,
      111.30675710605236,
      107.04858151879486,
      102.09592458823822,
      96.68937455936245,
      91.07681083063102,
      85.49403187427161,
      80.14035173555625,
      75.16070541342388,
      70.64739622002895,
      66.65469331780473,
      43.97107694647714,
      32.91748102188582,
      23.1492374430043,
      14.941252153708938,
      8.52255539991475,
      4.049418936249346,
      1.586451444451221,
      1.100184763246169,
      2.4630786506661764,
      5.463176447826925,
      9.819176021205017,
      15.203130936877912,
      21.26881483989333,
      27.678908315108234,
      34.12659350218079,
      40.35239817814471,
      46.15601047217045,
      51.40141627874702,
      56.01557876940592,
      59.986618580291605,
      63.36648849905377,
      66.27159482309547,
      68.87541987557529,
      71.39147971619664,
      74.04915874796643,
      77.0656812621936,
      80.61536640280718,
      84.79581678681522,
      89.5924380692139,
      94.86796414008344,
      100.3968610351753,
      105.90573688350331,
      111.10559074766377,
      115.71681208117745,
      119.48908860477165,
      122.21755573710205,
      123.75470592491538,
      124.0178008229923,
      122.9931186729866,
      120.73785251588353,
      117.37744038324281,
      113.09128158586982,
      108.09419276215888,
      102.62250601841595,
      96.92068879614831,
      91.22276316058566,
      85.72887861391354,
      80.58818399146321,
      75.89893241154296,
      71.72069323932675,
      40.61152018214671,
      30.003547633063473,
      20.71516040710706,
      13.008387231080249,
      7.097652921072168,
      3.1251692849702835,
      1.1443292449004048,
      1.11435389087724,
      2.904046103390236,
      6.300899194759296,
      11.025595250971215,
      16.754277293979307,
      23.146844801402278,
      29.873445854551377,
      36.63431899356539,
      43.17506021786208,
      49.2974538270739,
      54.864374913511156,
      59.79926188401775,
      64.08551686339051,
      67.76989261896841,
      70.96427932163988,
      73.83908407921365,
      76.6057730808624,
      79.49189920372328,
      82.71259838138664,
      86.43976654190843,
      90.76852078437946,
      95.68229833350858,
      101.04319751253087,
      106.62722653835803,
      112.16501350859491,
      117.37349689281551,
      121.97979337569414,
      125.73995630381901,
      128.45432886713405,
      129.978885354852,
      130.23216711843816,
      129.19942190057105,
      126.93475427491387,
      123.55928274180302,
      119.24752048851623,
      114.2092909878606,
      108.67605487055127,
      102.88826198003754,
      97.07778259746014,
      91.44538745257371,
      86.14413176630177,
      81.2780452810068,
      76.9121580194539,
      37.466501485178824,
      27.303849076811392,
      18.491854180261026,
      11.280183694182504,
      5.869511131952571,
      2.3888662970159302,
      0.8810778318837436,
      1.2984848328654834,
      3.506612817296812,
      7.2927770438106805,
      12.37991723104306,
      18.44839467923144,
      25.164243213701806,
      32.20498169819831,
      39.277685471538604,
      46.13281572839571,
      52.5741688412332,
      58.463594885739916,
      63.72124630726352,
      68.32603930503448,
      72.31963428033953,
      75.8093341590421,
      78.9622569466643,
      81.987338034343,
      85.10950599325702,
      88.54077017979398,
      92.44935368488133,
      96.92643058802828,
      101.9528000099323,
      107.39109590606049,
      113.02017203644583,
      118.57578992298387,
      123.78173111427618,
      128.37249476752277,
      132.11093376643788,
      134.8028618622826,
      136.30790536615396,
      136.5460600234283,
      135.50178057113493,
      133.2263314028757,
      129.83633125534595,
      125.50097015643802,
      120.42459424980377,
      114.83326253443238,
      108.9629135726272,
      103.04297560924996,
      97.2745973117324,
      91.814355613746,
      86.77176000578527,
      82.21732355022192,
      34.53752515542347,
      24.81898372886736,
      16.47909280172555,
      9.755682863555236,
      4.8364984957341335,
      1.8382088767088618,
      0.7937020709643008,
      1.648871021415033,
      4.266340075561494,
      8.433620062172245,
      13.876212123976096,
      20.278886993559528,
      27.31383159031653,
      34.66576097715346,
      42.04830137738843,
      49.216554618619284,
      55.976259610624886,
      62.18838305517049,
      67.77008450104663,
      72.69605533139163,
      77.00298530737265,
      80.79351875208735,
      84.23125163259515,
      87.52205068443627,
      90.88737443588526,
      94.53504916695732,
      98.62840448641134,
      103.25343433936531,
      108.38788640763318,
      113.89576913541859,
      119.56000505285972,
      125.12259069063242,
      130.31503636358292,
      134.87984514583206,
      138.58707991095986,
      141.24826913272028,
      142.72682855313394,
      142.9443733545674,
      141.8848068513811,
      139.5968038860861,
      136.19235797611384,
      131.83496218007724,
      126.72308409636227,
      121.07696438433818,
      115.1276416836109,
      109.10185117427582,
      103.200819892552,
      97.58419861806416,
      92.36659302948976,
      87.62390624807009,
      31.82561388205564,
      22.549194750756623,
      14.676424319947877,
      8.433810241090441,
      3.9969496750244033,
      1.4709220446666862,
      0.8792844066268586,
      2.1619318111033152,
      5.178952873964185,
      9.718409573120837,
      15.508682428768033,
      22.239219575845308,
      29.588412479298746,
      37.24790580440934,
      44.937543379601905,
      52.416834409644174,
      59.493408620442395,
      66.02752744313098,
      71.93368340974828,
      77.18264458082723,
      81.80628426754846,
      85.90251323818536,
      89.6311318406591,
      93.19432050655243,
      96.80916988269135,
      100.67826981977038,
      104.95893255294368,
      109.73108075302409,
      114.96924091409713,
      120.53930408187482,
      126.22929060057386,
      131.78848502591367,
      136.95697693325806,
      141.48584830517308,
      145.1527471050814,
      147.77514134956925,
      149.2203584450287,
      149.4117968075007,
      148.3330413992536,
      146.0303644821683,
      142.61108906108257,
      138.23274854416087,
      133.0876281125622,
      127.38987104195901,
      121.3653313929034,
      115.23779338329139,
      109.20818967619586,
      103.438750091218,
      98.04873543857266,
      93.11925397794546,
      29.331298162657095,
      20.494343363003512,
      13.083127743549426,
      7.313317686382348,
      3.3490958858797697,
      1.2846808040462037,
      1.1349088716826046,
      2.834144205216127,
      6.24029121437885,
      11.142281371749206,
      17.271693709140106,
      24.32298681943722,
      31.98084571096794,
      39.943502247661144,
      47.93666382828097,
      55.724013791010094,
      63.11503559946432,
      69.96947977743775,
      76.19951034496876,
      81.77231269762888,
      86.71515632680158,
      91.12114954736045,
      95.1459551075931,
      98.98735143841738,
      102.85712752407863,
      106.9516245425666,
      111.42118293411598,
      116.33911203705634,
      121.6767246538228,
      127.30209285829913,
      133.00911560716804,
      138.5553150084423,
      143.69014266130472,
      148.1737697232677,
      151.7917537262926,
      154.36770205510987,
      155.77298427484948,
      155.93294488069859,
      154.83105479322387,
      152.51131417851536,
      149.07639666001955,
      144.67773926123039,
      139.50124810452326,
      133.7548405208433,
      127.65901596928722,
      121.43429638778422,
      115.28087521551443,
      109.36303845385561,
      103.80422529070026,
      98.6904928717614,
      27.054598305652867,
      18.65387228960578,
      11.698159764349775,
      6.392717247668813,
      2.8909884186541035,
      1.2770283782047755,
      1.557579361618032,
      3.661964205945793,
      7.446244006172748,
      12.70048520866763,
      19.159783148794258,
      26.523969048788516,
      34.48410548014289,
      42.74467444366519,
      51.03688932726095,
      59.12837799401569,
      66.83044922833375,
      74.00253680362843,
      80.55480915923133,
      86.45123363813384,
      91.71476800218261,
      96.43368186347894,
      100.7590537533801,
      104.88344390912927,
      109.01240139830131,
      113.33508954993037,
      117.99413192892607,
      123.05597319494284,
      128.48885255553841,
      134.16322260589467,
      139.8794078887134,
      145.40396504474336,
      150.49637828742885,
      154.926328783523,
      158.48754671266613,
      161.0099548997989,
      162.3691102900534,
      162.492464165592,
      161.3635424484478,
      159.02417420147407,
      155.57245679112418,
      151.15370933070162,
      145.9473709391654,
      140.15514050002247,
      133.99212049008497,
      127.67517489540361,
      121.40326669500318,
      115.34220351225267,
      109.61910486255076,
      104.32466555975819,
      24.99500230562477,
      17.02676260853866,
      10.520093074975726,
      5.670207958896732,
      2.620416773456874,
      1.44529236825813,
      2.144137739383538,
      4.6417437360952505,
      8.792665004542272,
      14.388315032061044,
      21.167617057622692,
      28.836118269790123,
      37.09130426937679,
      45.64364008994346,
      54.229505333699706,
      62.62025080566964,
      70.62898624677993,
      78.11501221298553,
      84.98681589283566,
      91.20551142397314,
      96.79011178594321,
      101.82408514741536,
      106.45333544930655,
      110.86431671346999,
      115.25543355832818,
      119.80785748592793,
      124.65596192931892,
      129.85929531061018,
      135.38326787148208,
      141.10089522245417,
      146.81929216085288,
      152.31466218743813,
      157.35703140323238,
      161.7258979893607,
      165.22336378789393,
      167.6858227318705,
      168.99317350405502,
      169.07513152851425,
      167.91541863727224,
      165.55378763745983,
      162.08387744051578,
      157.64496625681048,
      152.41004479646443,
      146.5746969468437,
      140.34867007315677,
      133.94474025007273,
      127.56013505881926,
      121.36164548211892,
      115.47956013989578,
      110.00885764303256,
      23.151443566750093,
      15.611488543304041,
      9.547048579951813,
      5.143596580972819,
      2.5348232906901274,
      1.7865040205070528,
      2.8911890614159788,
      5.769654542717049,
      10.27528169459589,
      16.201023054355417,
      23.289914043820634,
      31.25349427955527,
      39.79568706054474,
      48.63274665151009,
      57.50592438838665,
      66.19008991734125,
      74.50013297887553,
      82.29538998108957,
      89.48295757623542,
      96.02144432301358,
      101.92631548467664,
      107.2763589335401,
      112.21158031591901,
      116.9114268508909,
      121.56631792873887,
      126.34874984947155,
      131.38450214257801,
      136.72635063682816,
      142.33720145182812,
      148.09285553277226,
      153.80746747046868,
      159.2672960224077,
      164.2532116948856,
      168.55470858492177,
      171.98239793332544,
      174.3792810247677,
      175.62975353998706,
      175.66594755054464,
      174.47190586262627,
      172.08540971500432,
      168.59579870722467,
      164.13647018894738,
      158.87408474853862,
      152.99826583029872,
      146.71343498496074,
      140.227933444683,
      133.7367594419304,
      127.40714918611052,
      121.37204102332997,
      115.73031036309989,
      21.522282939718245,
      14.405976700949424,
      8.776626521545609,
      4.810212958183492,
      2.6312185013026763,
      2.2973278687826593,
      3.7950413801436866,
      7.041632095578045,
      11.88963590145562,
      18.133756663235825,
      25.521377399684127,
      33.770210159205,
      42.59061263255713,
      51.70449214524314,
      60.85773801664226,
      69.82856396342957,
      78.4336254483652,
      86.5324506848649,
      94.03101465370051,
      100.88574811721833,
      107.10894124490379,
      112.77479368038377,
      118.01671004447277,
      123.0062678256489,
      127.925139341622,
      132.936593511545,
      138.15762896159615,
      143.63447506358338,
      149.32791107717273,
      155.11681580151094,
      160.82259360087903,
      166.24174546376264,
      171.1660519979917,
      175.39505622545317,
      178.74795979989517,
      181.0744862294422,
      182.26367639129222,
      182.25022516531624,
      181.01861666497848,
      178.60478437912013,
      175.09396612177395,
      170.61390569834612,
      165.3251303931612,
      159.4114640666864,
      153.07200088187113,
      146.5104125932111,
      139.9190222185064,
      133.46498318553955,
      127.28336176129906,
      121.47651838556371,
      20.10529945173698,
      13.407577976002663,
      8.205849444690777,
      4.666822485331451,
      2.9061098360007023,
      2.9740106745104455,
      4.851665613657495,
      8.453345160206844,
      13.631070667361868,
      20.181535817531444,
      27.856654508400243,
      36.380397118983815,
      45.469535751485026,
      54.85153609174083,
      64.2767540175314,
      73.52661111424484,
      82.41952609624815,
      90.81536554655338,
      98.61923277945832,
      105.78568517475563,
      112.32413103359514,
      118.3041554095442,
      123.8520105010564,
      129.13063201164096,
      134.31227452178183,
      139.55055193756561,
      144.9536194663212,
      150.5614498645681,
      156.33309596618926,
      162.15087082879515,
      167.84367543795776,
      173.21819684411926,
      178.07695942422373,
      182.22949851900478,
      185.50363313060188,
      187.75589771271302,
      188.88011210064428,
      188.81367212557763,
      187.54162601971723,
      185.0982061824388,
      181.56477979375893,
      177.0637140201846,
      171.7496477802831,
      165.8007525568498,
      159.41078513704394,
      152.77860049196926,
      146.09347392680485,
      139.52197499817322,
      133.20078204993519,
      127.23531242111932,
      18.89769310616837,
      12.613059698623807,
      7.8311388711868375,
      4.709577186982884,
      3.355468437406536,
      3.812357539938091,
      6.0566775752122055,
      10.00018688872521,
      15.494732505966915,
      22.33924931160093,
      30.290319786322424,
      39.0781862567557,
      48.42599579860808,
      58.06670539292233,
      67.75502164665396,
      77.275480371765,
      86.44827731786637,
      95.13375781426402,
      103.23638373566268,
      110.70910353123904,
      117.55862065526831,
      123.84978796616512,
      129.7013018124875,
      135.2668292879919,
      140.70864747020113,
      146.1704055640355,
      151.75145143724583,
      157.48583028630986,
      163.33127183051974,
      169.17390136352617,
      174.85042720732127,
      180.17743328271115,
      184.967843809167,
      189.04103642794718,
      192.233418489783,
      194.4083910150618,
      195.4646652362352,
      195.34246586065512,
      194.0275334463339,
      191.5525680395695,
      187.99532387480298,
      183.4730995602185,
      178.1349120096187,
      172.1534150212974,
      165.71702781323194,
      159.01970282102644,
      152.24737261367707,
      145.56556473113267,
      139.11207001017456,
      132.99492706073016,
      17.896101237580208,
      12.018621193468242,
      7.648337441954574,
      4.934059064566419,
      3.9747480907257184,
      4.807737588325537,
      7.405340819688924,
      11.677280432796493,
      17.47557715122714,
      24.601657187124157,
      32.816872633262214,
      41.85770319074584,
      51.453612362049235,
      61.34299810371446,
      71.28484729553949,
      81.06675767878721,
      90.51073409358452,
      99.47773574504416,
      107.87178815456764,
      115.64443667066809,
      122.79974451673398,
      129.39766911516332,
      135.54906185374415,
      141.39786045617547,
      147.095936440177,
      152.7767787781817,
      158.53104459659068,
      164.38720671500198,
      170.30207153912937,
      176.1659390415225,
      181.82357368426028,
      187.1010730103432,
      191.821311959325,
      195.81327277704497,
      198.9218612583212,
      201.0173600275284,
      202.003456651031,
      201.82331960127914,
      200.4635147137804,
      197.95539643206018,
      194.37338153152757,
      189.83002266685025,
      184.46898518897325,
      178.4575351424062,
      171.97877308151027,
      165.22170752946053,
      158.36870314940734,
      151.58384021434324,
      145.00554881476089,
      138.74405470022643,
    ],
    green_scale: [
      [247, 252, 253],
      [229, 245, 249],
      [204, 236, 230],
      [153, 216, 201],
      [102, 194, 164],
      [65, 174, 118],
      [35, 139, 69],
      [0, 109, 44],
      [0, 68, 27],
    ],
    green_pink_scale: [
      [142, 1, 82],
      [197, 27, 125],
      [222, 119, 174],
      [241, 182, 218],
      [253, 224, 239],
      [247, 247, 247],
      [230, 245, 208],
      [184, 225, 134],
      [127, 188, 65],
      [77, 146, 33],
      [39, 100, 25],
    ],
    grid_x: [
      -5.0,
      -4.6938775510204085,
      -4.387755102040816,
      -4.081632653061225,
      -3.7755102040816326,
      -3.4693877551020407,
      -3.163265306122449,
      -2.857142857142857,
      -2.5510204081632653,
      -2.2448979591836733,
      -1.9387755102040813,
      -1.6326530612244898,
      -1.3265306122448979,
      -1.020408163265306,
      -0.7142857142857144,
      -0.408163265306122,
      -0.1020408163265305,
      0.204081632653061,
      0.5102040816326534,
      0.8163265306122449,
      1.1224489795918373,
      1.4285714285714288,
      1.7346938775510203,
      2.0408163265306127,
      2.3469387755102042,
      2.6530612244897958,
      2.959183673469388,
      3.2653061224489797,
      3.571428571428571,
      3.8775510204081627,
      4.183673469387756,
      4.4897959183673475,
      4.795918367346939,
      5.1020408163265305,
      5.408163265306122,
      5.714285714285715,
      6.020408163265307,
      6.326530612244898,
      6.63265306122449,
      6.938775510204081,
      7.244897959183675,
      7.551020408163266,
      7.857142857142858,
      8.16326530612245,
      8.46938775510204,
      8.775510204081632,
      9.081632653061225,
      9.387755102040817,
      9.693877551020408,
      10.0,
    ],
    grid_y: [
      0.0,
      0.30612244897959184,
      0.6122448979591837,
      0.9183673469387755,
      1.2244897959183674,
      1.5306122448979593,
      1.836734693877551,
      2.142857142857143,
      2.4489795918367347,
      2.7551020408163267,
      3.0612244897959187,
      3.36734693877551,
      3.673469387755102,
      3.979591836734694,
      4.285714285714286,
      4.591836734693878,
      4.8979591836734695,
      5.204081632653061,
      5.510204081632653,
      5.816326530612245,
      6.122448979591837,
      6.428571428571429,
      6.73469387755102,
      7.040816326530613,
      7.346938775510204,
      7.653061224489796,
      7.959183673469388,
      8.26530612244898,
      8.571428571428571,
      8.877551020408163,
      9.183673469387756,
      9.489795918367347,
      9.795918367346939,
      10.10204081632653,
      10.408163265306122,
      10.714285714285715,
      11.020408163265307,
      11.326530612244898,
      11.63265306122449,
      11.938775510204081,
      12.244897959183675,
      12.551020408163266,
      12.857142857142858,
      13.16326530612245,
      13.46938775510204,
      13.775510204081632,
      14.081632653061225,
      14.387755102040817,
      14.693877551020408,
      15.0,
    ],
    lower_is_better: false,
    metric: 'metric_a',
    rel: false,
    sd: [
      16.594616554688688,
      14.467285466764766,
      12.682219482881646,
      11.175563317334678,
      9.865652887241176,
      8.680615482313465,
      7.581708104688582,
      6.567661257944135,
      5.658940072696163,
      4.88134248015756,
      4.277118352035075,
      3.931833318528337,
      3.93409004011965,
      4.255166059171334,
      4.744028505889571,
      5.243592100884591,
      5.6444319367124285,
      5.876809049442193,
      5.901324884669727,
      5.7109386167759695,
      5.331871856227973,
      4.814309694865433,
      4.218387899788953,
      3.6078726661861795,
      3.053107779361153,
      2.6449762155170147,
      2.5026209395642374,
      2.6771671282737515,
      3.0568716626646917,
      3.500249645297114,
      3.9390412853709766,
      4.3463849770903105,
      4.68021600605699,
      4.868425839321828,
      4.836277597919969,
      4.540321271139378,
      3.989623418947745,
      3.261673353580116,
      2.5380310249176614,
      2.1575877601553812,
      2.374573632102469,
      2.9159820497462032,
      3.401838892118932,
      3.6348393322301784,
      3.568280449951134,
      3.3488107345063916,
      3.4525094282323656,
      4.470421639178174,
      6.446422192789117,
      9.110538016027277,
      15.334974477298765,
      13.217856528520072,
      11.468812554229189,
      10.019688479839012,
      8.77804962857941,
      7.660283705266487,
      6.621505591032902,
      5.662238522353567,
      4.807783519827421,
      4.082251400079656,
      3.517987841941077,
      3.197522564121535,
      3.221561036437338,
      3.561609481844327,
      4.055602115630687,
      4.548218940703462,
      4.937720620917611,
      5.1575306170015285,
      5.166988763626379,
      4.958627042497239,
      4.562881509464873,
      4.038154896569765,
      3.4530554179824766,
      2.8781502324345207,
      2.385731664944574,
      2.0550501368668614,
      1.9795805747688582,
      2.178898579480297,
      2.5310636217638662,
      2.9216961559593266,
      3.319885920476123,
      3.723286079929703,
      4.090557000730645,
      4.334279946011602,
      4.364817829826115,
      4.131075369886576,
      3.639390787813114,
      2.963659906024537,
      2.274829267918829,
      1.899995104799905,
      2.1023071816636,
      2.6137155156313865,
      3.059334225724307,
      3.241839853256838,
      3.0997591575765333,
      2.7628587859215767,
      2.7717531580691133,
      3.8366499193065895,
      5.892649541709538,
      8.598314894024803,
      14.124399083002656,
      12.016623033000837,
      10.305320758733716,
      8.918851683012674,
      7.7527319289491246,
      6.709257800430899,
      5.736038598836197,
      4.836518642620626,
      4.044264684809918,
      3.383875127804178,
      2.8743412688308014,
      2.586911226172246,
      2.628852689008899,
      2.9734221079938146,
      3.4549362974749087,
      3.9270834903922207,
      4.298063985299114,
      4.503012187008503,
      4.497406618284126,
      4.2715921374538075,
      3.860362987617304,
      3.332943973708768,
      2.771303354456855,
      2.260620238189087,
      1.8826670685616977,
      1.6919402537997204,
      1.7116635714397395,
      1.9073312957545507,
      2.179421619038034,
      2.4680831887024706,
      2.790842997625833,
      3.173176957311154,
      3.5684093947684237,
      3.8655856576184497,
      3.957425900019672,
      3.7868237878230606,
      3.360957479675149,
      2.754709970573826,
      2.1309117913803246,
      1.785684448179315,
      1.9555312609803617,
      2.4103058104511277,
      2.8066001729506733,
      2.948222518501887,
      2.756867081798375,
      2.336845264006221,
      2.275342329274214,
      3.391620241576576,
      5.49724805102473,
      8.211137161669692,
      12.9669466894171,
      10.866995429180198,
      9.194608775360063,
      7.876084242814762,
      6.793569414610938,
      5.832328596761511,
      4.930567347546596,
      4.095754276008236,
      3.374265428792053,
      2.795131923302312,
      2.3608426293478693,
      2.1194243033090534,
      2.172035023422208,
      2.498048366278493,
      2.94361136274396,
      3.379850563232851,
      3.7256209662982314,
      3.9149486708778922,
      3.896137599616769,
      3.6554152030478035,
      3.232254315681793,
      2.710618616491496,
      2.194435835456114,
      1.7964931303643552,
      1.607661909419412,
      1.611248015523596,
      1.7230161551617542,
      1.8767079519733083,
      2.0218993106986094,
      2.160532947436214,
      2.3674134850489303,
      2.705930967043629,
      3.119266271330138,
      3.462980634299786,
      3.6095074826744358,
      3.4975565526092667,
      3.138217001753642,
      2.6107355491563826,
      2.070857858519256,
      1.7706646753399675,
      1.897738495954008,
      2.2789705384493004,
      2.6231389844059305,
      2.739051319883465,
      2.5349606785628667,
      2.0937083993949965,
      2.014565242994755,
      3.1557607909618555,
      5.257974547426375,
      7.941231251906655,
      11.867072285098798,
      9.772781184333653,
      8.139817473199823,
      6.894725182078308,
      5.904996095292102,
      5.03519826199315,
      4.211618127098716,
      3.4466571120991376,
      2.804974756534684,
      2.325577815278476,
      1.9911276831364266,
      1.8116826193079256,
      1.8634636921624654,
      2.139768910461311,
      2.521439357582009,
      2.905520409066456,
      3.220580492862473,
      3.395478129816808,
      3.367654199073054,
      3.1176077754070284,
      2.6904392564876582,
      2.1910243948099732,
      1.7593491652149555,
      1.5436963221487447,
      1.5931309501532256,
      1.7688401352848095,
      1.9318588084515977,
      2.026873680368338,
      2.038938987712178,
      2.009439448070897,
      2.067645464028794,
      2.3347813259999732,
      2.7497065003149808,
      3.126448384763841,
      3.3151451502154115,
      3.251831100181174,
      2.9534760198065326,
      2.505171822728955,
      2.0540690591658475,
      1.802542771612954,
      1.8862230429975408,
      2.1901289896852543,
      2.4859659827639926,
      2.594257677918468,
      2.4168076178586,
      2.0284847349212227,
      1.9994181478656023,
      3.117969295265511,
      5.158565413292126,
      7.7745506415225965,
      10.829663293259529,
      8.738306809107149,
      7.144497600485684,
      5.978579241246698,
      5.092217462138306,
      4.324689332065372,
      3.5872446302436702,
      2.8977665350010002,
      2.3447400112909267,
      1.9824036630801638,
      1.7679722255031887,
      1.6608573101539839,
      1.6986829011516729,
      1.8948612051815505,
      2.1855266411100804,
      2.502541895393174,
      2.7833648958062827,
      2.947157768124931,
      2.917108513800862,
      2.667542633767389,
      2.251691261585034,
      1.8046469829894387,
      1.5159524913335456,
      1.5306695370551722,
      1.7759681470825242,
      2.0481392386514385,
      2.2245064533711414,
      2.266261418844409,
      2.172816550940384,
      1.9987976816627162,
      1.90341384958393,
      2.0734036909494584,
      2.4655541635166562,
      2.854359325491326,
      3.067167345381796,
      3.037876508693909,
      2.7899447532829362,
      2.4143292330793744,
      2.0471183121626613,
      1.8411148027832966,
      1.8866397456018444,
      2.118685367452475,
      2.37423248732401,
      2.492406524293319,
      2.3747912730667426,
      2.09693074949926,
      2.164841484340534,
      3.23155921413569,
      5.170635368991512,
      7.692117860130428,
      9.860037818352344,
      7.768567921160086,
      6.212813139880452,
      5.13216567791949,
      4.361458432006485,
      3.7087709186346163,
      3.066783787059323,
      2.458972426173799,
      2.001155243872522,
      1.7637886337449034,
      1.6711322958385189,
      1.6314878571699882,
      1.6467739983551775,
      1.7473899345435149,
      1.9294210451630045,
      2.168989001483288,
      2.414746962481512,
      2.5725944868809973,
      2.549397841905636,
      2.3150505463567863,
      1.935863452788747,
      1.586117729732699,
      1.4883408289831117,
      1.6998642767323071,
      2.0509381839374257,
      2.3582503889873117,
      2.5266682479935767,
      2.5259689487388357,
      2.3607275744312655,
      2.0869452631412124,
      1.8667108317383636,
      1.9280205092210512,
      2.268375807491588,
      2.6423520903473845,
      2.8574021360365975,
      2.8447420624075677,
      2.6337753106549693,
      2.3207812433374184,
      2.028897180788468,
      1.864098620197212,
      1.8788609182831149,
      2.0483085954869664,
      2.2726482429281574,
      2.414621276037544,
      2.3782961612272295,
      2.2377287359826266,
      2.417720302642374,
      3.4349197318482094,
      5.259783119714058,
      7.672271120036757,
      8.963870869981411,
      6.8693967190166845,
      5.349846340215705,
      4.361099986370588,
      3.720175586622569,
      3.1960150335683086,
      2.659246257009454,
      2.138688049653703,
      1.7758198382310044,
      1.6519274803868151,
      1.6587590750482515,
      1.6691740595001014,
      1.6607916630092812,
      1.6708553916359699,
      1.7429774053448,
      1.902675030068566,
      2.115640181965807,
      2.2734524577508526,
      2.2671283400328486,
      2.0664764183191666,
      1.7566634815429631,
      1.545377228396543,
      1.6280826054463582,
      1.955136557424426,
      2.3440827495482957,
      2.651397515176134,
      2.8008368890146507,
      2.766806187476548,
      2.556810403283983,
      2.2259223689534497,
      1.9255704082140905,
      1.8877923510110588,
      2.1515559018159327,
      2.4825717925501567,
      2.677123244565833,
      2.663234694542004,
      2.4752580621188196,
      2.2144804409911574,
      1.990158919921807,
      1.8641506238241412,
      1.8561159272235281,
      1.972438997834539,
      2.1729563797243006,
      2.3470242864383697,
      2.4008012004026305,
      2.399916020221649,
      2.688987275205271,
      3.674049063437119,
      5.392272508117503,
      7.693071611427247,
      8.146992561203296,
      6.047608273594035,
      4.56203925262717,
      3.672638153732225,
      3.176975155140379,
      2.793800437898877,
      2.3693321903344513,
      1.9374652580557679,
      1.65718361329681,
      1.6145585555831998,
      1.6855642679519962,
      1.7268872065401069,
      1.6987753861882895,
      1.6364346814614337,
      1.6135308243389168,
      1.700964212361567,
      1.886220602756086,
      2.048712962611914,
      2.0676466428750415,
      1.9185010957416428,
      1.7060088732163514,
      1.6418948821063106,
      1.850396110223631,
      2.2276854978676797,
      2.616656470977627,
      2.904765884538699,
      3.0291407352475317,
      2.968414142828062,
      2.733035445971114,
      2.377201746674731,
      2.037482334021203,
      1.923972474177708,
      2.0990277885246393,
      2.363852042311791,
      2.517640109411721,
      2.4865217536865614,
      2.309269422694833,
      2.0925541950510222,
      1.931345478213974,
      1.844702018769293,
      1.8221462898385108,
      1.8934791291952071,
      2.0738659726036497,
      2.2813537547746696,
      2.4230389106633488,
      2.55074776901182,
      2.939407285065424,
      3.9107031796019833,
      5.5393539454100065,
      7.734233748888839,
      7.414983972853292,
      5.311026283182955,
      3.8577774410075008,
      3.076309675604319,
      2.7406177274690777,
      2.5046765811916565,
      2.191667412322787,
      1.8411148965058022,
      1.6188642832234068,
      1.616586779325206,
      1.71839554570203,
      1.7762880668985273,
      1.73440952069508,
      1.6213934155555492,
      1.5281953081213961,
      1.560057379604004,
      1.724226161057194,
      1.8927037258860056,
      1.9406850962296247,
      1.8541336714119014,
      1.749291027830595,
      1.8095100276068221,
      2.0911755928999174,
      2.4808002422130953,
      2.84962120729476,
      3.1075850609973563,
      3.203282874603095,
      3.1205900462771163,
      2.873439573851808,
      2.5149272483542506,
      2.165193929893569,
      2.000968554624038,
      2.088557459286031,
      2.273016838222177,
      2.3709488866998636,
      2.3104250394667725,
      2.135296864964437,
      1.9587307210654785,
      1.8605771570753533,
      1.8167139942776938,
      1.7882796439992588,
      1.8211406805042647,
      1.9800320930733808,
      2.2143123911189417,
      2.432825025420791,
      2.67183533424259,
      3.148867632457278,
      4.120694465520547,
      5.67879276980253,
      7.778305836511673,
      6.772496070602244,
      4.6681766573116485,
      3.2479773310327236,
      2.5841847569111995,
      2.417151985550014,
      2.3217702358588936,
      2.1074973332483635,
      1.821406756613587,
      1.6284300941144938,
      1.6312308901104804,
      1.7396217645605367,
      1.805502338638782,
      1.7562605449625646,
      1.6125995367642476,
      1.4762103198597738,
      1.473908673615556,
      1.6230838189076078,
      1.7942761115337242,
      1.8689467392965702,
      1.8461655114693722,
      1.8416395558088057,
      1.994633369705202,
      2.3147770141308714,
      2.6962325386179242,
      3.033760514988441,
      3.255069182947195,
      3.319874513351173,
      3.2186436687179927,
      2.9693773840464184,
      2.623271888179428,
      2.282656282898835,
      2.0879846440706658,
      2.0974412153165907,
      2.196845173598252,
      2.230371026936062,
      2.1335294720235174,
      1.9573557605549927,
      1.8228327392455554,
      1.7919050078038044,
      1.7958144336747104,
      1.7701606179476737,
      1.7698271498423477,
      1.900280155958768,
      2.1463142157831996,
      2.423544258742488,
      2.753976739170937,
      3.307920353792301,
      4.289869566958359,
      5.794615345091998,
      7.811156087957095,
      6.222266465629743,
      4.127284896876432,
      2.7460798827673947,
      2.209384970775508,
      2.2049143975043335,
      2.226646206564361,
      2.0884188837012028,
      1.846073130173559,
      1.6589979462148667,
      1.6438743243041225,
      1.744231155253138,
      1.8139838817193614,
      1.763500015390556,
      1.6057755596718553,
      1.4502436064189481,
      1.4337459487762192,
      1.571520582361256,
      1.7383457616489726,
      1.8320863806178798,
      1.8660679358655463,
      1.9459277652928868,
      2.165188968639465,
      2.503194452176378,
      2.8651614745899066,
      3.1649992208001625,
      3.345728696399301,
      3.3783334055225382,
      3.261137280834776,
      3.0167482966508508,
      2.693359864256289,
      2.3740021013738466,
      2.1635492713562665,
      2.1069806988721624,
      2.1239703701475285,
      2.0911549835999708,
      1.9572680865898728,
      1.7839641767446723,
      1.7001489986370872,
      1.7430063125355213,
      1.7987794607123133,
      1.7833974458848605,
      1.7543917422362036,
      1.8449386684293818,
      2.080087560363237,
      2.392584577308554,
      2.79364310463371,
      3.413182093512521,
      4.410796063060733,
      5.876130963072767,
      7.821970650017298,
      5.763942208859915,
      3.694158840998802,
      2.3658702650492445,
      1.9604526352385054,
      2.0899870283438458,
      2.1927062560820576,
      2.1049880878172247,
      1.8888809132051763,
      1.694507685631299,
      1.6508544132979404,
      1.7362368460239912,
      1.8084654199657064,
      1.7619449444696869,
      1.6029012032479086,
      1.4462680292450303,
      1.4292334748786037,
      1.555695056601677,
      1.7092708197284288,
      1.8116379316048203,
      1.891180156157698,
      2.038340102483532,
      2.3045168023599594,
      2.647910068291146,
      2.983824746566062,
      3.242255953458748,
      3.380156032075756,
      3.37994022614015,
      3.24883080939204,
      3.0145646976025713,
      2.721185936362814,
      2.430953980922795,
      2.2150450437771325,
      2.1043863150188153,
      2.046249113122105,
      1.9510755411149743,
      1.7861437700167417,
      1.628059743269057,
      1.6097140433890356,
      1.731298880429012,
      1.8390487719157171,
      1.8385164343533253,
      1.7846277999251254,
      1.822457140460318,
      2.0194266524876388,
      2.340197091770018,
      2.790987244202108,
      3.4650124344445654,
      4.480555299217915,
      5.916841486852589,
      7.80297662953012,
      5.393024257831879,
      3.368953021574709,
      2.1148717871818437,
      1.831592388389267,
      2.04695014438671,
      2.192232598557724,
      2.1335327885297937,
      1.9333105904562764,
      1.7289865255345294,
      1.6566652960120198,
      1.725703374959335,
      1.7999396649872468,
      1.7607867551064043,
      1.6090722035116685,
      1.4622275137475305,
      1.4502507852507953,
      1.5624219395512005,
      1.6941169543708177,
      1.794271723425251,
      1.907170268254401,
      2.106279899801838,
      2.4051820936013137,
      2.745699513837326,
      3.051474344834804,
      3.266426009955584,
      3.3604700690470737,
      3.3274393448560913,
      3.1842350691268924,
      2.9642812094827238,
      2.706431589691353,
      2.4507727805007256,
      2.236879054836553,
      2.082897555385134,
      1.9595584822758256,
      1.8110960841919626,
      1.6281826736796092,
      1.5062304441559635,
      1.5699937766414331,
      1.7686309361136647,
      1.922641287335953,
      1.9374689728309173,
      1.8614082634291473,
      1.8365438333493593,
      1.968285088211808,
      2.2688468870904694,
      2.748813804518837,
      3.4663342142725475,
      4.49934705422727,
      5.913479537353019,
      7.749046262225639,
      5.100414640558456,
      3.14300639375844,
      1.9843806552733583,
      1.7970315869672555,
      2.0457825868746236,
      2.202135895803601,
      2.1582985549009597,
      1.971394694838864,
      1.7634640833289181,
      1.6707371630019754,
      1.7258062214546905,
      1.800835875119265,
      1.7695921206994225,
      1.629278763964709,
      1.4960559527298978,
      1.487834675217095,
      1.5813289665463073,
      1.6843949252914843,
      1.7728273067409168,
      1.9074482458486863,
      2.1450015540725964,
      2.4652554351609344,
      2.7965580002124644,
      3.0693734324910222,
      3.2398800116392814,
      3.2900736640226262,
      3.2249156331448154,
      3.0714907897959645,
      2.869547856407802,
      2.6518559343594656,
      2.434963905438311,
      2.2288706163479164,
      2.0412093005952463,
      1.8642019994507102,
      1.6761109924728768,
      1.4954278354708188,
      1.4360509647822586,
      1.5921807726336648,
      1.8571640568654182,
      2.0467960421926428,
      2.073817972481097,
      1.9772041173085413,
      1.885287706440718,
      1.9302626471221063,
      2.182960928111849,
      2.6721014171997104,
      3.4220030095448153,
      4.469586405324098,
      5.8652237975148305,
      7.657276255768948,
      4.87297563482808,
      2.9980990010396145,
      1.9454826372510123,
      1.8186145692443914,
      2.0595829966893198,
      2.2061374182274194,
      2.1705190373209438,
      2.001009813687266,
      1.8024934134995245,
      1.7036663243006873,
      1.7492155996996137,
      1.8219637200256629,
      1.7955607453313551,
      1.6657206483304359,
      1.543899464747451,
      1.5342012175928168,
      1.6053420275293995,
      1.676209395950466,
      1.7458958365448671,
      1.8916170934468217,
      2.1550103751445437,
      2.4862346186033464,
      2.802603755607746,
      3.0402652902514675,
      3.1662126921211073,
      3.173574170842641,
      3.0778294308618483,
      2.9164464295881225,
      2.736216702871231,
      2.5630196705435315,
      2.3884889881949967,
      2.1950915412317253,
      1.9827703410408948,
      1.7650640684464207,
      1.5555615692749396,
      1.4035045227662268,
      1.4306828465204875,
      1.6755727978205093,
      1.989504168395284,
      2.202011531912164,
      2.2359337311171457,
      2.1197280965741423,
      1.9623680065580233,
      1.9083578603329807,
      2.0889024558732734,
      2.5678134394685848,
      3.338419388130558,
      4.395268767219952,
      5.773067930781067,
      7.526591768109066,
      4.695127445138119,
      2.909556953759425,
      1.9585858922561055,
      1.8600559504400633,
      2.068581932714958,
      2.1944154160831695,
      2.1665646249370702,
      2.0232809327438384,
      1.8509213418414376,
      1.7630546059618817,
      1.804096391047405,
      1.869672425539818,
      1.8416371870132129,
      1.7166524008647417,
      1.5996883351516795,
      1.5825259459937027,
      1.6301300107224004,
      1.6693957436058695,
      1.7166788899484988,
      1.863834350980776,
      2.1402376619912116,
      2.47179637011532,
      2.767430421292843,
      2.9680721286770817,
      3.0501280309972536,
      3.0168038024879467,
      2.893163355258172,
      2.72688793505675,
      2.5725224818210677,
      2.4481792597012193,
      2.319205002386864,
      2.1429541512186834,
      1.9150266342128357,
      1.6714125228728527,
      1.4631788315502223,
      1.3683255685680118,
      1.4928136455361996,
      1.8090218369248594,
      2.1525781679716456,
      2.3756247918060103,
      2.410622399588898,
      2.2757237598896984,
      2.059244569282818,
      1.904765809443855,
      1.9949251773759977,
      2.4447972289251805,
      3.223205403526739,
      4.281462056214905,
      5.6393055715201434,
      7.3573996406669036,
      4.551043159959324,
      2.851726379979592,
      1.9875018148367312,
      1.8952495909494975,
      2.0605932471379873,
      2.162365281371511,
      2.1462361024045773,
      2.040553899775862,
      1.9114299317330314,
      1.8503573540850382,
      1.8914427979649224,
      1.9443565588144605,
      1.9061499405244662,
      1.7771272079158713,
      1.6563260338613435,
      1.626980090830022,
      1.6532656468730476,
      1.6661436953123274,
      1.691361763615745,
      1.8311331975606997,
      2.1066327920352625,
      2.426944618765545,
      2.6956848868048464,
      2.8577269947298833,
      2.897418712392483,
      2.8269208520886995,
      2.6796725766110177,
      2.512914682526074,
      2.389388503194731,
      2.318203588170845,
      2.2372775719327667,
      2.0822421791684103,
      1.8483626405035167,
      1.5958673362137814,
      1.4144109471386637,
      1.399198737595607,
      1.6131624678922136,
      1.976466126135212,
      2.331927418024019,
      2.554756958257922,
      2.5854891950653043,
      2.433218246505268,
      2.1670693469548947,
      1.920556286188726,
      1.9107619959533055,
      2.3135623177826865,
      3.0848201962172515,
      4.13384298431429,
      5.467103257946299,
      7.151305466613021,
      4.426800692948703,
      2.8028418351838997,
      2.0067750662978674,
      1.9090757969827892,
      2.029921616140318,
      2.1093838613392326,
      2.1114678625454624,
      2.0549955960364263,
      1.983404905854968,
      1.9607413507723674,
      2.0054053421372973,
      2.041041233292231,
      1.9839616427125009,
      1.8407943049019073,
      1.7072392051638998,
      1.6630281678944818,
      1.6735211354918913,
      1.6694160997976937,
      1.676969088566561,
      1.8015039295093247,
      2.0609251589374797,
      2.3573733190718187,
      2.5927899687523075,
      2.7151110420169053,
      2.7150370938692228,
      2.6125991027068887,
      2.4482460894182347,
      2.2874541967423543,
      2.2007594210493138,
      2.1862978495545238,
      2.154312903021976,
      2.023783148371617,
      1.7943298243429195,
      1.551757373284963,
      1.4206504935274622,
      1.4927466222530703,
      1.7750364915570833,
      2.1617675378680725,
      2.514276824964994,
      2.7278794559650024,
      2.749929318131668,
      2.582291178917525,
      2.2777367832233475,
      1.9552267672748602,
      1.8464420161116932,
      2.1856676074417667,
      2.9320179118195795,
      3.9582390313748306,
      5.260150954992692,
      6.9109083173964985,
      4.312022200754337,
      2.7476816035528837,
      2.0021428796153637,
      1.895269819153939,
      1.9760877204895935,
      2.0379363935052197,
      2.0653912293492587,
      2.0677891889732427,
      2.0631921298317417,
      2.08540548282635,
      2.1360221166061653,
      2.151503707422386,
      2.0683447602740164,
      1.901668828119001,
      1.7475500500634131,
      1.6877941876259583,
      1.6904269953994773,
      1.6814671995396138,
      1.6788426539864612,
      1.7817176617655797,
      2.009514087989337,
      2.2690053401242625,
      2.464801302831593,
      2.547104171973765,
      2.511278927460115,
      2.3843253782963623,
      2.212361867278376,
      2.0668021516087847,
      2.0236560693858103,
      2.0671720446744772,
      2.0819748392102384,
      1.977595301906808,
      1.7629126286463614,
      1.5486292728400746,
      1.4829446967886695,
      1.634079438399127,
      1.9602548153299832,
      2.3509128073289314,
      2.688430921680549,
      2.885330280478113,
      2.8952990418375313,
      2.7150374824257275,
      2.3841845097700283,
      2.00629152704882,
      1.8101162237624797,
      2.0724065097456044,
      2.7730934668838136,
      3.7601796037788735,
      5.022400036461075,
      6.639691279866921,
      4.200854844701928,
      2.678321335378712,
      1.968548918665748,
      1.8542751076418609,
      1.9028302421361387,
      1.952864614092431,
      2.011638054545185,
      2.0788462081293817,
      2.1452012051756366,
      2.214277407013807,
      2.2722823205755414,
      2.26663845582233,
      2.1526832368474227,
      1.9553173434029743,
      1.7747502228040577,
      1.7003544961014916,
      1.704071935711926,
      1.7028584598544878,
      1.6985599918199916,
      1.7754612494308728,
      1.9576393876805422,
      2.167744359544829,
      2.3184218122819553,
      2.361774054056618,
      2.2961094542776523,
      2.1548041274411602,
      1.9884813483831878,
      1.8707033640630453,
      1.8771981883424922,
      1.975183330276606,
      2.0300349683220746,
      1.950717216759864,
      1.7593616273472787,
      1.5876496973900933,
      1.590704619639495,
      1.8037403196010808,
      2.152650379891094,
      2.5324285594018336,
      2.8453094744943246,
      3.019311264258322,
      3.0147568225300008,
      2.825264412434176,
      2.4803150741171387,
      2.0691460215503876,
      1.8053430698566437,
      1.982642377788218,
      2.614957062952743,
      3.5445035223088106,
      4.757918668588098,
      6.342032500961095,
      4.0923676337850745,
      2.59397869902871,
      1.908339635961169,
      1.7918281172692803,
      1.8173734687436862,
      1.8607934585968022,
      1.9537874336339016,
      2.0869210738063018,
      2.2231942116114007,
      2.337959015104842,
      2.404198063752181,
      2.3781417636365343,
      2.2315295580981167,
      1.9993710788586128,
      1.7889332605809398,
      1.7018709996482464,
      1.7150449758679212,
      1.7322619072630356,
      1.733626953789273,
      1.782775745236238,
      1.9090520886209157,
      2.059495050535611,
      2.1612061174228447,
      2.1687232093460382,
      2.0816285481114556,
      1.9393428459486968,
      1.7958276546329164,
      1.7206970444187533,
      1.7793968410883922,
      1.921286173519885,
      2.0042510858051656,
      1.9454489388161513,
      1.7821887400694028,
      1.6603454065178043,
      1.7264799084594133,
      1.9834336157554089,
      2.339111605689753,
      2.6971588260156465,
      2.97772256191499,
      3.123720215435592,
      3.103043130227189,
      2.908199128125134,
      2.5608576715141202,
      2.137393025314385,
      1.8291946638165002,
      1.920291815332565,
      2.4622398764427853,
      3.315110303516757,
      4.470913184201367,
      6.023368025131257,
      3.990469388001609,
      2.50065303331296,
      1.8303177412816802,
      1.7181479585494985,
      1.7297465635507292,
      1.76946926460905,
      1.8949271086652795,
      2.0900068657372888,
      2.2913578762627873,
      2.4487557274279923,
      2.523759983987943,
      2.479327299433671,
      2.3009866981986837,
      2.033470397925205,
      1.7926276940815504,
      1.695472821813043,
      1.724375288612392,
      1.7669406058319166,
      1.7788497016506237,
      1.8009495577489971,
      1.866264667950254,
      1.9504674911037136,
      2.0019647076782023,
      1.979557345315453,
      1.8825196106807331,
      1.755714887918663,
      1.6542730689323857,
      1.6349194938789493,
      1.741341741566771,
      1.9097096156380402,
      2.004970438724802,
      1.9589046143649576,
      1.8237556288515953,
      1.752142665917208,
      1.8719775438811854,
      2.1582427441689926,
      2.5094598010597844,
      2.8379632347554313,
      3.0801488586235695,
      3.193983983248615,
      3.1563110519041264,
      2.960311233258698,
      2.6213464153510837,
      2.203652216767855,
      1.872809408908231,
      1.8829578798184992,
      2.316783768067498,
      3.074968025251352,
      4.165981764428916,
      5.690541624321163,
      3.9033442418443944,
      2.410689692134248,
      1.7494259245629726,
      1.647315598606218,
      1.6518268217004375,
      1.6868915795717105,
      1.8374036586672051,
      2.0859158808928577,
      2.3450538669113534,
      2.5410653097464952,
      2.625160776736891,
      2.5652964598389394,
      2.3585890711337547,
      2.0587644813925987,
      1.7902026472426695,
      1.6857646629487772,
      1.733323836413856,
      1.8034743932639232,
      1.8281159182007087,
      1.8260611320693834,
      1.8312147014074736,
      1.8476838946785605,
      1.8512911615494874,
      1.8082571627625457,
      1.715910412657888,
      1.622302125453383,
      1.578934002266011,
      1.6200552747746597,
      1.76178482272209,
      1.9364196499247222,
      2.0273078307383394,
      1.9841838483098106,
      1.8730042809771867,
      1.8473633383808703,
      2.011620342832419,
      2.316827230688117,
      2.656050963126129,
      2.949488554931959,
      3.1485869763196948,
      3.2269481100684927,
      3.1720397202185775,
      2.979269277782609,
      2.65826350853622,
      2.260659879902522,
      1.9243948800393158,
      1.8630026928617718,
      2.177850356138792,
      2.8264945352804216,
      3.84868692519735,
      5.35237184560389,
      3.842260450411932,
      2.3417692724182975,
      1.686165013229735,
      1.596168332015113,
      1.5958211557463784,
      1.6202777873260166,
      1.7829371872326216,
      2.072981690730183,
      2.381303058825228,
      2.61142629945096,
      2.7046575046465775,
      2.632749924703422,
      2.4028904747112723,
      2.0770859527564007,
      1.786793566915726,
      1.6778534037573487,
      1.7429532025770296,
      1.8383457140120438,
      1.8757679880272744,
      1.8543926751781226,
      1.806002200942334,
      1.7594442926410714,
      1.7219136400215036,
      1.670833006316124,
      1.599390550730307,
      1.5531457408663991,
      1.5729449061352991,
      1.6668735500698997,
      1.8273770672519556,
      1.990736379516235,
      2.062902899055155,
      2.0125535749245858,
      1.9185738014411329,
      1.932565707837469,
      2.133664578101484,
      2.4510174566151774,
      2.7734213084377903,
      3.0280163586532822,
      3.180473515833944,
      3.2208281844437394,
      3.14902760102547,
      2.964011868212127,
      2.6693114207841533,
      2.3023505718346544,
      1.9725748617523142,
      1.8504359609050114,
      2.0431574246576742,
      2.572425825533669,
      3.5265595905274214,
      5.020436178088435,
      3.819581620238996,
      2.314270026789239,
      1.6639761494072725,
      1.5818145502376542,
      1.5723760228267187,
      1.5754393442565875,
      1.7332674658329976,
      2.0508287716693063,
      2.3990879216686922,
      2.6584103712361498,
      2.760293653089515,
      2.6796526730279586,
      2.432946200384198,
      2.089970051395723,
      1.7867972598292747,
      1.6759199018991107,
      1.7535496664065464,
      1.8682559778085355,
      1.9173344351840123,
      1.8833030351843827,
      1.7933267073346222,
      1.6952921328988955,
      1.6281632772305081,
      1.583163869345896,
      1.5459788329536792,
      1.5511567802996544,
      1.6245964877759755,
      1.7546448136028254,
      1.918679201446475,
      2.059055768758119,
      2.1023621495060016,
      2.0356712781162782,
      1.9510590385650053,
      1.9979310247045927,
      2.2301376913764,
      2.555368289547487,
      2.858021996608047,
      3.0713549627343437,
      3.1746418231692406,
      3.175209473680634,
      3.087449599115288,
      2.9148987458394737,
      2.6537406457039294,
      2.324695302601234,
      2.0086501033976902,
      1.8360614084368445,
      1.9105896676344805,
      2.3173111101950994,
      3.210666221245783,
      4.70997796038592,
      3.84606615526992,
      2.3461944549531584,
      1.7029268046459674,
      1.617440898992183,
      1.5888990700485361,
      1.5571244844533294,
      1.6912531728588542,
      2.0211209481945844,
      2.399513368925203,
      2.682435056803468,
      2.791583594983571,
      2.7048834072206134,
      2.447850217964915,
      2.097786525486522,
      1.792263052469665,
      1.681668947096719,
      1.7641445767455184,
      1.8902566180258535,
      1.9497449899473325,
      1.9114908042321364,
      1.7963432470073837,
      1.664887108951114,
      1.583556584901567,
      1.5563985755110703,
      1.5578437832879621,
      1.6052961598453794,
      1.7125960648169933,
      1.8599765177257572,
      2.0165918146422155,
      2.1283992947395314,
      2.137384135070079,
      2.047225572069685,
      1.9642131737625705,
      2.03751240351341,
      2.296423362000144,
      2.626782269062136,
      2.9080090477606757,
      3.0787445307720285,
      3.131296228364984,
      3.091077656148194,
      2.9889593622018236,
      2.8339033040308563,
      2.6126549444936447,
      2.326223904665911,
      2.0276952617737134,
      1.8138558261972457,
      1.7803190414848504,
      2.0698467170667274,
      2.917787589562384,
      4.440615113032162,
      3.928094682328605,
      2.446936777608408,
      1.8116757630501295,
      1.7081016352236038,
      1.6484414074136668,
      1.569586784999461,
      1.6619488441069448,
      1.9881195549494897,
      2.3857990698755267,
      2.6855047948305173,
      2.799196342348484,
      2.707941918902854,
      2.4464522620236404,
      2.0993040169727197,
      1.801955283906263,
      1.6934773468472883,
      1.7724616648535285,
      1.9018587715916238,
      1.9712657008233134,
      1.9387840674851209,
      1.8178753845603206,
      1.6755333729552153,
      1.5963685807195054,
      1.5919922279473009,
      1.6246350331199844,
      1.6956335942215095,
      1.8144296741964816,
      1.962940727279962,
      2.1058248385066567,
      2.188523813320162,
      2.162093541968844,
      2.0438713862800957,
      1.955411694245281,
      2.049022967644043,
      2.330795322877513,
      2.6641783710759,
      2.9230488397246726,
      3.050753293468846,
      3.0519828927301473,
      2.970866102842634,
      2.8568206503416285,
      2.724807844566389,
      2.549220843441873,
      2.308234022398162,
      2.028871692848195,
      1.7823692181094872,
      1.6570881767355226,
      1.8462318908343918,
      2.672742979188663,
      4.2361223010021964,
      4.065900447143718,
      2.6138731956473276,
      1.9842989123576857,
      1.8495637748473464,
      1.7494918882483947,
      1.6164618894456468,
      1.6528991784722527,
      1.9587678874867918,
      2.3630132897637814,
      2.6708536559381004,
      2.7846443803546435,
      2.688748524844164,
      2.4273206755482017,
      2.091882779362938,
      1.8118880254654701,
      1.7071230429472666,
      1.7754711882116734,
      1.9012525853849103,
      1.9813522678987785,
      1.9656659135440198,
      1.859257543608728,
      1.7292117127770221,
      1.6656092476900326,
      1.680768733662739,
      1.7287334486368842,
      1.8015018645245027,
      1.9116694399840173,
      2.0490450029518534,
      2.1757633753680334,
      2.232680588306282,
      2.1736074252868356,
      2.0255878859473055,
      1.9256995928474283,
      2.0334666477084244,
      2.333951519153024,
      2.6681670737811123,
      2.904115243712539,
      2.989154146951795,
      2.9395459990389337,
      2.8185105879122925,
      2.6960556258810255,
      2.5933582705074025,
      2.4687028317495248,
      2.2746739696247085,
      2.0152396219469617,
      1.745315392925459,
      1.5522823373311103,
      1.6737984120072837,
      2.5087910911187725,
      4.122167600410951,
      4.253571777988371,
      2.8344258660763444,
      2.2048783957176568,
      2.0309429309699727,
      1.8867324198915836,
      1.6997280953094145,
      1.6729101996107323,
      1.9419182761743548,
      2.3374270587425237,
      2.6424565779111684,
      2.749971623209935,
      2.6475404792320814,
      2.3889440911631534,
      2.072219275012329,
      1.816983192393429,
      1.71764808329177,
      1.7704246130890955,
      1.8876808267712697,
      1.980534162353332,
      1.992740304668038,
      1.9193767328944908,
      1.8210551212969195,
      1.7809432528531366,
      1.807166836465819,
      1.8522308540547971,
      1.9065530673702773,
      1.9915266521761363,
      2.109037469889532,
      2.2201583670425067,
      2.257588169275185,
      2.1720343850291712,
      1.9955845873976807,
      1.8795668483713357,
      1.9946742268265307,
      2.308523766772771,
      2.6407109938259286,
      2.8532756330696567,
      2.896784659121449,
      2.79806713683686,
      2.6395091511806537,
      2.5135988341742856,
      2.447315537430161,
      2.3782233007294318,
      2.2316349902733044,
      1.9931158628043917,
      1.7113902176238787,
      1.484637866874377,
      1.5904268043570406,
      2.461685111306379,
      4.121307929518316,
      4.480622725754581,
      3.0911537347775484,
      2.4544107320324042,
      2.2385420615753944,
      2.0522083200988868,
      1.8182773010279054,
      1.729140577901626,
      1.946396669535667,
      2.3154134976920058,
      2.60439833131049,
      2.69743459342553,
      2.584849615378426,
      2.3301082333905585,
      2.037372228978892,
      1.8129124848333047,
      1.7212994648160767,
      1.7560536440644414,
      1.8619271608239756,
      1.9703563139587454,
      2.0202910009970374,
      1.9944389891735186,
      1.9407060167290713,
      1.9268136974625507,
      1.954758963119775,
      1.9809258108855365,
      2.0000994986895853,
      2.046597610123241,
      2.1381984766460307,
      2.2365532357467677,
      2.26305854090261,
      2.1600708649518015,
      1.9597701818581543,
      1.824413080743836,
      1.9386918884785365,
      2.2585360948658275,
      2.5847792119125335,
      2.7734869634519663,
      2.777411946133052,
      2.632798971360852,
      2.4409922432796125,
      2.3184343748664986,
      2.296295558725188,
      2.286120465695379,
      2.186362319344368,
      1.9708477458134928,
      1.6929727020583245,
      1.4769989179332559,
      1.630877508314289,
      2.555298573342618,
      4.246670665320572,
      4.734197291189642,
      3.3660836483846386,
      2.7150149729795254,
      2.4584715082812014,
      2.2363279383896577,
      1.9669944864673674,
      1.8235924429124306,
      1.9781289379383302,
      2.301989263443647,
      2.560141110213924,
      2.6291797664905516,
      2.5015353773626283,
      2.2503675121695244,
      1.985816498631971,
      1.7976232203968365,
      1.717041052768189,
      1.7336507065657378,
      1.826819463078198,
      1.9533336696966108,
      2.048001807250045,
      2.0785141119047643,
      2.0754316940831856,
      2.087227729764935,
      2.109591447930222,
      2.1052421615475896,
      2.0766944490810815,
      2.074224319307832,
      2.1357618468858823,
      2.2257809297479887,
      2.2514844602171773,
      2.1422774568868563,
      1.9257053199863405,
      1.7695224989254272,
      1.8729298433349233,
      2.188821490338003,
      2.5040387690067223,
      2.668450283114374,
      2.635649784966298,
      2.4501264363439548,
      2.231813910311949,
      2.1216511307009047,
      2.151216075703545,
      2.200795922881259,
      2.145768102989336,
      1.9568916617838743,
      1.7031942175133454,
      1.5473448533783563,
      1.8041896327926559,
      2.7891415755558353,
      4.498181698545579,
      5.001033122960465,
      3.642968544863394,
      2.9712462950163014,
      2.677704461852504,
      2.428522862693055,
      2.1369158752528765,
      1.9510314841501297,
      2.03750962040501,
      2.2993633705755947,
      2.5118006086340534,
      2.546935786923084,
      2.3988498385541983,
      2.150555267045066,
      1.9184052405738325,
      1.7724314544036655,
      1.707507368897313,
      1.7078318493703426,
      1.7875954763201256,
      1.9328244487005048,
      2.0748227808055275,
      2.164452538997328,
      2.2127158041863724,
      2.248450138033839,
      2.2611601667798524,
      2.2197150359977265,
      2.1353017614208447,
      2.075978231475371,
      2.104580157801245,
      2.1915730479570956,
      2.227238840577486,
      2.1240868188804067,
      1.9010039543265314,
      1.7243509773299546,
      1.8050233453646336,
      2.104476195688497,
      2.4026669464255797,
      2.542602139509409,
      2.4770109027482285,
      2.257626595165466,
      2.0226703664965004,
      1.93624472309615,
      2.0231149109971844,
      2.129088561999564,
      2.114660216206202,
      1.9574356491741371,
      1.7515997559543928,
      1.6993506076434792,
      2.0900858205568076,
      3.1418620302996936,
      4.864144915129637,
      5.2688124548299715,
      3.9080148502545833,
      3.210035273247591,
      2.8842558812468155,
      2.617700476189177,
      2.3163581589060294,
      2.0999856535962924,
      2.118621430524094,
      2.3060326697323656,
      2.4595955199601756,
      2.451759994355883,
      2.2785275562372034,
      2.033325685149761,
      1.8392353764751206,
      1.7426922789560542,
      1.69934104950578,
      1.686753503367436,
      1.7519032084817778,
      1.912714541821551,
      2.0989273354339804,
      2.244729620411734,
      2.3415547559608267,
      2.3997129606683845,
      2.402174895975259,
      2.322125864980816,
      2.1784829825819516,
      2.0572996527236866,
      2.0509567421352726,
      2.1401962441316265,
      2.195957758286066,
      2.1106410881254996,
      1.8914374868190913,
      1.6961995311731024,
      1.7415671029521993,
      2.010521752584162,
      2.2854064650049586,
      2.4013515739852296,
      2.3082206911998204,
      2.0643557316556183,
      1.8262155266413178,
      1.7763088471476667,
      1.9212239460400933,
      2.0745303043967303,
      2.094218624474639,
      1.9744109194578063,
      1.8404496497209821,
      1.9220547366187026,
      2.4578444289331642,
      3.5852704607648818,
      5.326602979447198,
      5.526942468255143,
      4.149917485492672,
      3.4202983209129374,
      3.0670952102813787,
      2.792639977346808,
      2.492424679887777,
      2.2558816663466463,
      2.210716396327106,
      2.316817163612516,
      2.401638995289054,
      2.3439031493251665,
      2.142926280623597,
      1.9037765008220908,
      1.7564254154281342,
      1.717964698357823,
      1.7027345676288546,
      1.6814198799793323,
      1.7291308741080562,
      1.896853830631297,
      2.1177270833642607,
      2.3120233400370047,
      2.4528221445780902,
      2.5329999044379665,
      2.5279702439583494,
      2.412656806864691,
      2.211582819318757,
      2.0271115839547513,
      1.9844632129051423,
      2.0799539012240884,
      2.1636563823674533,
      2.105651326881849,
      1.8994212589396302,
      1.6882219111369785,
      1.6872707789088586,
      1.9120096768204013,
      2.1580096545944474,
      2.2516924038392347,
      2.1379522545792975,
      1.8815434232928332,
      1.6570379308787133,
      1.655129779784406,
      1.8506966413440131,
      2.0361849239341683,
      2.081386495059676,
      2.004970841275809,
      1.9647021708274357,
      2.1979832320334785,
      2.8813427573861117,
      4.0945362629131825,
      5.8666747452350965,
      5.766965738262811,
      4.359727262288435,
      3.5926320025054954,
      3.216082139007392,
      2.94239083659371,
      2.6523148979554123,
      2.40385099419994,
      2.300778205672862,
      2.3238110687665365,
      2.3341809736862067,
      2.2228865046812496,
      1.99530386235262,
      1.7702400794951572,
      1.68265272940198,
      1.7113563753661627,
      1.729908244224949,
      1.7037277009731375,
      1.7288233393926786,
      1.8883256489364213,
      2.1279752004501358,
      2.359564864491575,
      2.539226247675756,
      2.6426176565900605,
      2.635933190294336,
      2.493122670806562,
      2.2417626023268062,
      1.9970791808645365,
      1.917421653784576,
      2.020329270949265,
      2.135665098989733,
      2.110534696255122,
      1.9235988556105157,
      1.6993722654986902,
      1.6451591459374046,
      1.8147642519008438,
      2.0282029409811733,
      2.103300620742905,
      1.9780996117330514,
      1.723780671583001,
      1.531185580045163,
      1.582203321989517,
      1.8111744894200312,
      2.0087799051130544,
      2.0695572071985713,
      2.0428131632694746,
      2.115467002239228,
      2.510806523765663,
      3.3425131763468015,
      4.651234056890864,
      6.467739747785928,
      5.9827924011499025,
      4.530785577279904,
      3.7191975478646335,
      3.322011765045374,
      3.0566740581152043,
      2.7842437340008885,
      2.530443818740921,
      2.375878183979354,
      2.3178814827353094,
      2.2523247517991964,
      2.087931105962185,
      1.8404220065875918,
      1.6452785276869826,
      1.6348779280141705,
      1.7376108431219919,
      1.7925622564279942,
      1.7635150751656845,
      1.7583868272378023,
      1.8888620375628258,
      2.1260563306373665,
      2.3814071178603036,
      2.595211786721823,
      2.7248601377289017,
      2.7250669032520074,
      2.56627738204819,
      2.276771817342714,
      1.9800986925993844,
      1.863567703245722,
      1.9705581244743038,
      2.115483886984676,
      2.1240399781070156,
      1.9596129862514238,
      1.726011116296808,
      1.6177811688209696,
      1.7267634237097322,
      1.907185983356866,
      1.9700632650516217,
      1.8453883854990232,
      1.6101777151119985,
      1.4646859359158086,
      1.5610456217292212,
      1.797529497400625,
      1.9843315039199083,
      2.0504020585024505,
      2.0807388068059622,
      2.284083655210483,
      2.8486867196062966,
      3.8300148492203148,
      5.2428130840319405,
      7.11658608123447,
      6.170883100105746,
      4.658814149092107,
      3.793808801682519,
      3.376779549922145,
      3.126285137408787,
      2.8780706262305693,
      2.6245504505617316,
      2.4248642651832233,
      2.2903268786696076,
      2.151201287565823,
      1.938963932933532,
      1.6858415361407368,
      1.5465714808089368,
      1.632218660254273,
      1.8099874144860848,
      1.8991743229209619,
      1.8660965701166665,
      1.8212909667159016,
      1.8989101836986175,
      2.1085981442472086,
      2.372776203991294,
      2.6170000165857537,
      2.777876591422773,
      2.7957294083463187,
      2.63522540063448,
      2.3235254677498998,
      1.987786981132122,
      1.8354662913793556,
      1.9376448760830236,
      2.103807757359936,
      2.142423546196918,
      2.0015119425579333,
      1.7639720525726896,
      1.6087778550232203,
      1.659767831844026,
      1.8112818468357768,
      1.8714288114961728,
      1.762162262771637,
      1.5634930866593086,
      1.4704623411893654,
      1.5899985138910764,
      1.8029026469099079,
      1.9548419502004633,
      2.016384162305499,
      2.1135856764961196,
      2.4651020148068503,
      3.204833790813807,
      4.337469073519612,
      5.861286173149169,
      7.80341741946754,
      6.330451946655697,
      4.742194732474514,
      3.812235637754317,
      3.3736723850728194,
      3.14352648764979,
      2.92581989253613,
      2.6779988968186075,
      2.439561364560223,
      2.2345511920718923,
      2.0276595730866993,
      1.7785935267589492,
      1.5444419826197926,
      1.4965238709029929,
      1.6915417943577378,
      1.937212948165983,
      2.0536170465969144,
      2.012032592079623,
      1.9175563800126654,
      1.918704752226797,
      2.073541405524411,
      2.3306716802319114,
      2.602891304074608,
      2.801793335110596,
      2.8495697524768997,
      2.703015317133522,
      2.3868177702950963,
      2.0274797003977088,
      1.840966954854594,
      1.924354501572271,
      2.098069073476238,
      2.160079903952488,
      2.0431682409457856,
      1.8102732907410959,
      1.6240145195565259,
      1.6301299076734652,
      1.7623978778872993,
      1.8318016704093485,
      1.7537206516444734,
      1.60446055631245,
      1.554660201202164,
      1.6655347150246902,
      1.8227230830539363,
      1.9155088596451129,
      1.963687620786084,
      2.1410683371655925,
      2.6579170073453455,
      3.577090070075254,
      4.862211277873443,
      6.502101458165964,
      8.521423065421088,
      6.463713316317916,
      4.782462829345664,
      3.7727752541225446,
      3.3078293324006927,
      3.10274239660992,
      2.9222755004862218,
      2.6861986201830725,
      2.415892340568817,
      2.147933957600179,
      1.8827742666962324,
      1.61573773567915,
      1.4382498856556925,
      1.5188612000377952,
      1.82292351343866,
      2.1224280931599964,
      2.255859719343357,
      2.1991076934627016,
      2.0460319004819447,
      1.9501559870384886,
      2.021803789953753,
      2.2549170714769424,
      2.5539539166239638,
      2.799129682168735,
      2.889678659589524,
      2.7725088529443678,
      2.4686688125394123,
      2.100265801671794,
      1.8804021910150235,
      1.9282211397066658,
      2.0927573134498663,
      2.1704641080113123,
      2.079414162037156,
      1.8641281652892137,
      1.671573446348338,
      1.6569955080033312,
      1.784853983020018,
      1.8755079806821464,
      1.8404332110451818,
      1.7430352800800246,
      1.71571327190957,
      1.7858611192147948,
      1.8582465764354468,
      1.8682562236383375,
      1.8957462744369942,
      2.1703915168216055,
      2.8673506067112076,
      3.967285411821671,
      5.404463502603662,
      7.163323834393976,
      9.266261927206642,
      6.576158417438521,
      4.785036160077965,
      3.6772170242213877,
      3.176997445625067,
      3.0011059131952016,
      2.86586059890818,
      2.64913276314869,
      2.3553775166280153,
      2.034399160905059,
      1.7259097370066316,
      1.4717115729436523,
      1.40080850147853,
      1.6318394728868018,
      2.0285567513488703,
      2.364668487606625,
      2.504015417684526,
      2.4249091143996515,
      2.2067781142731664,
      1.9989082657949924,
      1.9596828026726905,
      2.149967459891571,
      2.475266175737742,
      2.7755429200666635,
      2.9209505655716947,
      2.8465816925955902,
      2.56864970340707,
      2.2015824182648878,
      1.9470982115331772,
      1.9424193708029704,
      2.0805351353027173,
      2.167194162784757,
      2.1069476766331032,
      1.9273402178296624,
      1.7603176012757724,
      1.756935259240222,
      1.8976512490914368,
      2.018111519212635,
      2.029398817545783,
      1.9752452689894726,
      1.9474984322897002,
      1.952836237649626,
      1.91873151217665,
      1.8256606521323355,
      1.8277840771254528,
      2.218262466957897,
      3.1033470835455197,
      4.380502486931156,
      5.966716351593712,
      7.845038249224036,
      10.035585720565116,
      6.676806675215787,
      4.7601717225296225,
      3.5324391829864843,
      2.9828788412581493,
      2.8399617879913213,
      2.7601146455000083,
      2.5730292875104546,
      2.26749946900764,
      1.9084482970873808,
      1.5813845917175637,
      1.3873650702042777,
      1.470100863821532,
      1.842414520560334,
      2.3055584244515144,
      2.661443124754432,
      2.7963679178016827,
      2.688653561021756,
      2.4025490138890526,
      2.075752364311758,
      1.9019976996960408,
      2.0279322836100677,
      2.377913817006802,
      2.740888761608439,
      2.950604575248122,
      2.928629384476551,
      2.6850972641355115,
      2.3240881561415305,
      2.0311302479878317,
      1.9583182255842415,
      2.0539660372681863,
      2.1453457858646026,
      2.125241451805999,
      2.004359272124995,
      1.8976748447122458,
      1.9378792304538803,
      2.1072355490741743,
      2.2611422307050124,
      2.3142070451691055,
      2.2893392928501037,
      2.2436665222531547,
      2.17179712187894,
      2.021457462279943,
      1.814477961437161,
      1.7916886918110082,
      2.3109710223759334,
      3.379755436456955,
      4.8242250128994115,
      6.553180883868888,
      8.548878007244962,
      10.828625754270654,
      6.778326310934522,
      4.724047471395747,
      3.3530106553750465,
      2.7337402309433543,
      2.6273608235577535,
      2.6162750149431493,
      2.473085588753888,
      2.173279296356465,
      1.8009995356450206,
      1.496447523655841,
      1.4199863812345637,
      1.669622402836932,
      2.1473082318283856,
      2.649680367473998,
      3.010743868157701,
      3.1325721100175565,
      2.9918906926708653,
      2.6390574059270273,
      2.1964866791784527,
      1.8750620447808979,
      1.9131252521505497,
      2.2817716886831225,
      2.710410640007001,
      2.9887207950547214,
      3.0232527931980924,
      2.8167564444126336,
      2.4610698179754356,
      2.1236880744369384,
      1.968768427434234,
      2.0076923946129095,
      2.1030979967286587,
      2.13768607858828,
      2.102225727692838,
      2.0882271324649104,
      2.1979189280841576,
      2.4077970570307783,
      2.595364314426769,
      2.6821641977288326,
      2.673496441774172,
      2.600104233331046,
      2.450041765800507,
      2.188652051890788,
      1.8749392411700414,
      1.8361503854873222,
      2.480381558882032,
      3.712249485921467,
      5.307360139070372,
      7.169246343200994,
      9.277615404344024,
      11.645834536186433,
      6.896863106932783,
      4.69962779027056,
      3.165152505760253,
      2.4497494426887694,
      2.3830659400351704,
      2.457622283702887,
      2.37729946775464,
      2.1092407821795605,
      1.7636356892242968,
      1.5377685544249426,
      1.6136865736341943,
      1.9978982305294244,
      2.5388603809066694,
      3.0575374345025645,
      3.4119217861894526,
      3.5139720133550014,
      3.3383140569896352,
      2.9241951282685577,
      2.379563437061333,
      1.916131835949645,
      1.8465674549601863,
      2.218136804449713,
      2.705460462690854,
      3.0485164461035397,
      3.136916275547047,
      2.964330180398208,
      2.60908591336705,
      2.2204502897869345,
      1.971404971712394,
      1.941162758813688,
      2.0440208457086366,
      2.1530260725357215,
      2.230408139894461,
      2.3340566573362187,
      2.5296690955479337,
      2.787766755105518,
      3.008036095357144,
      3.121018020247861,
      3.1192866768691516,
      3.015242036726914,
      2.794968619820849,
      2.4416135553120344,
      2.049742714032278,
      2.0124340181647935,
      2.755467647148653,
      4.115795353727264,
      5.839199433328457,
      7.82093360969229,
      10.034784576385386,
      12.488568735780017,
      7.051384027390464,
      4.7165652450490585,
      3.0114954362794015,
      2.1736188488051047,
      2.1479611110444163,
      2.3254852830418473,
      2.3296380648078236,
      2.127098318863621,
      1.858714667080473,
      1.7568045120164015,
      1.970660351710961,
      2.4393314526224774,
      3.009661278540679,
      3.527211925450535,
      3.8657044347582694,
      3.943325579492927,
      3.733055112384554,
      3.2666409171627895,
      2.642004980866666,
      2.0642517356991914,
      1.88298319318738,
      2.228798362963861,
      2.7525527077757177,
      3.145968735394657,
      3.278328492634286,
      3.1315742596489935,
      2.769519677929881,
      2.323698367203112,
      1.9718191230880808,
      1.8623286046220808,
      1.9803022815312605,
      2.1867299848329815,
      2.400309664781373,
      2.6360850428823137,
      2.925193574950045,
      3.235787675444985,
      3.487895980636453,
      3.62169282105934,
      3.621838250081579,
      3.4893377940870343,
      3.2126404513932267,
      2.794981233164766,
      2.3658794773160716,
      2.349451663356421,
      3.153967985304495,
      4.602418998519642,
      6.428445022394222,
      8.514367808033192,
      10.82432921676704,
      13.358804493988048,
      7.262388134859737,
      4.809029892831587,
      2.952551519709744,
      1.9865213399928034,
      1.9965890011067216,
      2.2823668800089276,
      2.386380111724565,
      2.2805501819887786,
      2.127838667906759,
      2.1558089351853686,
      2.465903251215439,
      2.977924768885658,
      3.5542022424749162,
      4.058021292723538,
      4.373799261159987,
      4.424249232209693,
      4.181792044888131,
      3.6743934067756636,
      2.9956296073434228,
      2.3446507449067897,
      2.070186004541116,
      2.3563382090353775,
      2.8794802999177596,
      3.2984475717407125,
      3.458312003175016,
      3.3257348825835362,
      2.9491217694080816,
      2.4432765193683537,
      1.986397982738948,
      1.792611754482068,
      1.936595459177826,
      2.2612136229130138,
      2.624228994635549,
      2.9952649697552496,
      3.3785610785250872,
      3.7433291727946227,
      4.026803690404899,
      4.178403241850967,
      4.178900340270555,
      4.02360146174791,
      3.7070974538830015,
      3.254658635880495,
      2.826781368172378,
      2.8452637689303493,
      3.6802015062063176,
      5.179960267143582,
      7.0824396909125795,
      9.255308560616761,
      11.650281097480745,
      14.258881756242348,
      7.550016106897722,
      5.010747914950657,
      3.05543076043918,
      2.005463532346657,
      2.0319876123945293,
      2.3989878288195707,
      2.598508572999426,
      2.6015544022871824,
      2.5713118868632217,
      2.705393188954572,
      3.073720163618326,
      3.6020269370644615,
      4.168808959902594,
      4.650056892866619,
      4.938395297976437,
      4.9606111035477,
      4.6899215419806755,
      4.153689682524179,
      3.4456511218071135,
      2.7610229997387195,
      2.423755774836546,
      2.6276528265937276,
      3.108998818603444,
      3.5224375641082375,
      3.6890404514532715,
      3.5572234368975306,
      3.1595749915119846,
      2.596153349950067,
      2.043390489963205,
      1.771338651877649,
      1.951790939347003,
      2.403279304593635,
      2.913883731936532,
      3.4131456113743774,
      3.8863897308479056,
      4.30499033988043,
      4.619604715543265,
      4.78791138805301,
      4.789864430632622,
      4.619503740907174,
      4.280328139038301,
      3.819617824581872,
      3.420801310519388,
      3.4816852060136005,
      4.329039637541851,
      5.851994193142301,
      7.806693841781605,
      10.04877497189424,
      12.516480844910076,
      15.191278447397156,
      7.931881940239207,
      5.348355892833455,
      3.3667525906626765,
      2.312826653506796,
      2.327636365637996,
      2.7204624070987107,
      2.9895363458504045,
      3.0902051866716977,
      3.164760006653172,
      3.375662556274043,
      3.776201180714478,
      4.303906847257146,
      4.851074752424574,
      5.3037575734076094,
      5.56172072805703,
      5.556011306342192,
      5.261947043912792,
      4.708522829170604,
      3.9917828206229964,
      3.3023042050984466,
      2.928615280790477,
      3.045624014580247,
      3.453592754139278,
      3.831098037952972,
      3.982748644964549,
      3.8385342476409074,
      3.4160387292944594,
      2.804042395367436,
      2.178951977007923,
      1.8519303374144682,
      2.0723365410252907,
      2.638232518044714,
      3.27897600357168,
      3.8918801261235636,
      4.447464673608606,
      4.917933478949147,
      5.263467760885557,
      5.4487326535036935,
      5.455021602156683,
      5.2783309296707275,
      4.9326101857189855,
      4.485030113536878,
      4.132498889584444,
      4.239051937368762,
      5.091198671146461,
      6.6185727812936115,
      8.604723505973777,
      10.89878888332266,
      13.426352089700023,
      16.15841728428865,
      8.421197935691637,
      5.836328620973001,
      3.8930251409057703,
      2.8906247575241317,
      2.874677957056146,
      3.246135868876332,
      3.5525585945678113,
      3.7276430745519638,
      3.882126920778124,
      4.1458519487811225,
      4.561855770755553,
      5.078356307092616,
      5.599315577720965,
      6.019589557724691,
      6.245714318347551,
      6.213413729153447,
      5.901138992449981,
      5.340695834517027,
      4.6303827217663835,
      3.9532319304793893,
      3.5598598385448588,
      3.596602014317176,
      3.9148889013346158,
      4.232732583390551,
      4.350280275808494,
      4.182610955060754,
      3.7348188150319603,
      3.0891024487932577,
      2.42644112603477,
      2.0811114028818998,
      2.3345433195804994,
      2.9834238625854406,
      3.726324340910634,
      4.4339282950018255,
      5.062099966601795,
      5.581166546347282,
      5.957206000653421,
      6.1605020860426825,
      6.175057041898733,
      6.000946757449062,
      5.662957330459814,
      5.244681283187104,
      4.9481150618549234,
      5.101483801820184,
      5.9566774889036935,
      7.477262400842247,
      9.478142472942892,
      11.808240903041419,
      14.38273599069378,
      17.162508079997224,
      9.025748138586204,
      6.476328317733356,
      4.610417145134137,
      3.6728661002804395,
      3.619694464322617,
      3.947470986231797,
      4.265956501285606,
      4.491999884276225,
      4.703825310330094,
      5.002619526593498,
      5.423091077979789,
      5.921612648909119,
      6.412176220757926,
      6.7978325557556545,
      6.991816868298482,
      6.934939637168661,
      6.60944176284603,
      6.050195541713492,
      5.356315354263401,
      4.700065552180169,
      4.295973052927493,
      4.262431622918681,
      4.487185072470222,
      4.730732841939807,
      4.79994864742398,
      4.601097280653498,
      4.130733507398199,
      3.4691959995304855,
      2.8050717266793437,
      2.475621515531985,
      2.7501785975448008,
      3.4455930332414972,
      4.259747728975498,
      5.041678359155208,
      5.731520286944719,
      6.294906487827477,
      6.700714415170762,
      6.923507998277596,
      6.950724421277123,
      6.787699159324087,
      6.469522227086419,
      6.092248471452773,
      5.85664662319808,
      6.056989202436123,
      6.916210332615394,
      8.42409515116814,
      10.426915698562018,
      12.778866084631375,
      15.387787320563065,
      18.20542711615552,
    ],
    xvar: 'x1',
    yvar: 'x2',
    x_is_log: false,
    y_is_log: false,
  };
  const arm_data = data['arm_data'];
  const density = data['density'];
  const grid_x = data['grid_x'];
  const grid_y = data['grid_y'];
  const f = data['f'];
  const lower_is_better = data['lower_is_better'];
  const metric = data['metric'];
  const rel = data['rel'];
  const sd = data['sd'];
  const xvar = data['xvar'];
  const yvar = data['yvar'];
  const x_is_log = data['x_is_log'];
  const y_is_log = data['y_is_log'];

  const GREEN_SCALE = [
    [247, 252, 253],
    [229, 245, 249],
    [204, 236, 230],
    [153, 216, 201],
    [102, 194, 164],
    [65, 174, 118],
    [35, 139, 69],
    [0, 109, 44],
    [0, 68, 27],
  ];
  const GREEN_PINK_SCALE = [
    [142, 1, 82],
    [197, 27, 125],
    [222, 119, 174],
    [241, 182, 218],
    [253, 224, 239],
    [247, 247, 247],
    [230, 245, 208],
    [184, 225, 134],
    [127, 188, 65],
    [77, 146, 33],
    [39, 100, 25],
  ];
  const BLUE_SCALE = [
    [255, 247, 251],
    [236, 231, 242],
    [208, 209, 230],
    [166, 189, 219],
    [116, 169, 207],
    [54, 144, 192],
    [5, 112, 176],
    [3, 78, 123],
  ];

  // format data
  const res = relativize_data(f, sd, rel, arm_data, metric);
  const f_final = res[0];
  const sd_final = res[1];

  // calculate max of abs(outcome), used for colorscale
  const f_absmax = Math.max(
    Math.abs(Math.min(...f_final)),
    Math.max(...f_final),
  );

  // transform to nested array
  var f_plt = [];
  while (f_final.length) f_plt.push(f_final.splice(0, density));
  var sd_plt = [];
  while (sd_final.length) sd_plt.push(sd_final.splice(0, density));

  // create traces
  const CONTOUR_CONFIG = {
    autocolorscale: false,
    autocontour: true,
    contours: {
      coloring: 'heatmap',
    },
    hoverinfo: 'x+y+z',
    ncontours: density / 2,
    type: 'contour',
    x: grid_x,
    y: grid_y,
  };

  let f_scale;
  if (rel === true) {
    f_scale =
      lower_is_better === true ? GREEN_PINK_SCALE.reverse() : GREEN_PINK_SCALE;
  } else {
    f_scale = GREEN_SCALE;
  }

  const f_trace = {
    colorbar: {
      x: 0.45,
      y: 0.5,
      ticksuffix: rel === true ? '%' : '',
      tickfont: {
        size: 8,
      },
    },
    colorscale: f_scale.map((v, i) => [i / (f_scale.length - 1), rgb(v)]),
    xaxis: 'x',
    yaxis: 'y',
    z: f_plt,
    // zmax and zmin are ignored if zauto is true
    zauto: !rel,
    zmax: f_absmax,
    zmin: -f_absmax,
  };

  const sd_trace = {
    colorbar: {
      x: 1,
      y: 0.5,
      ticksuffix: rel === true ? '%' : '',
      tickfont: {
        size: 8,
      },
    },
    colorscale: BLUE_SCALE.map((v, i) => [i / (BLUE_SCALE.length - 1), rgb(v)]),
    xaxis: 'x2',
    yaxis: 'y2',
    z: sd_plt,
  };

  Object.keys(CONTOUR_CONFIG).forEach(key => {
    f_trace[key] = CONTOUR_CONFIG[key];
    sd_trace[key] = CONTOUR_CONFIG[key];
  });

  // get in-sample arms
  const arm_x = [];
  const arm_y = [];
  const arm_text = [];

  Object.keys(arm_data['in_sample']).forEach(arm_name => {
    arm_x.push(arm_data['in_sample'][arm_name]['parameters'][xvar]);
    arm_y.push(arm_data['in_sample'][arm_name]['parameters'][yvar]);
    arm_text.push(arm_name);
  });

  // configs for in-sample arms
  const base_in_sample_arm_config = {
    hoverinfo: 'text',
    legendgroup: 'In-sample',
    marker: {color: 'black', symbol: 1, opacity: 0.5},
    mode: 'markers',
    name: 'In-sample',
    text: arm_text,
    type: 'scatter',
    x: arm_x,
    y: arm_y,
  };

  const f_in_sample_arm_trace = {
    xaxis: 'x',
    yaxis: 'y',
  };

  const sd_in_sample_arm_trace = {
    showlegend: false,
    xaxis: 'x2',
    yaxis: 'y2',
  };

  Object.keys(base_in_sample_arm_config).forEach(key => {
    f_in_sample_arm_trace[key] = base_in_sample_arm_config[key];
    sd_in_sample_arm_trace[key] = base_in_sample_arm_config[key];
  });

  const traces = [
    f_trace,
    sd_trace,
    f_in_sample_arm_trace,
    sd_in_sample_arm_trace,
  ];

  // start symbol at 2 for candidate markers
  let i = 2;

  // iterate over out-of-sample arms
  Object.keys(arm_data['out_of_sample']).forEach(generator_run_name => {
    const ax = [];
    const ay = [];
    const atext = [];

    Object.keys(arm_data['out_of_sample'][generator_run_name]).forEach(
      arm_name => {
        ax.push(
          arm_data['out_of_sample'][generator_run_name][arm_name]['parameters'][
            xvar
          ],
        );
        ay.push(
          arm_data['out_of_sample'][generator_run_name][arm_name]['parameters'][
            yvar
          ],
        );
        atext.push('<em>Candidate ' + arm_name + '</em>');
      },
    );

    traces.push({
      hoverinfo: 'text',
      legendgroup: generator_run_name,
      marker: {color: 'black', symbol: i, opacity: 0.5},
      mode: 'markers',
      name: generator_run_name,
      text: atext,
      type: 'scatter',
      xaxis: 'x',
      x: ax,
      yaxis: 'y',
      y: ay,
    });
    traces.push({
      hoverinfo: 'text',
      legendgroup: generator_run_name,
      marker: {color: 'black', symbol: i, opacity: 0.5},
      mode: 'markers',
      name: 'In-sample',
      showlegend: false,
      text: atext,
      type: 'scatter',
      x: ax,
      xaxis: 'x2',
      y: ay,
      yaxis: 'y2',
    });
    i += 1;
  });

  // layout
  const xrange = axis_range(grid_x, x_is_log);
  const yrange = axis_range(grid_y, y_is_log);

  const xtype = x_is_log ? 'log' : 'linear';
  const ytype = y_is_log ? 'log' : 'linear';

  const layout = {
    autosize: false,
    margin: {
      l: 35,
      r: 35,
      t: 35,
      b: 100,
      pad: 0,
    },
    annotations: [
      {
        font: {size: 14},
        showarrow: false,
        text: 'Mean',
        x: 0.25,
        xanchor: 'center',
        xref: 'paper',
        y: 1,
        yanchor: 'bottom',
        yref: 'paper',
      },
      {
        font: {size: 14},
        showarrow: false,
        text: 'Standard Error',
        x: 0.8,
        xanchor: 'center',
        xref: 'paper',
        y: 1,
        yanchor: 'bottom',
        yref: 'paper',
      },
    ],
    hovermode: 'closest',
    legend: {orientation: 'h', x: 0, y: -0.25},
    height: 450,
    width: 950,
    xaxis: {
      anchor: 'y',
      autorange: false,
      domain: [0.05, 0.45],
      exponentformat: 'e',
      range: xrange,
      tickfont: {size: 11},
      tickmode: 'auto',
      title: xvar,
      type: xtype,
    },
    xaxis2: {
      anchor: 'y2',
      autorange: false,
      domain: [0.6, 1],
      exponentformat: 'e',
      range: xrange,
      tickfont: {size: 11},
      tickmode: 'auto',
      title: xvar,
      type: xtype,
    },
    yaxis: {
      anchor: 'x',
      autorange: false,
      domain: [0, 1],
      exponentformat: 'e',
      range: yrange,
      tickfont: {size: 11},
      tickmode: 'auto',
      title: yvar,
      type: ytype,
    },
    yaxis2: {
      anchor: 'x2',
      autorange: false,
      domain: [0, 1],
      exponentformat: 'e',
      range: yrange,
      tickfont: {size: 11},
      tickmode: 'auto',
      type: ytype,
    },
  };

  return {
    layout: layout,
    traces: traces,
  };
}

const contourPlotData = getPlotData();

Plotly.newPlot(
  'contour',
  contourPlotData['traces'],
  contourPlotData['layout'],
  {
    responsive: true,
    showLink: false,
  },
);
