"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.extension_dict
import google.protobuf.message
import google.rpc.status_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Operation(google.protobuf.message.Message):
    """This resource represents a long-running operation that is the result of a
    network API call.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    DONE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    RESPONSE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The server-assigned name, which is only unique within the same service that
    originally returns it. If you use the default HTTP mapping, the
    `name` should be a resource name ending with `operations/{unique_id}`.
    """
    @property
    def metadata(self) -> google.protobuf.any_pb2.Any:
        """Service-specific metadata associated with the operation.  It typically
        contains progress information and common metadata such as create time.
        Some services might not provide such metadata.  Any method that returns a
        long-running operation should document the metadata type, if any.
        """
    done: builtins.bool
    """If the value is `false`, it means the operation is still in progress.
    If `true`, the operation is completed, and either `error` or `response` is
    available.
    """
    @property
    def error(self) -> google.rpc.status_pb2.Status:
        """The error result of the operation in case of failure or cancellation."""
    @property
    def response(self) -> google.protobuf.any_pb2.Any:
        """The normal response of the operation in case of success.  If the original
        method returns no data on success, such as `Delete`, the response is
        `google.protobuf.Empty`.  If the original method is standard
        `Get`/`Create`/`Update`, the response should be the resource.  For other
        methods, the response should have the type `XxxResponse`, where `Xxx`
        is the original method name.  For example, if the original method name
        is `TakeSnapshot()`, the inferred response type is
        `TakeSnapshotResponse`.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        metadata: google.protobuf.any_pb2.Any | None = ...,
        done: builtins.bool = ...,
        error: google.rpc.status_pb2.Status | None = ...,
        response: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "error",
            b"error",
            "metadata",
            b"metadata",
            "response",
            b"response",
            "result",
            b"result",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "done",
            b"done",
            "error",
            b"error",
            "metadata",
            b"metadata",
            "name",
            b"name",
            "response",
            b"response",
            "result",
            b"result",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["result", b"result"]
    ) -> typing_extensions.Literal["error", "response"] | None: ...

global___Operation = Operation

@typing_extensions.final
class GetOperationRequest(google.protobuf.message.Message):
    """The request message for [Operations.GetOperation][google.longrunning.Operations.GetOperation]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name"]
    ) -> None: ...

global___GetOperationRequest = GetOperationRequest

@typing_extensions.final
class ListOperationsRequest(google.protobuf.message.Message):
    """The request message for [Operations.ListOperations][google.longrunning.Operations.ListOperations]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation's parent resource."""
    filter: builtins.str
    """The standard list filter."""
    page_size: builtins.int
    """The standard list page size."""
    page_token: builtins.str
    """The standard list page token."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        filter: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "filter",
            b"filter",
            "name",
            b"name",
            "page_size",
            b"page_size",
            "page_token",
            b"page_token",
        ],
    ) -> None: ...

global___ListOperationsRequest = ListOperationsRequest

@typing_extensions.final
class ListOperationsResponse(google.protobuf.message.Message):
    """The response message for [Operations.ListOperations][google.longrunning.Operations.ListOperations]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def operations(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Operation
    ]:
        """A list of operations that matches the specified filter in the request."""
    next_page_token: builtins.str
    """The standard List next-page token."""
    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[global___Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "next_page_token", b"next_page_token", "operations", b"operations"
        ],
    ) -> None: ...

global___ListOperationsResponse = ListOperationsResponse

@typing_extensions.final
class CancelOperationRequest(google.protobuf.message.Message):
    """The request message for [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource to be cancelled."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name"]
    ) -> None: ...

global___CancelOperationRequest = CancelOperationRequest

@typing_extensions.final
class DeleteOperationRequest(google.protobuf.message.Message):
    """The request message for [Operations.DeleteOperation][google.longrunning.Operations.DeleteOperation]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource to be deleted."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name"]
    ) -> None: ...

global___DeleteOperationRequest = DeleteOperationRequest

@typing_extensions.final
class WaitOperationRequest(google.protobuf.message.Message):
    """The request message for [Operations.WaitOperation][google.longrunning.Operations.WaitOperation]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource to wait on."""
    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """The maximum duration to wait before timing out. If left blank, the wait
        will be at most the time permitted by the underlying HTTP/RPC protocol.
        If RPC context deadline is also specified, the shorter one will be used.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["timeout", b"timeout"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["name", b"name", "timeout", b"timeout"],
    ) -> None: ...

global___WaitOperationRequest = WaitOperationRequest

@typing_extensions.final
class OperationInfo(google.protobuf.message.Message):
    """A message representing the message types used by a long-running operation.

    Example:

      rpc LongRunningRecognize(LongRunningRecognizeRequest)
          returns (google.longrunning.Operation) {
        option (google.longrunning.operation_info) = {
          response_type: "LongRunningRecognizeResponse"
          metadata_type: "LongRunningRecognizeMetadata"
        };
      }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_TYPE_FIELD_NUMBER: builtins.int
    METADATA_TYPE_FIELD_NUMBER: builtins.int
    response_type: builtins.str
    """Required. The message name of the primary return type for this
    long-running operation.
    This type will be used to deserialize the LRO's response.

    If the response is in a different package from the rpc, a fully-qualified
    message name must be used (e.g. `google.protobuf.Struct`).

    Note: Altering this value constitutes a breaking change.
    """
    metadata_type: builtins.str
    """Required. The message name of the metadata type for this long-running
    operation.

    If the response is in a different package from the rpc, a fully-qualified
    message name must be used (e.g. `google.protobuf.Struct`).

    Note: Altering this value constitutes a breaking change.
    """
    def __init__(
        self,
        *,
        response_type: builtins.str = ...,
        metadata_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "metadata_type", b"metadata_type", "response_type", b"response_type"
        ],
    ) -> None: ...

global___OperationInfo = OperationInfo

OPERATION_INFO_FIELD_NUMBER: builtins.int
operation_info: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.MethodOptions, global___OperationInfo
]
"""Additional information regarding long-running operations.
In particular, this specifies the types that are returned from
long-running operations.

Required for methods that return `google.longrunning.Operation`; invalid
otherwise.
"""
