"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class SystemParameters(google.protobuf.message.Message):
    """### System parameter configuration

    A system parameter is a special kind of parameter defined by the API
    system, not by an individual API. It is typically mapped to an HTTP header
    and/or a URL query parameter. This configuration specifies which methods
    change the names of the system parameters.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SystemParameterRule
    ]:
        """Define system parameters.

        The parameters defined here will override the default parameters
        implemented by the system. If this field is missing from the service
        config, default system parameters will be used. Default system parameters
        and names is implementation-dependent.

        Example: define api key for all methods

            system_parameters
              rules:
                - selector: "*"
                  parameters:
                    - name: api_key
                      url_query_parameter: api_key


        Example: define 2 api key names for a specific method.

            system_parameters
              rules:
                - selector: "/ListShelves"
                  parameters:
                    - name: api_key
                      http_header: Api-Key1
                    - name: api_key
                      http_header: Api-Key2

        **NOTE:** All service configuration rules follow "last one wins" order.
        """
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___SystemParameterRule] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["rules", b"rules"]
    ) -> None: ...

global___SystemParameters = SystemParameters

@typing_extensions.final
class SystemParameterRule(google.protobuf.message.Message):
    """Define a system parameter rule mapping system parameter definitions to
    methods.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SELECTOR_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    selector: builtins.str
    """Selects the methods to which this rule applies. Use '*' to indicate all
    methods in all APIs.

    Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    """
    @property
    def parameters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SystemParameter
    ]:
        """Define parameters. Multiple names may be defined for a parameter.
        For a given method call, only one of them should be used. If multiple
        names are used the behavior is implementation-dependent.
        If none of the specified names are present the behavior is
        parameter-dependent.
        """
    def __init__(
        self,
        *,
        selector: builtins.str = ...,
        parameters: collections.abc.Iterable[global___SystemParameter] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "parameters", b"parameters", "selector", b"selector"
        ],
    ) -> None: ...

global___SystemParameterRule = SystemParameterRule

@typing_extensions.final
class SystemParameter(google.protobuf.message.Message):
    """Define a parameter's name and location. The parameter may be passed as either
    an HTTP header or a URL query parameter, and if both are passed the behavior
    is implementation-dependent.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    HTTP_HEADER_FIELD_NUMBER: builtins.int
    URL_QUERY_PARAMETER_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Define the name of the parameter, such as "api_key" . It is case sensitive."""
    http_header: builtins.str
    """Define the HTTP header name to use for the parameter. It is case
    insensitive.
    """
    url_query_parameter: builtins.str
    """Define the URL query parameter name to use for the parameter. It is case
    sensitive.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        http_header: builtins.str = ...,
        url_query_parameter: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "http_header",
            b"http_header",
            "name",
            b"name",
            "url_query_parameter",
            b"url_query_parameter",
        ],
    ) -> None: ...

global___SystemParameter = SystemParameter
