"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.api.auth_pb2
import google.api.backend_pb2
import google.api.billing_pb2
import google.api.context_pb2
import google.api.control_pb2
import google.api.documentation_pb2
import google.api.endpoint_pb2
import google.api.http_pb2
import google.api.log_pb2
import google.api.logging_pb2
import google.api.metric_pb2
import google.api.monitored_resource_pb2
import google.api.monitoring_pb2
import google.api.quota_pb2
import google.api.source_info_pb2
import google.api.system_parameter_pb2
import google.api.usage_pb2
import google.protobuf.api_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.type_pb2
import google.protobuf.wrappers_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Service(google.protobuf.message.Message):
    """`Service` is the root object of Google service configuration schema. It
    describes basic information about a service, such as the name and the
    title, and delegates other aspects to sub-sections. Each sub-section is
    either a proto message or a repeated proto message that configures a
    specific aspect, such as auth. See each proto message definition for details.

    Example:

        type: google.api.Service
        name: calendar.googleapis.com
        title: Google Calendar API
        apis:
        - name: google.calendar.v3.Calendar
        authentication:
          providers:
          - id: google_calendar_auth
            jwks_uri: https://www.googleapis.com/oauth2/v1/certs
            issuer: https://securetoken.google.com
          rules:
          - selector: "*"
            requirements:
              provider_id: google_calendar_auth
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    PRODUCER_PROJECT_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    APIS_FIELD_NUMBER: builtins.int
    TYPES_FIELD_NUMBER: builtins.int
    ENUMS_FIELD_NUMBER: builtins.int
    DOCUMENTATION_FIELD_NUMBER: builtins.int
    BACKEND_FIELD_NUMBER: builtins.int
    HTTP_FIELD_NUMBER: builtins.int
    QUOTA_FIELD_NUMBER: builtins.int
    AUTHENTICATION_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    LOGS_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    MONITORED_RESOURCES_FIELD_NUMBER: builtins.int
    BILLING_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    SYSTEM_PARAMETERS_FIELD_NUMBER: builtins.int
    SOURCE_INFO_FIELD_NUMBER: builtins.int
    CONFIG_VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The service name, which is a DNS-like logical identifier for the
    service, such as `calendar.googleapis.com`. The service name
    typically goes through DNS verification to make sure the owner
    of the service also owns the DNS name.
    """
    title: builtins.str
    """The product title for this service."""
    producer_project_id: builtins.str
    """The Google project that owns this service."""
    id: builtins.str
    """A unique ID for a specific instance of this message, typically assigned
    by the client for tracking purpose. Must be no longer than 63 characters
    and only lower case letters, digits, '.', '_' and '-' are allowed. If
    empty, the server may choose to generate one instead.
    """
    @property
    def apis(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.protobuf.api_pb2.Api
    ]:
        """A list of API interfaces exported by this service. Only the `name` field
        of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by the configuration
        author, as the remaining fields will be derived from the IDL during the
        normalization process. It is an error to specify an API interface here
        which cannot be resolved against the associated IDL files.
        """
    @property
    def types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.protobuf.type_pb2.Type
    ]:
        """A list of all proto message types included in this API service.
        Types referenced directly or indirectly by the `apis` are
        automatically included.  Messages which are not referenced but
        shall be included, such as types used by the `google.protobuf.Any` type,
        should be listed here by name. Example:

            types:
            - name: google.protobuf.Int32
        """
    @property
    def enums(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.protobuf.type_pb2.Enum
    ]:
        """A list of all enum types included in this API service.  Enums
        referenced directly or indirectly by the `apis` are automatically
        included.  Enums which are not referenced but shall be included
        should be listed here by name. Example:

            enums:
            - name: google.someapi.v1.SomeEnum
        """
    @property
    def documentation(self) -> google.api.documentation_pb2.Documentation:
        """Additional API documentation."""
    @property
    def backend(self) -> google.api.backend_pb2.Backend:
        """API backend configuration."""
    @property
    def http(self) -> google.api.http_pb2.Http:
        """HTTP configuration."""
    @property
    def quota(self) -> google.api.quota_pb2.Quota:
        """Quota configuration."""
    @property
    def authentication(self) -> google.api.auth_pb2.Authentication:
        """Auth configuration."""
    @property
    def context(self) -> google.api.context_pb2.Context:
        """Context configuration."""
    @property
    def usage(self) -> google.api.usage_pb2.Usage:
        """Configuration controlling usage of this service."""
    @property
    def endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.api.endpoint_pb2.Endpoint
    ]:
        """Configuration for network endpoints.  If this is empty, then an endpoint
        with the same name as the service is automatically generated to service all
        defined APIs.
        """
    @property
    def control(self) -> google.api.control_pb2.Control:
        """Configuration for the service control plane."""
    @property
    def logs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.api.log_pb2.LogDescriptor
    ]:
        """Defines the logs used by this service."""
    @property
    def metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.api.metric_pb2.MetricDescriptor
    ]:
        """Defines the metrics used by this service."""
    @property
    def monitored_resources(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.api.monitored_resource_pb2.MonitoredResourceDescriptor
    ]:
        """Defines the monitored resources used by this service. This is required
        by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
        """
    @property
    def billing(self) -> google.api.billing_pb2.Billing:
        """Billing configuration."""
    @property
    def logging(self) -> google.api.logging_pb2.Logging:
        """Logging configuration."""
    @property
    def monitoring(self) -> google.api.monitoring_pb2.Monitoring:
        """Monitoring configuration."""
    @property
    def system_parameters(self) -> google.api.system_parameter_pb2.SystemParameters:
        """System parameter configuration."""
    @property
    def source_info(self) -> google.api.source_info_pb2.SourceInfo:
        """Output only. The source information for this configuration if available."""
    @property
    def config_version(self) -> google.protobuf.wrappers_pb2.UInt32Value:
        """Obsolete. Do not use.

        This field has no semantic meaning. The service config compiler always
        sets this field to `3`.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        title: builtins.str = ...,
        producer_project_id: builtins.str = ...,
        id: builtins.str = ...,
        apis: collections.abc.Iterable[google.protobuf.api_pb2.Api] | None = ...,
        types: collections.abc.Iterable[google.protobuf.type_pb2.Type] | None = ...,
        enums: collections.abc.Iterable[google.protobuf.type_pb2.Enum] | None = ...,
        documentation: google.api.documentation_pb2.Documentation | None = ...,
        backend: google.api.backend_pb2.Backend | None = ...,
        http: google.api.http_pb2.Http | None = ...,
        quota: google.api.quota_pb2.Quota | None = ...,
        authentication: google.api.auth_pb2.Authentication | None = ...,
        context: google.api.context_pb2.Context | None = ...,
        usage: google.api.usage_pb2.Usage | None = ...,
        endpoints: collections.abc.Iterable[google.api.endpoint_pb2.Endpoint]
        | None = ...,
        control: google.api.control_pb2.Control | None = ...,
        logs: collections.abc.Iterable[google.api.log_pb2.LogDescriptor] | None = ...,
        metrics: collections.abc.Iterable[google.api.metric_pb2.MetricDescriptor]
        | None = ...,
        monitored_resources: collections.abc.Iterable[
            google.api.monitored_resource_pb2.MonitoredResourceDescriptor
        ]
        | None = ...,
        billing: google.api.billing_pb2.Billing | None = ...,
        logging: google.api.logging_pb2.Logging | None = ...,
        monitoring: google.api.monitoring_pb2.Monitoring | None = ...,
        system_parameters: google.api.system_parameter_pb2.SystemParameters
        | None = ...,
        source_info: google.api.source_info_pb2.SourceInfo | None = ...,
        config_version: google.protobuf.wrappers_pb2.UInt32Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "authentication",
            b"authentication",
            "backend",
            b"backend",
            "billing",
            b"billing",
            "config_version",
            b"config_version",
            "context",
            b"context",
            "control",
            b"control",
            "documentation",
            b"documentation",
            "http",
            b"http",
            "logging",
            b"logging",
            "monitoring",
            b"monitoring",
            "quota",
            b"quota",
            "source_info",
            b"source_info",
            "system_parameters",
            b"system_parameters",
            "usage",
            b"usage",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "apis",
            b"apis",
            "authentication",
            b"authentication",
            "backend",
            b"backend",
            "billing",
            b"billing",
            "config_version",
            b"config_version",
            "context",
            b"context",
            "control",
            b"control",
            "documentation",
            b"documentation",
            "endpoints",
            b"endpoints",
            "enums",
            b"enums",
            "http",
            b"http",
            "id",
            b"id",
            "logging",
            b"logging",
            "logs",
            b"logs",
            "metrics",
            b"metrics",
            "monitored_resources",
            b"monitored_resources",
            "monitoring",
            b"monitoring",
            "name",
            b"name",
            "producer_project_id",
            b"producer_project_id",
            "quota",
            b"quota",
            "source_info",
            b"source_info",
            "system_parameters",
            b"system_parameters",
            "title",
            b"title",
            "types",
            b"types",
            "usage",
            b"usage",
        ],
    ) -> None: ...

global___Service = Service
