"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.api.label_pb2
import google.api.launch_stage_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.struct_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class MonitoredResourceDescriptor(google.protobuf.message.Message):
    """An object that describes the schema of a [MonitoredResource][google.api.MonitoredResource] object using a
    type name and a set of labels.  For example, the monitored resource
    descriptor for Google Compute Engine VM instances has a type of
    `"gce_instance"` and specifies the use of the labels `"instance_id"` and
    `"zone"` to identify particular VM instances.

    Different APIs can support different monitored resource types. APIs generally
    provide a `list` method that returns the monitored resource descriptors used
    by the API.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    LAUNCH_STAGE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Optional. The resource name of the monitored resource descriptor:
    `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
    {type} is the value of the `type` field in this object and
    {project_id} is a project ID that provides API-specific context for
    accessing the type.  APIs that do not use project information can use the
    resource name format `"monitoredResourceDescriptors/{type}"`.
    """
    type: builtins.str
    """Required. The monitored resource type. For example, the type
    `"cloudsql_database"` represents databases in Google Cloud SQL.
    """
    display_name: builtins.str
    """Optional. A concise name for the monitored resource type that might be
    displayed in user interfaces. It should be a Title Cased Noun Phrase,
    without any article or other determiners. For example,
    `"Google Cloud SQL Database"`.
    """
    description: builtins.str
    """Optional. A detailed description of the monitored resource type that might
    be used in documentation.
    """
    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.api.label_pb2.LabelDescriptor
    ]:
        """Required. A set of labels used to describe instances of this monitored
        resource type. For example, an individual Google Cloud SQL database is
        identified by values for the labels `"database_id"` and `"zone"`.
        """
    launch_stage: google.api.launch_stage_pb2.LaunchStage.ValueType
    """Optional. The launch stage of the monitored resource definition."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: builtins.str = ...,
        display_name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Iterable[google.api.label_pb2.LabelDescriptor]
        | None = ...,
        launch_stage: google.api.launch_stage_pb2.LaunchStage.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description",
            b"description",
            "display_name",
            b"display_name",
            "labels",
            b"labels",
            "launch_stage",
            b"launch_stage",
            "name",
            b"name",
            "type",
            b"type",
        ],
    ) -> None: ...

global___MonitoredResourceDescriptor = MonitoredResourceDescriptor

@typing_extensions.final
class MonitoredResource(google.protobuf.message.Message):
    """An object representing a resource that can be used for monitoring, logging,
    billing, or other purposes. Examples include virtual machine instances,
    databases, and storage devices such as disks. The `type` field identifies a
    [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object that describes the resource's
    schema. Information in the `labels` field identifies the actual resource and
    its attributes according to the schema. For example, a particular Compute
    Engine VM instance could be represented by the following object, because the
    [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] for `"gce_instance"` has labels
    `"instance_id"` and `"zone"`:

        { "type": "gce_instance",
          "labels": { "instance_id": "12345678901234",
                      "zone": "us-central1-a" }}
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...
    TYPE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Required. The monitored resource type. This field must match
    the `type` field of a [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object. For
    example, the type of a Compute Engine VM instance is `gce_instance`.
    """
    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Required. Values for all of the labels listed in the associated monitored
        resource descriptor. For example, Compute Engine VM instances use the
        labels `"project_id"`, `"instance_id"`, and `"zone"`.
        """
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["labels", b"labels", "type", b"type"],
    ) -> None: ...

global___MonitoredResource = MonitoredResource

@typing_extensions.final
class MonitoredResourceMetadata(google.protobuf.message.Message):
    """Auxiliary metadata for a [MonitoredResource][google.api.MonitoredResource] object.
    [MonitoredResource][google.api.MonitoredResource] objects contain the minimum set of information to
    uniquely identify a monitored resource instance. There is some other useful
    auxiliary metadata. Monitoring and Logging use an ingestion
    pipeline to extract metadata for cloud resources of all types, and store
    the metadata in this message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    @typing_extensions.final
    class UserLabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...
    SYSTEM_LABELS_FIELD_NUMBER: builtins.int
    USER_LABELS_FIELD_NUMBER: builtins.int
    @property
    def system_labels(self) -> google.protobuf.struct_pb2.Struct:
        """Output only. Values for predefined system metadata labels.
        System labels are a kind of metadata extracted by Google, including
        "machine_image", "vpc", "subnet_id",
        "security_group", "name", etc.
        System label values can be only strings, Boolean values, or a list of
        strings. For example:

            { "name": "my-test-instance",
              "security_group": ["a", "b", "c"],
              "spot_instance": false }
        """
    @property
    def user_labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Output only. A map of user-defined metadata labels."""
    def __init__(
        self,
        *,
        system_labels: google.protobuf.struct_pb2.Struct | None = ...,
        user_labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["system_labels", b"system_labels"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "system_labels", b"system_labels", "user_labels", b"user_labels"
        ],
    ) -> None: ...

global___MonitoredResourceMetadata = MonitoredResourceMetadata
