"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Context(google.protobuf.message.Message):
    """`Context` defines which contexts an API requests.

    Example:

        context:
          rules:
          - selector: "*"
            requested:
            - google.rpc.context.ProjectContext
            - google.rpc.context.OriginContext

    The above specifies that all methods in the API request
    `google.rpc.context.ProjectContext` and
    `google.rpc.context.OriginContext`.

    Available context types are defined in package
    `google.rpc.context`.

    This also provides mechanism to allowlist any protobuf message extension that
    can be sent in grpc metadata using “x-goog-ext-<extension_id>-bin” and
    “x-goog-ext-<extension_id>-jspb” format. For example, list any service
    specific protobuf types that can appear in grpc metadata as follows in your
    yaml file:

    Example:

        context:
          rules:
           - selector: "google.example.library.v1.LibraryService.CreateBook"
             allowed_request_extensions:
             - google.foo.v1.NewExtension
             allowed_response_extensions:
             - google.foo.v1.NewExtension

    You can also specify extension ID instead of fully qualified extension name
    here.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContextRule
    ]:
        """A list of RPC context rules that apply to individual API methods.

        **NOTE:** All service configuration rules follow "last one wins" order.
        """
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___ContextRule] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["rules", b"rules"]
    ) -> None: ...

global___Context = Context

@typing_extensions.final
class ContextRule(google.protobuf.message.Message):
    """A context rule provides information about the context for an individual API
    element.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SELECTOR_FIELD_NUMBER: builtins.int
    REQUESTED_FIELD_NUMBER: builtins.int
    PROVIDED_FIELD_NUMBER: builtins.int
    ALLOWED_REQUEST_EXTENSIONS_FIELD_NUMBER: builtins.int
    ALLOWED_RESPONSE_EXTENSIONS_FIELD_NUMBER: builtins.int
    selector: builtins.str
    """Selects the methods to which this rule applies.

    Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    """
    @property
    def requested(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of full type names of requested contexts."""
    @property
    def provided(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of full type names of provided contexts."""
    @property
    def allowed_request_extensions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of full type names or extension IDs of extensions allowed in grpc
        side channel from client to backend.
        """
    @property
    def allowed_response_extensions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of full type names or extension IDs of extensions allowed in grpc
        side channel from backend to client.
        """
    def __init__(
        self,
        *,
        selector: builtins.str = ...,
        requested: collections.abc.Iterable[builtins.str] | None = ...,
        provided: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_request_extensions: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_response_extensions: collections.abc.Iterable[builtins.str]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allowed_request_extensions",
            b"allowed_request_extensions",
            "allowed_response_extensions",
            b"allowed_response_extensions",
            "provided",
            b"provided",
            "requested",
            b"requested",
            "selector",
            b"selector",
        ],
    ) -> None: ...

global___ContextRule = ContextRule
