"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2016 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ProjectProperties(google.protobuf.message.Message):
    """A descriptor for defining project properties for a service. One service may
    have many consumer projects, and the service may want to behave differently
    depending on some properties on the project. For example, a project may be
    associated with a school, or a business, or a government agency, a business
    type property on the project may affect how a service responds to the client.
    This descriptor defines which properties are allowed to be set on a project.

    Example:

       project_properties:
         properties:
         - name: NO_WATERMARK
           type: BOOL
           description: Allows usage of the API without watermarks.
         - name: EXTENDED_TILE_CACHE_PERIOD
           type: INT64
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def properties(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Property
    ]:
        """List of per consumer project-specific properties."""
    def __init__(
        self,
        *,
        properties: collections.abc.Iterable[global___Property] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["properties", b"properties"]
    ) -> None: ...

global___ProjectProperties = ProjectProperties

@typing_extensions.final
class Property(google.protobuf.message.Message):
    """Defines project properties.

    API services can define properties that can be assigned to consumer projects
    so that backends can perform response customization without having to make
    additional calls or maintain additional storage. For example, Maps API
    defines properties that controls map tile cache period, or whether to embed a
    watermark in a result.

    These values can be set via API producer console. Only API providers can
    define and set these properties.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PropertyType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PropertyTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            Property._PropertyType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: Property._PropertyType.ValueType  # 0
        """The type is unspecified, and will result in an error."""
        INT64: Property._PropertyType.ValueType  # 1
        """The type is `int64`."""
        BOOL: Property._PropertyType.ValueType  # 2
        """The type is `bool`."""
        STRING: Property._PropertyType.ValueType  # 3
        """The type is `string`."""
        DOUBLE: Property._PropertyType.ValueType  # 4
        """The type is 'double'."""

    class PropertyType(_PropertyType, metaclass=_PropertyTypeEnumTypeWrapper):
        """Supported data type of the property values"""

    UNSPECIFIED: Property.PropertyType.ValueType  # 0
    """The type is unspecified, and will result in an error."""
    INT64: Property.PropertyType.ValueType  # 1
    """The type is `int64`."""
    BOOL: Property.PropertyType.ValueType  # 2
    """The type is `bool`."""
    STRING: Property.PropertyType.ValueType  # 3
    """The type is `string`."""
    DOUBLE: Property.PropertyType.ValueType  # 4
    """The type is 'double'."""

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the property (a.k.a key)."""
    type: global___Property.PropertyType.ValueType
    """The type of this property."""
    description: builtins.str
    """The description of the property"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___Property.PropertyType.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description", b"description", "name", b"name", "type", b"type"
        ],
    ) -> None: ...

global___Property = Property
