"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ChangeType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ChangeTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ChangeType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CHANGE_TYPE_UNSPECIFIED: _ChangeType.ValueType  # 0
    """No value was provided."""
    ADDED: _ChangeType.ValueType  # 1
    """The changed object exists in the 'new' service configuration, but not
    in the 'old' service configuration.
    """
    REMOVED: _ChangeType.ValueType  # 2
    """The changed object exists in the 'old' service configuration, but not
    in the 'new' service configuration.
    """
    MODIFIED: _ChangeType.ValueType  # 3
    """The changed object exists in both service configurations, but its value
    is different.
    """

class ChangeType(_ChangeType, metaclass=_ChangeTypeEnumTypeWrapper):
    """Classifies set of possible modifications to an object in the service
    configuration.
    """

CHANGE_TYPE_UNSPECIFIED: ChangeType.ValueType  # 0
"""No value was provided."""
ADDED: ChangeType.ValueType  # 1
"""The changed object exists in the 'new' service configuration, but not
in the 'old' service configuration.
"""
REMOVED: ChangeType.ValueType  # 2
"""The changed object exists in the 'old' service configuration, but not
in the 'new' service configuration.
"""
MODIFIED: ChangeType.ValueType  # 3
"""The changed object exists in both service configurations, but its value
is different.
"""
global___ChangeType = ChangeType

@typing_extensions.final
class ConfigChange(google.protobuf.message.Message):
    """Output generated from semantically comparing two versions of a service
    configuration.

    Includes detailed information about a field that have changed with
    applicable advice about potential consequences for the change, such as
    backwards-incompatibility.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    OLD_VALUE_FIELD_NUMBER: builtins.int
    NEW_VALUE_FIELD_NUMBER: builtins.int
    CHANGE_TYPE_FIELD_NUMBER: builtins.int
    ADVICES_FIELD_NUMBER: builtins.int
    element: builtins.str
    """Object hierarchy path to the change, with levels separated by a '.'
    character. For repeated fields, an applicable unique identifier field is
    used for the index (usually selector, name, or id). For maps, the term
    'key' is used. If the field has no unique identifier, the numeric index
    is used.
    Examples:
    - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
    - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
    - logging.producer_destinations[0]
    """
    old_value: builtins.str
    """Value of the changed object in the old Service configuration,
    in JSON format. This field will not be populated if ChangeType == ADDED.
    """
    new_value: builtins.str
    """Value of the changed object in the new Service configuration,
    in JSON format. This field will not be populated if ChangeType == REMOVED.
    """
    change_type: global___ChangeType.ValueType
    """The type for this change, either ADDED, REMOVED, or MODIFIED."""
    @property
    def advices(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Advice
    ]:
        """Collection of advice provided for this change, useful for determining the
        possible impact of this change.
        """
    def __init__(
        self,
        *,
        element: builtins.str = ...,
        old_value: builtins.str = ...,
        new_value: builtins.str = ...,
        change_type: global___ChangeType.ValueType = ...,
        advices: collections.abc.Iterable[global___Advice] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "advices",
            b"advices",
            "change_type",
            b"change_type",
            "element",
            b"element",
            "new_value",
            b"new_value",
            "old_value",
            b"old_value",
        ],
    ) -> None: ...

global___ConfigChange = ConfigChange

@typing_extensions.final
class Advice(google.protobuf.message.Message):
    """Generated advice about this change, used for providing more
    information about how a change will affect the existing service.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Useful description for why this advice was applied and what actions should
    be taken to mitigate any implied risks.
    """
    def __init__(
        self,
        *,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["description", b"description"]
    ) -> None: ...

global___Advice = Advice
