"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Billing(google.protobuf.message.Message):
    """Billing related configuration of the service.

    The following example shows how to configure monitored resources and metrics
    for billing, `consumer_destinations` is the only supported destination and
    the monitored resources need at least one label key
    `cloud.googleapis.com/location` to indicate the location of the billing
    usage, using different monitored resources between monitoring and billing is
    recommended so they can be evolved independently:


        monitored_resources:
        - type: library.googleapis.com/billing_branch
          labels:
          - key: cloud.googleapis.com/location
            description: |
              Predefined label to support billing location restriction.
          - key: city
            description: |
              Custom label to define the city where the library branch is located
              in.
          - key: name
            description: Custom label to define the name of the library branch.
        metrics:
        - name: library.googleapis.com/book/borrowed_count
          metric_kind: DELTA
          value_type: INT64
          unit: "1"
        billing:
          consumer_destinations:
          - monitored_resource: library.googleapis.com/billing_branch
            metrics:
            - library.googleapis.com/book/borrowed_count
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    @typing_extensions.final
    class BillingDestination(google.protobuf.message.Message):
        """Configuration of a specific billing destination (Currently only support
        bill against consumer project).
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MONITORED_RESOURCE_FIELD_NUMBER: builtins.int
        METRICS_FIELD_NUMBER: builtins.int
        monitored_resource: builtins.str
        """The monitored resource type. The type must be defined in
        [Service.monitored_resources][google.api.Service.monitored_resources] section.
        """
        @property
        def metrics(
            self,
        ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
            builtins.str
        ]:
            """Names of the metrics to report to this billing destination.
            Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
            """
        def __init__(
            self,
            *,
            monitored_resource: builtins.str = ...,
            metrics: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "metrics", b"metrics", "monitored_resource", b"monitored_resource"
            ],
        ) -> None: ...
    CONSUMER_DESTINATIONS_FIELD_NUMBER: builtins.int
    @property
    def consumer_destinations(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Billing.BillingDestination
    ]:
        """Billing configurations for sending metrics to the consumer project.
        There can be multiple consumer destinations per service, each one must have
        a different monitored resource type. A metric can be used in at most
        one consumer destination.
        """
    def __init__(
        self,
        *,
        consumer_destinations: collections.abc.Iterable[
            global___Billing.BillingDestination
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "consumer_destinations", b"consumer_destinations"
        ],
    ) -> None: ...

global___Billing = Billing
