use mobc::async_trait;
use mobc::Manager;
pub use redis;
pub use redis::aio::Connection;
use redis::Client;

/// The Mobc Redis ConnectionManager courtesy of
/// https://github.com/importcjj/mobc-redis
/// implemented here so as to use the same redis version as this project
pub struct RedisConnectionManager {
    client: Client,
}

impl RedisConnectionManager {
    pub fn new(c: Client) -> Self {
        Self { client: c }
    }
}

#[async_trait]
impl Manager for RedisConnectionManager {
    type Connection = Connection;
    type Error = redis::RedisError;

    async fn connect(&self) -> Result<Self::Connection, Self::Error> {
        let c = self.client.get_async_connection().await?;
        Ok(c)
    }

    async fn check(&self, mut conn: Self::Connection) -> Result<Self::Connection, Self::Error> {
        redis::cmd("PING").query_async(&mut conn).await?;
        Ok(conn)
    }
}
