# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class InstancesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_app_restart_instance(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Triggers app restart of this instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_app_restart_instance(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_app_restart_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_app_restart_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_app_restart_instance_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Triggers app restart of this instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_app_restart_instance_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_app_restart_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_app_restart_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_app_restart_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_app_restart_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}/app_restart', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_delete_instance(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Remove an instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_instance(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_delete_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_delete_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_delete_instance_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Remove an instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_instance_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_delete_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_delete_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_delete_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_delete_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_instance(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Get a single instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_instance(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: Instance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_instance_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Get a single instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_instance_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: Instance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_get_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Instance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_instances(self, username, password, **kwargs):  # noqa: E501
        """Get all instances of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_instances(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int limit:
        :return: list[Instance]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_instances_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_instances_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_instances_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all instances of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_instances_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int limit:
        :return: list[Instance]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_instances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_instances`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_instances`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Instance]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_instance_api_gateway(self, body, username, password, instance_id, **kwargs):  # noqa: E501
        """Forwards a custom HTTP API request  # noqa: E501

        Forwards a custom HTTP API request to the FMC/Middleware (management interface) and returns the answer. Before forwarding the request, a filter will be applied to block unauthorized access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_api_gateway(body, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstanceIdApiGatewayBody body: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_instance_api_gateway_with_http_info(body, username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_instance_api_gateway_with_http_info(body, username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_instance_api_gateway_with_http_info(self, body, username, password, instance_id, **kwargs):  # noqa: E501
        """Forwards a custom HTTP API request  # noqa: E501

        Forwards a custom HTTP API request to the FMC/Middleware (management interface) and returns the answer. Before forwarding the request, a filter will be applied to block unauthorized access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_api_gateway_with_http_info(body, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstanceIdApiGatewayBody body: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_instance_api_gateway" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cf_manager_rest_api_instance_api_gateway`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_instance_api_gateway`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_instance_api_gateway`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_instance_api_gateway`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}/api_gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_instance_change_runlevel(self, new_runlevel, username, password, instance_id, **kwargs):  # noqa: E501
        """Changes the `runlevel` of the instance (stack developers only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_change_runlevel(new_runlevel, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int new_runlevel: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_instance_change_runlevel_with_http_info(new_runlevel, username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_instance_change_runlevel_with_http_info(new_runlevel, username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_instance_change_runlevel_with_http_info(self, new_runlevel, username, password, instance_id, **kwargs):  # noqa: E501
        """Changes the `runlevel` of the instance (stack developers only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_change_runlevel_with_http_info(new_runlevel, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int new_runlevel: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_runlevel', 'username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_instance_change_runlevel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_runlevel' is set
        if ('new_runlevel' not in params or
                params['new_runlevel'] is None):
            raise ValueError("Missing the required parameter `new_runlevel` when calling `cf_manager_rest_api_instance_change_runlevel`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_instance_change_runlevel`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_instance_change_runlevel`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_instance_change_runlevel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'new_runlevel' in params:
            form_params.append(('new_runlevel', params['new_runlevel']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}/runlevel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_instance_get_runlevel(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Returns the current `runlevel` of the instance (stack developers only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_get_runlevel(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_instance_get_runlevel_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_instance_get_runlevel_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_instance_get_runlevel_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Returns the current `runlevel` of the instance (stack developers only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_instance_get_runlevel_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_instance_get_runlevel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_instance_get_runlevel`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_instance_get_runlevel`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_instance_get_runlevel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}/runlevel', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_instances(self, image_id, username, password, **kwargs):  # noqa: E501
        """Create an instance  # noqa: E501

        This configures an FPGA of type `fpga_board` (from the image metadata) with the given image and sets up the network accordingly.  Please contact the administrators, if this request failed several times with `500` or `507`.  If a user belongs to multiple projects, the Quota of the first project (in alphabetical order) is used. If another Quota should be used, the parameter `project_name` must be set accordingly.  If the given image is a partial bitstream, the partial reconfiguration flow is applied automatically (`breed` is `\"ROLE\"`). In that case, this request tries to find a resource with the corresponding `shell_type` as defined by the image. If no board with the requested `shell_type` is available, one board gets configured with the newest `shell_type` SHELL image.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_instances(image_id, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of the OpenStack project the quota should be acounted to, if a user has multiple projects.
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_instances_with_http_info(image_id, username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_instances_with_http_info(image_id, username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_instances_with_http_info(self, image_id, username, password, **kwargs):  # noqa: E501
        """Create an instance  # noqa: E501

        This configures an FPGA of type `fpga_board` (from the image metadata) with the given image and sets up the network accordingly.  Please contact the administrators, if this request failed several times with `500` or `507`.  If a user belongs to multiple projects, the Quota of the first project (in alphabetical order) is used. If another Quota should be used, the parameter `project_name` must be set accordingly.  If the given image is a partial bitstream, the partial reconfiguration flow is applied automatically (`breed` is `\"ROLE\"`). In that case, this request tries to find a resource with the corresponding `shell_type` as defined by the image. If no board with the requested `shell_type` is available, one board gets configured with the newest `shell_type` SHELL image.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_instances_with_http_info(image_id, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of the OpenStack project the quota should be acounted to, if a user has multiple projects.
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_id', 'username', 'password', 'project_name', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_instances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params or
                params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `cf_manager_rest_api_post_instances`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_instances`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_instances`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'project_name' in params:
            query_params.append(('project_name', params['project_name']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_id' in params:
            form_params.append(('image_id', params['image_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2001',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_update_instance(self, image_id, username, password, instance_id, **kwargs):  # noqa: E501
        """Reprogramm an instance  # noqa: E501

        Reprogram an instance with the submitted image and configure all current settings again afterwards. Hence, this call reuses the same FPGA again (in opposition to DELETE and POST again). This is **intended only for single instances**, not to update one instance out of a cluster.  **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_update_instance(image_id, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_update_instance_with_http_info(image_id, username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_update_instance_with_http_info(image_id, username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_update_instance_with_http_info(self, image_id, username, password, instance_id, **kwargs):  # noqa: E501
        """Reprogramm an instance  # noqa: E501

        Reprogram an instance with the submitted image and configure all current settings again afterwards. Hence, this call reuses the same FPGA again (in opposition to DELETE and POST again). This is **intended only for single instances**, not to update one instance out of a cluster.  **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_update_instance_with_http_info(image_id, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_id', 'username', 'password', 'instance_id', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_update_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params or
                params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `cf_manager_rest_api_update_instance`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_update_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_update_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_update_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_id' in params:
            form_params.append(('image_id', params['image_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2001',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
