# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.administrator import Administrator  # noqa: F401,E501


class Tenant(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'database_server_id': 'int',
        'name': 'str',
        'description': 'str',
        'agent_initiated_activation_password': 'str',
        'time_zone': 'str',
        'locale': 'str',
        'demo_mode': 'bool',
        'modules_visible': 'list[str]',
        'hide_unlicensed_modules': 'bool',
        'last_signin_time': 'int',
        'tenant_state': 'str',
        'activation_codes': 'list[str]',
        'administrator': 'Administrator',
        'primary_contacts': 'list[Administrator]',
        'guid': 'str',
        'id': 'int'
    }

    attribute_map = {
        'database_server_id': 'databaseServerID',
        'name': 'name',
        'description': 'description',
        'agent_initiated_activation_password': 'agentInitiatedActivationPassword',
        'time_zone': 'timeZone',
        'locale': 'locale',
        'demo_mode': 'demoMode',
        'modules_visible': 'modulesVisible',
        'hide_unlicensed_modules': 'hideUnlicensedModules',
        'last_signin_time': 'lastSigninTime',
        'tenant_state': 'tenantState',
        'activation_codes': 'activationCodes',
        'administrator': 'administrator',
        'primary_contacts': 'primaryContacts',
        'guid': 'guid',
        'id': 'ID'
    }

    def __init__(self, database_server_id=None, name=None, description=None, agent_initiated_activation_password=None, time_zone=None, locale=None, demo_mode=None, modules_visible=None, hide_unlicensed_modules=None, last_signin_time=None, tenant_state=None, activation_codes=None, administrator=None, primary_contacts=None, guid=None, id=None):  # noqa: E501
        """Tenant - a model defined in Swagger"""  # noqa: E501

        self._database_server_id = None
        self._name = None
        self._description = None
        self._agent_initiated_activation_password = None
        self._time_zone = None
        self._locale = None
        self._demo_mode = None
        self._modules_visible = None
        self._hide_unlicensed_modules = None
        self._last_signin_time = None
        self._tenant_state = None
        self._activation_codes = None
        self._administrator = None
        self._primary_contacts = None
        self._guid = None
        self._id = None
        self.discriminator = None

        if database_server_id is not None:
            self.database_server_id = database_server_id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if agent_initiated_activation_password is not None:
            self.agent_initiated_activation_password = agent_initiated_activation_password
        if time_zone is not None:
            self.time_zone = time_zone
        if locale is not None:
            self.locale = locale
        if demo_mode is not None:
            self.demo_mode = demo_mode
        if modules_visible is not None:
            self.modules_visible = modules_visible
        if hide_unlicensed_modules is not None:
            self.hide_unlicensed_modules = hide_unlicensed_modules
        if last_signin_time is not None:
            self.last_signin_time = last_signin_time
        if tenant_state is not None:
            self.tenant_state = tenant_state
        if activation_codes is not None:
            self.activation_codes = activation_codes
        if administrator is not None:
            self.administrator = administrator
        if primary_contacts is not None:
            self.primary_contacts = primary_contacts
        if guid is not None:
            self.guid = guid
        if id is not None:
            self.id = id

    @property
    def database_server_id(self):
        """Gets the database_server_id of this Tenant.  # noqa: E501

        ID of the tenant database server. Searchable as Numeric.  # noqa: E501

        :return: The database_server_id of this Tenant.  # noqa: E501
        :rtype: int
        """
        return self._database_server_id

    @database_server_id.setter
    def database_server_id(self, database_server_id):
        """Sets the database_server_id of this Tenant.

        ID of the tenant database server. Searchable as Numeric.  # noqa: E501

        :param database_server_id: The database_server_id of this Tenant.  # noqa: E501
        :type: int
        """

        self._database_server_id = database_server_id

    @property
    def name(self):
        """Gets the name of this Tenant.  # noqa: E501

        Display name of the tenant. Searchable as String.  # noqa: E501

        :return: The name of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Tenant.

        Display name of the tenant. Searchable as String.  # noqa: E501

        :param name: The name of this Tenant.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this Tenant.  # noqa: E501

        Description of the tenant. Searchable as String.  # noqa: E501

        :return: The description of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Tenant.

        Description of the tenant. Searchable as String.  # noqa: E501

        :param description: The description of this Tenant.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def agent_initiated_activation_password(self):
        """Gets the agent_initiated_activation_password of this Tenant.  # noqa: E501

        Activation token required to invoke agent-initiated activation for non-primary tenant users.  # noqa: E501

        :return: The agent_initiated_activation_password of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._agent_initiated_activation_password

    @agent_initiated_activation_password.setter
    def agent_initiated_activation_password(self, agent_initiated_activation_password):
        """Sets the agent_initiated_activation_password of this Tenant.

        Activation token required to invoke agent-initiated activation for non-primary tenant users.  # noqa: E501

        :param agent_initiated_activation_password: The agent_initiated_activation_password of this Tenant.  # noqa: E501
        :type: str
        """

        self._agent_initiated_activation_password = agent_initiated_activation_password

    @property
    def time_zone(self):
        """Gets the time_zone of this Tenant.  # noqa: E501

        Time zone ID of the tenant (for example: \"America/New_York\"). Searchable as String.  # noqa: E501

        :return: The time_zone of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this Tenant.

        Time zone ID of the tenant (for example: \"America/New_York\"). Searchable as String.  # noqa: E501

        :param time_zone: The time_zone of this Tenant.  # noqa: E501
        :type: str
        """

        self._time_zone = time_zone

    @property
    def locale(self):
        """Gets the locale of this Tenant.  # noqa: E501

        Locale of the tenant. Determines the language of the Deep Security Manager user interface.  # noqa: E501

        :return: The locale of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this Tenant.

        Locale of the tenant. Determines the language of the Deep Security Manager user interface.  # noqa: E501

        :param locale: The locale of this Tenant.  # noqa: E501
        :type: str
        """
        allowed_values = ["en-US", "ja-JP"]  # noqa: E501
        if locale not in allowed_values:
            raise ValueError(
                "Invalid value for `locale` ({0}), must be one of {1}"  # noqa: E501
                .format(locale, allowed_values)
            )

        self._locale = locale

    @property
    def demo_mode(self):
        """Gets the demo_mode of this Tenant.  # noqa: E501

        Populates the Deep Security Manager database with simulated computers, events, alerts and other data. Useful for testing environments. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :return: The demo_mode of this Tenant.  # noqa: E501
        :rtype: bool
        """
        return self._demo_mode

    @demo_mode.setter
    def demo_mode(self, demo_mode):
        """Sets the demo_mode of this Tenant.

        Populates the Deep Security Manager database with simulated computers, events, alerts and other data. Useful for testing environments. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :param demo_mode: The demo_mode of this Tenant.  # noqa: E501
        :type: bool
        """

        self._demo_mode = demo_mode

    @property
    def modules_visible(self):
        """Gets the modules_visible of this Tenant.  # noqa: E501

        Protection modules shown within the Deep Security Manager. All modules are visible by default.  # noqa: E501

        :return: The modules_visible of this Tenant.  # noqa: E501
        :rtype: list[str]
        """
        return self._modules_visible

    @modules_visible.setter
    def modules_visible(self, modules_visible):
        """Sets the modules_visible of this Tenant.

        Protection modules shown within the Deep Security Manager. All modules are visible by default.  # noqa: E501

        :param modules_visible: The modules_visible of this Tenant.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["all", "anti-malware", "web-reputation", "firewall", "intrusion-prevention", "integrity-monitoring", "log-inspection", "application-control", "SAP", "activity-monitoring", "container-control"]  # noqa: E501
        if not set(modules_visible).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `modules_visible` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(modules_visible) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._modules_visible = modules_visible

    @property
    def hide_unlicensed_modules(self):
        """Gets the hide_unlicensed_modules of this Tenant.  # noqa: E501

        Controls whether unlicensed protection modules appear in the Deep Security Manager for tenants. Set to true to hide all unlicensed protection modules. Searchable as Boolean.  # noqa: E501

        :return: The hide_unlicensed_modules of this Tenant.  # noqa: E501
        :rtype: bool
        """
        return self._hide_unlicensed_modules

    @hide_unlicensed_modules.setter
    def hide_unlicensed_modules(self, hide_unlicensed_modules):
        """Sets the hide_unlicensed_modules of this Tenant.

        Controls whether unlicensed protection modules appear in the Deep Security Manager for tenants. Set to true to hide all unlicensed protection modules. Searchable as Boolean.  # noqa: E501

        :param hide_unlicensed_modules: The hide_unlicensed_modules of this Tenant.  # noqa: E501
        :type: bool
        """

        self._hide_unlicensed_modules = hide_unlicensed_modules

    @property
    def last_signin_time(self):
        """Gets the last_signin_time of this Tenant.  # noqa: E501

        Timestamp indicates the last time any tenant user signed in, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The last_signin_time of this Tenant.  # noqa: E501
        :rtype: int
        """
        return self._last_signin_time

    @last_signin_time.setter
    def last_signin_time(self, last_signin_time):
        """Sets the last_signin_time of this Tenant.

        Timestamp indicates the last time any tenant user signed in, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param last_signin_time: The last_signin_time of this Tenant.  # noqa: E501
        :type: int
        """

        self._last_signin_time = last_signin_time

    @property
    def tenant_state(self):
        """Gets the tenant_state of this Tenant.  # noqa: E501

        State of the tenant. Searchable as Choice.  # noqa: E501

        :return: The tenant_state of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._tenant_state

    @tenant_state.setter
    def tenant_state(self, tenant_state):
        """Sets the tenant_state of this Tenant.

        State of the tenant. Searchable as Choice.  # noqa: E501

        :param tenant_state: The tenant_state of this Tenant.  # noqa: E501
        :type: str
        """
        allowed_values = ["undefined", "created", "active", "suspended", "suspended-db-locked", "pending-deletion", "db-upgrade-failure", "confirmation-required", "cache-requires-initialization", "cache-initializing", "cache-ready-for-use", "cache-activating"]  # noqa: E501
        if tenant_state not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_state` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_state, allowed_values)
            )

        self._tenant_state = tenant_state

    @property
    def activation_codes(self):
        """Gets the activation_codes of this Tenant.  # noqa: E501

        List of comma-delimited activation codes for the protection modules. Applicable only during the creation of a tenant in a 'Per-Tenant' licensing environment.  # noqa: E501

        :return: The activation_codes of this Tenant.  # noqa: E501
        :rtype: list[str]
        """
        return self._activation_codes

    @activation_codes.setter
    def activation_codes(self, activation_codes):
        """Sets the activation_codes of this Tenant.

        List of comma-delimited activation codes for the protection modules. Applicable only during the creation of a tenant in a 'Per-Tenant' licensing environment.  # noqa: E501

        :param activation_codes: The activation_codes of this Tenant.  # noqa: E501
        :type: list[str]
        """

        self._activation_codes = activation_codes

    @property
    def administrator(self):
        """Gets the administrator of this Tenant.  # noqa: E501

        First administrator created for the tenant. Only the username, password and emailAddress fields will be used during creation.  # noqa: E501

        :return: The administrator of this Tenant.  # noqa: E501
        :rtype: Administrator
        """
        return self._administrator

    @administrator.setter
    def administrator(self, administrator):
        """Sets the administrator of this Tenant.

        First administrator created for the tenant. Only the username, password and emailAddress fields will be used during creation.  # noqa: E501

        :param administrator: The administrator of this Tenant.  # noqa: E501
        :type: Administrator
        """

        self._administrator = administrator

    @property
    def primary_contacts(self):
        """Gets the primary_contacts of this Tenant.  # noqa: E501

        Primary contacts of the tenant. Only the ID, roleID, username, and emailAddress fields are returned in responses.  # noqa: E501

        :return: The primary_contacts of this Tenant.  # noqa: E501
        :rtype: list[Administrator]
        """
        return self._primary_contacts

    @primary_contacts.setter
    def primary_contacts(self, primary_contacts):
        """Sets the primary_contacts of this Tenant.

        Primary contacts of the tenant. Only the ID, roleID, username, and emailAddress fields are returned in responses.  # noqa: E501

        :param primary_contacts: The primary_contacts of this Tenant.  # noqa: E501
        :type: list[Administrator]
        """

        self._primary_contacts = primary_contacts

    @property
    def guid(self):
        """Gets the guid of this Tenant.  # noqa: E501

        GUID of the tenant. Used for global identification of the tenant. Searchable as String.  # noqa: E501

        :return: The guid of this Tenant.  # noqa: E501
        :rtype: str
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """Sets the guid of this Tenant.

        GUID of the tenant. Used for global identification of the tenant. Searchable as String.  # noqa: E501

        :param guid: The guid of this Tenant.  # noqa: E501
        :type: str
        """

        self._guid = guid

    @property
    def id(self):
        """Gets the id of this Tenant.  # noqa: E501

        ID of the tenant. Searchable as ID.  # noqa: E501

        :return: The id of this Tenant.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Tenant.

        ID of the tenant. Searchable as ID.  # noqa: E501

        :param id: The id of this Tenant.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Tenant, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Tenant):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

