# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SoftwareChange(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'computer_id': 'int',
        'computer_group_id': 'int',
        'vendor_name': 'str',
        'product_name': 'str',
        'product_version': 'str',
        'file_version': 'str',
        'file_description': 'str',
        'sha1': 'str',
        'sha256': 'str',
        'md5': 'str',
        'file_name': 'str',
        'install_path': 'str',
        'file_size': 'int',
        'change_event_time': 'int',
        'change_by_user': 'str',
        'change_by_user_id': 'str',
        'change_by_process': 'str',
        'change_by_process_id': 'str',
        'id': 'int'
    }

    attribute_map = {
        'computer_id': 'computerID',
        'computer_group_id': 'computerGroupID',
        'vendor_name': 'vendorName',
        'product_name': 'productName',
        'product_version': 'productVersion',
        'file_version': 'fileVersion',
        'file_description': 'fileDescription',
        'sha1': 'sha1',
        'sha256': 'sha256',
        'md5': 'md5',
        'file_name': 'fileName',
        'install_path': 'installPath',
        'file_size': 'fileSize',
        'change_event_time': 'changeEventTime',
        'change_by_user': 'changeByUser',
        'change_by_user_id': 'changeByUserID',
        'change_by_process': 'changeByProcess',
        'change_by_process_id': 'changeByProcessID',
        'id': 'ID'
    }

    def __init__(self, computer_id=None, computer_group_id=None, vendor_name=None, product_name=None, product_version=None, file_version=None, file_description=None, sha1=None, sha256=None, md5=None, file_name=None, install_path=None, file_size=None, change_event_time=None, change_by_user=None, change_by_user_id=None, change_by_process=None, change_by_process_id=None, id=None):  # noqa: E501
        """SoftwareChange - a model defined in Swagger"""  # noqa: E501

        self._computer_id = None
        self._computer_group_id = None
        self._vendor_name = None
        self._product_name = None
        self._product_version = None
        self._file_version = None
        self._file_description = None
        self._sha1 = None
        self._sha256 = None
        self._md5 = None
        self._file_name = None
        self._install_path = None
        self._file_size = None
        self._change_event_time = None
        self._change_by_user = None
        self._change_by_user_id = None
        self._change_by_process = None
        self._change_by_process_id = None
        self._id = None
        self.discriminator = None

        if computer_id is not None:
            self.computer_id = computer_id
        if computer_group_id is not None:
            self.computer_group_id = computer_group_id
        if vendor_name is not None:
            self.vendor_name = vendor_name
        if product_name is not None:
            self.product_name = product_name
        if product_version is not None:
            self.product_version = product_version
        if file_version is not None:
            self.file_version = file_version
        if file_description is not None:
            self.file_description = file_description
        if sha1 is not None:
            self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if md5 is not None:
            self.md5 = md5
        if file_name is not None:
            self.file_name = file_name
        if install_path is not None:
            self.install_path = install_path
        if file_size is not None:
            self.file_size = file_size
        if change_event_time is not None:
            self.change_event_time = change_event_time
        if change_by_user is not None:
            self.change_by_user = change_by_user
        if change_by_user_id is not None:
            self.change_by_user_id = change_by_user_id
        if change_by_process is not None:
            self.change_by_process = change_by_process
        if change_by_process_id is not None:
            self.change_by_process_id = change_by_process_id
        if id is not None:
            self.id = id

    @property
    def computer_id(self):
        """Gets the computer_id of this SoftwareChange.  # noqa: E501

        ID of the computer on which the software change was found. Searchable as Numeric.  # noqa: E501

        :return: The computer_id of this SoftwareChange.  # noqa: E501
        :rtype: int
        """
        return self._computer_id

    @computer_id.setter
    def computer_id(self, computer_id):
        """Sets the computer_id of this SoftwareChange.

        ID of the computer on which the software change was found. Searchable as Numeric.  # noqa: E501

        :param computer_id: The computer_id of this SoftwareChange.  # noqa: E501
        :type: int
        """

        self._computer_id = computer_id

    @property
    def computer_group_id(self):
        """Gets the computer_group_id of this SoftwareChange.  # noqa: E501

        ID of the computer group where the software change was found. Searchable as Numeric.  # noqa: E501

        :return: The computer_group_id of this SoftwareChange.  # noqa: E501
        :rtype: int
        """
        return self._computer_group_id

    @computer_group_id.setter
    def computer_group_id(self, computer_group_id):
        """Sets the computer_group_id of this SoftwareChange.

        ID of the computer group where the software change was found. Searchable as Numeric.  # noqa: E501

        :param computer_group_id: The computer_group_id of this SoftwareChange.  # noqa: E501
        :type: int
        """

        self._computer_group_id = computer_group_id

    @property
    def vendor_name(self):
        """Gets the vendor_name of this SoftwareChange.  # noqa: E501

        Vendor name associated with the changed software. Searchable as String.  # noqa: E501

        :return: The vendor_name of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._vendor_name

    @vendor_name.setter
    def vendor_name(self, vendor_name):
        """Sets the vendor_name of this SoftwareChange.

        Vendor name associated with the changed software. Searchable as String.  # noqa: E501

        :param vendor_name: The vendor_name of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._vendor_name = vendor_name

    @property
    def product_name(self):
        """Gets the product_name of this SoftwareChange.  # noqa: E501

        Product name associated with the changed software. Searchable as String.  # noqa: E501

        :return: The product_name of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this SoftwareChange.

        Product name associated with the changed software. Searchable as String.  # noqa: E501

        :param product_name: The product_name of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._product_name = product_name

    @property
    def product_version(self):
        """Gets the product_version of this SoftwareChange.  # noqa: E501

        Product version associated with the changed software. Searchable as String.  # noqa: E501

        :return: The product_version of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._product_version

    @product_version.setter
    def product_version(self, product_version):
        """Sets the product_version of this SoftwareChange.

        Product version associated with the changed software. Searchable as String.  # noqa: E501

        :param product_version: The product_version of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._product_version = product_version

    @property
    def file_version(self):
        """Gets the file_version of this SoftwareChange.  # noqa: E501

        File version associated with the changed software. Searchable as String.  # noqa: E501

        :return: The file_version of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._file_version

    @file_version.setter
    def file_version(self, file_version):
        """Sets the file_version of this SoftwareChange.

        File version associated with the changed software. Searchable as String.  # noqa: E501

        :param file_version: The file_version of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._file_version = file_version

    @property
    def file_description(self):
        """Gets the file_description of this SoftwareChange.  # noqa: E501

        File description associated with the changed software. Searchable as String.  # noqa: E501

        :return: The file_description of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._file_description

    @file_description.setter
    def file_description(self, file_description):
        """Sets the file_description of this SoftwareChange.

        File description associated with the changed software. Searchable as String.  # noqa: E501

        :param file_description: The file_description of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._file_description = file_description

    @property
    def sha1(self):
        """Gets the sha1 of this SoftwareChange.  # noqa: E501

        SHA1 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :return: The sha1 of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this SoftwareChange.

        SHA1 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :param sha1: The sha1 of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this SoftwareChange.  # noqa: E501

        SHA256 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :return: The sha256 of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this SoftwareChange.

        SHA256 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :param sha256: The sha256 of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._sha256 = sha256

    @property
    def md5(self):
        """Gets the md5 of this SoftwareChange.  # noqa: E501

        MD5 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :return: The md5 of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this SoftwareChange.

        MD5 hash calculated from the changed software. Searchable as String.  # noqa: E501

        :param md5: The md5 of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._md5 = md5

    @property
    def file_name(self):
        """Gets the file_name of this SoftwareChange.  # noqa: E501

        File name of the changed software. Searchable as String.  # noqa: E501

        :return: The file_name of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this SoftwareChange.

        File name of the changed software. Searchable as String.  # noqa: E501

        :param file_name: The file_name of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._file_name = file_name

    @property
    def install_path(self):
        """Gets the install_path of this SoftwareChange.  # noqa: E501

        Path on which the software change was found. Searchable as String.  # noqa: E501

        :return: The install_path of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._install_path

    @install_path.setter
    def install_path(self, install_path):
        """Sets the install_path of this SoftwareChange.

        Path on which the software change was found. Searchable as String.  # noqa: E501

        :param install_path: The install_path of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._install_path = install_path

    @property
    def file_size(self):
        """Gets the file_size of this SoftwareChange.  # noqa: E501

        File size of the changed software in bytes. Searchable as Numeric.  # noqa: E501

        :return: The file_size of this SoftwareChange.  # noqa: E501
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this SoftwareChange.

        File size of the changed software in bytes. Searchable as Numeric.  # noqa: E501

        :param file_size: The file_size of this SoftwareChange.  # noqa: E501
        :type: int
        """

        self._file_size = file_size

    @property
    def change_event_time(self):
        """Gets the change_event_time of this SoftwareChange.  # noqa: E501

        Time the software change was discovered, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The change_event_time of this SoftwareChange.  # noqa: E501
        :rtype: int
        """
        return self._change_event_time

    @change_event_time.setter
    def change_event_time(self, change_event_time):
        """Sets the change_event_time of this SoftwareChange.

        Time the software change was discovered, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param change_event_time: The change_event_time of this SoftwareChange.  # noqa: E501
        :type: int
        """

        self._change_event_time = change_event_time

    @property
    def change_by_user(self):
        """Gets the change_by_user of this SoftwareChange.  # noqa: E501

        Username of the user that introduced the software change. Searchable as String.  # noqa: E501

        :return: The change_by_user of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._change_by_user

    @change_by_user.setter
    def change_by_user(self, change_by_user):
        """Sets the change_by_user of this SoftwareChange.

        Username of the user that introduced the software change. Searchable as String.  # noqa: E501

        :param change_by_user: The change_by_user of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._change_by_user = change_by_user

    @property
    def change_by_user_id(self):
        """Gets the change_by_user_id of this SoftwareChange.  # noqa: E501

        User ID of the user that introduced the software change. Searchable as String.  # noqa: E501

        :return: The change_by_user_id of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._change_by_user_id

    @change_by_user_id.setter
    def change_by_user_id(self, change_by_user_id):
        """Sets the change_by_user_id of this SoftwareChange.

        User ID of the user that introduced the software change. Searchable as String.  # noqa: E501

        :param change_by_user_id: The change_by_user_id of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._change_by_user_id = change_by_user_id

    @property
    def change_by_process(self):
        """Gets the change_by_process of this SoftwareChange.  # noqa: E501

        Name of the process that introduced the software change. Searchable as String.  # noqa: E501

        :return: The change_by_process of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._change_by_process

    @change_by_process.setter
    def change_by_process(self, change_by_process):
        """Sets the change_by_process of this SoftwareChange.

        Name of the process that introduced the software change. Searchable as String.  # noqa: E501

        :param change_by_process: The change_by_process of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._change_by_process = change_by_process

    @property
    def change_by_process_id(self):
        """Gets the change_by_process_id of this SoftwareChange.  # noqa: E501

        Process ID of the process that introduced the software change. Searchable as String.  # noqa: E501

        :return: The change_by_process_id of this SoftwareChange.  # noqa: E501
        :rtype: str
        """
        return self._change_by_process_id

    @change_by_process_id.setter
    def change_by_process_id(self, change_by_process_id):
        """Sets the change_by_process_id of this SoftwareChange.

        Process ID of the process that introduced the software change. Searchable as String.  # noqa: E501

        :param change_by_process_id: The change_by_process_id of this SoftwareChange.  # noqa: E501
        :type: str
        """

        self._change_by_process_id = change_by_process_id

    @property
    def id(self):
        """Gets the id of this SoftwareChange.  # noqa: E501

        ID of software change. Searchable as Numeric.  # noqa: E501

        :return: The id of this SoftwareChange.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SoftwareChange.

        ID of software change. Searchable as Numeric.  # noqa: E501

        :param id: The id of this SoftwareChange.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SoftwareChange, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SoftwareChange):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

