# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Ruleset(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'version': 'int',
        'type': 'str',
        'created': 'int',
        'last_updated': 'int',
        'id': 'int'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'version': 'version',
        'type': 'type',
        'created': 'created',
        'last_updated': 'lastUpdated',
        'id': 'ID'
    }

    def __init__(self, name=None, description=None, version=None, type=None, created=None, last_updated=None, id=None):  # noqa: E501
        """Ruleset - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._description = None
        self._version = None
        self._type = None
        self._created = None
        self._last_updated = None
        self._id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if version is not None:
            self.version = version
        if type is not None:
            self.type = type
        if created is not None:
            self.created = created
        if last_updated is not None:
            self.last_updated = last_updated
        if id is not None:
            self.id = id

    @property
    def name(self):
        """Gets the name of this Ruleset.  # noqa: E501

        Name of the ruleset. Searchable as String.  # noqa: E501

        :return: The name of this Ruleset.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Ruleset.

        Name of the ruleset. Searchable as String.  # noqa: E501

        :param name: The name of this Ruleset.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this Ruleset.  # noqa: E501

        Description of the ruleset. Searchable as String.  # noqa: E501

        :return: The description of this Ruleset.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Ruleset.

        Description of the ruleset. Searchable as String.  # noqa: E501

        :param description: The description of this Ruleset.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def version(self):
        """Gets the version of this Ruleset.  # noqa: E501

        Version number of the ruleset. Incremented by one whenever the ruleset rules are modified. Searchable as Numeric.  # noqa: E501

        :return: The version of this Ruleset.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Ruleset.

        Version number of the ruleset. Incremented by one whenever the ruleset rules are modified. Searchable as Numeric.  # noqa: E501

        :param version: The version of this Ruleset.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def type(self):
        """Gets the type of this Ruleset.  # noqa: E501

        Type of the ruleset. Searchable as Choice.  # noqa: E501

        :return: The type of this Ruleset.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Ruleset.

        Type of the ruleset. Searchable as Choice.  # noqa: E501

        :param type: The type of this Ruleset.  # noqa: E501
        :type: str
        """
        allowed_values = ["local-file", "local-hash", "shared-file", "shared-hash"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def created(self):
        """Gets the created of this Ruleset.  # noqa: E501

        Timestamp of the ruleset's creation, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The created of this Ruleset.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Ruleset.

        Timestamp of the ruleset's creation, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param created: The created of this Ruleset.  # noqa: E501
        :type: int
        """

        self._created = created

    @property
    def last_updated(self):
        """Gets the last_updated of this Ruleset.  # noqa: E501

        Timestamp of when the ruleset was last updated, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The last_updated of this Ruleset.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this Ruleset.

        Timestamp of when the ruleset was last updated, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param last_updated: The last_updated of this Ruleset.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def id(self):
        """Gets the id of this Ruleset.  # noqa: E501

        ID of the ruleset. Searchable as ID.  # noqa: E501

        :return: The id of this Ruleset.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Ruleset.

        ID of the ruleset. Searchable as ID.  # noqa: E501

        :param id: The id of this Ruleset.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Ruleset, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Ruleset):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

