# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.policy_mapping import PolicyMapping  # noqa: F401,E501


class PolicyMigrationTask(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'task_guid': 'str',
        'status': 'str',
        'created': 'int',
        'policy_mappings': 'list[PolicyMapping]',
        'error_code': 'int',
        'id': 'int'
    }

    attribute_map = {
        'task_guid': 'taskGUID',
        'status': 'status',
        'created': 'created',
        'policy_mappings': 'policyMappings',
        'error_code': 'errorCode',
        'id': 'ID'
    }

    def __init__(self, task_guid=None, status=None, created=None, policy_mappings=None, error_code=None, id=None):  # noqa: E501
        """PolicyMigrationTask - a model defined in Swagger"""  # noqa: E501

        self._task_guid = None
        self._status = None
        self._created = None
        self._policy_mappings = None
        self._error_code = None
        self._id = None
        self.discriminator = None

        if task_guid is not None:
            self.task_guid = task_guid
        if status is not None:
            self.status = status
        if created is not None:
            self.created = created
        if policy_mappings is not None:
            self.policy_mappings = policy_mappings
        if error_code is not None:
            self.error_code = error_code
        if id is not None:
            self.id = id

    @property
    def task_guid(self):
        """Gets the task_guid of this PolicyMigrationTask.  # noqa: E501

        Task GUID on Workload Security. Searchable as String.  # noqa: E501

        :return: The task_guid of this PolicyMigrationTask.  # noqa: E501
        :rtype: str
        """
        return self._task_guid

    @task_guid.setter
    def task_guid(self, task_guid):
        """Sets the task_guid of this PolicyMigrationTask.

        Task GUID on Workload Security. Searchable as String.  # noqa: E501

        :param task_guid: The task_guid of this PolicyMigrationTask.  # noqa: E501
        :type: str
        """

        self._task_guid = task_guid

    @property
    def status(self):
        """Gets the status of this PolicyMigrationTask.  # noqa: E501

        The migration status.  # noqa: E501

        :return: The status of this PolicyMigrationTask.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PolicyMigrationTask.

        The migration status.  # noqa: E501

        :param status: The status of this PolicyMigrationTask.  # noqa: E501
        :type: str
        """
        allowed_values = ["requested", "in-progress", "complete", "failed"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def created(self):
        """Gets the created of this PolicyMigrationTask.  # noqa: E501

        Timestamp when the PolicyMigrationTask was created, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The created of this PolicyMigrationTask.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this PolicyMigrationTask.

        Timestamp when the PolicyMigrationTask was created, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param created: The created of this PolicyMigrationTask.  # noqa: E501
        :type: int
        """

        self._created = created

    @property
    def policy_mappings(self):
        """Gets the policy_mappings of this PolicyMigrationTask.  # noqa: E501

        The mapping table of policies on this Deep Security Manager and the Workload Security.  # noqa: E501

        :return: The policy_mappings of this PolicyMigrationTask.  # noqa: E501
        :rtype: list[PolicyMapping]
        """
        return self._policy_mappings

    @policy_mappings.setter
    def policy_mappings(self, policy_mappings):
        """Sets the policy_mappings of this PolicyMigrationTask.

        The mapping table of policies on this Deep Security Manager and the Workload Security.  # noqa: E501

        :param policy_mappings: The policy_mappings of this PolicyMigrationTask.  # noqa: E501
        :type: list[PolicyMapping]
        """

        self._policy_mappings = policy_mappings

    @property
    def error_code(self):
        """Gets the error_code of this PolicyMigrationTask.  # noqa: E501

        The error code of the failed task.  # noqa: E501

        :return: The error_code of this PolicyMigrationTask.  # noqa: E501
        :rtype: int
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this PolicyMigrationTask.

        The error code of the failed task.  # noqa: E501

        :param error_code: The error_code of this PolicyMigrationTask.  # noqa: E501
        :type: int
        """

        self._error_code = error_code

    @property
    def id(self):
        """Gets the id of this PolicyMigrationTask.  # noqa: E501

        ID of the policy migration task.  # noqa: E501

        :return: The id of this PolicyMigrationTask.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PolicyMigrationTask.

        ID of the policy migration task.  # noqa: E501

        :param id: The id of this PolicyMigrationTask.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PolicyMigrationTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PolicyMigrationTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

