# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NSXManagerInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host': 'str',
        'port': 'int',
        'username': 'str',
        'password': 'str',
        'webserver_url': 'str',
        'nsx_policy_sync': 'bool',
        'create_default_ebt': 'bool'
    }

    attribute_map = {
        'host': 'host',
        'port': 'port',
        'username': 'username',
        'password': 'password',
        'webserver_url': 'webserverUrl',
        'nsx_policy_sync': 'nsxPolicySync',
        'create_default_ebt': 'createDefaultEBT'
    }

    def __init__(self, host=None, port=None, username=None, password=None, webserver_url=None, nsx_policy_sync=None, create_default_ebt=None):  # noqa: E501
        """NSXManagerInfo - a model defined in Swagger"""  # noqa: E501

        self._host = None
        self._port = None
        self._username = None
        self._password = None
        self._webserver_url = None
        self._nsx_policy_sync = None
        self._create_default_ebt = None
        self.discriminator = None

        if host is not None:
            self.host = host
        if port is not None:
            self.port = port
        if username is not None:
            self.username = username
        if password is not None:
            self.password = password
        if webserver_url is not None:
            self.webserver_url = webserver_url
        if nsx_policy_sync is not None:
            self.nsx_policy_sync = nsx_policy_sync
        if create_default_ebt is not None:
            self.create_default_ebt = create_default_ebt

    @property
    def host(self):
        """Gets the host of this NSXManagerInfo.  # noqa: E501

        NSX Manager IP address or hostname.  # noqa: E501

        :return: The host of this NSXManagerInfo.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this NSXManagerInfo.

        NSX Manager IP address or hostname.  # noqa: E501

        :param host: The host of this NSXManagerInfo.  # noqa: E501
        :type: str
        """

        self._host = host

    @property
    def port(self):
        """Gets the port of this NSXManagerInfo.  # noqa: E501

        NSX Manager port.  # noqa: E501

        :return: The port of this NSXManagerInfo.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this NSXManagerInfo.

        NSX Manager port.  # noqa: E501

        :param port: The port of this NSXManagerInfo.  # noqa: E501
        :type: int
        """

        self._port = port

    @property
    def username(self):
        """Gets the username of this NSXManagerInfo.  # noqa: E501

        Username that the connector will use to authenticate to NSX Manager.  # noqa: E501

        :return: The username of this NSXManagerInfo.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this NSXManagerInfo.

        Username that the connector will use to authenticate to NSX Manager.  # noqa: E501

        :param username: The username of this NSXManagerInfo.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def password(self):
        """Gets the password of this NSXManagerInfo.  # noqa: E501

        Password of the NSX Manager user. Must be base64-encoded.  # noqa: E501

        :return: The password of this NSXManagerInfo.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this NSXManagerInfo.

        Password of the NSX Manager user. Must be base64-encoded.  # noqa: E501

        :param password: The password of this NSXManagerInfo.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def webserver_url(self):
        """Gets the webserver_url of this NSXManagerInfo.  # noqa: E501

        URL to the appliance OVF file.  # noqa: E501

        :return: The webserver_url of this NSXManagerInfo.  # noqa: E501
        :rtype: str
        """
        return self._webserver_url

    @webserver_url.setter
    def webserver_url(self, webserver_url):
        """Sets the webserver_url of this NSXManagerInfo.

        URL to the appliance OVF file.  # noqa: E501

        :param webserver_url: The webserver_url of this NSXManagerInfo.  # noqa: E501
        :type: str
        """

        self._webserver_url = webserver_url

    @property
    def nsx_policy_sync(self):
        """Gets the nsx_policy_sync of this NSXManagerInfo.  # noqa: E501

        Enable or disable the NSX policy sync feature.  # noqa: E501

        :return: The nsx_policy_sync of this NSXManagerInfo.  # noqa: E501
        :rtype: bool
        """
        return self._nsx_policy_sync

    @nsx_policy_sync.setter
    def nsx_policy_sync(self, nsx_policy_sync):
        """Sets the nsx_policy_sync of this NSXManagerInfo.

        Enable or disable the NSX policy sync feature.  # noqa: E501

        :param nsx_policy_sync: The nsx_policy_sync of this NSXManagerInfo.  # noqa: E501
        :type: bool
        """

        self._nsx_policy_sync = nsx_policy_sync

    @property
    def create_default_ebt(self):
        """Gets the create_default_ebt of this NSXManagerInfo.  # noqa: E501

        Create the default event-based task (also called the 'default EBT').  # noqa: E501

        :return: The create_default_ebt of this NSXManagerInfo.  # noqa: E501
        :rtype: bool
        """
        return self._create_default_ebt

    @create_default_ebt.setter
    def create_default_ebt(self, create_default_ebt):
        """Sets the create_default_ebt of this NSXManagerInfo.

        Create the default event-based task (also called the 'default EBT').  # noqa: E501

        :param create_default_ebt: The create_default_ebt of this NSXManagerInfo.  # noqa: E501
        :type: bool
        """

        self._create_default_ebt = create_default_ebt

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NSXManagerInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NSXManagerInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

