# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.virtual_machine_gcp_label import VirtualMachineGCPLabel  # noqa: F401,E501


class GcpVirtualMachineSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cloud_provider': 'str',
        'state': 'str',
        'operating_system': 'str',
        'instance_id': 'str',
        'private_ip_address': 'str',
        'public_ip_address': 'str',
        'zone': 'str',
        'v_cpus': 'int',
        'memory': 'int',
        'labels': 'list[VirtualMachineGCPLabel]',
        'network_tags': 'list[str]'
    }

    attribute_map = {
        'cloud_provider': 'cloudProvider',
        'state': 'state',
        'operating_system': 'operatingSystem',
        'instance_id': 'instanceID',
        'private_ip_address': 'privateIPAddress',
        'public_ip_address': 'publicIPAddress',
        'zone': 'zone',
        'v_cpus': 'vCPUs',
        'memory': 'memory',
        'labels': 'labels',
        'network_tags': 'networkTags'
    }

    def __init__(self, cloud_provider=None, state=None, operating_system=None, instance_id=None, private_ip_address=None, public_ip_address=None, zone=None, v_cpus=None, memory=None, labels=None, network_tags=None):  # noqa: E501
        """GcpVirtualMachineSummary - a model defined in Swagger"""  # noqa: E501

        self._cloud_provider = None
        self._state = None
        self._operating_system = None
        self._instance_id = None
        self._private_ip_address = None
        self._public_ip_address = None
        self._zone = None
        self._v_cpus = None
        self._memory = None
        self._labels = None
        self._network_tags = None
        self.discriminator = None

        if cloud_provider is not None:
            self.cloud_provider = cloud_provider
        if state is not None:
            self.state = state
        if operating_system is not None:
            self.operating_system = operating_system
        if instance_id is not None:
            self.instance_id = instance_id
        if private_ip_address is not None:
            self.private_ip_address = private_ip_address
        if public_ip_address is not None:
            self.public_ip_address = public_ip_address
        if zone is not None:
            self.zone = zone
        if v_cpus is not None:
            self.v_cpus = v_cpus
        if memory is not None:
            self.memory = memory
        if labels is not None:
            self.labels = labels
        if network_tags is not None:
            self.network_tags = network_tags

    @property
    def cloud_provider(self):
        """Gets the cloud_provider of this GcpVirtualMachineSummary.  # noqa: E501

        Cloud provider: \"GCP\".  # noqa: E501

        :return: The cloud_provider of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._cloud_provider

    @cloud_provider.setter
    def cloud_provider(self, cloud_provider):
        """Sets the cloud_provider of this GcpVirtualMachineSummary.

        Cloud provider: \"GCP\".  # noqa: E501

        :param cloud_provider: The cloud_provider of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._cloud_provider = cloud_provider

    @property
    def state(self):
        """Gets the state of this GcpVirtualMachineSummary.  # noqa: E501

        Power state, for example, \"POWER ON\".  # noqa: E501

        :return: The state of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this GcpVirtualMachineSummary.

        Power state, for example, \"POWER ON\".  # noqa: E501

        :param state: The state of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def operating_system(self):
        """Gets the operating_system of this GcpVirtualMachineSummary.  # noqa: E501

        Operating system, for example: \"Microsoft Windows (64 bit)\". Searchable as String.  # noqa: E501

        :return: The operating_system of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """Sets the operating_system of this GcpVirtualMachineSummary.

        Operating system, for example: \"Microsoft Windows (64 bit)\". Searchable as String.  # noqa: E501

        :param operating_system: The operating_system of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._operating_system = operating_system

    @property
    def instance_id(self):
        """Gets the instance_id of this GcpVirtualMachineSummary.  # noqa: E501

        Instance ID, for example: \"1234567890123456789\". Searchable as String.  # noqa: E501

        :return: The instance_id of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """Sets the instance_id of this GcpVirtualMachineSummary.

        Instance ID, for example: \"1234567890123456789\". Searchable as String.  # noqa: E501

        :param instance_id: The instance_id of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._instance_id = instance_id

    @property
    def private_ip_address(self):
        """Gets the private_ip_address of this GcpVirtualMachineSummary.  # noqa: E501

        Private IP address. Searchable as String.  # noqa: E501

        :return: The private_ip_address of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._private_ip_address

    @private_ip_address.setter
    def private_ip_address(self, private_ip_address):
        """Sets the private_ip_address of this GcpVirtualMachineSummary.

        Private IP address. Searchable as String.  # noqa: E501

        :param private_ip_address: The private_ip_address of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._private_ip_address = private_ip_address

    @property
    def public_ip_address(self):
        """Gets the public_ip_address of this GcpVirtualMachineSummary.  # noqa: E501

        Public IP address. Searchable as String.  # noqa: E501

        :return: The public_ip_address of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._public_ip_address

    @public_ip_address.setter
    def public_ip_address(self, public_ip_address):
        """Sets the public_ip_address of this GcpVirtualMachineSummary.

        Public IP address. Searchable as String.  # noqa: E501

        :param public_ip_address: The public_ip_address of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._public_ip_address = public_ip_address

    @property
    def zone(self):
        """Gets the zone of this GcpVirtualMachineSummary.  # noqa: E501

        Zone is a deployment area, for example: \"us-east1-d\". Searchable as String.  # noqa: E501

        :return: The zone of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: str
        """
        return self._zone

    @zone.setter
    def zone(self, zone):
        """Sets the zone of this GcpVirtualMachineSummary.

        Zone is a deployment area, for example: \"us-east1-d\". Searchable as String.  # noqa: E501

        :param zone: The zone of this GcpVirtualMachineSummary.  # noqa: E501
        :type: str
        """

        self._zone = zone

    @property
    def v_cpus(self):
        """Gets the v_cpus of this GcpVirtualMachineSummary.  # noqa: E501

        Number of vCPU. Searchable as Numeric.  # noqa: E501

        :return: The v_cpus of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: int
        """
        return self._v_cpus

    @v_cpus.setter
    def v_cpus(self, v_cpus):
        """Sets the v_cpus of this GcpVirtualMachineSummary.

        Number of vCPU. Searchable as Numeric.  # noqa: E501

        :param v_cpus: The v_cpus of this GcpVirtualMachineSummary.  # noqa: E501
        :type: int
        """

        self._v_cpus = v_cpus

    @property
    def memory(self):
        """Gets the memory of this GcpVirtualMachineSummary.  # noqa: E501

        Memory size in megabyte. Searchable as Numeric.  # noqa: E501

        :return: The memory of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this GcpVirtualMachineSummary.

        Memory size in megabyte. Searchable as Numeric.  # noqa: E501

        :param memory: The memory of this GcpVirtualMachineSummary.  # noqa: E501
        :type: int
        """

        self._memory = memory

    @property
    def labels(self):
        """Gets the labels of this GcpVirtualMachineSummary.  # noqa: E501

        List of key/value labels.  # noqa: E501

        :return: The labels of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: list[VirtualMachineGCPLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this GcpVirtualMachineSummary.

        List of key/value labels.  # noqa: E501

        :param labels: The labels of this GcpVirtualMachineSummary.  # noqa: E501
        :type: list[VirtualMachineGCPLabel]
        """

        self._labels = labels

    @property
    def network_tags(self):
        """Gets the network_tags of this GcpVirtualMachineSummary.  # noqa: E501

        List of network tags.  # noqa: E501

        :return: The network_tags of this GcpVirtualMachineSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._network_tags

    @network_tags.setter
    def network_tags(self, network_tags):
        """Sets the network_tags of this GcpVirtualMachineSummary.

        List of network tags.  # noqa: E501

        :param network_tags: The network_tags of this GcpVirtualMachineSummary.  # noqa: E501
        :type: list[str]
        """

        self._network_tags = network_tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GcpVirtualMachineSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GcpVirtualMachineSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

