# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FirewallRule(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'action': 'str',
        'priority': 'str',
        'direction': 'str',
        'frame_type': 'str',
        'frame_number': 'int',
        'frame_not': 'bool',
        'protocol': 'str',
        'protocol_number': 'int',
        'protocol_not': 'bool',
        'source_ip_type': 'str',
        'source_ip_value': 'str',
        'source_ip_mask': 'str',
        'source_ip_range_from': 'str',
        'source_ip_range_to': 'str',
        'source_ip_multiple': 'list[str]',
        'source_ip_list_id': 'int',
        'source_ip_not': 'bool',
        'source_mac_type': 'str',
        'source_mac_value': 'str',
        'source_mac_multiple': 'list[str]',
        'source_mac_list_id': 'int',
        'source_mac_not': 'bool',
        'source_port_type': 'str',
        'source_port_multiple': 'list[str]',
        'source_port_list_id': 'int',
        'source_port_not': 'bool',
        'destination_ip_type': 'str',
        'destination_ip_value': 'str',
        'destination_ip_mask': 'str',
        'destination_ip_range_from': 'str',
        'destination_ip_range_to': 'str',
        'destination_ip_multiple': 'list[str]',
        'destination_ip_list_id': 'int',
        'destination_ip_not': 'bool',
        'destination_mac_type': 'str',
        'destination_mac_value': 'str',
        'destination_mac_multiple': 'list[str]',
        'destination_mac_list_id': 'int',
        'destination_mac_not': 'bool',
        'destination_port_type': 'str',
        'destination_port_multiple': 'list[str]',
        'destination_port_list_id': 'int',
        'destination_port_not': 'bool',
        'any_flags': 'bool',
        'log_disabled': 'bool',
        'include_packet_data': 'bool',
        'alert_enabled': 'bool',
        'schedule_id': 'int',
        'context_id': 'int',
        'tcpflags': 'list[str]',
        'id': 'int',
        'tcp_not': 'bool',
        'icmp_type': 'int',
        'icmp_code': 'int',
        'icmp_not': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'action': 'action',
        'priority': 'priority',
        'direction': 'direction',
        'frame_type': 'frameType',
        'frame_number': 'frameNumber',
        'frame_not': 'frameNot',
        'protocol': 'protocol',
        'protocol_number': 'protocolNumber',
        'protocol_not': 'protocolNot',
        'source_ip_type': 'sourceIPType',
        'source_ip_value': 'sourceIPValue',
        'source_ip_mask': 'sourceIPMask',
        'source_ip_range_from': 'sourceIPRangeFrom',
        'source_ip_range_to': 'sourceIPRangeTo',
        'source_ip_multiple': 'sourceIPMultiple',
        'source_ip_list_id': 'sourceIPListID',
        'source_ip_not': 'sourceIPNot',
        'source_mac_type': 'sourceMACType',
        'source_mac_value': 'sourceMACValue',
        'source_mac_multiple': 'sourceMACMultiple',
        'source_mac_list_id': 'sourceMACListID',
        'source_mac_not': 'sourceMACNot',
        'source_port_type': 'sourcePortType',
        'source_port_multiple': 'sourcePortMultiple',
        'source_port_list_id': 'sourcePortListID',
        'source_port_not': 'sourcePortNot',
        'destination_ip_type': 'destinationIPType',
        'destination_ip_value': 'destinationIPValue',
        'destination_ip_mask': 'destinationIPMask',
        'destination_ip_range_from': 'destinationIPRangeFrom',
        'destination_ip_range_to': 'destinationIPRangeTo',
        'destination_ip_multiple': 'destinationIPMultiple',
        'destination_ip_list_id': 'destinationIPListID',
        'destination_ip_not': 'destinationIPNot',
        'destination_mac_type': 'destinationMACType',
        'destination_mac_value': 'destinationMACValue',
        'destination_mac_multiple': 'destinationMACMultiple',
        'destination_mac_list_id': 'destinationMACListID',
        'destination_mac_not': 'destinationMACNot',
        'destination_port_type': 'destinationPortType',
        'destination_port_multiple': 'destinationPortMultiple',
        'destination_port_list_id': 'destinationPortListID',
        'destination_port_not': 'destinationPortNot',
        'any_flags': 'anyFlags',
        'log_disabled': 'logDisabled',
        'include_packet_data': 'includePacketData',
        'alert_enabled': 'alertEnabled',
        'schedule_id': 'scheduleID',
        'context_id': 'contextID',
        'tcpflags': 'tcpflags',
        'id': 'ID',
        'tcp_not': 'TCPNot',
        'icmp_type': 'ICMPType',
        'icmp_code': 'ICMPCode',
        'icmp_not': 'ICMPNot'
    }

    def __init__(self, name=None, description=None, action=None, priority=None, direction=None, frame_type=None, frame_number=None, frame_not=None, protocol=None, protocol_number=None, protocol_not=None, source_ip_type=None, source_ip_value=None, source_ip_mask=None, source_ip_range_from=None, source_ip_range_to=None, source_ip_multiple=None, source_ip_list_id=None, source_ip_not=None, source_mac_type=None, source_mac_value=None, source_mac_multiple=None, source_mac_list_id=None, source_mac_not=None, source_port_type=None, source_port_multiple=None, source_port_list_id=None, source_port_not=None, destination_ip_type=None, destination_ip_value=None, destination_ip_mask=None, destination_ip_range_from=None, destination_ip_range_to=None, destination_ip_multiple=None, destination_ip_list_id=None, destination_ip_not=None, destination_mac_type=None, destination_mac_value=None, destination_mac_multiple=None, destination_mac_list_id=None, destination_mac_not=None, destination_port_type=None, destination_port_multiple=None, destination_port_list_id=None, destination_port_not=None, any_flags=None, log_disabled=None, include_packet_data=None, alert_enabled=None, schedule_id=None, context_id=None, tcpflags=None, id=None, tcp_not=None, icmp_type=None, icmp_code=None, icmp_not=None):  # noqa: E501
        """FirewallRule - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._description = None
        self._action = None
        self._priority = None
        self._direction = None
        self._frame_type = None
        self._frame_number = None
        self._frame_not = None
        self._protocol = None
        self._protocol_number = None
        self._protocol_not = None
        self._source_ip_type = None
        self._source_ip_value = None
        self._source_ip_mask = None
        self._source_ip_range_from = None
        self._source_ip_range_to = None
        self._source_ip_multiple = None
        self._source_ip_list_id = None
        self._source_ip_not = None
        self._source_mac_type = None
        self._source_mac_value = None
        self._source_mac_multiple = None
        self._source_mac_list_id = None
        self._source_mac_not = None
        self._source_port_type = None
        self._source_port_multiple = None
        self._source_port_list_id = None
        self._source_port_not = None
        self._destination_ip_type = None
        self._destination_ip_value = None
        self._destination_ip_mask = None
        self._destination_ip_range_from = None
        self._destination_ip_range_to = None
        self._destination_ip_multiple = None
        self._destination_ip_list_id = None
        self._destination_ip_not = None
        self._destination_mac_type = None
        self._destination_mac_value = None
        self._destination_mac_multiple = None
        self._destination_mac_list_id = None
        self._destination_mac_not = None
        self._destination_port_type = None
        self._destination_port_multiple = None
        self._destination_port_list_id = None
        self._destination_port_not = None
        self._any_flags = None
        self._log_disabled = None
        self._include_packet_data = None
        self._alert_enabled = None
        self._schedule_id = None
        self._context_id = None
        self._tcpflags = None
        self._id = None
        self._tcp_not = None
        self._icmp_type = None
        self._icmp_code = None
        self._icmp_not = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if action is not None:
            self.action = action
        if priority is not None:
            self.priority = priority
        if direction is not None:
            self.direction = direction
        if frame_type is not None:
            self.frame_type = frame_type
        if frame_number is not None:
            self.frame_number = frame_number
        if frame_not is not None:
            self.frame_not = frame_not
        if protocol is not None:
            self.protocol = protocol
        if protocol_number is not None:
            self.protocol_number = protocol_number
        if protocol_not is not None:
            self.protocol_not = protocol_not
        if source_ip_type is not None:
            self.source_ip_type = source_ip_type
        if source_ip_value is not None:
            self.source_ip_value = source_ip_value
        if source_ip_mask is not None:
            self.source_ip_mask = source_ip_mask
        if source_ip_range_from is not None:
            self.source_ip_range_from = source_ip_range_from
        if source_ip_range_to is not None:
            self.source_ip_range_to = source_ip_range_to
        if source_ip_multiple is not None:
            self.source_ip_multiple = source_ip_multiple
        if source_ip_list_id is not None:
            self.source_ip_list_id = source_ip_list_id
        if source_ip_not is not None:
            self.source_ip_not = source_ip_not
        if source_mac_type is not None:
            self.source_mac_type = source_mac_type
        if source_mac_value is not None:
            self.source_mac_value = source_mac_value
        if source_mac_multiple is not None:
            self.source_mac_multiple = source_mac_multiple
        if source_mac_list_id is not None:
            self.source_mac_list_id = source_mac_list_id
        if source_mac_not is not None:
            self.source_mac_not = source_mac_not
        if source_port_type is not None:
            self.source_port_type = source_port_type
        if source_port_multiple is not None:
            self.source_port_multiple = source_port_multiple
        if source_port_list_id is not None:
            self.source_port_list_id = source_port_list_id
        if source_port_not is not None:
            self.source_port_not = source_port_not
        if destination_ip_type is not None:
            self.destination_ip_type = destination_ip_type
        if destination_ip_value is not None:
            self.destination_ip_value = destination_ip_value
        if destination_ip_mask is not None:
            self.destination_ip_mask = destination_ip_mask
        if destination_ip_range_from is not None:
            self.destination_ip_range_from = destination_ip_range_from
        if destination_ip_range_to is not None:
            self.destination_ip_range_to = destination_ip_range_to
        if destination_ip_multiple is not None:
            self.destination_ip_multiple = destination_ip_multiple
        if destination_ip_list_id is not None:
            self.destination_ip_list_id = destination_ip_list_id
        if destination_ip_not is not None:
            self.destination_ip_not = destination_ip_not
        if destination_mac_type is not None:
            self.destination_mac_type = destination_mac_type
        if destination_mac_value is not None:
            self.destination_mac_value = destination_mac_value
        if destination_mac_multiple is not None:
            self.destination_mac_multiple = destination_mac_multiple
        if destination_mac_list_id is not None:
            self.destination_mac_list_id = destination_mac_list_id
        if destination_mac_not is not None:
            self.destination_mac_not = destination_mac_not
        if destination_port_type is not None:
            self.destination_port_type = destination_port_type
        if destination_port_multiple is not None:
            self.destination_port_multiple = destination_port_multiple
        if destination_port_list_id is not None:
            self.destination_port_list_id = destination_port_list_id
        if destination_port_not is not None:
            self.destination_port_not = destination_port_not
        if any_flags is not None:
            self.any_flags = any_flags
        if log_disabled is not None:
            self.log_disabled = log_disabled
        if include_packet_data is not None:
            self.include_packet_data = include_packet_data
        if alert_enabled is not None:
            self.alert_enabled = alert_enabled
        if schedule_id is not None:
            self.schedule_id = schedule_id
        if context_id is not None:
            self.context_id = context_id
        if tcpflags is not None:
            self.tcpflags = tcpflags
        if id is not None:
            self.id = id
        if tcp_not is not None:
            self.tcp_not = tcp_not
        if icmp_type is not None:
            self.icmp_type = icmp_type
        if icmp_code is not None:
            self.icmp_code = icmp_code
        if icmp_not is not None:
            self.icmp_not = icmp_not

    @property
    def name(self):
        """Gets the name of this FirewallRule.  # noqa: E501

        Name of the firewall rule. Searchable as String.  # noqa: E501

        :return: The name of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FirewallRule.

        Name of the firewall rule. Searchable as String.  # noqa: E501

        :param name: The name of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this FirewallRule.  # noqa: E501

        Description of the firewall rule. Searchable as String.  # noqa: E501

        :return: The description of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this FirewallRule.

        Description of the firewall rule. Searchable as String.  # noqa: E501

        :param description: The description of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def action(self):
        """Gets the action of this FirewallRule.  # noqa: E501

        Action of the packet filter. Searchable as Choice.  # noqa: E501

        :return: The action of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this FirewallRule.

        Action of the packet filter. Searchable as Choice.  # noqa: E501

        :param action: The action of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["log-only", "allow", "deny", "force-allow", "bypass"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def priority(self):
        """Gets the priority of this FirewallRule.  # noqa: E501

        Priority of the packet filter. Searchable as Choice.  # noqa: E501

        :return: The priority of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this FirewallRule.

        Priority of the packet filter. Searchable as Choice.  # noqa: E501

        :param priority: The priority of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["0", "1", "2", "3", "4"]  # noqa: E501
        if priority not in allowed_values:
            raise ValueError(
                "Invalid value for `priority` ({0}), must be one of {1}"  # noqa: E501
                .format(priority, allowed_values)
            )

        self._priority = priority

    @property
    def direction(self):
        """Gets the direction of this FirewallRule.  # noqa: E501

        Packet direction. Searchable as Choice.  # noqa: E501

        :return: The direction of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this FirewallRule.

        Packet direction. Searchable as Choice.  # noqa: E501

        :param direction: The direction of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["incoming", "outgoing"]  # noqa: E501
        if direction not in allowed_values:
            raise ValueError(
                "Invalid value for `direction` ({0}), must be one of {1}"  # noqa: E501
                .format(direction, allowed_values)
            )

        self._direction = direction

    @property
    def frame_type(self):
        """Gets the frame_type of this FirewallRule.  # noqa: E501

        Supported frame types. Searchable as Choice.  # noqa: E501

        :return: The frame_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._frame_type

    @frame_type.setter
    def frame_type(self, frame_type):
        """Sets the frame_type of this FirewallRule.

        Supported frame types. Searchable as Choice.  # noqa: E501

        :param frame_type: The frame_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "ip", "arp", "revarp", "ipv4", "ipv6", "other"]  # noqa: E501
        if frame_type not in allowed_values:
            raise ValueError(
                "Invalid value for `frame_type` ({0}), must be one of {1}"  # noqa: E501
                .format(frame_type, allowed_values)
            )

        self._frame_type = frame_type

    @property
    def frame_number(self):
        """Gets the frame_number of this FirewallRule.  # noqa: E501

        Ethernet frame number. Only required for FrameType \"other\". Searchable as Numeric.  # noqa: E501

        :return: The frame_number of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._frame_number

    @frame_number.setter
    def frame_number(self, frame_number):
        """Sets the frame_number of this FirewallRule.

        Ethernet frame number. Only required for FrameType \"other\". Searchable as Numeric.  # noqa: E501

        :param frame_number: The frame_number of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._frame_number = frame_number

    @property
    def frame_not(self):
        """Gets the frame_not of this FirewallRule.  # noqa: E501

        Controls if the frame setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The frame_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._frame_not

    @frame_not.setter
    def frame_not(self, frame_not):
        """Sets the frame_not of this FirewallRule.

        Controls if the frame setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param frame_not: The frame_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._frame_not = frame_not

    @property
    def protocol(self):
        """Gets the protocol of this FirewallRule.  # noqa: E501

        Protocol. Searchable as Choice.  # noqa: E501

        :return: The protocol of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this FirewallRule.

        Protocol. Searchable as Choice.  # noqa: E501

        :param protocol: The protocol of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "icmp", "igmp", "ggp", "tcp", "pup", "udp", "idp", "nd", "raw", "tcp-udp", "icmpv6", "other"]  # noqa: E501
        if protocol not in allowed_values:
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def protocol_number(self):
        """Gets the protocol_number of this FirewallRule.  # noqa: E501

        Two-byte protocol number. Searchable as Numeric.  # noqa: E501

        :return: The protocol_number of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._protocol_number

    @protocol_number.setter
    def protocol_number(self, protocol_number):
        """Sets the protocol_number of this FirewallRule.

        Two-byte protocol number. Searchable as Numeric.  # noqa: E501

        :param protocol_number: The protocol_number of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._protocol_number = protocol_number

    @property
    def protocol_not(self):
        """Gets the protocol_not of this FirewallRule.  # noqa: E501

        Controls if the protocol setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The protocol_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._protocol_not

    @protocol_not.setter
    def protocol_not(self, protocol_not):
        """Sets the protocol_not of this FirewallRule.

        Controls if the protocol setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param protocol_not: The protocol_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._protocol_not = protocol_not

    @property
    def source_ip_type(self):
        """Gets the source_ip_type of this FirewallRule.  # noqa: E501

        Source IP type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :return: The source_ip_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_ip_type

    @source_ip_type.setter
    def source_ip_type(self, source_ip_type):
        """Sets the source_ip_type of this FirewallRule.

        Source IP type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :param source_ip_type: The source_ip_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "masked-ip", "range", "ip-list", "single", "multiple"]  # noqa: E501
        if source_ip_type not in allowed_values:
            raise ValueError(
                "Invalid value for `source_ip_type` ({0}), must be one of {1}"  # noqa: E501
                .format(source_ip_type, allowed_values)
            )

        self._source_ip_type = source_ip_type

    @property
    def source_ip_value(self):
        """Gets the source_ip_value of this FirewallRule.  # noqa: E501

        Source IP. Only applies to source IP type \"masked-ip\" or \"single\". Searchable as String.  # noqa: E501

        :return: The source_ip_value of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_ip_value

    @source_ip_value.setter
    def source_ip_value(self, source_ip_value):
        """Sets the source_ip_value of this FirewallRule.

        Source IP. Only applies to source IP type \"masked-ip\" or \"single\". Searchable as String.  # noqa: E501

        :param source_ip_value: The source_ip_value of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._source_ip_value = source_ip_value

    @property
    def source_ip_mask(self):
        """Gets the source_ip_mask of this FirewallRule.  # noqa: E501

        Source IP mask. Only applies to source IP type \"masked-ip\". Searchable as String.  # noqa: E501

        :return: The source_ip_mask of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_ip_mask

    @source_ip_mask.setter
    def source_ip_mask(self, source_ip_mask):
        """Sets the source_ip_mask of this FirewallRule.

        Source IP mask. Only applies to source IP type \"masked-ip\". Searchable as String.  # noqa: E501

        :param source_ip_mask: The source_ip_mask of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._source_ip_mask = source_ip_mask

    @property
    def source_ip_range_from(self):
        """Gets the source_ip_range_from of this FirewallRule.  # noqa: E501

        The first value for a range of source IP addresses. Only applies to source IP type \"range\". Searchable as String.  # noqa: E501

        :return: The source_ip_range_from of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_ip_range_from

    @source_ip_range_from.setter
    def source_ip_range_from(self, source_ip_range_from):
        """Sets the source_ip_range_from of this FirewallRule.

        The first value for a range of source IP addresses. Only applies to source IP type \"range\". Searchable as String.  # noqa: E501

        :param source_ip_range_from: The source_ip_range_from of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._source_ip_range_from = source_ip_range_from

    @property
    def source_ip_range_to(self):
        """Gets the source_ip_range_to of this FirewallRule.  # noqa: E501

        The last value for a range of source IP addresses. Only applies to source IP type \"range\". Searchable as String.  # noqa: E501

        :return: The source_ip_range_to of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_ip_range_to

    @source_ip_range_to.setter
    def source_ip_range_to(self, source_ip_range_to):
        """Sets the source_ip_range_to of this FirewallRule.

        The last value for a range of source IP addresses. Only applies to source IP type \"range\". Searchable as String.  # noqa: E501

        :param source_ip_range_to: The source_ip_range_to of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._source_ip_range_to = source_ip_range_to

    @property
    def source_ip_multiple(self):
        """Gets the source_ip_multiple of this FirewallRule.  # noqa: E501

        List of source IP addresses. Only applies to source IP type \"multiple\". Searchable as String.  # noqa: E501

        :return: The source_ip_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_ip_multiple

    @source_ip_multiple.setter
    def source_ip_multiple(self, source_ip_multiple):
        """Sets the source_ip_multiple of this FirewallRule.

        List of source IP addresses. Only applies to source IP type \"multiple\". Searchable as String.  # noqa: E501

        :param source_ip_multiple: The source_ip_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._source_ip_multiple = source_ip_multiple

    @property
    def source_ip_list_id(self):
        """Gets the source_ip_list_id of this FirewallRule.  # noqa: E501

        ID of source IP list. Only applies to source IP type \"ip-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The source_ip_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._source_ip_list_id

    @source_ip_list_id.setter
    def source_ip_list_id(self, source_ip_list_id):
        """Sets the source_ip_list_id of this FirewallRule.

        ID of source IP list. Only applies to source IP type \"ip-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param source_ip_list_id: The source_ip_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._source_ip_list_id = source_ip_list_id

    @property
    def source_ip_not(self):
        """Gets the source_ip_not of this FirewallRule.  # noqa: E501

        Controls if the source IP setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The source_ip_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._source_ip_not

    @source_ip_not.setter
    def source_ip_not(self, source_ip_not):
        """Sets the source_ip_not of this FirewallRule.

        Controls if the source IP setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param source_ip_not: The source_ip_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._source_ip_not = source_ip_not

    @property
    def source_mac_type(self):
        """Gets the source_mac_type of this FirewallRule.  # noqa: E501

        Source MAC type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :return: The source_mac_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_mac_type

    @source_mac_type.setter
    def source_mac_type(self, source_mac_type):
        """Sets the source_mac_type of this FirewallRule.

        Source MAC type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :param source_mac_type: The source_mac_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "single", "mac-list", "multiple"]  # noqa: E501
        if source_mac_type not in allowed_values:
            raise ValueError(
                "Invalid value for `source_mac_type` ({0}), must be one of {1}"  # noqa: E501
                .format(source_mac_type, allowed_values)
            )

        self._source_mac_type = source_mac_type

    @property
    def source_mac_value(self):
        """Gets the source_mac_value of this FirewallRule.  # noqa: E501

        Source MAC address. Only applies to MAC type \"single\". Searchable as String.  # noqa: E501

        :return: The source_mac_value of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_mac_value

    @source_mac_value.setter
    def source_mac_value(self, source_mac_value):
        """Sets the source_mac_value of this FirewallRule.

        Source MAC address. Only applies to MAC type \"single\". Searchable as String.  # noqa: E501

        :param source_mac_value: The source_mac_value of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._source_mac_value = source_mac_value

    @property
    def source_mac_multiple(self):
        """Gets the source_mac_multiple of this FirewallRule.  # noqa: E501

        List of MAC addresses. Only applies to MAC type \"multiple\". Searchable as String.  # noqa: E501

        :return: The source_mac_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_mac_multiple

    @source_mac_multiple.setter
    def source_mac_multiple(self, source_mac_multiple):
        """Sets the source_mac_multiple of this FirewallRule.

        List of MAC addresses. Only applies to MAC type \"multiple\". Searchable as String.  # noqa: E501

        :param source_mac_multiple: The source_mac_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._source_mac_multiple = source_mac_multiple

    @property
    def source_mac_list_id(self):
        """Gets the source_mac_list_id of this FirewallRule.  # noqa: E501

        ID of MAC address list. Only applies to MAC type \"mac-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The source_mac_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._source_mac_list_id

    @source_mac_list_id.setter
    def source_mac_list_id(self, source_mac_list_id):
        """Sets the source_mac_list_id of this FirewallRule.

        ID of MAC address list. Only applies to MAC type \"mac-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param source_mac_list_id: The source_mac_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._source_mac_list_id = source_mac_list_id

    @property
    def source_mac_not(self):
        """Gets the source_mac_not of this FirewallRule.  # noqa: E501

        Controls if the source MAC setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The source_mac_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._source_mac_not

    @source_mac_not.setter
    def source_mac_not(self, source_mac_not):
        """Sets the source_mac_not of this FirewallRule.

        Controls if the source MAC setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param source_mac_not: The source_mac_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._source_mac_not = source_mac_not

    @property
    def source_port_type(self):
        """Gets the source_port_type of this FirewallRule.  # noqa: E501

        The type of source port. Searchable as Choice.  # noqa: E501

        :return: The source_port_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._source_port_type

    @source_port_type.setter
    def source_port_type(self, source_port_type):
        """Sets the source_port_type of this FirewallRule.

        The type of source port. Searchable as Choice.  # noqa: E501

        :param source_port_type: The source_port_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "multiple", "port-list"]  # noqa: E501
        if source_port_type not in allowed_values:
            raise ValueError(
                "Invalid value for `source_port_type` ({0}), must be one of {1}"  # noqa: E501
                .format(source_port_type, allowed_values)
            )

        self._source_port_type = source_port_type

    @property
    def source_port_multiple(self):
        """Gets the source_port_multiple of this FirewallRule.  # noqa: E501

        List of comma-delimited source ports. Only applies to source type \"multiple\". Searchable as String.  # noqa: E501

        :return: The source_port_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_port_multiple

    @source_port_multiple.setter
    def source_port_multiple(self, source_port_multiple):
        """Sets the source_port_multiple of this FirewallRule.

        List of comma-delimited source ports. Only applies to source type \"multiple\". Searchable as String.  # noqa: E501

        :param source_port_multiple: The source_port_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._source_port_multiple = source_port_multiple

    @property
    def source_port_list_id(self):
        """Gets the source_port_list_id of this FirewallRule.  # noqa: E501

        ID of source port list. Only applies to source type \"port-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The source_port_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._source_port_list_id

    @source_port_list_id.setter
    def source_port_list_id(self, source_port_list_id):
        """Sets the source_port_list_id of this FirewallRule.

        ID of source port list. Only applies to source type \"port-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param source_port_list_id: The source_port_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._source_port_list_id = source_port_list_id

    @property
    def source_port_not(self):
        """Gets the source_port_not of this FirewallRule.  # noqa: E501

        Controls if the source port setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The source_port_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._source_port_not

    @source_port_not.setter
    def source_port_not(self, source_port_not):
        """Sets the source_port_not of this FirewallRule.

        Controls if the source port setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param source_port_not: The source_port_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._source_port_not = source_port_not

    @property
    def destination_ip_type(self):
        """Gets the destination_ip_type of this FirewallRule.  # noqa: E501

        Destination IP type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :return: The destination_ip_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_ip_type

    @destination_ip_type.setter
    def destination_ip_type(self, destination_ip_type):
        """Sets the destination_ip_type of this FirewallRule.

        Destination IP type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :param destination_ip_type: The destination_ip_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "masked-ip", "range", "ip-list", "single", "multiple"]  # noqa: E501
        if destination_ip_type not in allowed_values:
            raise ValueError(
                "Invalid value for `destination_ip_type` ({0}), must be one of {1}"  # noqa: E501
                .format(destination_ip_type, allowed_values)
            )

        self._destination_ip_type = destination_ip_type

    @property
    def destination_ip_value(self):
        """Gets the destination_ip_value of this FirewallRule.  # noqa: E501

        Destination IP. Only applies to destination IP type \"masked-ip\" or \"single\". Searchable as String.  # noqa: E501

        :return: The destination_ip_value of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_ip_value

    @destination_ip_value.setter
    def destination_ip_value(self, destination_ip_value):
        """Sets the destination_ip_value of this FirewallRule.

        Destination IP. Only applies to destination IP type \"masked-ip\" or \"single\". Searchable as String.  # noqa: E501

        :param destination_ip_value: The destination_ip_value of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._destination_ip_value = destination_ip_value

    @property
    def destination_ip_mask(self):
        """Gets the destination_ip_mask of this FirewallRule.  # noqa: E501

        Destination IP mask. Only applies to destination IP type \"masked-ip\". Searchable as String.  # noqa: E501

        :return: The destination_ip_mask of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_ip_mask

    @destination_ip_mask.setter
    def destination_ip_mask(self, destination_ip_mask):
        """Sets the destination_ip_mask of this FirewallRule.

        Destination IP mask. Only applies to destination IP type \"masked-ip\". Searchable as String.  # noqa: E501

        :param destination_ip_mask: The destination_ip_mask of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._destination_ip_mask = destination_ip_mask

    @property
    def destination_ip_range_from(self):
        """Gets the destination_ip_range_from of this FirewallRule.  # noqa: E501

        The first value for a range of destination IP addresses. Only applies to estination IP type \"range\". Searchable as String.  # noqa: E501

        :return: The destination_ip_range_from of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_ip_range_from

    @destination_ip_range_from.setter
    def destination_ip_range_from(self, destination_ip_range_from):
        """Sets the destination_ip_range_from of this FirewallRule.

        The first value for a range of destination IP addresses. Only applies to estination IP type \"range\". Searchable as String.  # noqa: E501

        :param destination_ip_range_from: The destination_ip_range_from of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._destination_ip_range_from = destination_ip_range_from

    @property
    def destination_ip_range_to(self):
        """Gets the destination_ip_range_to of this FirewallRule.  # noqa: E501

        The last value for a range of destination IP addresses. Only applies to destination IP type \"range\". Searchable as String.  # noqa: E501

        :return: The destination_ip_range_to of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_ip_range_to

    @destination_ip_range_to.setter
    def destination_ip_range_to(self, destination_ip_range_to):
        """Sets the destination_ip_range_to of this FirewallRule.

        The last value for a range of destination IP addresses. Only applies to destination IP type \"range\". Searchable as String.  # noqa: E501

        :param destination_ip_range_to: The destination_ip_range_to of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._destination_ip_range_to = destination_ip_range_to

    @property
    def destination_ip_multiple(self):
        """Gets the destination_ip_multiple of this FirewallRule.  # noqa: E501

        List of comma-delimited destination IP addresses. Only applies to destination IP type \"multiple\". Searchable as String.  # noqa: E501

        :return: The destination_ip_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._destination_ip_multiple

    @destination_ip_multiple.setter
    def destination_ip_multiple(self, destination_ip_multiple):
        """Sets the destination_ip_multiple of this FirewallRule.

        List of comma-delimited destination IP addresses. Only applies to destination IP type \"multiple\". Searchable as String.  # noqa: E501

        :param destination_ip_multiple: The destination_ip_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._destination_ip_multiple = destination_ip_multiple

    @property
    def destination_ip_list_id(self):
        """Gets the destination_ip_list_id of this FirewallRule.  # noqa: E501

        ID of destination IP list. Only applies to destination IP type \"ip-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The destination_ip_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._destination_ip_list_id

    @destination_ip_list_id.setter
    def destination_ip_list_id(self, destination_ip_list_id):
        """Sets the destination_ip_list_id of this FirewallRule.

        ID of destination IP list. Only applies to destination IP type \"ip-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param destination_ip_list_id: The destination_ip_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._destination_ip_list_id = destination_ip_list_id

    @property
    def destination_ip_not(self):
        """Gets the destination_ip_not of this FirewallRule.  # noqa: E501

        Controls if the destination IP setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The destination_ip_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._destination_ip_not

    @destination_ip_not.setter
    def destination_ip_not(self, destination_ip_not):
        """Sets the destination_ip_not of this FirewallRule.

        Controls if the destination IP setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param destination_ip_not: The destination_ip_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._destination_ip_not = destination_ip_not

    @property
    def destination_mac_type(self):
        """Gets the destination_mac_type of this FirewallRule.  # noqa: E501

        Destination MAC type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :return: The destination_mac_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_mac_type

    @destination_mac_type.setter
    def destination_mac_type(self, destination_mac_type):
        """Sets the destination_mac_type of this FirewallRule.

        Destination MAC type. Default is \"any\". Searchable as Choice.  # noqa: E501

        :param destination_mac_type: The destination_mac_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "single", "mac-list", "multiple"]  # noqa: E501
        if destination_mac_type not in allowed_values:
            raise ValueError(
                "Invalid value for `destination_mac_type` ({0}), must be one of {1}"  # noqa: E501
                .format(destination_mac_type, allowed_values)
            )

        self._destination_mac_type = destination_mac_type

    @property
    def destination_mac_value(self):
        """Gets the destination_mac_value of this FirewallRule.  # noqa: E501

        Destination MAC address. Only applies to MAC type \"single\". Searchable as String.  # noqa: E501

        :return: The destination_mac_value of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_mac_value

    @destination_mac_value.setter
    def destination_mac_value(self, destination_mac_value):
        """Sets the destination_mac_value of this FirewallRule.

        Destination MAC address. Only applies to MAC type \"single\". Searchable as String.  # noqa: E501

        :param destination_mac_value: The destination_mac_value of this FirewallRule.  # noqa: E501
        :type: str
        """

        self._destination_mac_value = destination_mac_value

    @property
    def destination_mac_multiple(self):
        """Gets the destination_mac_multiple of this FirewallRule.  # noqa: E501

        List of comma-delimited MAC addresses. Only applies to MAC type \"multiple\". Searchable as String.  # noqa: E501

        :return: The destination_mac_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._destination_mac_multiple

    @destination_mac_multiple.setter
    def destination_mac_multiple(self, destination_mac_multiple):
        """Sets the destination_mac_multiple of this FirewallRule.

        List of comma-delimited MAC addresses. Only applies to MAC type \"multiple\". Searchable as String.  # noqa: E501

        :param destination_mac_multiple: The destination_mac_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._destination_mac_multiple = destination_mac_multiple

    @property
    def destination_mac_list_id(self):
        """Gets the destination_mac_list_id of this FirewallRule.  # noqa: E501

        ID of MAC address list. Only applies to MAC type \"mac-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The destination_mac_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._destination_mac_list_id

    @destination_mac_list_id.setter
    def destination_mac_list_id(self, destination_mac_list_id):
        """Sets the destination_mac_list_id of this FirewallRule.

        ID of MAC address list. Only applies to MAC type \"mac-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param destination_mac_list_id: The destination_mac_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._destination_mac_list_id = destination_mac_list_id

    @property
    def destination_mac_not(self):
        """Gets the destination_mac_not of this FirewallRule.  # noqa: E501

        Controls if the destination MAC setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The destination_mac_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._destination_mac_not

    @destination_mac_not.setter
    def destination_mac_not(self, destination_mac_not):
        """Sets the destination_mac_not of this FirewallRule.

        Controls if the destination MAC setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param destination_mac_not: The destination_mac_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._destination_mac_not = destination_mac_not

    @property
    def destination_port_type(self):
        """Gets the destination_port_type of this FirewallRule.  # noqa: E501

        The type of destination port. Searchable as Choice.  # noqa: E501

        :return: The destination_port_type of this FirewallRule.  # noqa: E501
        :rtype: str
        """
        return self._destination_port_type

    @destination_port_type.setter
    def destination_port_type(self, destination_port_type):
        """Sets the destination_port_type of this FirewallRule.

        The type of destination port. Searchable as Choice.  # noqa: E501

        :param destination_port_type: The destination_port_type of this FirewallRule.  # noqa: E501
        :type: str
        """
        allowed_values = ["any", "multiple", "port-list"]  # noqa: E501
        if destination_port_type not in allowed_values:
            raise ValueError(
                "Invalid value for `destination_port_type` ({0}), must be one of {1}"  # noqa: E501
                .format(destination_port_type, allowed_values)
            )

        self._destination_port_type = destination_port_type

    @property
    def destination_port_multiple(self):
        """Gets the destination_port_multiple of this FirewallRule.  # noqa: E501

        List of comma-delimited destination ports. Only applies to destination type \"multiple\". Searchable as String.  # noqa: E501

        :return: The destination_port_multiple of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._destination_port_multiple

    @destination_port_multiple.setter
    def destination_port_multiple(self, destination_port_multiple):
        """Sets the destination_port_multiple of this FirewallRule.

        List of comma-delimited destination ports. Only applies to destination type \"multiple\". Searchable as String.  # noqa: E501

        :param destination_port_multiple: The destination_port_multiple of this FirewallRule.  # noqa: E501
        :type: list[str]
        """

        self._destination_port_multiple = destination_port_multiple

    @property
    def destination_port_list_id(self):
        """Gets the destination_port_list_id of this FirewallRule.  # noqa: E501

        ID of destination port list. Only applies to destination type \"port-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The destination_port_list_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._destination_port_list_id

    @destination_port_list_id.setter
    def destination_port_list_id(self, destination_port_list_id):
        """Sets the destination_port_list_id of this FirewallRule.

        ID of destination port list. Only applies to destination type \"port-list\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param destination_port_list_id: The destination_port_list_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._destination_port_list_id = destination_port_list_id

    @property
    def destination_port_not(self):
        """Gets the destination_port_not of this FirewallRule.  # noqa: E501

        Controls if the destination port setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :return: The destination_port_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._destination_port_not

    @destination_port_not.setter
    def destination_port_not(self, destination_port_not):
        """Sets the destination_port_not of this FirewallRule.

        Controls if the destination port setting should be inverted. Set to true to invert. Searchable as Boolean.  # noqa: E501

        :param destination_port_not: The destination_port_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._destination_port_not = destination_port_not

    @property
    def any_flags(self):
        """Gets the any_flags of this FirewallRule.  # noqa: E501

        True if any flags are used. Searchable as Boolean.  # noqa: E501

        :return: The any_flags of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._any_flags

    @any_flags.setter
    def any_flags(self, any_flags):
        """Sets the any_flags of this FirewallRule.

        True if any flags are used. Searchable as Boolean.  # noqa: E501

        :param any_flags: The any_flags of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._any_flags = any_flags

    @property
    def log_disabled(self):
        """Gets the log_disabled of this FirewallRule.  # noqa: E501

        Controls if logging for this filter is disabled. Only applies to filter action \"log-only\" or \"deny\". Searchable as Boolean.  # noqa: E501

        :return: The log_disabled of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._log_disabled

    @log_disabled.setter
    def log_disabled(self, log_disabled):
        """Sets the log_disabled of this FirewallRule.

        Controls if logging for this filter is disabled. Only applies to filter action \"log-only\" or \"deny\". Searchable as Boolean.  # noqa: E501

        :param log_disabled: The log_disabled of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._log_disabled = log_disabled

    @property
    def include_packet_data(self):
        """Gets the include_packet_data of this FirewallRule.  # noqa: E501

        Controls if this filter should capture data for every log. Searchable as Boolean.  # noqa: E501

        :return: The include_packet_data of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._include_packet_data

    @include_packet_data.setter
    def include_packet_data(self, include_packet_data):
        """Sets the include_packet_data of this FirewallRule.

        Controls if this filter should capture data for every log. Searchable as Boolean.  # noqa: E501

        :param include_packet_data: The include_packet_data of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._include_packet_data = include_packet_data

    @property
    def alert_enabled(self):
        """Gets the alert_enabled of this FirewallRule.  # noqa: E501

        Controls if this filter should be alerted on. Searchable as Boolean.  # noqa: E501

        :return: The alert_enabled of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._alert_enabled

    @alert_enabled.setter
    def alert_enabled(self, alert_enabled):
        """Sets the alert_enabled of this FirewallRule.

        Controls if this filter should be alerted on. Searchable as Boolean.  # noqa: E501

        :param alert_enabled: The alert_enabled of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._alert_enabled = alert_enabled

    @property
    def schedule_id(self):
        """Gets the schedule_id of this FirewallRule.  # noqa: E501

        ID of the schedule to control when this filter is \"on\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The schedule_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._schedule_id

    @schedule_id.setter
    def schedule_id(self, schedule_id):
        """Sets the schedule_id of this FirewallRule.

        ID of the schedule to control when this filter is \"on\". Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param schedule_id: The schedule_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._schedule_id = schedule_id

    @property
    def context_id(self):
        """Gets the context_id of this FirewallRule.  # noqa: E501

        RuleContext that is applied to this filter. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The context_id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id):
        """Sets the context_id of this FirewallRule.

        RuleContext that is applied to this filter. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param context_id: The context_id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._context_id = context_id

    @property
    def tcpflags(self):
        """Gets the tcpflags of this FirewallRule.  # noqa: E501


        :return: The tcpflags of this FirewallRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._tcpflags

    @tcpflags.setter
    def tcpflags(self, tcpflags):
        """Sets the tcpflags of this FirewallRule.


        :param tcpflags: The tcpflags of this FirewallRule.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["fin", "syn", "rst", "psh", "ack", "urg"]  # noqa: E501
        if not set(tcpflags).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `tcpflags` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(tcpflags) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._tcpflags = tcpflags

    @property
    def id(self):
        """Gets the id of this FirewallRule.  # noqa: E501

        ID of the firewall rule. Searchable as ID.  # noqa: E501

        :return: The id of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FirewallRule.

        ID of the firewall rule. Searchable as ID.  # noqa: E501

        :param id: The id of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def tcp_not(self):
        """Gets the tcp_not of this FirewallRule.  # noqa: E501


        :return: The tcp_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._tcp_not

    @tcp_not.setter
    def tcp_not(self, tcp_not):
        """Sets the tcp_not of this FirewallRule.


        :param tcp_not: The tcp_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._tcp_not = tcp_not

    @property
    def icmp_type(self):
        """Gets the icmp_type of this FirewallRule.  # noqa: E501


        :return: The icmp_type of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._icmp_type

    @icmp_type.setter
    def icmp_type(self, icmp_type):
        """Sets the icmp_type of this FirewallRule.


        :param icmp_type: The icmp_type of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._icmp_type = icmp_type

    @property
    def icmp_code(self):
        """Gets the icmp_code of this FirewallRule.  # noqa: E501


        :return: The icmp_code of this FirewallRule.  # noqa: E501
        :rtype: int
        """
        return self._icmp_code

    @icmp_code.setter
    def icmp_code(self, icmp_code):
        """Sets the icmp_code of this FirewallRule.


        :param icmp_code: The icmp_code of this FirewallRule.  # noqa: E501
        :type: int
        """

        self._icmp_code = icmp_code

    @property
    def icmp_not(self):
        """Gets the icmp_not of this FirewallRule.  # noqa: E501


        :return: The icmp_not of this FirewallRule.  # noqa: E501
        :rtype: bool
        """
        return self._icmp_not

    @icmp_not.setter
    def icmp_not(self, icmp_not):
        """Sets the icmp_not of this FirewallRule.


        :param icmp_not: The icmp_not of this FirewallRule.  # noqa: E501
        :type: bool
        """

        self._icmp_not = icmp_not

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FirewallRule, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

