# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.event_based_task_action import EventBasedTaskAction  # noqa: F401,E501
from deepsecurity.models.event_based_task_condition import EventBasedTaskCondition  # noqa: F401,E501


class EventBasedTask(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'type': 'str',
        'enabled': 'bool',
        'last_run_time': 'int',
        'actions': 'list[EventBasedTaskAction]',
        'conditions': 'list[EventBasedTaskCondition]',
        'id': 'int'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'enabled': 'enabled',
        'last_run_time': 'lastRunTime',
        'actions': 'actions',
        'conditions': 'conditions',
        'id': 'ID'
    }

    def __init__(self, name=None, type=None, enabled=None, last_run_time=None, actions=None, conditions=None, id=None):  # noqa: E501
        """EventBasedTask - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._type = None
        self._enabled = None
        self._last_run_time = None
        self._actions = None
        self._conditions = None
        self._id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if enabled is not None:
            self.enabled = enabled
        if last_run_time is not None:
            self.last_run_time = last_run_time
        if actions is not None:
            self.actions = actions
        if conditions is not None:
            self.conditions = conditions
        if id is not None:
            self.id = id

    @property
    def name(self):
        """Gets the name of this EventBasedTask.  # noqa: E501

        Name of event based task. Searchable as String.  # noqa: E501

        :return: The name of this EventBasedTask.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EventBasedTask.

        Name of event based task. Searchable as String.  # noqa: E501

        :param name: The name of this EventBasedTask.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this EventBasedTask.  # noqa: E501

        Type of scheduled task. Searchable as Choice.  # noqa: E501

        :return: The type of this EventBasedTask.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this EventBasedTask.

        Type of scheduled task. Searchable as Choice.  # noqa: E501

        :param type: The type of this EventBasedTask.  # noqa: E501
        :type: str
        """
        allowed_values = ["computer-created-by-system", "computer-moved-by-system", "agent-initiated-activation", "agent-ip-changed", "nsx-protection-changed", "computer-powered-on-by-system"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def enabled(self):
        """Gets the enabled of this EventBasedTask.  # noqa: E501

        Indicates whether or not the event based task is enabled. Searchable as Boolean.  # noqa: E501

        :return: The enabled of this EventBasedTask.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this EventBasedTask.

        Indicates whether or not the event based task is enabled. Searchable as Boolean.  # noqa: E501

        :param enabled: The enabled of this EventBasedTask.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def last_run_time(self):
        """Gets the last_run_time of this EventBasedTask.  # noqa: E501

        The last time this event based task was run, or null if never run. Searchable as Date.  # noqa: E501

        :return: The last_run_time of this EventBasedTask.  # noqa: E501
        :rtype: int
        """
        return self._last_run_time

    @last_run_time.setter
    def last_run_time(self, last_run_time):
        """Sets the last_run_time of this EventBasedTask.

        The last time this event based task was run, or null if never run. Searchable as Date.  # noqa: E501

        :param last_run_time: The last_run_time of this EventBasedTask.  # noqa: E501
        :type: int
        """

        self._last_run_time = last_run_time

    @property
    def actions(self):
        """Gets the actions of this EventBasedTask.  # noqa: E501

        List of actions to perform when an event based task condition is met.  # noqa: E501

        :return: The actions of this EventBasedTask.  # noqa: E501
        :rtype: list[EventBasedTaskAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this EventBasedTask.

        List of actions to perform when an event based task condition is met.  # noqa: E501

        :param actions: The actions of this EventBasedTask.  # noqa: E501
        :type: list[EventBasedTaskAction]
        """

        self._actions = actions

    @property
    def conditions(self):
        """Gets the conditions of this EventBasedTask.  # noqa: E501

        List of conditions that must be met in order for an event based task to run its actions.  # noqa: E501

        :return: The conditions of this EventBasedTask.  # noqa: E501
        :rtype: list[EventBasedTaskCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this EventBasedTask.

        List of conditions that must be met in order for an event based task to run its actions.  # noqa: E501

        :param conditions: The conditions of this EventBasedTask.  # noqa: E501
        :type: list[EventBasedTaskCondition]
        """

        self._conditions = conditions

    @property
    def id(self):
        """Gets the id of this EventBasedTask.  # noqa: E501

        Event based task identifier. Searchable as ID.  # noqa: E501

        :return: The id of this EventBasedTask.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EventBasedTask.

        Event based task identifier. Searchable as ID.  # noqa: E501

        :param id: The id of this EventBasedTask.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventBasedTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventBasedTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

