# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.activity_monitoring_computer_extension import ActivityMonitoringComputerExtension  # noqa: F401,E501
from deepsecurity.models.anti_malware_computer_extension import AntiMalwareComputerExtension  # noqa: F401,E501
from deepsecurity.models.application_control_computer_extension import ApplicationControlComputerExtension  # noqa: F401,E501
from deepsecurity.models.azure_arm_virtual_machine_summary import AzureARMVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.azure_vm_virtual_machine_summary import AzureVMVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.computer_settings import ComputerSettings  # noqa: F401,E501
from deepsecurity.models.computer_status import ComputerStatus  # noqa: F401,E501
from deepsecurity.models.computer_tasks import ComputerTasks  # noqa: F401,E501
from deepsecurity.models.ec2_virtual_machine_summary import Ec2VirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.esx_summary import ESXSummary  # noqa: F401,E501
from deepsecurity.models.firewall_computer_extension import FirewallComputerExtension  # noqa: F401,E501
from deepsecurity.models.gcp_virtual_machine_summary import GcpVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.integrity_monitoring_computer_extension import IntegrityMonitoringComputerExtension  # noqa: F401,E501
from deepsecurity.models.interfaces import Interfaces  # noqa: F401,E501
from deepsecurity.models.intrusion_prevention_computer_extension import IntrusionPreventionComputerExtension  # noqa: F401,E501
from deepsecurity.models.log_inspection_computer_extension import LogInspectionComputerExtension  # noqa: F401,E501
from deepsecurity.models.no_connector_virtual_machine_summary import NoConnectorVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.sap_computer_extension import SAPComputerExtension  # noqa: F401,E501
from deepsecurity.models.security_updates import SecurityUpdates  # noqa: F401,E501
from deepsecurity.models.vcloud_vm_virtual_machine_summary import VcloudVMVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.vmware_vm_virtual_machine_summary import VmwareVMVirtualMachineSummary  # noqa: F401,E501
from deepsecurity.models.web_reputation_computer_extension import WebReputationComputerExtension  # noqa: F401,E501
from deepsecurity.models.workspace_virtual_machine_summary import WorkspaceVirtualMachineSummary  # noqa: F401,E501


class Computer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host_name': 'str',
        'display_name': 'str',
        'description': 'str',
        'last_ip_used': 'str',
        'platform': 'str',
        'group_id': 'int',
        'policy_id': 'int',
        'asset_importance_id': 'int',
        'relay_list_id': 'int',
        'agent_finger_print': 'str',
        'appliance_finger_print': 'str',
        'last_agent_communication': 'int',
        'last_appliance_communication': 'int',
        'last_send_policy_request': 'int',
        'last_send_policy_success': 'int',
        'agent_version': 'str',
        'computer_status': 'ComputerStatus',
        'tasks': 'ComputerTasks',
        'security_updates': 'SecurityUpdates',
        'computer_settings': 'ComputerSettings',
        'interfaces': 'Interfaces',
        'bios_uuid': 'str',
        'azure_arm_virtual_machine_summary': 'AzureARMVirtualMachineSummary',
        'azure_vm_virtual_machine_summary': 'AzureVMVirtualMachineSummary',
        'ec2_virtual_machine_summary': 'Ec2VirtualMachineSummary',
        'no_connector_virtual_machine_summary': 'NoConnectorVirtualMachineSummary',
        'vmware_vm_virtual_machine_summary': 'VmwareVMVirtualMachineSummary',
        'vcloud_vm_virtual_machine_summary': 'VcloudVMVirtualMachineSummary',
        'workspace_virtual_machine_summary': 'WorkspaceVirtualMachineSummary',
        'gcp_virtual_machine_summary': 'GcpVirtualMachineSummary',
        'host_guid': 'str',
        'id': 'int',
        'anti_malware': 'AntiMalwareComputerExtension',
        'web_reputation': 'WebReputationComputerExtension',
        'activity_monitoring': 'ActivityMonitoringComputerExtension',
        'firewall': 'FirewallComputerExtension',
        'intrusion_prevention': 'IntrusionPreventionComputerExtension',
        'integrity_monitoring': 'IntegrityMonitoringComputerExtension',
        'log_inspection': 'LogInspectionComputerExtension',
        'application_control': 'ApplicationControlComputerExtension',
        'esx_summary': 'ESXSummary',
        'sap': 'SAPComputerExtension'
    }

    attribute_map = {
        'host_name': 'hostName',
        'display_name': 'displayName',
        'description': 'description',
        'last_ip_used': 'lastIPUsed',
        'platform': 'platform',
        'group_id': 'groupID',
        'policy_id': 'policyID',
        'asset_importance_id': 'assetImportanceID',
        'relay_list_id': 'relayListID',
        'agent_finger_print': 'agentFingerPrint',
        'appliance_finger_print': 'applianceFingerPrint',
        'last_agent_communication': 'lastAgentCommunication',
        'last_appliance_communication': 'lastApplianceCommunication',
        'last_send_policy_request': 'lastSendPolicyRequest',
        'last_send_policy_success': 'lastSendPolicySuccess',
        'agent_version': 'agentVersion',
        'computer_status': 'computerStatus',
        'tasks': 'tasks',
        'security_updates': 'securityUpdates',
        'computer_settings': 'computerSettings',
        'interfaces': 'interfaces',
        'bios_uuid': 'biosUUID',
        'azure_arm_virtual_machine_summary': 'azureARMVirtualMachineSummary',
        'azure_vm_virtual_machine_summary': 'azureVMVirtualMachineSummary',
        'ec2_virtual_machine_summary': 'ec2VirtualMachineSummary',
        'no_connector_virtual_machine_summary': 'noConnectorVirtualMachineSummary',
        'vmware_vm_virtual_machine_summary': 'vmwareVMVirtualMachineSummary',
        'vcloud_vm_virtual_machine_summary': 'vcloudVMVirtualMachineSummary',
        'workspace_virtual_machine_summary': 'workspaceVirtualMachineSummary',
        'gcp_virtual_machine_summary': 'gcpVirtualMachineSummary',
        'host_guid': 'hostGUID',
        'id': 'ID',
        'anti_malware': 'antiMalware',
        'web_reputation': 'webReputation',
        'activity_monitoring': 'activityMonitoring',
        'firewall': 'firewall',
        'intrusion_prevention': 'intrusionPrevention',
        'integrity_monitoring': 'integrityMonitoring',
        'log_inspection': 'logInspection',
        'application_control': 'applicationControl',
        'esx_summary': 'ESXSummary',
        'sap': 'SAP'
    }

    def __init__(self, host_name=None, display_name=None, description=None, last_ip_used=None, platform=None, group_id=None, policy_id=None, asset_importance_id=None, relay_list_id=None, agent_finger_print=None, appliance_finger_print=None, last_agent_communication=None, last_appliance_communication=None, last_send_policy_request=None, last_send_policy_success=None, agent_version=None, computer_status=None, tasks=None, security_updates=None, computer_settings=None, interfaces=None, bios_uuid=None, azure_arm_virtual_machine_summary=None, azure_vm_virtual_machine_summary=None, ec2_virtual_machine_summary=None, no_connector_virtual_machine_summary=None, vmware_vm_virtual_machine_summary=None, vcloud_vm_virtual_machine_summary=None, workspace_virtual_machine_summary=None, gcp_virtual_machine_summary=None, host_guid=None, id=None, anti_malware=None, web_reputation=None, activity_monitoring=None, firewall=None, intrusion_prevention=None, integrity_monitoring=None, log_inspection=None, application_control=None, esx_summary=None, sap=None):  # noqa: E501
        """Computer - a model defined in Swagger"""  # noqa: E501

        self._host_name = None
        self._display_name = None
        self._description = None
        self._last_ip_used = None
        self._platform = None
        self._group_id = None
        self._policy_id = None
        self._asset_importance_id = None
        self._relay_list_id = None
        self._agent_finger_print = None
        self._appliance_finger_print = None
        self._last_agent_communication = None
        self._last_appliance_communication = None
        self._last_send_policy_request = None
        self._last_send_policy_success = None
        self._agent_version = None
        self._computer_status = None
        self._tasks = None
        self._security_updates = None
        self._computer_settings = None
        self._interfaces = None
        self._bios_uuid = None
        self._azure_arm_virtual_machine_summary = None
        self._azure_vm_virtual_machine_summary = None
        self._ec2_virtual_machine_summary = None
        self._no_connector_virtual_machine_summary = None
        self._vmware_vm_virtual_machine_summary = None
        self._vcloud_vm_virtual_machine_summary = None
        self._workspace_virtual_machine_summary = None
        self._gcp_virtual_machine_summary = None
        self._host_guid = None
        self._id = None
        self._anti_malware = None
        self._web_reputation = None
        self._activity_monitoring = None
        self._firewall = None
        self._intrusion_prevention = None
        self._integrity_monitoring = None
        self._log_inspection = None
        self._application_control = None
        self._esx_summary = None
        self._sap = None
        self.discriminator = None

        if host_name is not None:
            self.host_name = host_name
        if display_name is not None:
            self.display_name = display_name
        if description is not None:
            self.description = description
        if last_ip_used is not None:
            self.last_ip_used = last_ip_used
        if platform is not None:
            self.platform = platform
        if group_id is not None:
            self.group_id = group_id
        if policy_id is not None:
            self.policy_id = policy_id
        if asset_importance_id is not None:
            self.asset_importance_id = asset_importance_id
        if relay_list_id is not None:
            self.relay_list_id = relay_list_id
        if agent_finger_print is not None:
            self.agent_finger_print = agent_finger_print
        if appliance_finger_print is not None:
            self.appliance_finger_print = appliance_finger_print
        if last_agent_communication is not None:
            self.last_agent_communication = last_agent_communication
        if last_appliance_communication is not None:
            self.last_appliance_communication = last_appliance_communication
        if last_send_policy_request is not None:
            self.last_send_policy_request = last_send_policy_request
        if last_send_policy_success is not None:
            self.last_send_policy_success = last_send_policy_success
        if agent_version is not None:
            self.agent_version = agent_version
        if computer_status is not None:
            self.computer_status = computer_status
        if tasks is not None:
            self.tasks = tasks
        if security_updates is not None:
            self.security_updates = security_updates
        if computer_settings is not None:
            self.computer_settings = computer_settings
        if interfaces is not None:
            self.interfaces = interfaces
        if bios_uuid is not None:
            self.bios_uuid = bios_uuid
        if azure_arm_virtual_machine_summary is not None:
            self.azure_arm_virtual_machine_summary = azure_arm_virtual_machine_summary
        if azure_vm_virtual_machine_summary is not None:
            self.azure_vm_virtual_machine_summary = azure_vm_virtual_machine_summary
        if ec2_virtual_machine_summary is not None:
            self.ec2_virtual_machine_summary = ec2_virtual_machine_summary
        if no_connector_virtual_machine_summary is not None:
            self.no_connector_virtual_machine_summary = no_connector_virtual_machine_summary
        if vmware_vm_virtual_machine_summary is not None:
            self.vmware_vm_virtual_machine_summary = vmware_vm_virtual_machine_summary
        if vcloud_vm_virtual_machine_summary is not None:
            self.vcloud_vm_virtual_machine_summary = vcloud_vm_virtual_machine_summary
        if workspace_virtual_machine_summary is not None:
            self.workspace_virtual_machine_summary = workspace_virtual_machine_summary
        if gcp_virtual_machine_summary is not None:
            self.gcp_virtual_machine_summary = gcp_virtual_machine_summary
        if host_guid is not None:
            self.host_guid = host_guid
        if id is not None:
            self.id = id
        if anti_malware is not None:
            self.anti_malware = anti_malware
        if web_reputation is not None:
            self.web_reputation = web_reputation
        if activity_monitoring is not None:
            self.activity_monitoring = activity_monitoring
        if firewall is not None:
            self.firewall = firewall
        if intrusion_prevention is not None:
            self.intrusion_prevention = intrusion_prevention
        if integrity_monitoring is not None:
            self.integrity_monitoring = integrity_monitoring
        if log_inspection is not None:
            self.log_inspection = log_inspection
        if application_control is not None:
            self.application_control = application_control
        if esx_summary is not None:
            self.esx_summary = esx_summary
        if sap is not None:
            self.sap = sap

    @property
    def host_name(self):
        """Gets the host_name of this Computer.  # noqa: E501

        Hostname of the computer. Searchable as String.  # noqa: E501

        :return: The host_name of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """Sets the host_name of this Computer.

        Hostname of the computer. Searchable as String.  # noqa: E501

        :param host_name: The host_name of this Computer.  # noqa: E501
        :type: str
        """

        self._host_name = host_name

    @property
    def display_name(self):
        """Gets the display_name of this Computer.  # noqa: E501

        Display name of the computer. Searchable as String.  # noqa: E501

        :return: The display_name of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Computer.

        Display name of the computer. Searchable as String.  # noqa: E501

        :param display_name: The display_name of this Computer.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """Gets the description of this Computer.  # noqa: E501

        Description of the computer. Searchable as String.  # noqa: E501

        :return: The description of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Computer.

        Description of the computer. Searchable as String.  # noqa: E501

        :param description: The description of this Computer.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def last_ip_used(self):
        """Gets the last_ip_used of this Computer.  # noqa: E501

        Most recent IP address used by the computer. This value is null when the computer is not activated. Searchable as String.  # noqa: E501

        :return: The last_ip_used of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._last_ip_used

    @last_ip_used.setter
    def last_ip_used(self, last_ip_used):
        """Sets the last_ip_used of this Computer.

        Most recent IP address used by the computer. This value is null when the computer is not activated. Searchable as String.  # noqa: E501

        :param last_ip_used: The last_ip_used of this Computer.  # noqa: E501
        :type: str
        """

        self._last_ip_used = last_ip_used

    @property
    def platform(self):
        """Gets the platform of this Computer.  # noqa: E501

        Platform of the computer. Automatically detected and set. Searchable as String  # noqa: E501

        :return: The platform of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this Computer.

        Platform of the computer. Automatically detected and set. Searchable as String  # noqa: E501

        :param platform: The platform of this Computer.  # noqa: E501
        :type: str
        """

        self._platform = platform

    @property
    def group_id(self):
        """Gets the group_id of this Computer.  # noqa: E501

        ID of the computer group to which the computer belongs. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The group_id of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this Computer.

        ID of the computer group to which the computer belongs. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param group_id: The group_id of this Computer.  # noqa: E501
        :type: int
        """

        self._group_id = group_id

    @property
    def policy_id(self):
        """Gets the policy_id of this Computer.  # noqa: E501

        ID of the policy assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The policy_id of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._policy_id

    @policy_id.setter
    def policy_id(self, policy_id):
        """Sets the policy_id of this Computer.

        ID of the policy assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param policy_id: The policy_id of this Computer.  # noqa: E501
        :type: int
        """

        self._policy_id = policy_id

    @property
    def asset_importance_id(self):
        """Gets the asset_importance_id of this Computer.  # noqa: E501

        ID of the asset importance assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The asset_importance_id of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._asset_importance_id

    @asset_importance_id.setter
    def asset_importance_id(self, asset_importance_id):
        """Sets the asset_importance_id of this Computer.

        ID of the asset importance assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param asset_importance_id: The asset_importance_id of this Computer.  # noqa: E501
        :type: int
        """

        self._asset_importance_id = asset_importance_id

    @property
    def relay_list_id(self):
        """Gets the relay_list_id of this Computer.  # noqa: E501

        ID of the relay list that is assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The relay_list_id of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._relay_list_id

    @relay_list_id.setter
    def relay_list_id(self, relay_list_id):
        """Sets the relay_list_id of this Computer.

        ID of the relay list that is assigned to the computer. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param relay_list_id: The relay_list_id of this Computer.  # noqa: E501
        :type: int
        """

        self._relay_list_id = relay_list_id

    @property
    def agent_finger_print(self):
        """Gets the agent_finger_print of this Computer.  # noqa: E501

        FingerPrint of the Agent on the computer. This value is null when no agent is installed or activated. Searchable as String.  # noqa: E501

        :return: The agent_finger_print of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._agent_finger_print

    @agent_finger_print.setter
    def agent_finger_print(self, agent_finger_print):
        """Sets the agent_finger_print of this Computer.

        FingerPrint of the Agent on the computer. This value is null when no agent is installed or activated. Searchable as String.  # noqa: E501

        :param agent_finger_print: The agent_finger_print of this Computer.  # noqa: E501
        :type: str
        """

        self._agent_finger_print = agent_finger_print

    @property
    def appliance_finger_print(self):
        """Gets the appliance_finger_print of this Computer.  # noqa: E501

        FingerPrint of the Appliance protecting the computer. This value is null when no Deep Security Virtual Appliance is protecting the computer.  # noqa: E501

        :return: The appliance_finger_print of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._appliance_finger_print

    @appliance_finger_print.setter
    def appliance_finger_print(self, appliance_finger_print):
        """Sets the appliance_finger_print of this Computer.

        FingerPrint of the Appliance protecting the computer. This value is null when no Deep Security Virtual Appliance is protecting the computer.  # noqa: E501

        :param appliance_finger_print: The appliance_finger_print of this Computer.  # noqa: E501
        :type: str
        """

        self._appliance_finger_print = appliance_finger_print

    @property
    def last_agent_communication(self):
        """Gets the last_agent_communication of this Computer.  # noqa: E501

        Timestamp of the last agent communication, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The last_agent_communication of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._last_agent_communication

    @last_agent_communication.setter
    def last_agent_communication(self, last_agent_communication):
        """Sets the last_agent_communication of this Computer.

        Timestamp of the last agent communication, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param last_agent_communication: The last_agent_communication of this Computer.  # noqa: E501
        :type: int
        """

        self._last_agent_communication = last_agent_communication

    @property
    def last_appliance_communication(self):
        """Gets the last_appliance_communication of this Computer.  # noqa: E501

        Timestamp of the last appliance communication, in milliseconds since epoch.  # noqa: E501

        :return: The last_appliance_communication of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._last_appliance_communication

    @last_appliance_communication.setter
    def last_appliance_communication(self, last_appliance_communication):
        """Sets the last_appliance_communication of this Computer.

        Timestamp of the last appliance communication, in milliseconds since epoch.  # noqa: E501

        :param last_appliance_communication: The last_appliance_communication of this Computer.  # noqa: E501
        :type: int
        """

        self._last_appliance_communication = last_appliance_communication

    @property
    def last_send_policy_request(self):
        """Gets the last_send_policy_request of this Computer.  # noqa: E501

        Timestamp of the last policy request sent, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The last_send_policy_request of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._last_send_policy_request

    @last_send_policy_request.setter
    def last_send_policy_request(self, last_send_policy_request):
        """Sets the last_send_policy_request of this Computer.

        Timestamp of the last policy request sent, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param last_send_policy_request: The last_send_policy_request of this Computer.  # noqa: E501
        :type: int
        """

        self._last_send_policy_request = last_send_policy_request

    @property
    def last_send_policy_success(self):
        """Gets the last_send_policy_success of this Computer.  # noqa: E501

        Timestamp of last successful policy sent, in milliseconds since epoch.  Searchable as Date.  # noqa: E501

        :return: The last_send_policy_success of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._last_send_policy_success

    @last_send_policy_success.setter
    def last_send_policy_success(self, last_send_policy_success):
        """Sets the last_send_policy_success of this Computer.

        Timestamp of last successful policy sent, in milliseconds since epoch.  Searchable as Date.  # noqa: E501

        :param last_send_policy_success: The last_send_policy_success of this Computer.  # noqa: E501
        :type: int
        """

        self._last_send_policy_success = last_send_policy_success

    @property
    def agent_version(self):
        """Gets the agent_version of this Computer.  # noqa: E501

        Version of Deep Security Agent that is installed on the computer. When no agent software is installed or activated, the version is '0.0.0.0'. Searchable as String, however to search for computers without an agent, search for computers that have no agent fingerprint.'.  # noqa: E501

        :return: The agent_version of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._agent_version

    @agent_version.setter
    def agent_version(self, agent_version):
        """Sets the agent_version of this Computer.

        Version of Deep Security Agent that is installed on the computer. When no agent software is installed or activated, the version is '0.0.0.0'. Searchable as String, however to search for computers without an agent, search for computers that have no agent fingerprint.'.  # noqa: E501

        :param agent_version: The agent_version of this Computer.  # noqa: E501
        :type: str
        """

        self._agent_version = agent_version

    @property
    def computer_status(self):
        """Gets the computer_status of this Computer.  # noqa: E501


        :return: The computer_status of this Computer.  # noqa: E501
        :rtype: ComputerStatus
        """
        return self._computer_status

    @computer_status.setter
    def computer_status(self, computer_status):
        """Sets the computer_status of this Computer.


        :param computer_status: The computer_status of this Computer.  # noqa: E501
        :type: ComputerStatus
        """

        self._computer_status = computer_status

    @property
    def tasks(self):
        """Gets the tasks of this Computer.  # noqa: E501


        :return: The tasks of this Computer.  # noqa: E501
        :rtype: ComputerTasks
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this Computer.


        :param tasks: The tasks of this Computer.  # noqa: E501
        :type: ComputerTasks
        """

        self._tasks = tasks

    @property
    def security_updates(self):
        """Gets the security_updates of this Computer.  # noqa: E501

        Security Update information.  # noqa: E501

        :return: The security_updates of this Computer.  # noqa: E501
        :rtype: SecurityUpdates
        """
        return self._security_updates

    @security_updates.setter
    def security_updates(self, security_updates):
        """Sets the security_updates of this Computer.

        Security Update information.  # noqa: E501

        :param security_updates: The security_updates of this Computer.  # noqa: E501
        :type: SecurityUpdates
        """

        self._security_updates = security_updates

    @property
    def computer_settings(self):
        """Gets the computer_settings of this Computer.  # noqa: E501

        Settings that can be applied directly to the computer. Those settings will generally override policy settings.  # noqa: E501

        :return: The computer_settings of this Computer.  # noqa: E501
        :rtype: ComputerSettings
        """
        return self._computer_settings

    @computer_settings.setter
    def computer_settings(self, computer_settings):
        """Sets the computer_settings of this Computer.

        Settings that can be applied directly to the computer. Those settings will generally override policy settings.  # noqa: E501

        :param computer_settings: The computer_settings of this Computer.  # noqa: E501
        :type: ComputerSettings
        """

        self._computer_settings = computer_settings

    @property
    def interfaces(self):
        """Gets the interfaces of this Computer.  # noqa: E501

        List of interfaces detected on the computer. This value is null when the computer is not activated.  # noqa: E501

        :return: The interfaces of this Computer.  # noqa: E501
        :rtype: Interfaces
        """
        return self._interfaces

    @interfaces.setter
    def interfaces(self, interfaces):
        """Sets the interfaces of this Computer.

        List of interfaces detected on the computer. This value is null when the computer is not activated.  # noqa: E501

        :param interfaces: The interfaces of this Computer.  # noqa: E501
        :type: Interfaces
        """

        self._interfaces = interfaces

    @property
    def bios_uuid(self):
        """Gets the bios_uuid of this Computer.  # noqa: E501

        BIOS UUID, for example: \"421e1137-5c49-56e4-246d-9bf7637e69f5\". Only applies to VMware VMs.  # noqa: E501

        :return: The bios_uuid of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._bios_uuid

    @bios_uuid.setter
    def bios_uuid(self, bios_uuid):
        """Sets the bios_uuid of this Computer.

        BIOS UUID, for example: \"421e1137-5c49-56e4-246d-9bf7637e69f5\". Only applies to VMware VMs.  # noqa: E501

        :param bios_uuid: The bios_uuid of this Computer.  # noqa: E501
        :type: str
        """

        self._bios_uuid = bios_uuid

    @property
    def azure_arm_virtual_machine_summary(self):
        """Gets the azure_arm_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The azure_arm_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: AzureARMVirtualMachineSummary
        """
        return self._azure_arm_virtual_machine_summary

    @azure_arm_virtual_machine_summary.setter
    def azure_arm_virtual_machine_summary(self, azure_arm_virtual_machine_summary):
        """Sets the azure_arm_virtual_machine_summary of this Computer.


        :param azure_arm_virtual_machine_summary: The azure_arm_virtual_machine_summary of this Computer.  # noqa: E501
        :type: AzureARMVirtualMachineSummary
        """

        self._azure_arm_virtual_machine_summary = azure_arm_virtual_machine_summary

    @property
    def azure_vm_virtual_machine_summary(self):
        """Gets the azure_vm_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The azure_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: AzureVMVirtualMachineSummary
        """
        return self._azure_vm_virtual_machine_summary

    @azure_vm_virtual_machine_summary.setter
    def azure_vm_virtual_machine_summary(self, azure_vm_virtual_machine_summary):
        """Sets the azure_vm_virtual_machine_summary of this Computer.


        :param azure_vm_virtual_machine_summary: The azure_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :type: AzureVMVirtualMachineSummary
        """

        self._azure_vm_virtual_machine_summary = azure_vm_virtual_machine_summary

    @property
    def ec2_virtual_machine_summary(self):
        """Gets the ec2_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The ec2_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: Ec2VirtualMachineSummary
        """
        return self._ec2_virtual_machine_summary

    @ec2_virtual_machine_summary.setter
    def ec2_virtual_machine_summary(self, ec2_virtual_machine_summary):
        """Sets the ec2_virtual_machine_summary of this Computer.


        :param ec2_virtual_machine_summary: The ec2_virtual_machine_summary of this Computer.  # noqa: E501
        :type: Ec2VirtualMachineSummary
        """

        self._ec2_virtual_machine_summary = ec2_virtual_machine_summary

    @property
    def no_connector_virtual_machine_summary(self):
        """Gets the no_connector_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The no_connector_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: NoConnectorVirtualMachineSummary
        """
        return self._no_connector_virtual_machine_summary

    @no_connector_virtual_machine_summary.setter
    def no_connector_virtual_machine_summary(self, no_connector_virtual_machine_summary):
        """Sets the no_connector_virtual_machine_summary of this Computer.


        :param no_connector_virtual_machine_summary: The no_connector_virtual_machine_summary of this Computer.  # noqa: E501
        :type: NoConnectorVirtualMachineSummary
        """

        self._no_connector_virtual_machine_summary = no_connector_virtual_machine_summary

    @property
    def vmware_vm_virtual_machine_summary(self):
        """Gets the vmware_vm_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The vmware_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: VmwareVMVirtualMachineSummary
        """
        return self._vmware_vm_virtual_machine_summary

    @vmware_vm_virtual_machine_summary.setter
    def vmware_vm_virtual_machine_summary(self, vmware_vm_virtual_machine_summary):
        """Sets the vmware_vm_virtual_machine_summary of this Computer.


        :param vmware_vm_virtual_machine_summary: The vmware_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :type: VmwareVMVirtualMachineSummary
        """

        self._vmware_vm_virtual_machine_summary = vmware_vm_virtual_machine_summary

    @property
    def vcloud_vm_virtual_machine_summary(self):
        """Gets the vcloud_vm_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The vcloud_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: VcloudVMVirtualMachineSummary
        """
        return self._vcloud_vm_virtual_machine_summary

    @vcloud_vm_virtual_machine_summary.setter
    def vcloud_vm_virtual_machine_summary(self, vcloud_vm_virtual_machine_summary):
        """Sets the vcloud_vm_virtual_machine_summary of this Computer.


        :param vcloud_vm_virtual_machine_summary: The vcloud_vm_virtual_machine_summary of this Computer.  # noqa: E501
        :type: VcloudVMVirtualMachineSummary
        """

        self._vcloud_vm_virtual_machine_summary = vcloud_vm_virtual_machine_summary

    @property
    def workspace_virtual_machine_summary(self):
        """Gets the workspace_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The workspace_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: WorkspaceVirtualMachineSummary
        """
        return self._workspace_virtual_machine_summary

    @workspace_virtual_machine_summary.setter
    def workspace_virtual_machine_summary(self, workspace_virtual_machine_summary):
        """Sets the workspace_virtual_machine_summary of this Computer.


        :param workspace_virtual_machine_summary: The workspace_virtual_machine_summary of this Computer.  # noqa: E501
        :type: WorkspaceVirtualMachineSummary
        """

        self._workspace_virtual_machine_summary = workspace_virtual_machine_summary

    @property
    def gcp_virtual_machine_summary(self):
        """Gets the gcp_virtual_machine_summary of this Computer.  # noqa: E501


        :return: The gcp_virtual_machine_summary of this Computer.  # noqa: E501
        :rtype: GcpVirtualMachineSummary
        """
        return self._gcp_virtual_machine_summary

    @gcp_virtual_machine_summary.setter
    def gcp_virtual_machine_summary(self, gcp_virtual_machine_summary):
        """Sets the gcp_virtual_machine_summary of this Computer.


        :param gcp_virtual_machine_summary: The gcp_virtual_machine_summary of this Computer.  # noqa: E501
        :type: GcpVirtualMachineSummary
        """

        self._gcp_virtual_machine_summary = gcp_virtual_machine_summary

    @property
    def host_guid(self):
        """Gets the host_guid of this Computer.  # noqa: E501

        HostGUID of the computer. Searchable as String.  # noqa: E501

        :return: The host_guid of this Computer.  # noqa: E501
        :rtype: str
        """
        return self._host_guid

    @host_guid.setter
    def host_guid(self, host_guid):
        """Sets the host_guid of this Computer.

        HostGUID of the computer. Searchable as String.  # noqa: E501

        :param host_guid: The host_guid of this Computer.  # noqa: E501
        :type: str
        """

        self._host_guid = host_guid

    @property
    def id(self):
        """Gets the id of this Computer.  # noqa: E501

        ID of the computer. Searchable as ID.  # noqa: E501

        :return: The id of this Computer.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Computer.

        ID of the computer. Searchable as ID.  # noqa: E501

        :param id: The id of this Computer.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def anti_malware(self):
        """Gets the anti_malware of this Computer.  # noqa: E501


        :return: The anti_malware of this Computer.  # noqa: E501
        :rtype: AntiMalwareComputerExtension
        """
        return self._anti_malware

    @anti_malware.setter
    def anti_malware(self, anti_malware):
        """Sets the anti_malware of this Computer.


        :param anti_malware: The anti_malware of this Computer.  # noqa: E501
        :type: AntiMalwareComputerExtension
        """

        self._anti_malware = anti_malware

    @property
    def web_reputation(self):
        """Gets the web_reputation of this Computer.  # noqa: E501


        :return: The web_reputation of this Computer.  # noqa: E501
        :rtype: WebReputationComputerExtension
        """
        return self._web_reputation

    @web_reputation.setter
    def web_reputation(self, web_reputation):
        """Sets the web_reputation of this Computer.


        :param web_reputation: The web_reputation of this Computer.  # noqa: E501
        :type: WebReputationComputerExtension
        """

        self._web_reputation = web_reputation

    @property
    def activity_monitoring(self):
        """Gets the activity_monitoring of this Computer.  # noqa: E501


        :return: The activity_monitoring of this Computer.  # noqa: E501
        :rtype: ActivityMonitoringComputerExtension
        """
        return self._activity_monitoring

    @activity_monitoring.setter
    def activity_monitoring(self, activity_monitoring):
        """Sets the activity_monitoring of this Computer.


        :param activity_monitoring: The activity_monitoring of this Computer.  # noqa: E501
        :type: ActivityMonitoringComputerExtension
        """

        self._activity_monitoring = activity_monitoring

    @property
    def firewall(self):
        """Gets the firewall of this Computer.  # noqa: E501


        :return: The firewall of this Computer.  # noqa: E501
        :rtype: FirewallComputerExtension
        """
        return self._firewall

    @firewall.setter
    def firewall(self, firewall):
        """Sets the firewall of this Computer.


        :param firewall: The firewall of this Computer.  # noqa: E501
        :type: FirewallComputerExtension
        """

        self._firewall = firewall

    @property
    def intrusion_prevention(self):
        """Gets the intrusion_prevention of this Computer.  # noqa: E501


        :return: The intrusion_prevention of this Computer.  # noqa: E501
        :rtype: IntrusionPreventionComputerExtension
        """
        return self._intrusion_prevention

    @intrusion_prevention.setter
    def intrusion_prevention(self, intrusion_prevention):
        """Sets the intrusion_prevention of this Computer.


        :param intrusion_prevention: The intrusion_prevention of this Computer.  # noqa: E501
        :type: IntrusionPreventionComputerExtension
        """

        self._intrusion_prevention = intrusion_prevention

    @property
    def integrity_monitoring(self):
        """Gets the integrity_monitoring of this Computer.  # noqa: E501


        :return: The integrity_monitoring of this Computer.  # noqa: E501
        :rtype: IntegrityMonitoringComputerExtension
        """
        return self._integrity_monitoring

    @integrity_monitoring.setter
    def integrity_monitoring(self, integrity_monitoring):
        """Sets the integrity_monitoring of this Computer.


        :param integrity_monitoring: The integrity_monitoring of this Computer.  # noqa: E501
        :type: IntegrityMonitoringComputerExtension
        """

        self._integrity_monitoring = integrity_monitoring

    @property
    def log_inspection(self):
        """Gets the log_inspection of this Computer.  # noqa: E501


        :return: The log_inspection of this Computer.  # noqa: E501
        :rtype: LogInspectionComputerExtension
        """
        return self._log_inspection

    @log_inspection.setter
    def log_inspection(self, log_inspection):
        """Sets the log_inspection of this Computer.


        :param log_inspection: The log_inspection of this Computer.  # noqa: E501
        :type: LogInspectionComputerExtension
        """

        self._log_inspection = log_inspection

    @property
    def application_control(self):
        """Gets the application_control of this Computer.  # noqa: E501


        :return: The application_control of this Computer.  # noqa: E501
        :rtype: ApplicationControlComputerExtension
        """
        return self._application_control

    @application_control.setter
    def application_control(self, application_control):
        """Sets the application_control of this Computer.


        :param application_control: The application_control of this Computer.  # noqa: E501
        :type: ApplicationControlComputerExtension
        """

        self._application_control = application_control

    @property
    def esx_summary(self):
        """Gets the esx_summary of this Computer.  # noqa: E501


        :return: The esx_summary of this Computer.  # noqa: E501
        :rtype: ESXSummary
        """
        return self._esx_summary

    @esx_summary.setter
    def esx_summary(self, esx_summary):
        """Sets the esx_summary of this Computer.


        :param esx_summary: The esx_summary of this Computer.  # noqa: E501
        :type: ESXSummary
        """

        self._esx_summary = esx_summary

    @property
    def sap(self):
        """Gets the sap of this Computer.  # noqa: E501


        :return: The sap of this Computer.  # noqa: E501
        :rtype: SAPComputerExtension
        """
        return self._sap

    @sap.setter
    def sap(self, sap):
        """Sets the sap of this Computer.


        :param sap: The sap of this Computer.  # noqa: E501
        :type: SAPComputerExtension
        """

        self._sap = sap

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Computer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Computer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

