# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.certificate_details import CertificateDetails  # noqa: F401,E501


class Certificate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'certificate': 'str',
        'certificate_details': 'CertificateDetails',
        'trusted': 'bool',
        'purpose': 'str'
    }

    attribute_map = {
        'id': 'ID',
        'certificate': 'certificate',
        'certificate_details': 'certificateDetails',
        'trusted': 'trusted',
        'purpose': 'purpose'
    }

    def __init__(self, id=None, certificate=None, certificate_details=None, trusted=None, purpose=None):  # noqa: E501
        """Certificate - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._certificate = None
        self._certificate_details = None
        self._trusted = None
        self._purpose = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if certificate is not None:
            self.certificate = certificate
        if certificate_details is not None:
            self.certificate_details = certificate_details
        if trusted is not None:
            self.trusted = trusted
        if purpose is not None:
            self.purpose = purpose

    @property
    def id(self):
        """Gets the id of this Certificate.  # noqa: E501

        ID of the SSL certificate. This ID is set automatically.  # noqa: E501

        :return: The id of this Certificate.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Certificate.

        ID of the SSL certificate. This ID is set automatically.  # noqa: E501

        :param id: The id of this Certificate.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def certificate(self):
        """Gets the certificate of this Certificate.  # noqa: E501

        The certificate. It's a PEM formatted string  # noqa: E501

        :return: The certificate of this Certificate.  # noqa: E501
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """Sets the certificate of this Certificate.

        The certificate. It's a PEM formatted string  # noqa: E501

        :param certificate: The certificate of this Certificate.  # noqa: E501
        :type: str
        """

        self._certificate = certificate

    @property
    def certificate_details(self):
        """Gets the certificate_details of this Certificate.  # noqa: E501

        Detailed information about the certificate.  # noqa: E501

        :return: The certificate_details of this Certificate.  # noqa: E501
        :rtype: CertificateDetails
        """
        return self._certificate_details

    @certificate_details.setter
    def certificate_details(self, certificate_details):
        """Sets the certificate_details of this Certificate.

        Detailed information about the certificate.  # noqa: E501

        :param certificate_details: The certificate_details of this Certificate.  # noqa: E501
        :type: CertificateDetails
        """

        self._certificate_details = certificate_details

    @property
    def trusted(self):
        """Gets the trusted of this Certificate.  # noqa: E501

        True if the certificate is trusted by Deep Security Manager or verified by a CA.  # noqa: E501

        :return: The trusted of this Certificate.  # noqa: E501
        :rtype: bool
        """
        return self._trusted

    @trusted.setter
    def trusted(self, trusted):
        """Sets the trusted of this Certificate.

        True if the certificate is trusted by Deep Security Manager or verified by a CA.  # noqa: E501

        :param trusted: The trusted of this Certificate.  # noqa: E501
        :type: bool
        """

        self._trusted = trusted

    @property
    def purpose(self):
        """Gets the purpose of this Certificate.  # noqa: E501

        The type of connections for which the certificate is to be used.  # noqa: E501

        :return: The purpose of this Certificate.  # noqa: E501
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """Sets the purpose of this Certificate.

        The type of connections for which the certificate is to be used.  # noqa: E501

        :param purpose: The purpose of this Certificate.  # noqa: E501
        :type: str
        """
        allowed_values = ["SSL"]  # noqa: E501
        if purpose not in allowed_values:
            raise ValueError(
                "Invalid value for `purpose` ({0}), must be one of {1}"  # noqa: E501
                .format(purpose, allowed_values)
            )

        self._purpose = purpose

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Certificate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Certificate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

