# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.aws_region import AWSRegion  # noqa: F401,E501


class AWSConnector(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'display_name': 'str',
        'account_id': 'str',
        'account_alias': 'str',
        'access_key': 'str',
        'secret_key': 'str',
        'seed_region': 'str',
        'use_instance_role': 'bool',
        'cross_account_role_arn': 'str',
        'last_sync_time': 'int',
        'synced_regions': 'list[AWSRegion]',
        'workspaces_enabled': 'bool',
        'id': 'int'
    }

    attribute_map = {
        'display_name': 'displayName',
        'account_id': 'accountId',
        'account_alias': 'accountAlias',
        'access_key': 'accessKey',
        'secret_key': 'secretKey',
        'seed_region': 'seedRegion',
        'use_instance_role': 'useInstanceRole',
        'cross_account_role_arn': 'crossAccountRoleArn',
        'last_sync_time': 'lastSyncTime',
        'synced_regions': 'syncedRegions',
        'workspaces_enabled': 'workspacesEnabled',
        'id': 'ID'
    }

    def __init__(self, display_name=None, account_id=None, account_alias=None, access_key=None, secret_key=None, seed_region=None, use_instance_role=None, cross_account_role_arn=None, last_sync_time=None, synced_regions=None, workspaces_enabled=None, id=None):  # noqa: E501
        """AWSConnector - a model defined in Swagger"""  # noqa: E501

        self._display_name = None
        self._account_id = None
        self._account_alias = None
        self._access_key = None
        self._secret_key = None
        self._seed_region = None
        self._use_instance_role = None
        self._cross_account_role_arn = None
        self._last_sync_time = None
        self._synced_regions = None
        self._workspaces_enabled = None
        self._id = None
        self.discriminator = None

        if display_name is not None:
            self.display_name = display_name
        if account_id is not None:
            self.account_id = account_id
        if account_alias is not None:
            self.account_alias = account_alias
        if access_key is not None:
            self.access_key = access_key
        if secret_key is not None:
            self.secret_key = secret_key
        if seed_region is not None:
            self.seed_region = seed_region
        if use_instance_role is not None:
            self.use_instance_role = use_instance_role
        if cross_account_role_arn is not None:
            self.cross_account_role_arn = cross_account_role_arn
        if last_sync_time is not None:
            self.last_sync_time = last_sync_time
        if synced_regions is not None:
            self.synced_regions = synced_regions
        if workspaces_enabled is not None:
            self.workspaces_enabled = workspaces_enabled
        if id is not None:
            self.id = id

    @property
    def display_name(self):
        """Gets the display_name of this AWSConnector.  # noqa: E501

        The AWS Connector's display name in DSM.  # noqa: E501

        :return: The display_name of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this AWSConnector.

        The AWS Connector's display name in DSM.  # noqa: E501

        :param display_name: The display_name of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def account_id(self):
        """Gets the account_id of this AWSConnector.  # noqa: E501

        The AWS Account ID. Searchable as String.  # noqa: E501

        :return: The account_id of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AWSConnector.

        The AWS Account ID. Searchable as String.  # noqa: E501

        :param account_id: The account_id of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def account_alias(self):
        """Gets the account_alias of this AWSConnector.  # noqa: E501

        The AWS Account Alias. Searchable as String.  # noqa: E501

        :return: The account_alias of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._account_alias

    @account_alias.setter
    def account_alias(self, account_alias):
        """Sets the account_alias of this AWSConnector.

        The AWS Account Alias. Searchable as String.  # noqa: E501

        :param account_alias: The account_alias of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._account_alias = account_alias

    @property
    def access_key(self):
        """Gets the access_key of this AWSConnector.  # noqa: E501

        The AWS Access Key of the account. If used, Cross Account Role ARN is not required. Searchable as String.  # noqa: E501

        :return: The access_key of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._access_key

    @access_key.setter
    def access_key(self, access_key):
        """Sets the access_key of this AWSConnector.

        The AWS Access Key of the account. If used, Cross Account Role ARN is not required. Searchable as String.  # noqa: E501

        :param access_key: The access_key of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._access_key = access_key

    @property
    def secret_key(self):
        """Gets the secret_key of this AWSConnector.  # noqa: E501

        The AWS Secret Key required to add the connector using an Access Key. Not present in returned objects.  # noqa: E501

        :return: The secret_key of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._secret_key

    @secret_key.setter
    def secret_key(self, secret_key):
        """Sets the secret_key of this AWSConnector.

        The AWS Secret Key required to add the connector using an Access Key. Not present in returned objects.  # noqa: E501

        :param secret_key: The secret_key of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._secret_key = secret_key

    @property
    def seed_region(self):
        """Gets the seed_region of this AWSConnector.  # noqa: E501

        The region to initialize the EC2 client in. This is an advanced option used if you want to access special regions. Searchable as String.  # noqa: E501

        :return: The seed_region of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._seed_region

    @seed_region.setter
    def seed_region(self, seed_region):
        """Sets the seed_region of this AWSConnector.

        The region to initialize the EC2 client in. This is an advanced option used if you want to access special regions. Searchable as String.  # noqa: E501

        :param seed_region: The seed_region of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._seed_region = seed_region

    @property
    def use_instance_role(self):
        """Gets the use_instance_role of this AWSConnector.  # noqa: E501

        Specifies whether or not to use the DSM instance role to add the AWS Connector instead of an Access Key or a Cross Account Role ARN.  # noqa: E501

        :return: The use_instance_role of this AWSConnector.  # noqa: E501
        :rtype: bool
        """
        return self._use_instance_role

    @use_instance_role.setter
    def use_instance_role(self, use_instance_role):
        """Sets the use_instance_role of this AWSConnector.

        Specifies whether or not to use the DSM instance role to add the AWS Connector instead of an Access Key or a Cross Account Role ARN.  # noqa: E501

        :param use_instance_role: The use_instance_role of this AWSConnector.  # noqa: E501
        :type: bool
        """

        self._use_instance_role = use_instance_role

    @property
    def cross_account_role_arn(self):
        """Gets the cross_account_role_arn of this AWSConnector.  # noqa: E501

        The Cross Account Role ARN of the AWS account. If used, Access Key is not required. Searchable as String.  # noqa: E501

        :return: The cross_account_role_arn of this AWSConnector.  # noqa: E501
        :rtype: str
        """
        return self._cross_account_role_arn

    @cross_account_role_arn.setter
    def cross_account_role_arn(self, cross_account_role_arn):
        """Sets the cross_account_role_arn of this AWSConnector.

        The Cross Account Role ARN of the AWS account. If used, Access Key is not required. Searchable as String.  # noqa: E501

        :param cross_account_role_arn: The cross_account_role_arn of this AWSConnector.  # noqa: E501
        :type: str
        """

        self._cross_account_role_arn = cross_account_role_arn

    @property
    def last_sync_time(self):
        """Gets the last_sync_time of this AWSConnector.  # noqa: E501

        Timestamp of the last time the AWS Connector was successfully synchronized, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :return: The last_sync_time of this AWSConnector.  # noqa: E501
        :rtype: int
        """
        return self._last_sync_time

    @last_sync_time.setter
    def last_sync_time(self, last_sync_time):
        """Sets the last_sync_time of this AWSConnector.

        Timestamp of the last time the AWS Connector was successfully synchronized, in milliseconds since epoch. Searchable as Date.  # noqa: E501

        :param last_sync_time: The last_sync_time of this AWSConnector.  # noqa: E501
        :type: int
        """

        self._last_sync_time = last_sync_time

    @property
    def synced_regions(self):
        """Gets the synced_regions of this AWSConnector.  # noqa: E501

        The list of AWS regions that have been synchronized for the connector.  # noqa: E501

        :return: The synced_regions of this AWSConnector.  # noqa: E501
        :rtype: list[AWSRegion]
        """
        return self._synced_regions

    @synced_regions.setter
    def synced_regions(self, synced_regions):
        """Sets the synced_regions of this AWSConnector.

        The list of AWS regions that have been synchronized for the connector.  # noqa: E501

        :param synced_regions: The synced_regions of this AWSConnector.  # noqa: E501
        :type: list[AWSRegion]
        """

        self._synced_regions = synced_regions

    @property
    def workspaces_enabled(self):
        """Gets the workspaces_enabled of this AWSConnector.  # noqa: E501

        A flag controlling whether or not Amazon Workspaces are enabled for the connector. Searchable as Boolean. Default is false.  # noqa: E501

        :return: The workspaces_enabled of this AWSConnector.  # noqa: E501
        :rtype: bool
        """
        return self._workspaces_enabled

    @workspaces_enabled.setter
    def workspaces_enabled(self, workspaces_enabled):
        """Sets the workspaces_enabled of this AWSConnector.

        A flag controlling whether or not Amazon Workspaces are enabled for the connector. Searchable as Boolean. Default is false.  # noqa: E501

        :param workspaces_enabled: The workspaces_enabled of this AWSConnector.  # noqa: E501
        :type: bool
        """

        self._workspaces_enabled = workspaces_enabled

    @property
    def id(self):
        """Gets the id of this AWSConnector.  # noqa: E501

        The Deep Security internal ID of the AWS Cloud Connector. Searchable as ID.  # noqa: E501

        :return: The id of this AWSConnector.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AWSConnector.

        The Deep Security internal ID of the AWS Cloud Connector. Searchable as ID.  # noqa: E501

        :param id: The id of this AWSConnector.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AWSConnector, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AWSConnector):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

