# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AntiMalwareConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'scan_type': 'str',
        'document_exploit_protection_enabled': 'bool',
        'document_exploit_protection': 'str',
        'document_exploit_heuristic_level': 'str',
        'machine_learning_enabled': 'bool',
        'behavior_monitoring_enabled': 'bool',
        'document_recovery_enabled': 'bool',
        'intelli_trap_enabled': 'bool',
        'memory_scan_enabled': 'bool',
        'spyware_enabled': 'bool',
        'alert_enabled': 'bool',
        'directories_to_scan': 'str',
        'directory_list_id': 'int',
        'files_to_scan': 'str',
        'file_extension_list_id': 'int',
        'excluded_directory_list_id': 'int',
        'excluded_file_list_id': 'int',
        'excluded_file_extension_list_id': 'int',
        'excluded_process_image_file_list_id': 'int',
        'real_time_scan': 'str',
        'scan_compressed_enabled': 'bool',
        'scan_compressed_maximum_size': 'int',
        'scan_compressed_maximum_levels': 'int',
        'scan_compressed_maximum_files': 'int',
        'microsoft_office_enabled': 'bool',
        'microsoft_office_layers': 'int',
        'network_directories_enabled': 'bool',
        'custom_remediation_actions_enabled': 'bool',
        'custom_scan_actions_enabled': 'bool',
        'scan_action_for_virus': 'str',
        'scan_action_for_trojans': 'str',
        'scan_action_for_packer': 'str',
        'scan_action_for_spyware': 'str',
        'scan_action_for_other_threats': 'str',
        'scan_action_for_cookies': 'str',
        'scan_action_for_cve': 'str',
        'scan_action_for_heuristics': 'str',
        'scan_action_for_possible_malware': 'str',
        'amsi_scan_enabled': 'bool',
        'scan_action_for_behavior_monitoring': 'str',
        'scan_action_for_machine_learning': 'str',
        'scan_action_for_amsi': 'str',
        'id': 'int',
        'cpu_usage': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'scan_type': 'scanType',
        'document_exploit_protection_enabled': 'documentExploitProtectionEnabled',
        'document_exploit_protection': 'documentExploitProtection',
        'document_exploit_heuristic_level': 'documentExploitHeuristicLevel',
        'machine_learning_enabled': 'machineLearningEnabled',
        'behavior_monitoring_enabled': 'behaviorMonitoringEnabled',
        'document_recovery_enabled': 'documentRecoveryEnabled',
        'intelli_trap_enabled': 'intelliTrapEnabled',
        'memory_scan_enabled': 'memoryScanEnabled',
        'spyware_enabled': 'spywareEnabled',
        'alert_enabled': 'alertEnabled',
        'directories_to_scan': 'directoriesToScan',
        'directory_list_id': 'directoryListID',
        'files_to_scan': 'filesToScan',
        'file_extension_list_id': 'fileExtensionListID',
        'excluded_directory_list_id': 'excludedDirectoryListID',
        'excluded_file_list_id': 'excludedFileListID',
        'excluded_file_extension_list_id': 'excludedFileExtensionListID',
        'excluded_process_image_file_list_id': 'excludedProcessImageFileListID',
        'real_time_scan': 'realTimeScan',
        'scan_compressed_enabled': 'scanCompressedEnabled',
        'scan_compressed_maximum_size': 'scanCompressedMaximumSize',
        'scan_compressed_maximum_levels': 'scanCompressedMaximumLevels',
        'scan_compressed_maximum_files': 'scanCompressedMaximumFiles',
        'microsoft_office_enabled': 'microsoftOfficeEnabled',
        'microsoft_office_layers': 'microsoftOfficeLayers',
        'network_directories_enabled': 'networkDirectoriesEnabled',
        'custom_remediation_actions_enabled': 'customRemediationActionsEnabled',
        'custom_scan_actions_enabled': 'customScanActionsEnabled',
        'scan_action_for_virus': 'scanActionForVirus',
        'scan_action_for_trojans': 'scanActionForTrojans',
        'scan_action_for_packer': 'scanActionForPacker',
        'scan_action_for_spyware': 'scanActionForSpyware',
        'scan_action_for_other_threats': 'scanActionForOtherThreats',
        'scan_action_for_cookies': 'scanActionForCookies',
        'scan_action_for_cve': 'scanActionForCVE',
        'scan_action_for_heuristics': 'scanActionForHeuristics',
        'scan_action_for_possible_malware': 'scanActionForPossibleMalware',
        'amsi_scan_enabled': 'amsiScanEnabled',
        'scan_action_for_behavior_monitoring': 'scanActionForBehaviorMonitoring',
        'scan_action_for_machine_learning': 'scanActionForMachineLearning',
        'scan_action_for_amsi': 'scanActionForAmsi',
        'id': 'ID',
        'cpu_usage': 'cpuUsage'
    }

    def __init__(self, name=None, description=None, scan_type=None, document_exploit_protection_enabled=None, document_exploit_protection=None, document_exploit_heuristic_level=None, machine_learning_enabled=None, behavior_monitoring_enabled=None, document_recovery_enabled=None, intelli_trap_enabled=None, memory_scan_enabled=None, spyware_enabled=None, alert_enabled=None, directories_to_scan=None, directory_list_id=None, files_to_scan=None, file_extension_list_id=None, excluded_directory_list_id=None, excluded_file_list_id=None, excluded_file_extension_list_id=None, excluded_process_image_file_list_id=None, real_time_scan=None, scan_compressed_enabled=None, scan_compressed_maximum_size=None, scan_compressed_maximum_levels=None, scan_compressed_maximum_files=None, microsoft_office_enabled=None, microsoft_office_layers=None, network_directories_enabled=None, custom_remediation_actions_enabled=None, custom_scan_actions_enabled=None, scan_action_for_virus=None, scan_action_for_trojans=None, scan_action_for_packer=None, scan_action_for_spyware=None, scan_action_for_other_threats=None, scan_action_for_cookies=None, scan_action_for_cve=None, scan_action_for_heuristics=None, scan_action_for_possible_malware=None, amsi_scan_enabled=None, scan_action_for_behavior_monitoring=None, scan_action_for_machine_learning=None, scan_action_for_amsi=None, id=None, cpu_usage=None):  # noqa: E501
        """AntiMalwareConfiguration - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._description = None
        self._scan_type = None
        self._document_exploit_protection_enabled = None
        self._document_exploit_protection = None
        self._document_exploit_heuristic_level = None
        self._machine_learning_enabled = None
        self._behavior_monitoring_enabled = None
        self._document_recovery_enabled = None
        self._intelli_trap_enabled = None
        self._memory_scan_enabled = None
        self._spyware_enabled = None
        self._alert_enabled = None
        self._directories_to_scan = None
        self._directory_list_id = None
        self._files_to_scan = None
        self._file_extension_list_id = None
        self._excluded_directory_list_id = None
        self._excluded_file_list_id = None
        self._excluded_file_extension_list_id = None
        self._excluded_process_image_file_list_id = None
        self._real_time_scan = None
        self._scan_compressed_enabled = None
        self._scan_compressed_maximum_size = None
        self._scan_compressed_maximum_levels = None
        self._scan_compressed_maximum_files = None
        self._microsoft_office_enabled = None
        self._microsoft_office_layers = None
        self._network_directories_enabled = None
        self._custom_remediation_actions_enabled = None
        self._custom_scan_actions_enabled = None
        self._scan_action_for_virus = None
        self._scan_action_for_trojans = None
        self._scan_action_for_packer = None
        self._scan_action_for_spyware = None
        self._scan_action_for_other_threats = None
        self._scan_action_for_cookies = None
        self._scan_action_for_cve = None
        self._scan_action_for_heuristics = None
        self._scan_action_for_possible_malware = None
        self._amsi_scan_enabled = None
        self._scan_action_for_behavior_monitoring = None
        self._scan_action_for_machine_learning = None
        self._scan_action_for_amsi = None
        self._id = None
        self._cpu_usage = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if scan_type is not None:
            self.scan_type = scan_type
        if document_exploit_protection_enabled is not None:
            self.document_exploit_protection_enabled = document_exploit_protection_enabled
        if document_exploit_protection is not None:
            self.document_exploit_protection = document_exploit_protection
        if document_exploit_heuristic_level is not None:
            self.document_exploit_heuristic_level = document_exploit_heuristic_level
        if machine_learning_enabled is not None:
            self.machine_learning_enabled = machine_learning_enabled
        if behavior_monitoring_enabled is not None:
            self.behavior_monitoring_enabled = behavior_monitoring_enabled
        if document_recovery_enabled is not None:
            self.document_recovery_enabled = document_recovery_enabled
        if intelli_trap_enabled is not None:
            self.intelli_trap_enabled = intelli_trap_enabled
        if memory_scan_enabled is not None:
            self.memory_scan_enabled = memory_scan_enabled
        if spyware_enabled is not None:
            self.spyware_enabled = spyware_enabled
        if alert_enabled is not None:
            self.alert_enabled = alert_enabled
        if directories_to_scan is not None:
            self.directories_to_scan = directories_to_scan
        if directory_list_id is not None:
            self.directory_list_id = directory_list_id
        if files_to_scan is not None:
            self.files_to_scan = files_to_scan
        if file_extension_list_id is not None:
            self.file_extension_list_id = file_extension_list_id
        if excluded_directory_list_id is not None:
            self.excluded_directory_list_id = excluded_directory_list_id
        if excluded_file_list_id is not None:
            self.excluded_file_list_id = excluded_file_list_id
        if excluded_file_extension_list_id is not None:
            self.excluded_file_extension_list_id = excluded_file_extension_list_id
        if excluded_process_image_file_list_id is not None:
            self.excluded_process_image_file_list_id = excluded_process_image_file_list_id
        if real_time_scan is not None:
            self.real_time_scan = real_time_scan
        if scan_compressed_enabled is not None:
            self.scan_compressed_enabled = scan_compressed_enabled
        if scan_compressed_maximum_size is not None:
            self.scan_compressed_maximum_size = scan_compressed_maximum_size
        if scan_compressed_maximum_levels is not None:
            self.scan_compressed_maximum_levels = scan_compressed_maximum_levels
        if scan_compressed_maximum_files is not None:
            self.scan_compressed_maximum_files = scan_compressed_maximum_files
        if microsoft_office_enabled is not None:
            self.microsoft_office_enabled = microsoft_office_enabled
        if microsoft_office_layers is not None:
            self.microsoft_office_layers = microsoft_office_layers
        if network_directories_enabled is not None:
            self.network_directories_enabled = network_directories_enabled
        if custom_remediation_actions_enabled is not None:
            self.custom_remediation_actions_enabled = custom_remediation_actions_enabled
        if custom_scan_actions_enabled is not None:
            self.custom_scan_actions_enabled = custom_scan_actions_enabled
        if scan_action_for_virus is not None:
            self.scan_action_for_virus = scan_action_for_virus
        if scan_action_for_trojans is not None:
            self.scan_action_for_trojans = scan_action_for_trojans
        if scan_action_for_packer is not None:
            self.scan_action_for_packer = scan_action_for_packer
        if scan_action_for_spyware is not None:
            self.scan_action_for_spyware = scan_action_for_spyware
        if scan_action_for_other_threats is not None:
            self.scan_action_for_other_threats = scan_action_for_other_threats
        if scan_action_for_cookies is not None:
            self.scan_action_for_cookies = scan_action_for_cookies
        if scan_action_for_cve is not None:
            self.scan_action_for_cve = scan_action_for_cve
        if scan_action_for_heuristics is not None:
            self.scan_action_for_heuristics = scan_action_for_heuristics
        if scan_action_for_possible_malware is not None:
            self.scan_action_for_possible_malware = scan_action_for_possible_malware
        if amsi_scan_enabled is not None:
            self.amsi_scan_enabled = amsi_scan_enabled
        if scan_action_for_behavior_monitoring is not None:
            self.scan_action_for_behavior_monitoring = scan_action_for_behavior_monitoring
        if scan_action_for_machine_learning is not None:
            self.scan_action_for_machine_learning = scan_action_for_machine_learning
        if scan_action_for_amsi is not None:
            self.scan_action_for_amsi = scan_action_for_amsi
        if id is not None:
            self.id = id
        if cpu_usage is not None:
            self.cpu_usage = cpu_usage

    @property
    def name(self):
        """Gets the name of this AntiMalwareConfiguration.  # noqa: E501

        Name of the anti-malware configuration. Searchable as String.  # noqa: E501

        :return: The name of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AntiMalwareConfiguration.

        Name of the anti-malware configuration. Searchable as String.  # noqa: E501

        :param name: The name of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this AntiMalwareConfiguration.  # noqa: E501

        Description of the anti-malware configuration. Searchable as String.  # noqa: E501

        :return: The description of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AntiMalwareConfiguration.

        Description of the anti-malware configuration. Searchable as String.  # noqa: E501

        :param description: The description of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def scan_type(self):
        """Gets the scan_type of this AntiMalwareConfiguration.  # noqa: E501

        The type of malware scan configuration. Searchable as Choice.  # noqa: E501

        :return: The scan_type of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_type

    @scan_type.setter
    def scan_type(self, scan_type):
        """Sets the scan_type of this AntiMalwareConfiguration.

        The type of malware scan configuration. Searchable as Choice.  # noqa: E501

        :param scan_type: The scan_type of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["real-time", "on-demand"]  # noqa: E501
        if scan_type not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_type` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_type, allowed_values)
            )

        self._scan_type = scan_type

    @property
    def document_exploit_protection_enabled(self):
        """Gets the document_exploit_protection_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan for known critical vulnerabilities. Use true to enable scan.  # noqa: E501

        :return: The document_exploit_protection_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._document_exploit_protection_enabled

    @document_exploit_protection_enabled.setter
    def document_exploit_protection_enabled(self, document_exploit_protection_enabled):
        """Sets the document_exploit_protection_enabled of this AntiMalwareConfiguration.

        Controls whether to scan for known critical vulnerabilities. Use true to enable scan.  # noqa: E501

        :param document_exploit_protection_enabled: The document_exploit_protection_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._document_exploit_protection_enabled = document_exploit_protection_enabled

    @property
    def document_exploit_protection(self):
        """Gets the document_exploit_protection of this AntiMalwareConfiguration.  # noqa: E501

        Scan for exploits against known critical vulnerabilities only. Searchable as Choice.  # noqa: E501

        :return: The document_exploit_protection of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._document_exploit_protection

    @document_exploit_protection.setter
    def document_exploit_protection(self, document_exploit_protection):
        """Sets the document_exploit_protection of this AntiMalwareConfiguration.

        Scan for exploits against known critical vulnerabilities only. Searchable as Choice.  # noqa: E501

        :param document_exploit_protection: The document_exploit_protection of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["critical-only", "critical-and-heuristic"]  # noqa: E501
        if document_exploit_protection not in allowed_values:
            raise ValueError(
                "Invalid value for `document_exploit_protection` ({0}), must be one of {1}"  # noqa: E501
                .format(document_exploit_protection, allowed_values)
            )

        self._document_exploit_protection = document_exploit_protection

    @property
    def document_exploit_heuristic_level(self):
        """Gets the document_exploit_heuristic_level of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan for exploits of known critical vulnerabilites as well as aggessively detect suspicious behaviour that could be an unknown exploit. Searchable as Choice.  # noqa: E501

        :return: The document_exploit_heuristic_level of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._document_exploit_heuristic_level

    @document_exploit_heuristic_level.setter
    def document_exploit_heuristic_level(self, document_exploit_heuristic_level):
        """Sets the document_exploit_heuristic_level of this AntiMalwareConfiguration.

        Controls whether to scan for exploits of known critical vulnerabilites as well as aggessively detect suspicious behaviour that could be an unknown exploit. Searchable as Choice.  # noqa: E501

        :param document_exploit_heuristic_level: The document_exploit_heuristic_level of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["default", "default-and-agressive", "LEVEL_THREE", "LEVEL_FOUR"]  # noqa: E501
        if document_exploit_heuristic_level not in allowed_values:
            raise ValueError(
                "Invalid value for `document_exploit_heuristic_level` ({0}), must be one of {1}"  # noqa: E501
                .format(document_exploit_heuristic_level, allowed_values)
            )

        self._document_exploit_heuristic_level = document_exploit_heuristic_level

    @property
    def machine_learning_enabled(self):
        """Gets the machine_learning_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether predictive machine learning is enabled.  Set to true to enable. Searchable as Boolean.  # noqa: E501

        :return: The machine_learning_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._machine_learning_enabled

    @machine_learning_enabled.setter
    def machine_learning_enabled(self, machine_learning_enabled):
        """Sets the machine_learning_enabled of this AntiMalwareConfiguration.

        Controls whether predictive machine learning is enabled.  Set to true to enable. Searchable as Boolean.  # noqa: E501

        :param machine_learning_enabled: The machine_learning_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._machine_learning_enabled = machine_learning_enabled

    @property
    def behavior_monitoring_enabled(self):
        """Gets the behavior_monitoring_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to detect suspicious activity and unauthorized changes (including ransomware). Set to true to detect.  # noqa: E501

        :return: The behavior_monitoring_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._behavior_monitoring_enabled

    @behavior_monitoring_enabled.setter
    def behavior_monitoring_enabled(self, behavior_monitoring_enabled):
        """Sets the behavior_monitoring_enabled of this AntiMalwareConfiguration.

        Controls whether to detect suspicious activity and unauthorized changes (including ransomware). Set to true to detect.  # noqa: E501

        :param behavior_monitoring_enabled: The behavior_monitoring_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._behavior_monitoring_enabled = behavior_monitoring_enabled

    @property
    def document_recovery_enabled(self):
        """Gets the document_recovery_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to back up ransomware-encrypted files. Set to true to back up. Searchable as Boolean.  # noqa: E501

        :return: The document_recovery_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._document_recovery_enabled

    @document_recovery_enabled.setter
    def document_recovery_enabled(self, document_recovery_enabled):
        """Sets the document_recovery_enabled of this AntiMalwareConfiguration.

        Controls whether to back up ransomware-encrypted files. Set to true to back up. Searchable as Boolean.  # noqa: E501

        :param document_recovery_enabled: The document_recovery_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._document_recovery_enabled = document_recovery_enabled

    @property
    def intelli_trap_enabled(self):
        """Gets the intelli_trap_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether IntelliTrap is enabled. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :return: The intelli_trap_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._intelli_trap_enabled

    @intelli_trap_enabled.setter
    def intelli_trap_enabled(self, intelli_trap_enabled):
        """Sets the intelli_trap_enabled of this AntiMalwareConfiguration.

        Controls whether IntelliTrap is enabled. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :param intelli_trap_enabled: The intelli_trap_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._intelli_trap_enabled = intelli_trap_enabled

    @property
    def memory_scan_enabled(self):
        """Gets the memory_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan process memory for malware. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :return: The memory_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._memory_scan_enabled

    @memory_scan_enabled.setter
    def memory_scan_enabled(self, memory_scan_enabled):
        """Sets the memory_scan_enabled of this AntiMalwareConfiguration.

        Controls whether to scan process memory for malware. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :param memory_scan_enabled: The memory_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._memory_scan_enabled = memory_scan_enabled

    @property
    def spyware_enabled(self):
        """Gets the spyware_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to enable spyware/grayware protection. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :return: The spyware_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._spyware_enabled

    @spyware_enabled.setter
    def spyware_enabled(self, spyware_enabled):
        """Sets the spyware_enabled of this AntiMalwareConfiguration.

        Controls whether to enable spyware/grayware protection. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :param spyware_enabled: The spyware_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._spyware_enabled = spyware_enabled

    @property
    def alert_enabled(self):
        """Gets the alert_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to create an alert when the Malware Scan Configuration logs an event. Set to true to enable the alert. Searchable as Boolean.  # noqa: E501

        :return: The alert_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._alert_enabled

    @alert_enabled.setter
    def alert_enabled(self, alert_enabled):
        """Sets the alert_enabled of this AntiMalwareConfiguration.

        Controls whether to create an alert when the Malware Scan Configuration logs an event. Set to true to enable the alert. Searchable as Boolean.  # noqa: E501

        :param alert_enabled: The alert_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._alert_enabled = alert_enabled

    @property
    def directories_to_scan(self):
        """Gets the directories_to_scan of this AntiMalwareConfiguration.  # noqa: E501

        Specify if the scan will be peformed on all the directories or on a subset. Searchable as Choice.  # noqa: E501

        :return: The directories_to_scan of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._directories_to_scan

    @directories_to_scan.setter
    def directories_to_scan(self, directories_to_scan):
        """Sets the directories_to_scan of this AntiMalwareConfiguration.

        Specify if the scan will be peformed on all the directories or on a subset. Searchable as Choice.  # noqa: E501

        :param directories_to_scan: The directories_to_scan of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["all-directories", "directory-list"]  # noqa: E501
        if directories_to_scan not in allowed_values:
            raise ValueError(
                "Invalid value for `directories_to_scan` ({0}), must be one of {1}"  # noqa: E501
                .format(directories_to_scan, allowed_values)
            )

        self._directories_to_scan = directories_to_scan

    @property
    def directory_list_id(self):
        """Gets the directory_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the directory list to scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The directory_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._directory_list_id

    @directory_list_id.setter
    def directory_list_id(self, directory_list_id):
        """Sets the directory_list_id of this AntiMalwareConfiguration.

        ID of the directory list to scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param directory_list_id: The directory_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._directory_list_id = directory_list_id

    @property
    def files_to_scan(self):
        """Gets the files_to_scan of this AntiMalwareConfiguration.  # noqa: E501

        Specify if scan will be performed on all files, a subset or by using IntelliScan. Searchable as Choice.  # noqa: E501

        :return: The files_to_scan of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._files_to_scan

    @files_to_scan.setter
    def files_to_scan(self, files_to_scan):
        """Sets the files_to_scan of this AntiMalwareConfiguration.

        Specify if scan will be performed on all files, a subset or by using IntelliScan. Searchable as Choice.  # noqa: E501

        :param files_to_scan: The files_to_scan of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["all-files", "intelliscan-file-types", "file-extension-list"]  # noqa: E501
        if files_to_scan not in allowed_values:
            raise ValueError(
                "Invalid value for `files_to_scan` ({0}), must be one of {1}"  # noqa: E501
                .format(files_to_scan, allowed_values)
            )

        self._files_to_scan = files_to_scan

    @property
    def file_extension_list_id(self):
        """Gets the file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the file extension list to scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._file_extension_list_id

    @file_extension_list_id.setter
    def file_extension_list_id(self, file_extension_list_id):
        """Sets the file_extension_list_id of this AntiMalwareConfiguration.

        ID of the file extension list to scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param file_extension_list_id: The file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._file_extension_list_id = file_extension_list_id

    @property
    def excluded_directory_list_id(self):
        """Gets the excluded_directory_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the directory list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The excluded_directory_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._excluded_directory_list_id

    @excluded_directory_list_id.setter
    def excluded_directory_list_id(self, excluded_directory_list_id):
        """Sets the excluded_directory_list_id of this AntiMalwareConfiguration.

        ID of the directory list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param excluded_directory_list_id: The excluded_directory_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._excluded_directory_list_id = excluded_directory_list_id

    @property
    def excluded_file_list_id(self):
        """Gets the excluded_file_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the file list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The excluded_file_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._excluded_file_list_id

    @excluded_file_list_id.setter
    def excluded_file_list_id(self, excluded_file_list_id):
        """Sets the excluded_file_list_id of this AntiMalwareConfiguration.

        ID of the file list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param excluded_file_list_id: The excluded_file_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._excluded_file_list_id = excluded_file_list_id

    @property
    def excluded_file_extension_list_id(self):
        """Gets the excluded_file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the file extension list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The excluded_file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._excluded_file_extension_list_id

    @excluded_file_extension_list_id.setter
    def excluded_file_extension_list_id(self, excluded_file_extension_list_id):
        """Sets the excluded_file_extension_list_id of this AntiMalwareConfiguration.

        ID of the file extension list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param excluded_file_extension_list_id: The excluded_file_extension_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._excluded_file_extension_list_id = excluded_file_extension_list_id

    @property
    def excluded_process_image_file_list_id(self):
        """Gets the excluded_process_image_file_list_id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the process image file list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :return: The excluded_process_image_file_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._excluded_process_image_file_list_id

    @excluded_process_image_file_list_id.setter
    def excluded_process_image_file_list_id(self, excluded_process_image_file_list_id):
        """Sets the excluded_process_image_file_list_id of this AntiMalwareConfiguration.

        ID of the process image file list to exclude from the scan. Set to 0 to remove any assignment. Searchable as Numeric.  # noqa: E501

        :param excluded_process_image_file_list_id: The excluded_process_image_file_list_id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._excluded_process_image_file_list_id = excluded_process_image_file_list_id

    @property
    def real_time_scan(self):
        """Gets the real_time_scan of this AntiMalwareConfiguration.  # noqa: E501

        Specify when to perform the real-time scan. Searchable as Choice.  # noqa: E501

        :return: The real_time_scan of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._real_time_scan

    @real_time_scan.setter
    def real_time_scan(self, real_time_scan):
        """Sets the real_time_scan of this AntiMalwareConfiguration.

        Specify when to perform the real-time scan. Searchable as Choice.  # noqa: E501

        :param real_time_scan: The real_time_scan of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["read-only", "write-only", "read-write"]  # noqa: E501
        if real_time_scan not in allowed_values:
            raise ValueError(
                "Invalid value for `real_time_scan` ({0}), must be one of {1}"  # noqa: E501
                .format(real_time_scan, allowed_values)
            )

        self._real_time_scan = real_time_scan

    @property
    def scan_compressed_enabled(self):
        """Gets the scan_compressed_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan compressed files. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :return: The scan_compressed_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._scan_compressed_enabled

    @scan_compressed_enabled.setter
    def scan_compressed_enabled(self, scan_compressed_enabled):
        """Sets the scan_compressed_enabled of this AntiMalwareConfiguration.

        Controls whether to scan compressed files. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :param scan_compressed_enabled: The scan_compressed_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._scan_compressed_enabled = scan_compressed_enabled

    @property
    def scan_compressed_maximum_size(self):
        """Gets the scan_compressed_maximum_size of this AntiMalwareConfiguration.  # noqa: E501

        Maximum size of compressed files to scan, in MB. Searchable as Numeric.  # noqa: E501

        :return: The scan_compressed_maximum_size of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._scan_compressed_maximum_size

    @scan_compressed_maximum_size.setter
    def scan_compressed_maximum_size(self, scan_compressed_maximum_size):
        """Sets the scan_compressed_maximum_size of this AntiMalwareConfiguration.

        Maximum size of compressed files to scan, in MB. Searchable as Numeric.  # noqa: E501

        :param scan_compressed_maximum_size: The scan_compressed_maximum_size of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._scan_compressed_maximum_size = scan_compressed_maximum_size

    @property
    def scan_compressed_maximum_levels(self):
        """Gets the scan_compressed_maximum_levels of this AntiMalwareConfiguration.  # noqa: E501

        The maximum number of levels of compression to scan. Searchable as Numeric.  # noqa: E501

        :return: The scan_compressed_maximum_levels of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._scan_compressed_maximum_levels

    @scan_compressed_maximum_levels.setter
    def scan_compressed_maximum_levels(self, scan_compressed_maximum_levels):
        """Sets the scan_compressed_maximum_levels of this AntiMalwareConfiguration.

        The maximum number of levels of compression to scan. Searchable as Numeric.  # noqa: E501

        :param scan_compressed_maximum_levels: The scan_compressed_maximum_levels of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._scan_compressed_maximum_levels = scan_compressed_maximum_levels

    @property
    def scan_compressed_maximum_files(self):
        """Gets the scan_compressed_maximum_files of this AntiMalwareConfiguration.  # noqa: E501

        Maximum number of files to extract. Searchable as Numeric.  # noqa: E501

        :return: The scan_compressed_maximum_files of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._scan_compressed_maximum_files

    @scan_compressed_maximum_files.setter
    def scan_compressed_maximum_files(self, scan_compressed_maximum_files):
        """Sets the scan_compressed_maximum_files of this AntiMalwareConfiguration.

        Maximum number of files to extract. Searchable as Numeric.  # noqa: E501

        :param scan_compressed_maximum_files: The scan_compressed_maximum_files of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._scan_compressed_maximum_files = scan_compressed_maximum_files

    @property
    def microsoft_office_enabled(self):
        """Gets the microsoft_office_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan Embedded Microsoft Office Objects. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :return: The microsoft_office_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._microsoft_office_enabled

    @microsoft_office_enabled.setter
    def microsoft_office_enabled(self, microsoft_office_enabled):
        """Sets the microsoft_office_enabled of this AntiMalwareConfiguration.

        Controls whether to scan Embedded Microsoft Office Objects. Use true to enable scan. Searchable as Boolean.  # noqa: E501

        :param microsoft_office_enabled: The microsoft_office_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._microsoft_office_enabled = microsoft_office_enabled

    @property
    def microsoft_office_layers(self):
        """Gets the microsoft_office_layers of this AntiMalwareConfiguration.  # noqa: E501

        Number of Microsoft Object Linking and Embedding (OLE) Layers to scan. Searchable as Numeric.  # noqa: E501

        :return: The microsoft_office_layers of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._microsoft_office_layers

    @microsoft_office_layers.setter
    def microsoft_office_layers(self, microsoft_office_layers):
        """Sets the microsoft_office_layers of this AntiMalwareConfiguration.

        Number of Microsoft Object Linking and Embedding (OLE) Layers to scan. Searchable as Numeric.  # noqa: E501

        :param microsoft_office_layers: The microsoft_office_layers of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._microsoft_office_layers = microsoft_office_layers

    @property
    def network_directories_enabled(self):
        """Gets the network_directories_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to scan network directories. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :return: The network_directories_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._network_directories_enabled

    @network_directories_enabled.setter
    def network_directories_enabled(self, network_directories_enabled):
        """Sets the network_directories_enabled of this AntiMalwareConfiguration.

        Controls whether to scan network directories. Set to true to enable. Searchable as Boolean.  # noqa: E501

        :param network_directories_enabled: The network_directories_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._network_directories_enabled = network_directories_enabled

    @property
    def custom_remediation_actions_enabled(self):
        """Gets the custom_remediation_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to use the action ActiveActions recommends when malware is detected. Set to true to use the action ActiveAction recommends.  # noqa: E501

        :return: The custom_remediation_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._custom_remediation_actions_enabled

    @custom_remediation_actions_enabled.setter
    def custom_remediation_actions_enabled(self, custom_remediation_actions_enabled):
        """Sets the custom_remediation_actions_enabled of this AntiMalwareConfiguration.

        Controls whether to use the action ActiveActions recommends when malware is detected. Set to true to use the action ActiveAction recommends.  # noqa: E501

        :param custom_remediation_actions_enabled: The custom_remediation_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._custom_remediation_actions_enabled = custom_remediation_actions_enabled

    @property
    def custom_scan_actions_enabled(self):
        """Gets the custom_scan_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether to use custom actions. Use true to enable custom actions. Available when 'customRemediationActionsEnabled' is true.  # noqa: E501

        :return: The custom_scan_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._custom_scan_actions_enabled

    @custom_scan_actions_enabled.setter
    def custom_scan_actions_enabled(self, custom_scan_actions_enabled):
        """Sets the custom_scan_actions_enabled of this AntiMalwareConfiguration.

        Controls whether to use custom actions. Use true to enable custom actions. Available when 'customRemediationActionsEnabled' is true.  # noqa: E501

        :param custom_scan_actions_enabled: The custom_scan_actions_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._custom_scan_actions_enabled = custom_scan_actions_enabled

    @property
    def scan_action_for_virus(self):
        """Gets the scan_action_for_virus of this AntiMalwareConfiguration.  # noqa: E501

        The action to perform when a virus is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_virus of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_virus

    @scan_action_for_virus.setter
    def scan_action_for_virus(self, scan_action_for_virus):
        """Sets the scan_action_for_virus of this AntiMalwareConfiguration.

        The action to perform when a virus is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_virus: The scan_action_for_virus of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "clean", "deny-access"]  # noqa: E501
        if scan_action_for_virus not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_virus` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_virus, allowed_values)
            )

        self._scan_action_for_virus = scan_action_for_virus

    @property
    def scan_action_for_trojans(self):
        """Gets the scan_action_for_trojans of this AntiMalwareConfiguration.  # noqa: E501

        The action to perform when a trojan is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_trojans of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_trojans

    @scan_action_for_trojans.setter
    def scan_action_for_trojans(self, scan_action_for_trojans):
        """Sets the scan_action_for_trojans of this AntiMalwareConfiguration.

        The action to perform when a trojan is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_trojans: The scan_action_for_trojans of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_trojans not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_trojans` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_trojans, allowed_values)
            )

        self._scan_action_for_trojans = scan_action_for_trojans

    @property
    def scan_action_for_packer(self):
        """Gets the scan_action_for_packer of this AntiMalwareConfiguration.  # noqa: E501

        The action to perform when a packer is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_packer of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_packer

    @scan_action_for_packer.setter
    def scan_action_for_packer(self, scan_action_for_packer):
        """Sets the scan_action_for_packer of this AntiMalwareConfiguration.

        The action to perform when a packer is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_packer: The scan_action_for_packer of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_packer not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_packer` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_packer, allowed_values)
            )

        self._scan_action_for_packer = scan_action_for_packer

    @property
    def scan_action_for_spyware(self):
        """Gets the scan_action_for_spyware of this AntiMalwareConfiguration.  # noqa: E501

        The action to perform when spyware is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_spyware of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_spyware

    @scan_action_for_spyware.setter
    def scan_action_for_spyware(self, scan_action_for_spyware):
        """Sets the scan_action_for_spyware of this AntiMalwareConfiguration.

        The action to perform when spyware is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_spyware: The scan_action_for_spyware of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_spyware not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_spyware` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_spyware, allowed_values)
            )

        self._scan_action_for_spyware = scan_action_for_spyware

    @property
    def scan_action_for_other_threats(self):
        """Gets the scan_action_for_other_threats of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when other threats are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_other_threats of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_other_threats

    @scan_action_for_other_threats.setter
    def scan_action_for_other_threats(self, scan_action_for_other_threats):
        """Sets the scan_action_for_other_threats of this AntiMalwareConfiguration.

        The action to take when other threats are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_other_threats: The scan_action_for_other_threats of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "clean", "deny-access"]  # noqa: E501
        if scan_action_for_other_threats not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_other_threats` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_other_threats, allowed_values)
            )

        self._scan_action_for_other_threats = scan_action_for_other_threats

    @property
    def scan_action_for_cookies(self):
        """Gets the scan_action_for_cookies of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when cookies are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_cookies of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_cookies

    @scan_action_for_cookies.setter
    def scan_action_for_cookies(self, scan_action_for_cookies):
        """Sets the scan_action_for_cookies of this AntiMalwareConfiguration.

        The action to take when cookies are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_cookies: The scan_action_for_cookies of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete"]  # noqa: E501
        if scan_action_for_cookies not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_cookies` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_cookies, allowed_values)
            )

        self._scan_action_for_cookies = scan_action_for_cookies

    @property
    def scan_action_for_cve(self):
        """Gets the scan_action_for_cve of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when a CVE exploit is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_cve of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_cve

    @scan_action_for_cve.setter
    def scan_action_for_cve(self, scan_action_for_cve):
        """Sets the scan_action_for_cve of this AntiMalwareConfiguration.

        The action to take when a CVE exploit is detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_cve: The scan_action_for_cve of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_cve not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_cve` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_cve, allowed_values)
            )

        self._scan_action_for_cve = scan_action_for_cve

    @property
    def scan_action_for_heuristics(self):
        """Gets the scan_action_for_heuristics of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when malware identified with heuristics are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_heuristics of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_heuristics

    @scan_action_for_heuristics.setter
    def scan_action_for_heuristics(self, scan_action_for_heuristics):
        """Sets the scan_action_for_heuristics of this AntiMalwareConfiguration.

        The action to take when malware identified with heuristics are detected. Searchable as Choice. Available when 'customScanActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_heuristics: The scan_action_for_heuristics of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_heuristics not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_heuristics` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_heuristics, allowed_values)
            )

        self._scan_action_for_heuristics = scan_action_for_heuristics

    @property
    def scan_action_for_possible_malware(self):
        """Gets the scan_action_for_possible_malware of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when possible malware is detected. Searchable as Choice. Available when 'customRemediationActionsEnabled' is true.  # noqa: E501

        :return: The scan_action_for_possible_malware of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_possible_malware

    @scan_action_for_possible_malware.setter
    def scan_action_for_possible_malware(self, scan_action_for_possible_malware):
        """Sets the scan_action_for_possible_malware of this AntiMalwareConfiguration.

        The action to take when possible malware is detected. Searchable as Choice. Available when 'customRemediationActionsEnabled' is true.  # noqa: E501

        :param scan_action_for_possible_malware: The scan_action_for_possible_malware of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["active-action", "pass", "delete", "quarantine", "deny-access"]  # noqa: E501
        if scan_action_for_possible_malware not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_possible_malware` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_possible_malware, allowed_values)
            )

        self._scan_action_for_possible_malware = scan_action_for_possible_malware

    @property
    def amsi_scan_enabled(self):
        """Gets the amsi_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501

        Controls whether Windows Antimalware Scan Interface (AMSI) protection is enabled. Set to true to enable.  # noqa: E501

        :return: The amsi_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._amsi_scan_enabled

    @amsi_scan_enabled.setter
    def amsi_scan_enabled(self, amsi_scan_enabled):
        """Sets the amsi_scan_enabled of this AntiMalwareConfiguration.

        Controls whether Windows Antimalware Scan Interface (AMSI) protection is enabled. Set to true to enable.  # noqa: E501

        :param amsi_scan_enabled: The amsi_scan_enabled of this AntiMalwareConfiguration.  # noqa: E501
        :type: bool
        """

        self._amsi_scan_enabled = amsi_scan_enabled

    @property
    def scan_action_for_behavior_monitoring(self):
        """Gets the scan_action_for_behavior_monitoring of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when suspicious activity and unauthorized changes are detected. Searchable as Choice. Available when 'behaviorMonitoringEnabled' is true.  # noqa: E501

        :return: The scan_action_for_behavior_monitoring of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_behavior_monitoring

    @scan_action_for_behavior_monitoring.setter
    def scan_action_for_behavior_monitoring(self, scan_action_for_behavior_monitoring):
        """Sets the scan_action_for_behavior_monitoring of this AntiMalwareConfiguration.

        The action to take when suspicious activity and unauthorized changes are detected. Searchable as Choice. Available when 'behaviorMonitoringEnabled' is true.  # noqa: E501

        :param scan_action_for_behavior_monitoring: The scan_action_for_behavior_monitoring of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["active-action", "pass"]  # noqa: E501
        if scan_action_for_behavior_monitoring not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_behavior_monitoring` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_behavior_monitoring, allowed_values)
            )

        self._scan_action_for_behavior_monitoring = scan_action_for_behavior_monitoring

    @property
    def scan_action_for_machine_learning(self):
        """Gets the scan_action_for_machine_learning of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when malware identified with machine learning is detected. Searchable as Choice. Available when 'machineLearningEnabled' is true.  # noqa: E501

        :return: The scan_action_for_machine_learning of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_machine_learning

    @scan_action_for_machine_learning.setter
    def scan_action_for_machine_learning(self, scan_action_for_machine_learning):
        """Sets the scan_action_for_machine_learning of this AntiMalwareConfiguration.

        The action to take when malware identified with machine learning is detected. Searchable as Choice. Available when 'machineLearningEnabled' is true.  # noqa: E501

        :param scan_action_for_machine_learning: The scan_action_for_machine_learning of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "delete", "quarantine"]  # noqa: E501
        if scan_action_for_machine_learning not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_machine_learning` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_machine_learning, allowed_values)
            )

        self._scan_action_for_machine_learning = scan_action_for_machine_learning

    @property
    def scan_action_for_amsi(self):
        """Gets the scan_action_for_amsi of this AntiMalwareConfiguration.  # noqa: E501

        The action to take when malware identified with AMSI protection is detected. Available when 'amsiScanEnabled' is true.  # noqa: E501

        :return: The scan_action_for_amsi of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._scan_action_for_amsi

    @scan_action_for_amsi.setter
    def scan_action_for_amsi(self, scan_action_for_amsi):
        """Sets the scan_action_for_amsi of this AntiMalwareConfiguration.

        The action to take when malware identified with AMSI protection is detected. Available when 'amsiScanEnabled' is true.  # noqa: E501

        :param scan_action_for_amsi: The scan_action_for_amsi of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["pass", "terminate"]  # noqa: E501
        if scan_action_for_amsi not in allowed_values:
            raise ValueError(
                "Invalid value for `scan_action_for_amsi` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_action_for_amsi, allowed_values)
            )

        self._scan_action_for_amsi = scan_action_for_amsi

    @property
    def id(self):
        """Gets the id of this AntiMalwareConfiguration.  # noqa: E501

        ID of the anti-malware configuration. This ID is set automatically. Searchable as ID.  # noqa: E501

        :return: The id of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AntiMalwareConfiguration.

        ID of the anti-malware configuration. This ID is set automatically. Searchable as ID.  # noqa: E501

        :param id: The id of this AntiMalwareConfiguration.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def cpu_usage(self):
        """Gets the cpu_usage of this AntiMalwareConfiguration.  # noqa: E501


        :return: The cpu_usage of this AntiMalwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._cpu_usage

    @cpu_usage.setter
    def cpu_usage(self, cpu_usage):
        """Sets the cpu_usage of this AntiMalwareConfiguration.


        :param cpu_usage: The cpu_usage of this AntiMalwareConfiguration.  # noqa: E501
        :type: str
        """
        allowed_values = ["low", "medium", "high"]  # noqa: E501
        if cpu_usage not in allowed_values:
            raise ValueError(
                "Invalid value for `cpu_usage` ({0}), must be one of {1}"  # noqa: E501
                .format(cpu_usage, allowed_values)
            )

        self._cpu_usage = cpu_usage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AntiMalwareConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AntiMalwareConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

