# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from deepsecurity.models.available_version import AvailableVersion  # noqa: F401,E501


class AgentVersionControl(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'os': 'str',
        'distro': 'str',
        'platform': 'str',
        'architecture': 'str',
        'type': 'str',
        'version': 'str',
        'available_versions': 'list[AvailableVersion]',
        'id': 'int'
    }

    attribute_map = {
        'os': 'os',
        'distro': 'distro',
        'platform': 'platform',
        'architecture': 'architecture',
        'type': 'type',
        'version': 'version',
        'available_versions': 'availableVersions',
        'id': 'ID'
    }

    def __init__(self, os=None, distro=None, platform=None, architecture=None, type=None, version=None, available_versions=None, id=None):  # noqa: E501
        """AgentVersionControl - a model defined in Swagger"""  # noqa: E501

        self._os = None
        self._distro = None
        self._platform = None
        self._architecture = None
        self._type = None
        self._version = None
        self._available_versions = None
        self._id = None
        self.discriminator = None

        if os is not None:
            self.os = os
        if distro is not None:
            self.distro = distro
        if platform is not None:
            self.platform = platform
        if architecture is not None:
            self.architecture = architecture
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version
        if available_versions is not None:
            self.available_versions = available_versions
        if id is not None:
            self.id = id

    @property
    def os(self):
        """Gets the os of this AgentVersionControl.  # noqa: E501

        OS of the agent version control. Searchable as Choice.  # noqa: E501

        :return: The os of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this AgentVersionControl.

        OS of the agent version control. Searchable as Choice.  # noqa: E501

        :param os: The os of this AgentVersionControl.  # noqa: E501
        :type: str
        """
        allowed_values = ["Windows", "Linux", "Unix"]  # noqa: E501
        if os not in allowed_values:
            raise ValueError(
                "Invalid value for `os` ({0}), must be one of {1}"  # noqa: E501
                .format(os, allowed_values)
            )

        self._os = os

    @property
    def distro(self):
        """Gets the distro of this AgentVersionControl.  # noqa: E501

        Distro of the agent version control. Searchable as Choice.  # noqa: E501

        :return: The distro of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._distro

    @distro.setter
    def distro(self, distro):
        """Sets the distro of this AgentVersionControl.

        Distro of the agent version control. Searchable as Choice.  # noqa: E501

        :param distro: The distro of this AgentVersionControl.  # noqa: E501
        :type: str
        """
        allowed_values = ["Red Hat", "CentOS", "SUSE", "Ubuntu", "Debian", "Oracle Linux", "Amazon Linux", "CloudLinux", "Solaris", "AIX"]  # noqa: E501
        if distro not in allowed_values:
            raise ValueError(
                "Invalid value for `distro` ({0}), must be one of {1}"  # noqa: E501
                .format(distro, allowed_values)
            )

        self._distro = distro

    @property
    def platform(self):
        """Gets the platform of this AgentVersionControl.  # noqa: E501

        Platform of the agent version control. Searchable as Choice.  # noqa: E501

        :return: The platform of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this AgentVersionControl.

        Platform of the agent version control. Searchable as Choice.  # noqa: E501

        :param platform: The platform of this AgentVersionControl.  # noqa: E501
        :type: str
        """
        allowed_values = ["Microsoft Windows 2000 Server", "Microsoft Windows Server 2003", "Microsoft Windows Server 2003 R2", "Microsoft Windows Server 2008", "Microsoft Windows Server 2008 R2", "Microsoft Windows Server 2012", "Microsoft Windows Server 2012 R2", "Microsoft Windows Server 2016", "Microsoft Windows Server 2019", "Microsoft Windows 2000 Professional", "Microsoft Windows XP", "Microsoft Windows 7", "Microsoft Windows 8", "Microsoft Windows 8.1", "Microsoft Windows 10", "Solaris 10 U4 to U6", "Solaris 10 U7 to U11", "Solaris 11.0 to 11.3", "Solaris 11.4", "AIX 5.3", "AIX 6.1", "AIX 7.1", "AIX 7.2", "Red Hat Enterprise 5", "Red Hat Enterprise 6", "Red Hat Enterprise 7", "Red Hat Enterprise 8", "Ubuntu Linux 10", "Ubuntu Linux 12", "Ubuntu Linux 14", "Ubuntu Linux 16", "Ubuntu Linux 18", "Ubuntu Linux 20", "CentOS 5", "CentOS 6", "CentOS 7", "CentOS 8", "Debian 6", "Debian 7", "Debian 8", "Debian 9", "Debian 10", "Amazon Linux", "Amazon Linux 2", "Oracle Linux Release 5", "Oracle Linux Release 6", "Oracle Linux Release 7", "Oracle Linux Release 8", "SUSE Enterprise Server 10", "SUSE Enterprise Server 11", "SUSE Enterprise Server 12", "SUSE Enterprise Server 15", "CloudLinux 5", "CloudLinux 6", "CloudLinux 7", "CloudLinux 8"]  # noqa: E501
        if platform not in allowed_values:
            raise ValueError(
                "Invalid value for `platform` ({0}), must be one of {1}"  # noqa: E501
                .format(platform, allowed_values)
            )

        self._platform = platform

    @property
    def architecture(self):
        """Gets the architecture of this AgentVersionControl.  # noqa: E501

        Architecture of the agent version control. Searchable as Choice.  # noqa: E501

        :return: The architecture of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this AgentVersionControl.

        Architecture of the agent version control. Searchable as Choice.  # noqa: E501

        :param architecture: The architecture of this AgentVersionControl.  # noqa: E501
        :type: str
        """
        allowed_values = ["32-bit", "64-bit", "sparc", "powerpc", "64-bit Arm"]  # noqa: E501
        if architecture not in allowed_values:
            raise ValueError(
                "Invalid value for `architecture` ({0}), must be one of {1}"  # noqa: E501
                .format(architecture, allowed_values)
            )

        self._architecture = architecture

    @property
    def type(self):
        """Gets the type of this AgentVersionControl.  # noqa: E501

        Type of the agent version control. Searchable as Choice.  # noqa: E501

        :return: The type of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this AgentVersionControl.

        Type of the agent version control. Searchable as Choice.  # noqa: E501

        :param type: The type of this AgentVersionControl.  # noqa: E501
        :type: str
        """
        allowed_values = ["latest", "latest-lts", "specified", "unknown"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def version(self):
        """Gets the version of this AgentVersionControl.  # noqa: E501

        Version of the agent version control. Searchable as String.  # noqa: E501

        :return: The version of this AgentVersionControl.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AgentVersionControl.

        Version of the agent version control. Searchable as String.  # noqa: E501

        :param version: The version of this AgentVersionControl.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def available_versions(self):
        """Gets the available_versions of this AgentVersionControl.  # noqa: E501

        List of available versions for the platform.  # noqa: E501

        :return: The available_versions of this AgentVersionControl.  # noqa: E501
        :rtype: list[AvailableVersion]
        """
        return self._available_versions

    @available_versions.setter
    def available_versions(self, available_versions):
        """Sets the available_versions of this AgentVersionControl.

        List of available versions for the platform.  # noqa: E501

        :param available_versions: The available_versions of this AgentVersionControl.  # noqa: E501
        :type: list[AvailableVersion]
        """

        self._available_versions = available_versions

    @property
    def id(self):
        """Gets the id of this AgentVersionControl.  # noqa: E501

        ID of the agent version control. Searchable as ID.  # noqa: E501

        :return: The id of this AgentVersionControl.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AgentVersionControl.

        ID of the agent version control. Searchable as ID.  # noqa: E501

        :param id: The id of this AgentVersionControl.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AgentVersionControl, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AgentVersionControl):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

