# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class WorkloadSecurityLinksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_workload_security_link(self, workload_security_link, api_version, **kwargs):  # noqa: E501
        """Create a Workload Security Link  # noqa: E501

        Can create only one Workload Security Link, delete it to create another one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workload_security_link(workload_security_link, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkloadSecurityLink workload_security_link: The workload security link to create. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_workload_security_link_with_http_info(workload_security_link, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_workload_security_link_with_http_info(workload_security_link, api_version, **kwargs)  # noqa: E501
            return data

    def create_workload_security_link_with_http_info(self, workload_security_link, api_version, **kwargs):  # noqa: E501
        """Create a Workload Security Link  # noqa: E501

        Can create only one Workload Security Link, delete it to create another one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workload_security_link_with_http_info(workload_security_link, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WorkloadSecurityLink workload_security_link: The workload security link to create. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workload_security_link', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workload_security_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workload_security_link' is set
        if ('workload_security_link' not in params or
                params['workload_security_link'] is None):
            raise ValueError("Missing the required parameter `workload_security_link` when calling `create_workload_security_link`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_workload_security_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workload_security_link' in params:
            body_params = params['workload_security_link']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/workloadsecuritylinks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkloadSecurityLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_workload_security_link(self, workload_security_link_id, api_version, **kwargs):  # noqa: E501
        """Delete a Workload Security Link  # noqa: E501

        Delete a Workload Security Link by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workload_security_link(workload_security_link_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_workload_security_link_with_http_info(workload_security_link_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_workload_security_link_with_http_info(workload_security_link_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_workload_security_link_with_http_info(self, workload_security_link_id, api_version, **kwargs):  # noqa: E501
        """Delete a Workload Security Link  # noqa: E501

        Delete a Workload Security Link by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workload_security_link_with_http_info(workload_security_link_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link to delete. (required)
        :param str api_version: The version of the api being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workload_security_link_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workload_security_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workload_security_link_id' is set
        if ('workload_security_link_id' not in params or
                params['workload_security_link_id'] is None):
            raise ValueError("Missing the required parameter `workload_security_link_id` when calling `delete_workload_security_link`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_workload_security_link`")  # noqa: E501

        if 'workload_security_link_id' in params and not re.search('\\d+', str(params['workload_security_link_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `workload_security_link_id` when calling `delete_workload_security_link`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'workload_security_link_id' in params:
            path_params['workloadSecurityLinkID'] = params['workload_security_link_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/workloadsecuritylinks/{workloadSecurityLinkID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_workload_security_links(self, workload_security_link_id, api_version, **kwargs):  # noqa: E501
        """Describe a Workload Security Link  # noqa: E501

        Describe a Workload Security Link by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_workload_security_links(workload_security_link_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_workload_security_links_with_http_info(workload_security_link_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_workload_security_links_with_http_info(workload_security_link_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_workload_security_links_with_http_info(self, workload_security_link_id, api_version, **kwargs):  # noqa: E501
        """Describe a Workload Security Link  # noqa: E501

        Describe a Workload Security Link by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_workload_security_links_with_http_info(workload_security_link_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link to describe. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workload_security_link_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_workload_security_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workload_security_link_id' is set
        if ('workload_security_link_id' not in params or
                params['workload_security_link_id'] is None):
            raise ValueError("Missing the required parameter `workload_security_link_id` when calling `describe_workload_security_links`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_workload_security_links`")  # noqa: E501

        if 'workload_security_link_id' in params and not re.search('\\d+', str(params['workload_security_link_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `workload_security_link_id` when calling `describe_workload_security_links`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'workload_security_link_id' in params:
            path_params['workloadSecurityLinkID'] = params['workload_security_link_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/workloadsecuritylinks/{workloadSecurityLinkID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkloadSecurityLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workload_security_links(self, api_version, **kwargs):  # noqa: E501
        """List Workload Security Links  # noqa: E501

        List Workload Security Links.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workload_security_links(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workload_security_links_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workload_security_links_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_workload_security_links_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List Workload Security Links  # noqa: E501

        List Workload Security Links.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workload_security_links_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workload_security_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_workload_security_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/workloadsecuritylinks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkloadSecurityLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_workload_security_link(self, workload_security_link_id, workload_security_link, api_version, **kwargs):  # noqa: E501
        """Update a Workload Security Link  # noqa: E501

        Update a Workload Security Link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_workload_security_link(workload_security_link_id, workload_security_link, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link. (required)
        :param WorkloadSecurityLink workload_security_link: The workload security link to create. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_workload_security_link_with_http_info(workload_security_link_id, workload_security_link, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_workload_security_link_with_http_info(workload_security_link_id, workload_security_link, api_version, **kwargs)  # noqa: E501
            return data

    def modify_workload_security_link_with_http_info(self, workload_security_link_id, workload_security_link, api_version, **kwargs):  # noqa: E501
        """Update a Workload Security Link  # noqa: E501

        Update a Workload Security Link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_workload_security_link_with_http_info(workload_security_link_id, workload_security_link, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workload_security_link_id: The ID number of the workload security link. (required)
        :param WorkloadSecurityLink workload_security_link: The workload security link to create. (required)
        :param str api_version: The version of the api being called. (required)
        :return: WorkloadSecurityLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workload_security_link_id', 'workload_security_link', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_workload_security_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workload_security_link_id' is set
        if ('workload_security_link_id' not in params or
                params['workload_security_link_id'] is None):
            raise ValueError("Missing the required parameter `workload_security_link_id` when calling `modify_workload_security_link`")  # noqa: E501
        # verify the required parameter 'workload_security_link' is set
        if ('workload_security_link' not in params or
                params['workload_security_link'] is None):
            raise ValueError("Missing the required parameter `workload_security_link` when calling `modify_workload_security_link`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_workload_security_link`")  # noqa: E501

        if 'workload_security_link_id' in params and not re.search('\\d+', str(params['workload_security_link_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `workload_security_link_id` when calling `modify_workload_security_link`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'workload_security_link_id' in params:
            path_params['workloadSecurityLinkID'] = params['workload_security_link_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workload_security_link' in params:
            body_params = params['workload_security_link']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/workloadsecuritylinks/{workloadSecurityLinkID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkloadSecurityLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
