# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient


class VCenterConnectorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_v_center_connector(self, vcenter_connector, api_version, **kwargs):  # noqa: E501
        """Create a vCenter connector  # noqa: E501

        Create a new vCenter connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_v_center_connector(vcenter_connector, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param VCenterConnector vcenter_connector: Settings for the new vCenter connector. (required)
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_v_center_connector_with_http_info(vcenter_connector, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.create_v_center_connector_with_http_info(vcenter_connector, api_version, **kwargs)  # noqa: E501
            return data

    def create_v_center_connector_with_http_info(self, vcenter_connector, api_version, **kwargs):  # noqa: E501
        """Create a vCenter connector  # noqa: E501

        Create a new vCenter connector.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_v_center_connector_with_http_info(vcenter_connector, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param VCenterConnector vcenter_connector: Settings for the new vCenter connector. (required)
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vcenter_connector', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_v_center_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vcenter_connector' is set
        if ('vcenter_connector' not in params or
                params['vcenter_connector'] is None):
            raise ValueError("Missing the required parameter `vcenter_connector` when calling `create_v_center_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `create_v_center_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vcenter_connector' in params:
            body_params = params['vcenter_connector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VCenterConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v_center_connector(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Delete a vCenter connector  # noqa: E501

        Delete a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v_center_connector(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter connector whose NSX Manager will be removed. (required)
        :param str api_version: Version of the API being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
            return data

    def delete_v_center_connector_with_http_info(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Delete a vCenter connector  # noqa: E501

        Delete a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v_center_connector_with_http_info(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter connector whose NSX Manager will be removed. (required)
        :param str api_version: Version of the API being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v_center_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_id' is set
        if ('virtual_id' not in params or
                params['virtual_id'] is None):
            raise ValueError("Missing the required parameter `virtual_id` when calling `delete_v_center_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `delete_v_center_connector`")  # noqa: E501

        if 'virtual_id' in params and not re.search('\\d+', str(params['virtual_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `virtual_id` when calling `delete_v_center_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'virtual_id' in params:
            path_params['virtualID'] = params['virtual_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors/{virtualID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def describe_v_center_connector(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Describe a vCenter Connector  # noqa: E501

        Describe a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_v_center_connector(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter connector to describe. (required)
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
            return data

    def describe_v_center_connector_with_http_info(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Describe a vCenter Connector  # noqa: E501

        Describe a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_v_center_connector_with_http_info(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter connector to describe. (required)
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_v_center_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_id' is set
        if ('virtual_id' not in params or
                params['virtual_id'] is None):
            raise ValueError("Missing the required parameter `virtual_id` when calling `describe_v_center_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_v_center_connector`")  # noqa: E501

        if 'virtual_id' in params and not re.search('\\d+', str(params['virtual_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `virtual_id` when calling `describe_v_center_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'virtual_id' in params:
            path_params['virtualID'] = params['virtual_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors/{virtualID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VCenterConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_v_center_connectors(self, api_version, **kwargs):  # noqa: E501
        """List vCenter connectors  # noqa: E501

        List all vCenter connectors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_v_center_connectors(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_v_center_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_v_center_connectors_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_v_center_connectors_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List vCenter connectors  # noqa: E501

        List all vCenter connectors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_v_center_connectors_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: Version of the API being called. (required)
        :return: VCenterConnectors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_v_center_connectors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_v_center_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VCenterConnectors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_v_center_connector(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Modify a vCenter Connector  # noqa: E501

        Modify a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_v_center_connector(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter Connector to modify. (required)
        :param str api_version: Version of the API being called. (required)
        :param VCenterConnector vcenter_connector: The settings of the vCenter connector to modify.
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_v_center_connector_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
            return data

    def modify_v_center_connector_with_http_info(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Modify a vCenter Connector  # noqa: E501

        Modify a vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_v_center_connector_with_http_info(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter Connector to modify. (required)
        :param str api_version: Version of the API being called. (required)
        :param VCenterConnector vcenter_connector: The settings of the vCenter connector to modify.
        :return: VCenterConnector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_id', 'api_version', 'vcenter_connector']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_v_center_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_id' is set
        if ('virtual_id' not in params or
                params['virtual_id'] is None):
            raise ValueError("Missing the required parameter `virtual_id` when calling `modify_v_center_connector`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_v_center_connector`")  # noqa: E501

        if 'virtual_id' in params and not re.search('\\d+', str(params['virtual_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `virtual_id` when calling `modify_v_center_connector`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'virtual_id' in params:
            path_params['virtualID'] = params['virtual_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vcenter_connector' in params:
            body_params = params['vcenter_connector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors/{virtualID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VCenterConnector',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_nsx_manager(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Remove NSX Manager  # noqa: E501

        Remove the NSX Manager associated with the vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nsx_manager(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter Connector to be deleted. (required)
        :param str api_version: Version of the API being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_nsx_manager_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_nsx_manager_with_http_info(virtual_id, api_version, **kwargs)  # noqa: E501
            return data

    def remove_nsx_manager_with_http_info(self, virtual_id, api_version, **kwargs):  # noqa: E501
        """Remove NSX Manager  # noqa: E501

        Remove the NSX Manager associated with the vCenter connector by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nsx_manager_with_http_info(virtual_id, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int virtual_id: ID number of the vCenter Connector to be deleted. (required)
        :param str api_version: Version of the API being called. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virtual_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_nsx_manager" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virtual_id' is set
        if ('virtual_id' not in params or
                params['virtual_id'] is None):
            raise ValueError("Missing the required parameter `virtual_id` when calling `remove_nsx_manager`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `remove_nsx_manager`")  # noqa: E501

        if 'virtual_id' in params and not re.search('\\d+', str(params['virtual_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `virtual_id` when calling `remove_nsx_manager`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'virtual_id' in params:
            path_params['virtualID'] = params['virtual_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/vcenterconnectors/{virtualID}/nsxmanagers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
