# coding: utf-8

"""
    Trend Micro Deep Security API

    Copyright 2018 - 2021 Trend Micro Incorporated.<br/>Get protected, stay secured, and keep informed with Trend Micro Deep Security's new RESTful API. Access system data and manage security configurations to automate your security workflows and integrate Deep Security into your CI/CD pipeline.  # noqa: E501

    OpenAPI spec version: 20.0.463
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsecurity.api_client import ApiClient
from deepsecurity.models import SystemSettings


class SystemSettingsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def describe_system_setting(self, name, api_version, **kwargs):  # noqa: E501
        """Describe a System Setting  # noqa: E501

        Return the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_system_setting(name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the system setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.describe_system_setting_with_http_info(name, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.describe_system_setting_with_http_info(name, api_version, **kwargs)  # noqa: E501
            return data

    def describe_system_setting_with_http_info(self, name, api_version, **kwargs):  # noqa: E501
        """Describe a System Setting  # noqa: E501

        Return the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.describe_system_setting_with_http_info(name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the system setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method describe_system_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `describe_system_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `describe_system_setting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = SystemSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in SystemSettings.attribute_map:
                params['name'] = SystemSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/systemsettings/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_system_settings(self, api_version, **kwargs):  # noqa: E501
        """List System Settings  # noqa: E501

        Lists all system settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_system_settings(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: SystemSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_system_settings_with_http_info(api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.list_system_settings_with_http_info(api_version, **kwargs)  # noqa: E501
            return data

    def list_system_settings_with_http_info(self, api_version, **kwargs):  # noqa: E501
        """List System Settings  # noqa: E501

        Lists all system settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_system_settings_with_http_info(api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_version: The version of the api being called. (required)
        :return: SystemSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_system_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `list_system_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/systemsettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_system_setting(self, name, value, api_version, **kwargs):  # noqa: E501
        """Modify a System Setting  # noqa: E501

        Modify the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_system_setting(name, value, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the setting. (required)
        :param SettingValue value: The new value for the setting setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_system_setting_with_http_info(name, value, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_system_setting_with_http_info(name, value, api_version, **kwargs)  # noqa: E501
            return data

    def modify_system_setting_with_http_info(self, name, value, api_version, **kwargs):  # noqa: E501
        """Modify a System Setting  # noqa: E501

        Modify the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_system_setting_with_http_info(name, value, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the setting. (required)
        :param SettingValue value: The new value for the setting setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'value', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_system_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `modify_system_setting`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `modify_system_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_system_setting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = SystemSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in SystemSettings.attribute_map:
                params['name'] = SystemSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in params:
            body_params = params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/systemsettings/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_system_settings(self, system_settings, api_version, **kwargs):  # noqa: E501
        """Modify System Settings  # noqa: E501

        Modify the system settings. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_system_settings(system_settings, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemSettings system_settings: The system settings to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SystemSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_system_settings_with_http_info(system_settings, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_system_settings_with_http_info(system_settings, api_version, **kwargs)  # noqa: E501
            return data

    def modify_system_settings_with_http_info(self, system_settings, api_version, **kwargs):  # noqa: E501
        """Modify System Settings  # noqa: E501

        Modify the system settings. Any unset elements will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_system_settings_with_http_info(system_settings, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemSettings system_settings: The system settings to modify. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SystemSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_settings', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_system_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_settings' is set
        if ('system_settings' not in params or
                params['system_settings'] is None):
            raise ValueError("Missing the required parameter `system_settings` when calling `modify_system_settings`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `modify_system_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'system_settings' in params:
            body_params = params['system_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/systemsettings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_system_setting(self, name, api_version, **kwargs):  # noqa: E501
        """Reset a System Setting  # noqa: E501

        Reset the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_system_setting(name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the system setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_system_setting_with_http_info(name, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_system_setting_with_http_info(name, api_version, **kwargs)  # noqa: E501
            return data

    def reset_system_setting_with_http_info(self, name, api_version, **kwargs):  # noqa: E501
        """Reset a System Setting  # noqa: E501

        Reset the value for a system setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_system_setting_with_http_info(name, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the system setting. (required)
        :param str api_version: The version of the api being called. (required)
        :return: SettingValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_system_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `reset_system_setting`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `reset_system_setting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            if not type(params['name']) is str and type(params['name']) is property:
                camel_case_name = SystemSettings.attribute_map[params['name'].fget.__name__]
                params['name'] = camel_case_name
            elif params['name'] in SystemSettings.attribute_map:
                params['name'] = SystemSettings.attribute_map[params['name']]
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'api_version' in params:
            header_params['api-version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['DefaultAuthentication']  # noqa: E501

        return self.api_client.call_api(
            '/systemsettings/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
